#include <gtk/gtk.h>

#include "guiboolchoice.h"

GtkWidget *gui_bool_choice_dialog_new(GuiBoolChoice *bc)
{
	GtkWidget *dialog, *button, *label;
	GtkTooltips *tooltips = NULL; /* init. to keep compiler happy */

	if(bc->tooltip[0] || bc->tooltip[1])
		tooltips = gtk_tooltips_new();
	dialog = gtk_dialog_new();
	gtk_container_border_width(GTK_CONTAINER(dialog), 3);
	gtk_signal_connect(GTK_OBJECT(dialog),"delete_event", GTK_SIGNAL_FUNC(bc->callback[2]), bc->parameter[2]);
	gtk_window_set_title(GTK_WINDOW(dialog), bc->title);
	label = gtk_label_new(bc->question);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
	gtk_widget_show(label);
	button = gtk_button_new_with_label(bc->choice[0]);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(bc->callback[0]), bc->parameter[0]);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	if(bc->tooltip[0])
		gtk_tooltips_set_tip(tooltips, button, bc->tooltip[0], NULL);
	button = gtk_button_new_with_label(bc->choice[1]);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(bc->callback[1]), bc->parameter[1]);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
	if(bc->tooltip[1])
		gtk_tooltips_set_tip(tooltips, button, bc->tooltip[1], NULL);
	gtk_widget_show(dialog);

	return dialog;
}
