/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <gnome.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <pwd.h>
#include <sys/stat.h>
#include "cfgfiles.h"

char *cfg_get_str(char *cfg, char *var, char *dest)
{
   *dest = 0;
   while(1)
   {
      if(!strncasecmp(var, cfg, strlen(var)))
      {
	 char *value, t;
	 cfg += strlen(var);
	 while(*cfg == ' ' || *cfg == '=') cfg++;
	 value = cfg;
	 while(*cfg != 0 && *cfg != '\n') cfg++;
	 t = *cfg;
	 *cfg = 0;
	 strcpy(dest, value);
	 *cfg = t;
	 return cfg;
      }
      while(*cfg != 0 && *cfg != '\n') cfg++;
      if(*cfg == 0) return 0;
      cfg++;
      if(*cfg == 0) return 0;
   }
}

void cfg_put_str(int fh, char *var, char *value)
{
   write(fh, var, strlen(var));
   write(fh, "= ", 2);
   write(fh, value, strlen(value));
   write(fh, "\n", 1);
}

void cfg_put_int(int fh, int value, char *var)
{
   char buf[24];

   if(value == -1) value = 1;
   write(fh, var, strlen(var));
   sprintf(buf, "= %d\n", value);
   write(fh, buf, strlen(buf));
}

int cfg_get_int(char *cfg, char *var)
{
   char str[128];

   cfg_get_str(cfg, var, str);

   return atoi(str);
}

char *get_xdir(void)
{
   static char xdir[128];
   snprintf(xdir, sizeof xdir, "%s/.gnome-chess", g_get_home_dir());
   return(xdir);
}

void check_prefs_dir(void) {
	struct stat st;
	char *xdir = get_xdir();
	if(stat(xdir, &st) < 0) {
		if(mkdir(xdir, S_IRUSR | S_IWUSR | S_IXUSR) != 0)
			gnome_message_box_new(_("Unable to create ~/.gnome-chess!"), 
				GNOME_MESSAGE_BOX_ERROR, GNOME_STOCK_BUTTON_OK, NULL);
   }
}




