/*
 * File: client_main.c
 * Author: Brent Hendricks
 * Project: NetSpades
 * Date: 7/31/97
 *
 * This file contains the client function which is responsible for
 * handling the particulars of playing spades on the client side.  I
 * tried to keep this file at as high a level as possible, so the code
 * could be largely algorithmic.  This makes for ease of change and
 * aids in possible future games.
 *
 * Copyright (C) 1998 Brent Hendricks.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <config.h>           /* Site data config */

#include <signal.h>           /* for signal */
#include <stdlib.h>

#include <card.h>
#include <client.h>
#include <display.h>

#ifdef DEBUG_MEM
# include <dmalloc.h>
#endif


/* Global state of game variable */
gameState_t gameState;

int main(int argc, char *argv[]) {

  int i;
  char *message;

#ifdef DEBUG_SCREEN

  Card playedCard;

  GameInit();
  
  gameState.players[0] = "Brenton1";
  gameState.players[1] = "Jason";
  gameState.players[2] = "Douglas1";
  gameState.players[3] = "Phil";
  gameState.playerId = 0;

  gameState.scores[0] = -10;
  gameState.scores[1] = 10;
  gameState.bids[0] = BID_KNEEL;
  gameState.bids[1] = 3;
  gameState.bids[2] = BID_BLANK;
  gameState.bids[3] = 5;

  for( i=0; i< 13; i++)
      gameState.hand[i] = i;
      
  DisplayInit( &argc, &argv );
  DisplayStatusLine( "Welcome to NetSpades %s -By Brent Hendricks", VERSION );
  DisplayTable();
  DisplayScores();
  DisplayTallys();
  DisplayHand();
  for( i=0; i< 4; i++)
    DisplayPlayedCard( gameState.hand[i], i, gameState.playerId );

    MainIOLoop();

  DisplayStatusLine( "Session Over" );
  DisplayCleanup();
  NetClose();
  
  return( 0 );

#else

  /* Arrange interrupts to terminate */
  signal(SIGINT, die);
  signal(SIGPIPE, die);
  signal(SIGCHLD, DeadEngine);
  
  AppInit();
  
  if ( ParseOptions( argc, argv ) < 0 )
      return -1;

  DisplayInit( &argc, &argv );

  DisplayStatusLine( "Welcome to NetSpades %s -By Brent Hendricks", VERSION );

  InputServerInfo();

  MainIOLoop();

  DisplayStatusLine( "Session Over" );
  DisplayCleanup();
  NetClose();

  /* Clean up after ourselves*/
  if( gameState.record != NULL ) {
    free( gameState.record );
  }
  gameState.record = NULL;

  for( i=0; i<4; i++) {
    if( gameState.players[i] != NULL ) {
      free(gameState.players[i]);
      gameState.players[i] = NULL;
    }
  }

  
  return( 0 );
#endif 
  
}
