## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports

# PySol imports
from tkconst import TK_DASH_PATCH                                   #bundle#
from acard import AbstractCard                                      #bundle#

# Toolkit imports
from tkcanvas import MfxCanvasGroup, MfxCanvasImage                 #bundle#


# /***********************************************************************
# //
# ************************************************************************/

class _HideableCard(AbstractCard):
    def hide(self, stack):
        if stack is self.hide_stack:
            return
        if TK_DASH_PATCH:
            self.item.config(state="hidden")
        else:
            if self.hide_stack:
                assert self.hide_x != 0 or self.hide_y != 0
                hx, hy = stack.hide_x - self.hide_x, stack.hide_y - self.hide_y
            else:
                assert self.hide_x == 0 and self.hide_y == 0
                hx, hy = stack.hide_x, stack.hide_y
            self.item.move(hx, hy)
            self.hide_x, self.hide_y = stack.hide_x, stack.hide_y
        self.hide_stack = stack
        ##print "hide:", self.id, hx, hy, self.item.coords()

    def unhide(self):
        if self.hide_stack is None:
            return 0
        if TK_DASH_PATCH:
            self.item.config(state="normal")
        else:
            self.item.move(-self.hide_x, -self.hide_y)
            ##print "unhide:", self.id, -self.hide_x, -self.hide_y, self.item.coords()
            self.hide_x, self.hide_y = 0, 0
        self.hide_stack = None
        return 1


# /***********************************************************************
# // New implemetation since 2.10
# //
# // We use a single CanvasImage and call CanvasImage.config() to
# // turn the card.
# // This makes turning cards a little bit slower, but dragging cards
# // around is noticeable faster as the total number of images is
# // reduced by half.
# ************************************************************************/

class _OneImageCard(_HideableCard):
    def __init__(self, id, deck, suit, rank, game, x=0, y=0):
        _HideableCard.__init__(self, id, deck, suit, rank, game, x=x, y=y)
        images = game.app.images
        self._face_image = images.getFace(suit, rank)
        self._back_image = images.getBack(deck)
        self._image = MfxCanvasImage(game.canvas, self.x, self.y, image=self._back_image, anchor="nw")
        if 0:
            # using a group for a single image doesn't gain much
            self.item = MfxCanvasGroup(game.canvas)
            self._image.addtag(self.item)
        else:
            self.item = self._image

    def showFace(self, unhide=1):
        if not self.face_up:
            self._image.config(image=self._face_image)
            self.tkraise(unhide)
            self.face_up = 1

    def showBack(self, unhide=1):
        if self.face_up:
            self._image.config(image=self._back_image)
            self.tkraise(unhide)
            self.face_up = 0

    def updateCardBackground(self, image):
        self._back_image = image
        if not self.face_up:
            self._image.config(image=image)


# /***********************************************************************
# // New idea since 3.00
# //
# // Hide a card by configuring the canvas image to None.
# ************************************************************************/

class _OneImageCardWithHideByConfig(_OneImageCard):
    def hide(self, stack):
        if stack is self.hide_stack:
            return
        self._image.config(image=None)
        self.hide_stack = stack

    def unhide(self):
        if self.hide_stack is None:
            return 0
        if self.face_up:
            self._image.config(image=self._face_image)
        else:
            self._image.config(image=self._back_image)
        self.hide_stack = None
        return 1

    #
    # much like in _OneImageCard
    #

    def showFace(self, unhide=1):
        if not self.face_up:
            if unhide:
                self._image.config(image=self._face_image)
            self.item.tkraise()
            self.face_up = 1

    def showBack(self, unhide=1):
        if self.face_up:
            if unhide:
                self._image.config(image=self._back_image)
            self.item.tkraise()
            self.face_up = 0

    def updateCardBackground(self, image):
        self._back_image = image
        if not self.face_up and not self.hide_stack:
            self._image.config(image=image)


# /***********************************************************************
# // Old implemetation prior to 2.10
# //
# // The card consists of two CanvasImages. To show the card face up,
# // the face item is placed in front of the back. To show it face
# // down, this is reversed.
# ************************************************************************/

class _TwoImageCard(_HideableCard):
    # Private instance variables:
    #   __face, __back -- the canvas items making up the card
    def __init__(self, id, deck, suit, rank, game, x=0, y=0):
        _HideableCard.__init__(self, id, deck, suit, rank, game, x=x, y=y)
        images = game.app.images
        self.item = MfxCanvasGroup(game.canvas)
        self.__face = MfxCanvasImage(game.canvas, self.x, self.y, image=images.getFace(suit,rank), anchor="nw")
        self.__back = MfxCanvasImage(game.canvas, self.x, self.y, image=images.getBack(deck), anchor="nw")
        self.__face.addtag(self.item)
        self.__back.addtag(self.item)

    def showFace(self, unhide=1):
        if not self.face_up:
            if TK_DASH_PATCH:
                self.__back.config(state="hidden")
                self.__face.config(state="normal")
            self.__face.tkraise()
            self.tkraise(unhide)
            self.face_up = 1

    def showBack(self, unhide=1):
        if self.face_up:
            if TK_DASH_PATCH:
                self.__face.config(state="hidden")
                self.__back.config(state="normal")
            self.__back.tkraise()
            self.tkraise(unhide)
            self.face_up = 0

    def updateCardBackground(self, image):
        self.__back.config(image=image)


# /***********************************************************************
# // New idea since 2.90
# //
# // The card consists of two CanvasImages. Instead of raising
# // one image above the other we move the inactive image out
# // of the visible canvas.
# ************************************************************************/

class _TwoImageCardWithHideItem(_HideableCard):
    # Private instance variables:
    #   __face, __back -- the canvas items making up the card
    def __init__(self, id, deck, suit, rank, game, x=0, y=0):
        _HideableCard.__init__(self, id, deck, suit, rank, game, x=x, y=y)
        images = game.app.images
        self.item = MfxCanvasGroup(game.canvas)
        self.__face = MfxCanvasImage(game.canvas, self.x, self.y + 11000, image=images.getFace(suit,rank), anchor="nw")
        self.__back = MfxCanvasImage(game.canvas, self.x, self.y, image=images.getBack(deck), anchor="nw")
        self.__face.addtag(self.item)
        self.__back.addtag(self.item)

    def showFace(self, unhide=1):
        if not self.face_up:
            self.__back.move(0, 10000)
            ##self.__face.tkraise()
            self.__face.move(0, -11000)
            self.tkraise(unhide)
            self.face_up = 1

    def showBack(self, unhide=1):
        if self.face_up:
            self.__face.move(0, 11000)
            ##self.__back.tkraise()
            self.__back.move(0, -10000)
            self.tkraise(unhide)
            self.face_up = 0

    def updateCardBackground(self, image):
        self.__back.config(image=image)



# choose the implementation
Card = _TwoImageCardWithHideItem
Card = _TwoImageCard
Card = _OneImageCardWithHideByConfig
Card = _OneImageCard

