## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports
import sys, os, string, time, types
import Tkinter


# /***********************************************************************
# // window util
# ************************************************************************/

def withdraw(window):
    window.wm_withdraw()


def deiconify(window):
    if os.name == "nt":
        # FIXME: This is needed so the window pops up on top on Windows.
        try:
            window.wm_iconify()
            window.update_idletasks()
        except Tkinter.TclError:
            # wm_iconify may fail if the window is transient
            pass
    window.wm_deiconify()


def setTransient(window, parent, relx=0.5, rely=0.3, expose=1):
    # Make an existing toplevel window transient for a parent.
    #
    # The window must exist but should not yet have been placed; in
    # other words, this should be called after creating all the
    # subwidget but before letting the user interact.

    # remain invisible while we figure out the geometry
    window.wm_withdraw()
    window.wm_group(parent)
    if os.name == "nt":
        # FIXME: This is needed to avoid ugly frames on Windows.
        window.wm_geometry("+%d+%d" % (-10000, -10000))
        if expose and parent is not None:
            # FIXME: This is needed so the window pops up on top on Windows.
            window.wm_iconify()
    window.wm_transient(parent)
    # actualize geometry information
    window.update_idletasks()
    # show
    x, y = __getWidgetXY(window, parent, relx, rely)
    if os.name == "nt":
        if expose:
            deiconify(window)
        window.wm_geometry("+%d+%d" % (x, y))
    else:
        window.wm_geometry("+%d+%d" % (x, y))
        if expose:
            window.wm_deiconify()


def makeToplevel(parent, title=None, class_=None):
    # Create a Toplevel window.
    #
    # This is a shortcut for a Toplevel() instantiation plus calls to
    # set the title and icon name of the window.
    if class_:
        window = Tkinter.Toplevel(parent, class_=class_)
    else:
        window = Tkinter.Toplevel(parent)
    ##window.wm_group(parent)
    if title:
        window.wm_title(title)
        window.wm_iconname(title)
    return window


def __getWidgetXY(widget, parent, relx=0.5, rely=0.3,
                  w_width=None, w_height=None):
    if w_width is None:
        w_width = widget.winfo_reqwidth()
    if w_height is None:
        w_height = widget.winfo_reqheight()
    s_width = widget.winfo_screenwidth()
    s_height = widget.winfo_screenheight()
    m_width, m_height = s_width, s_height
    m_x = m_y = 0
    if parent and parent.winfo_ismapped():
        m_width = parent.winfo_width()
        m_height = parent.winfo_height()
        m_x = parent.winfo_rootx()
        m_y = parent.winfo_rooty()
    x = m_x + int((m_width - w_width) * relx)
    y = m_y + int((m_height - w_height) * rely)
    ###print x, y, w_width, w_height, m_x, m_y, m_width, m_height
    # make sure the widget is fully on screen
    if x < 0: x = 0
    elif x + w_width + 32 > s_width: x = s_width - w_width
    if y < 0: y = 0
    elif y + w_height + 32 > s_height: y = s_height - w_height
    return x, y


# /***********************************************************************
# // event wrapper - Tkinter doesn't properly delete all bindings
# ************************************************************************/

__mfx_bindings = {}

def bind(widget, sequence, func, add=None):
    global __mfx_bindings
    assert callable(func)
    if sequence == "WM_DELETE_WINDOW":
        funcid = widget._register(func)
        widget.tk.call("wm", "protocol", widget._w, sequence, funcid)
    elif add is None:
        funcid = widget.bind(sequence, func)
    else:
        funcid = widget.bind(sequence, func, add)
    k = id(widget)
    if __mfx_bindings.has_key(k):
        __mfx_bindings[k].append((sequence, funcid))
    else:
        __mfx_bindings[k] = [(sequence, funcid)]

def unbind_destroy(widget):
    global __mfx_bindings
    if widget is None:
        return
    k = id(widget)
    if __mfx_bindings.has_key(k):
        for sequence, funcid in __mfx_bindings[k]:
            try:
                if sequence == "WM_DELETE_WINDOW":
                    widget.tk.call("wm", "protocol", widget._w, sequence, "")
                    ##widget.deletecommand(funcid)
                else:
                    widget.unbind(sequence, funcid)
            except Tkinter.TclError:
                pass
        del __mfx_bindings[k]
    ##for k in __mfx_bindings.keys(): print __mfx_bindings[k]
    ##print len(__mfx_bindings.keys())


# /***********************************************************************
# // timer wrapper - Tkinter doesn't properly delete all commands
# ************************************************************************/

def after(widget, ms, func, *args):
    timer = apply(widget.after, (ms, func) + args)
    command = widget._tclCommands[-1]
    return (timer, command, widget)

def after_idle(widget, func, *args):
    return apply(after, (widget, "idle", func) + args)

def after_cancel(t):
    if t is not None:
        t[2].after_cancel(t[0])
        try:
            t[2].deletecommand(t[1])
        except Tkinter.TclError:
            pass


# /***********************************************************************
# // font
# ************************************************************************/

def getFont(name, **kw):
    name = string.lower(name)
    cardw = int(kw.get("cardw", 0))
    # default
    font = ("Helvetica", "14")
    if os.name == "nt":
        font = ("MS Sans Serif", "10")
    elif os.name == "mac":
        font = "system"
        font = ("Chicago", "12")
    #
    if name in ("canvas", "canvas_small", "small"):
        font = ("Helvetica", "10")
        if os.name == "nt":
            font = ("MS Sans Serif", "8")
    elif name in ("canvas_large",):
        font = ("Helvetica", "-18")
    elif name in ("canvas_card",):
        if cardw >= 71:   font = ("Helvetica", "-18")
        elif cardw >= 57: font = ("Helvetica", "-16")
        else:             font = ("Helvetica", "-14")
    elif name in ("canvas_fixed",):
        font = ("Courier", "-12")
        if os.name == "nt":
            font = ("Courier New", "10")
        elif os.name == "mac":
            font = "fixed"
            font = ("Monaco", "9")
    elif name in ("fixed",):
        font = ("Courier", "-14")
        if os.name == "nt":
            font = ("Courier New", "10")
        elif os.name == "mac":
            font = ("Courier", "12")
    elif not name in ("default",):
        print name                                                  #bundle#
        ##raise AttributeError, name                                  #bundle#
        pass
    return font

