#!/usr/local/bin/typist
#
# Typist v2.2 - improved typing tutor program for UNIX systems
# Copyright (C) 1998  Simon Baldwin (simonb@sco.com)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#

#==============================================================================
# Combined series file
#==============================================================================
G:__SERIESMENU
*:__NO_SERIESMENU
#==============================================================================
*:__S_Q_SERIES
# Start of file q.typ
#------------------------------------------------------------------------------
# Series Q
#------------------------------------------------------------------------------
G:_Q_MENU
*:_Q_NO_MENU
#------------------------------------------------------------------------------
# Lesson Q1
#------------------------------------------------------------------------------
*:Q1
*:_Q_S_Q1
*:_Q_R_L0
#                                                              ../orig/q.typ:21
T:			Welcome to lesson Q1.
 :
 :In the Q series of lessons, we will be learning to touch-type on the standard
 :keyboard.  I will introduce you to each letter on the keyboard, one at a time.
 :By the time you have completed this series, you will be able to type the entire
 :alphabet, the numbers, and most of the punctuation keys by touch.
 :
 :If you have never taken any lessons in typing before, please be patient.  Typing
 :is not difficult but it does take a lot of practice.  Avoid the tendency to
 :look down at your fingers while typing.  This is a very bad habit and is hard
 :to break later.  If you hit the wrong key, I will let you know.  (But, I won't
 :tell anyone else, so don't worry about it.)
 :
 :If you have always used the hunt-and-peck method, you will have an even harder
 :time keeping yourself from looking.  Don't be surprised if you find touch
 :typing slower than your old ways.  It may be slower when you first start.
 :But, touch typing is far faster once you get the hang of it.
 :
 :If you can already touch type, you should be able to go through these lessons
 :fairly quickly.  Or, you may want to go directly to the S series.
Q: Press Y to continue, or Fkey12 to exit 
N:_Q_R_L0

*:_Q_R_L1
#                                                              ../orig/q.typ:42
T:
 :			The HOME Keys.
 :
 :In order to hit the correct keys by touch alone, you must always know where your
 :fingers are.  The way to do this is to have a special place for each finger.
 :This key is called the HOME position.
 :
 :Place the first finger of your right hand on the J-key.  Now, place your second
 :finger on the K-key, your third finger on the L-key, and your fourth-finger on
 :the ;-key (the one with the : and ; on it).
 :
 :Similarly place the four fingers of your left hand on the F, D, S, and A-keys.
 :Place your right thumb over the SPACE bar.  (Henceforth, always hit the SPACE
 :bar with this thumb.)  Now, lift all your fingers slightly so that they are
 :poised just over the keys.  Each finger should be just barely touching its home
 :key.  This is an electronic keyboard and does not take much pressure to ac-
 :cidentally press the key down.
 :
 :Above the D-key is the E-key.  Above the K-key is the I-key.  Learn these
 :positions well.  Whenever you are about to type a line, look at your fingers and
 :make sure they are in the HOME position.  Then don't look at them again.
Q: Press Y to continue, or Fkey12 to exit 
N:_Q_R_L1

*:_Q_R_L2
#                                                              ../orig/q.typ:63
T:
 :			DRILL PATTERNS
 :
 :For the rest of this lesson, I will display a line of text in the middle of the
 :screen and instructions at the top of the screen.
 :
 :All you have to do is type in the characters that you see in the middle of
 :the screen.  If you hit the correct key, I will not do anything.  If you make
 :a mistake, I will display a large X under the letter that you got wrong and
 :beep the terminal. In either event, just keep going by typing the next letter.
 :
 :When you have finished typing the line, hit the RETURN key.  To do this, extend
 :the little finger of your right hand over to the RETURN key.  Hit the key and
 :zip the finger back to its home position.  Be careful not to let your other
 :fingers move far from their home positions in the process.  Also, be careful
 :not to type an extra space at the end of the line.
 :
 :If you made no mistakes on the line, I will display the next drill pattern.  If
 :you did make a mistake, I will beep at you and make you do the line again.  If
 :on the second try you made more than two mistakes, I will beep again and make
 :you try again, etc.  Don't forget to use your right thumb for the SPACE bar.
Q: Press Y to continue, or Fkey12 to exit 
N:_Q_R_L2

#                                                              ../orig/q.typ:64
I:(1) Try this:
*:_Q_R_L3
#                                                              ../orig/q.typ:65
O:asdf ;lkj asdf ;lkj asdf ;lkj asdf ;lkj asdf ;lkj asdf ;lkj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L3

#                                                              ../orig/q.typ:66
I:Now this:
*:_Q_R_L4
#                                                              ../orig/q.typ:67
O:asdef ;lkij asdef ;lkij asdef ;lkij asdef ;lkij asdef ;lkij
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L4

#                                                              ../orig/q.typ:68
I:(2) Some more:
*:_Q_R_L5
#                                                              ../orig/q.typ:71
O:as al ad ak af aj fa ka da la sa ja sl sd sk sf ls ds ks fs
 :de le ae ke se je fe ed el ea ek es ej ef ed lf dk dl fl kl
 :ki ai li si di ji fi ia il is ik id ij if dd ee ss ff ll ei
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L5

#                                                              ../orig/q.typ:72
I:(3) Hang in there; let's do some sentences...
*:_Q_R_L6
#                                                              ../orig/q.typ:73
O:Dad adds a salad  A lad asks  Salad falls as a lad asks Dad
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L6

#                                                              ../orig/q.typ:74
I:(4)
*:_Q_R_L7
#                                                              ../orig/q.typ:76
O:Lease a desk  Add a safe deal  Ask less fees  Add a lease
 :Lease a lake  Add lake sales  Add deeds  Flee false deals
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L7

#                                                              ../orig/q.typ:77
I:(5)
*:_Q_R_L8
#                                                              ../orig/q.typ:80
O:Feel a dead faded leaf  Seeds fall as a faded leaf falls
 :A lad sells seeds  Dad feels a seed  Dad adds a seed deal
 :A deaf lad sells a false jade  Dad sells a deaf lad a sled
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L8

#                                                              ../orig/q.typ:81
I:(6)
*:_Q_R_L9
#                                                              ../orig/q.typ:85
O:Idle Sid seeks a salad  Sis aids Sid  A salad is laid aside
 :Sid seeks a lake Sis is all silks  Sid likes silks
 :A lad asks if Dad likes lilies  Dad is ill  Dad feels life dies as lilies fade
 :Dad slides all lilies aside  Dad is jaded
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L9

#                                                              ../orig/q.typ:86
I:(7)
*:_Q_R_L10
#                                                              ../orig/q.typ:91
O:Sails fill as Sis sails a safe lake  Skill aids Sis  Dad
 :likes a safe sail  Sis seeks a lee isle  All sail is
 :laid aside  Sis feels life is ideal  Idle fields lead as
 :Sis seeks lilies  Sis falls  Lilies fade as Sis falls
 :Faded sails fill  Idle isles slide aside as Sis sails
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L10

#                                                              ../orig/q.typ:92
I:(8)
*:_Q_R_L11
#                                                              ../orig/q.typ:93
O:Sid adds all sail as Dad sees a safe sea as idle as a lake
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L11

G:_Q_E_Q1
#------------------------------------------------------------------------------
# Lesson Q2
#------------------------------------------------------------------------------
*:Q2
*:_Q_S_Q2
*:_Q_R_L12
#                                                             ../orig/q.typ:104
T:
 :			  (h g o u n . t)
 :
 :In this lesson you learn six new letters (H, G, O, U, N, T) and the period. (.).
 :Be sure that the F-finger does not linger on the G-key  or the J-finger on the
 :H-key.
 :
 :Note that you always follow a period with two spaces.
Q: Press Y to continue, or Fkey12 to exit 
N:_Q_R_L12

#                                                             ../orig/q.typ:105
I:(1) Rhythm Drill
*:_Q_R_L13
#                                                             ../orig/q.typ:108
O:a;sldkfjgh a;sldkfjgh a;sldkfjgh a;sldkfjgh a;sldkfjgh
 :asdefghk lokijujhjn asdefgfk lokijujhjn asdefgfk
 :l.  a.  l.  s.  l.  d.  l.  e.  l.  n.  l.  t.  l.  o.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L13

#                                                             ../orig/q.typ:109
I:(2) Balanced Keyboard Drill
*:_Q_R_L14
#                                                             ../orig/q.typ:112
O:as os es us is an on en un in at ot et ut it ad od ed ud id
 :sa so se su si na no ne nu ni ta to te tu ti ha ho he hu hi
 :da do de du di au st oi sh oi ts ht oe nk ou nd ue ns ui th
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L14

#                                                             ../orig/q.typ:113
I:(3) Continuous Copy
*:_Q_R_L15
#                                                             ../orig/q.typ:116
O:Ed had a shed.   His shed had dishes.  He had shade.
 :Ed had his ease.  Sis liked a safe shed.  Sis had shade.
 :His shed is ashes.  Ed hides his head.  He heeds Sis.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L15

#                                                             ../orig/q.typ:117
I:(4)
*:_Q_R_L16
#                                                             ../orig/q.typ:120
O:Odd ideas are like odd seeds.  Odd seeds die as do odd deeds.
 :Dad has odd ideas.  Dad sees a soda as a sad dose.  A soda
 :aids Sis.  So I see a soda is added.  Sis does like a soda.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L16

#                                                             ../orig/q.typ:121
I:(5)
*:_Q_R_L17
#                                                             ../orig/q.typ:124
O:Sid used us.  Sid sued us.  Ada used us as aid.  I did aid.
 :I added ease.  I issued added deeds.  Ada said adieu.  Ada
 :used dead deeds as issues.  Sid said I used deeds due Ada.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L17

#                                                             ../orig/q.typ:125
I:(6)
*:_Q_R_L18
#                                                             ../orig/q.typ:128
O:Ed is staid.  Ed uses tested data as assets.  Sis is a
 :tease.  Sis sets a tea date.  As Ed tastes tea I state tea
 :data.  Sis teases Ed at tea.  As Ed eats I state diet data.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L18

#                                                             ../orig/q.typ:129
I:(7)
*:_Q_R_L19
#                                                             ../orig/q.typ:132
O:Sis said Dean is dense as sand.  Dean needs an idea and Sis
 :needs a sedan.  Dad sends a sedan.  Dean is indeed sad as
 :he sees Sis and Ed inside.  At nine he sees Sis and Ed dine.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L19

#                                                             ../orig/q.typ:133
I:(8) Rhythmic Review
*:_Q_R_L20
#                                                             ../orig/q.typ:134
O:He sees that in a test he has to state and use a sane idea.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L20

G:_Q_E_Q2
#------------------------------------------------------------------------------
# Lesson Q3
#------------------------------------------------------------------------------
*:Q3
*:_Q_S_Q3
*:_Q_R_L21
#                                                             ../orig/q.typ:147
T:
 :			  (y r c , ? : p)
 :
 :You learned first the letters that are most frequently used in the English
 :language.  They are repeated over and over again.
 :
 :One space always follows a comma.  Don't forget there are two spaces between
 :sentences, no matter what punctuation mark closes the sentence.
 :
 :The colon (:) introduces a list and is followed by two spaces.
Q: Press Y to continue, or Fkey12 to exit 
N:_Q_R_L21

#                                                             ../orig/q.typ:148
I:(1) Rhythm Drill
*:_Q_R_L22
#                                                             ../orig/q.typ:150
O:deki frju dck, dcl. frju ftjy deki frju dck, dcl. frju ftjy
 :fgjh ;p;? jujy dedc lol. kik, fgju ;:;: frfk jujy dedc kik,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L22

#                                                             ../orig/q.typ:151
I:(2) Balanced Keyboard Drill
*:_Q_R_L23
#                                                             ../orig/q.typ:157
O:ag ac ar al ap at ay af ug uc ur ul up ut eg ec er el ep et
 :ey ef og or ol op ot of ig ic ir il ip if ga ca ra la pa fa
 :gu cu ru lu pu fu ge ce re le pe ye fe go co ro lo po yo fo
 :gi ci ri li fi gn pl gh ld sy rd ty ct ft ch nc dy dr ph ng
 :s?  d?  e?  f?  r?  f?  t?  j?  n?  s:  d:  e:  r:  t:  n:
 :k, i, d, e, f, r, k, u, f, t, k, y, d, c, k, n, k, h, l, o,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L23

#                                                             ../orig/q.typ:158
I:(3) Continuous Copy
*:_Q_R_L24
#                                                             ../orig/q.typ:160
O:Chance can aid a nice choice.  It can teach one to count his
 :costs too.  In each such case a chance cause can hit costs.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L24

#                                                             ../orig/q.typ:161
I:(4)
*:_Q_R_L25
#                                                             ../orig/q.typ:163
O:At his age a good song is the thing as he gets his dog and
 :gun.  He is going to hunt again.  As night ends he sets out.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L25

#                                                             ../orig/q.typ:164
I:(5)
*:_Q_R_L26
#                                                             ../orig/q.typ:166
O:As soon as papa is deep in a nap Pat happens to pound in his
 :shop and the phone sounds.  Pat is to paint and pass up noise.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L26

#                                                             ../orig/q.typ:167
I:(6)
*:_Q_R_L27
#                                                             ../orig/q.typ:169
O:I hear there is an error in her other order.  The store sent
 :her red dress to our door.  She is sure that it is too dear.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L27

#                                                             ../orig/q.typ:170
I:(7)
*:_Q_R_L28
#                                                             ../orig/q.typ:172
O:I shall hold those ideal hotel lots at least until all land
 :is sold.  Late sales still total less than the one old deal.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L28

#                                                             ../orig/q.typ:173
I:(8)
*:_Q_R_L29
#                                                             ../orig/q.typ:175
O:Sunday is too soon.  It is not easy to stay and study this
 :dandy day.  I need to study.  It is not easy on the eyes.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L29

#                                                             ../orig/q.typ:176
I:(9)
*:_Q_R_L30
#                                                             ../orig/q.typ:178
O:One needs to use faith if one fishes often.  It is fun to sit
 :on soft sod and fish.  It is fun to feel a fish dash out fast.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L30

#                                                             ../orig/q.typ:179
I:(9A)
*:_Q_R_L31
#                                                             ../orig/q.typ:183
O:Hello, is this Dan?  Hello, Dan, this is Ann.  No, Ann.  Did
 :you see Ted?  Is Nan at the house?  Then dash to the house.
 :Is he at the house?  Has he his auto?  Did he tie on those
 :odds and ends:  used suits, sun hats, shoes, and side tent?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L31

#                                                             ../orig/q.typ:184
I:(10) Rhythmic Review
*:_Q_R_L32
#                                                             ../orig/q.typ:185
O:Papa can not plan to get us all there in such a car as this.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L32

G:_Q_E_Q3
#------------------------------------------------------------------------------
# Lesson Q4
#------------------------------------------------------------------------------
*:Q4
*:_Q_S_Q4
*:_Q_R_L33
#                                                             ../orig/q.typ:196
T:
 :			(m w v z x b q ' -)
 :
 :Self control is important in learning to type.  Concentrate on using the
 :correct finger for each key.  In this lesson you learn the seven remaining
 :letters of the alphabet.
 :
 :The semicolon (;), like the comma, is followed by one space in a sentence.
Q: Press Y to continue, or Fkey12 to exit 
N:_Q_R_L33

#                                                             ../orig/q.typ:197
I:(1) Rhythm Drill
*:_Q_R_L34
#                                                             ../orig/q.typ:199
O:dedc kik, frfv jujm swsx lol. aqaz ;p;p frfv jujm ftfb jyjn
 :aqsw az;p sxl. fvjm fvjn fbjn aqsw az;p sxl. fvjm fvjn fbjn
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L34

#                                                             ../orig/q.typ:200
I:(2) Balanced Keyboard Drill
*:_Q_R_L35
#                                                             ../orig/q.typ:204
O:am aw av az ak ax ab um ub em ew ev ez ek eq ex om ow ov oz
 :ok ob im iv iz ix ib ma wa va za ka ja xa ba mu ju qu bu me
 :we ve ze ke je xe be mo wo vo zo ko jo bo mi wi vi zi ki xi
 :bi xt sm sk sw kn ms nk wh tw ks wn dv s; o; n; d; l; e; t;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L35

#                                                             ../orig/q.typ:205
I:(3) Continuous Copy
*:_Q_R_L36
#                                                             ../orig/q.typ:207
O:Iowa was white with snow when we two went down town and saw
 :a show.  We wanted to see news and not the widow who was wed.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L36

#                                                             ../orig/q.typ:208
I:(4)
*:_Q_R_L37
#                                                             ../orig/q.typ:210
O:John has to use a tan and jet auto.  He joined Jane in its
 :joint use.  Jane just intends to use it in June on a jaunt.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L37

#                                                             ../orig/q.typ:211
I:(5)
*:_Q_R_L38
#                                                             ../orig/q.typ:213
O:Smith is his name.  He is on some Maine team.  I am to meet
 :him and Miss Smith.  I must see them some time this month.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L38

#                                                             ../orig/q.typ:214
I:(6)
*:_Q_R_L39
#                                                             ../orig/q.typ:216
O:Kate uses ink to send a note south to Kansas kin.  She asks
 :to use a kodak to take along on these keen skates and skis.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L39

#                                                             ../orig/q.typ:217
I:(7)
*:_Q_R_L40
#                                                             ../orig/q.typ:219
O:I advise Eva in vain to avoid an auto visit in seven states.
 :Nevada is so vivid that Eva votes to have this visit saved.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L40

#                                                             ../orig/q.typ:220
I:(8)
*:_Q_R_L41
#                                                             ../orig/q.typ:222
O:She has questions and unique ideas to quote us.  So she is
 :quite the queen in this quiet set and sets us quaint quotas.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L41

#                                                             ../orig/q.typ:223
I:(9)
*:_Q_R_L42
#                                                             ../orig/q.typ:225
O:The zoo is shut.  His zest is dashed.  Dan dozes.  One sneeze
 :and then a dozen seize Dan.  In a daze he sees the zoo seized.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L42

#                                                             ../orig/q.typ:226
I:(9A)
*:_Q_R_L43
#                                                             ../orig/q.typ:228
O:The boat has been best to Boston.  On this basis no doubt one
 :is bound to be a bit behind but boats beat both dust and heat.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L43

#                                                             ../orig/q.typ:229
I:(9B)
*:_Q_R_L44
#                                                             ../orig/q.typ:231
O:Nan is in Texas.  She is anxious to dine at six.  She sees a
 :taxi stand next to the sixth exit.  Taxis exist to aid one.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L44

#                                                             ../orig/q.typ:232
I:(10) Rhythmic Review
*:_Q_R_L45
#                                                             ../orig/q.typ:233
O:Ask them to let us have the car if they both go to the show.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L45

G:_Q_E_Q4
#------------------------------------------------------------------------------
# Lesson Q5
#------------------------------------------------------------------------------
*:Q5
*:_Q_S_Q5
*:_Q_R_L46
#                                                             ../orig/q.typ:239
T:
 :Now you know all of the alphabet.  In this lesson we add the hyphen (-) and
 :the apostrophe (').
Q: Press Y to continue, or Fkey12 to exit 
N:_Q_R_L46

#                                                             ../orig/q.typ:240
I:(1) Rhythm Drill
*:_Q_R_L47
#                                                             ../orig/q.typ:242
O:dedc kik, frfv jujm swsx lol. aqaz ;p;p frfv jujm ftfb jyjn
 :frfk fvfb jujy jmjn aqsw azsw azsx ;plo ;p;- kik, ;p;-
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L47

#                                                             ../orig/q.typ:243
I:(2) Balanced Keyboard Drill
*:_Q_R_L48
#                                                             ../orig/q.typ:246
O:ad ar an al am ab ee st ed er en el es em ex om on or un up
 :id ic ir in im se sy le ly re ry ec fy ty de be my by bi di
 :l-t o-d s-c p-t o-d n-y r-o g-d r-h d-g n't t's l's y's I'l
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L48

#                                                             ../orig/q.typ:247
I:(3) Continuous Copy -- Review
*:_Q_R_L49
#                                                             ../orig/q.typ:249
O:It is a good thing papa has gone.  Pat gets up a deep song.
 :Yet Ann says an easy song any day is a sign to guess again.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L49

#                                                             ../orig/q.typ:250
I:(4)
*:_Q_R_L50
#                                                             ../orig/q.typ:252
O:They often need funds but don't think it is any fun to study.
 :Ann is keen to ask him to use his kodak at the same time.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L50

#                                                             ../orig/q.typ:253
I:(5)
*:_Q_R_L51
#                                                             ../orig/q.typ:255
O:Ted notes an odd noise.  Dan is in the seas and needs aid.
 :He sheds his suit and shoes on the sand and is out in haste.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L51

#                                                             ../orig/q.typ:256
I:(6)
*:_Q_R_L52
#                                                             ../orig/q.typ:258
O:A good visit East is Ann's next quest.  Ann seems to seize
 :on this idea with zest.  She has set seven visits as a quota.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L52

#                                                             ../orig/q.typ:259
I:(7)
*:_Q_R_L53
#                                                             ../orig/q.typ:261
O:She is to adjust her six visits to have a snow-white Maine
 :Christmas.  An Iowa aunt asks Ann to take in that state, too.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L53

#                                                             ../orig/q.typ:262
I:(8)
*:_Q_R_L54
#                                                             ../orig/q.typ:264
O:It's a tax on time, but it's quite a new zone to Ann who is
 :in just the mood to end her quota of visits in sixteen weeks.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L54

#                                                             ../orig/q.typ:265
I:(9) Rhythmic Review
*:_Q_R_L55
#                                                             ../orig/q.typ:266
O:Two of the boys are to do it today and two of them next week.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_Q_R_L55

G:_Q_E_Q5
#------------------------------------------------------------------------------
# Lesson series Q jump tables
#------------------------------------------------------------------------------
*:_Q_E_Q1
Q: Do you want to continue to lesson Q2 [Y/N] ? 
N:_Q_MENU
G:_Q_M_Q2
*:_Q_E_Q2
Q: Do you want to continue to lesson Q3 [Y/N] ? 
N:_Q_MENU
G:_Q_M_Q3
*:_Q_E_Q3
Q: Do you want to continue to lesson Q4 [Y/N] ? 
N:_Q_MENU
G:_Q_M_Q4
*:_Q_E_Q4
Q: Do you want to continue to lesson Q5 [Y/N] ? 
N:_Q_MENU
G:_Q_M_Q5
*:_Q_E_Q5
G:_Q_MENU

*:_Q_M_Q1
B:                             Lesson Q1
K:12:_Q_MENU
G:_Q_S_Q1
*:_Q_M_Q2
B:                             Lesson Q2
K:12:_Q_MENU
G:_Q_S_Q2
*:_Q_M_Q3
B:                             Lesson Q3
K:12:_Q_MENU
G:_Q_S_Q3
*:_Q_M_Q4
B:                             Lesson Q4
K:12:_Q_MENU
G:_Q_S_Q4
*:_Q_M_Q5
B:                             Lesson Q5
K:12:_Q_MENU
G:_Q_S_Q5
#------------------------------------------------------------------------------
# Lesson series Q menu
#------------------------------------------------------------------------------
*:_Q_MENU
*:_Q_MENU_PAGE0
B:                 Lesson selection menu - series Q
K:1:_Q_M_Q1
K:2:_Q_M_Q2
K:3:_Q_M_Q3
K:4:_Q_M_Q4
K:5:_Q_M_Q5
K:6:NULL
K:7:NULL
K:8:NULL
K:9:NULL
K:10:NULL
K:11:NULL
K:12:_Q_QEXIT
T:The Q series contains the following 5 lessons:
 :
 :        Fkey 1 - Lesson Q1     a s d f g h j k l ;
 :        Fkey 2 - Lesson Q2     h g o u n . t
 :        Fkey 3 - Lesson Q3     y r c , ? : p
 :        Fkey 4 - Lesson Q4     m w v z x b q
 :        Fkey 5 - Lesson Q5     ' -
 :
 :
 :
 :
 :
 :
 :
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_Q_MENU_PAGE0
*:_Q_QEXIT
Q: Do you want to leave this lesson series? [Y/N] ? 
N:_Q_MENU
G:_Q_EXIT
*:_Q_EXIT
#------------------------------------------------------------------------------
# End of file q.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_R_SERIES
# Start of file r.typ
#------------------------------------------------------------------------------
# Series R
#------------------------------------------------------------------------------
G:_R_MENU
*:_R_NO_MENU
#------------------------------------------------------------------------------
# Lesson R1
#------------------------------------------------------------------------------
*:R1
*:_R_S_R1
*:_R_R_L0
#                                                               ../orig/r.typ:4
T:
 :In the R series lessons we work on speed and accuracy.
Q: Press Y to continue, or Fkey12 to exit 
N:_R_R_L0

#                                                               ../orig/r.typ:5
I:(1) Warming-Up Drill
*:_R_R_L1
#                                                               ../orig/r.typ:6
O:Up to date I can not see that the thing is as good as this one.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L1

#                                                               ../orig/r.typ:7
I:(2) Balanced Keyboard Drill
*:_R_R_L2
#                                                               ../orig/r.typ:8
O:uch pos oug ept ing ope hic ati sch cou get ice con goo ght
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L2

#                                                               ../orig/r.typ:9
I:(3) Continuous Copy
*:_R_R_L3
#                                                              ../orig/r.typ:10
O:Nan is cute.  She can sing and dance.  She can tap a piano.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L3

#                                                              ../orig/r.typ:11
I:(4)
*:_R_R_L4
#                                                              ../orig/r.typ:13
O:Tonight Nan opens the piano.  She sings such good songs and
 :soon dashes into a dance.  Nan can dance.  The noise stops.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L4

#                                                              ../orig/r.typ:14
I:(5)
*:_R_R_L5
#                                                              ../orig/r.typ:17
O:Nan gets us going.  The dance is on.  Ted pounds the piano
 :as Ann stops to go to the phone.  She has to get the gang.
 :This chance scene passes too soon.  I hope it happens again.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L5

#                                                              ../orig/r.typ:18
I:(6)
*:_R_R_L6
#                                                              ../orig/r.typ:22
O:At eight papa said that he ought to put out his good pipe
 :and then get a good nap.  Soon papa is snug in a deep nap.
 :At eight ten I guess the dance gets going.  At ten it stops.
 :As papa put it, such singing upsets him enough for one night.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L6

#                                                              ../orig/r.typ:23
I:(7)
*:_R_R_L7
#                                                              ../orig/r.typ:28
O:Get the gang.  Catch this sign.  Get going.  Go up this high
 :post and put a sign on top.  Put these copies on each post.
 :I guess no one intends to stop us.  The cast is set.  Each
 :scene is set.  Each act can open in good shape.  I hope that
 :enough cash is paid in so the cast need not stand the costs.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L7

*:_R_R_L8
#                                                              ../orig/r.typ:43
T:			SPEED EXERCISES
 :
 :From now on, I will be mixing speed exercises in with the lessons.  In the
 :drills that you have been doing, I make you keep practicing a line until
 :you get it right.  In a speed exercise, I will only display the text once.
 :
 :What will be different is that I will be timing you.  From the time you type
 :the first letter of the line until you hit the final carriage return, my
 :stopwatch will be running.  When you finish, I will calculate your typing speed
 :and convert it to words per minute (WPM).  I will also count each of the
 :mistakes you make and display the total number of errors.
 :
 :If you make a mistake, I will beep at you and light up the letter that you
 :should have typed in inverse video (a black letter on a white background).
 :Just keep going and try to make as few errors as possible.
Q: Press Y to continue, or Fkey12 to exit 
N:_R_R_L8

#                                                              ../orig/r.typ:44
I:(8) Pointer Paragraph (o e)
*:_R_R_L9
#                                                              ../orig/r.typ:49
P:     Only too well do we know about your house.  Mother told
 :me you hope to be settled there quite soon.  Of course she
 :would enjoy seeing the whole house next week.  Before then
 :please write her a letter to let her know how to get there
 :from here.  We know you have moved to a very cozy new home.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L9

#                                                              ../orig/r.typ:50
I:(9) Test Paragraph
*:_R_R_L10
#                                                              ../orig/r.typ:56
P:     The High dance opens at eight and the gang is going.
 :So Ted shuts the piano and stops at the phone to catch Ann.
 :I ought to post Ted that he pounds the piano as I once did.
 :I guess he is upset.  He has to catch Dad to get the cash.
 :He has to see Ann to each dance.  This is not a noisy night.
 :His auto is a cheap one and no good on a night such as this.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L10

#                                                              ../orig/r.typ:57
I:(10) Rhythmic Review
*:_R_R_L11
#                                                              ../orig/r.typ:58
O:The gang can use the piano and good songs to open the dance.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L11

G:_R_E_R1
#------------------------------------------------------------------------------
# Lesson R2
#------------------------------------------------------------------------------
*:R2
*:_R_S_R2
#                                                              ../orig/r.typ:62
I:(1) Warming-Up Drill
*:_R_R_L12
#                                                              ../orig/r.typ:63
O:It is a good thing to use good habits each time you practice.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L12

#                                                              ../orig/r.typ:64
I:(2) Balanced Keyboard Drill
*:_R_R_L13
#                                                              ../orig/r.typ:65
O:thr pre rec ear ers ure urn gre art ore her are ter ere tru
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L13

#                                                              ../orig/r.typ:66
I:(3) Continuous Copy
*:_R_R_L14
#                                                              ../orig/r.typ:67
O:Dad and his son, Dan, are to go east on a great auto trip.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L14

#                                                              ../orig/r.typ:68
I:(4)
*:_R_R_L15
#                                                              ../orig/r.typ:70
O:The phone rings.  Dan hopes the rain has not upset the trip.
 :Soon the pair share a snug rug and start out in our red car.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L15

#                                                              ../orig/r.typ:71
I:(5)
*:_R_R_L16
#                                                              ../orig/r.typ:74
O:On a poor, rough road, Dan dares to rush in the rain.  Soon
 :he sees a horse ahead.  He tries hard to stop.  The car hits
 :and then turns around.  The horse runs east at a great rate.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L16

#                                                              ../orig/r.typ:75
I:(6)
*:_R_R_L17
#                                                              ../orig/r.typ:79
O:In order to raise a poor grade one tries to use good sense.
 :An error is a sure sign not to do the thing that one did.
 :An error seen once does not hurt.  As soon as an error is
 :seen or heard again, note its sort and end it right there.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L17

#                                                              ../orig/r.typ:80
I:(7)
*:_R_R_L18
#                                                              ../orig/r.typ:85
O:Her error is a sign that this thing or that has upset her.
 :Does she care?  Is it a hard part?  She has to get used to
 :the letters that she has to print.  Is this order upset?
 :Is she tired?  Then she needs a short rest.  Is it the rate?
 :She need not raise her rate too high.  Has she a good touch?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L18
#
I:(8) Pointed Paragraph (t h)

*:_R_R_L19
#                                                              ../orig/r.typ:92
P:     Hugh thought he ought to start that night although the
 :weather might hurt his health.  Hal thought they ought to go
 :to Arizona together the thirtieth of June.  Both hastened
 :through the streets to their very high hotel.  Hal hesitated
 :to start north without warm clothes.  Although he hated to
 :hurt his health, Hugh started north quickly on the sixteenth.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L19

#                                                              ../orig/r.typ:93
I:(9) Test Paragraph
*:_R_R_L20
#                                                              ../orig/r.typ:99
P:     Dad and his son are to start on a trip in our red car.
 :House cares are the sort that upset Dad and he is so tired
 :that he tries a nap in order to rest.  It rains at a great
 :rate.  Dan is too sure.  He has heard this road is poor in
 :parts.  It is a great error, Dan, to rush a short turn on a
 :grade.  The car turns out and ends on its side.  Hurt?  No.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L20

#                                                             ../orig/r.typ:100
I:(10) Rhythmic Review
*:_R_R_L21
#                                                             ../orig/r.typ:101
O:Dad had a short rest in order to start on the hard car trip.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L21

G:_R_E_R2
#------------------------------------------------------------------------------
# Lesson R3
#------------------------------------------------------------------------------
*:R3
*:_R_S_R3
#                                                             ../orig/r.typ:105
I:(1) Warming-Up Drill
*:_R_R_L22
#                                                             ../orig/r.typ:106
O:As a rule call earlier on all orders as long as this one.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L22

#                                                             ../orig/r.typ:107
I:(2) Balanced Keyboard Drill
*:_R_R_L23
#                                                             ../orig/r.typ:108
O:als ple gla ulo clo ile ill oul all eas onl ion tle lea ndl
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L23

#                                                             ../orig/r.typ:109
I:(3) Continuous Copy
*:_R_R_L24
#                                                             ../orig/r.typ:110
O:As a rule it is the real line drill that helps one to learn.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L24

#                                                             ../orig/r.typ:111
I:(4)
*:_R_R_L25
#                                                             ../orig/r.typ:113
O:It helps to read a line as soon as one can.  It helps to see
 :its sense.  This, indeed, helps to hold each line until done.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L25

#                                                             ../orig/r.typ:114
I:(5)
*:_R_R_L26
#                                                             ../orig/r.typ:117
O:As soon as one hits a hard place then one plans to drill on
 :this part.  Later one can drill this hard part again.  In
 :order to end an error one can drill all the old line again.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L26

#                                                             ../orig/r.typ:118
I:(6)
*:_R_R_L27
#                                                             ../orig/r.typ:122
O:Learn the sound as one uses loose hands to type out a line.
 :As one types his usual rate he ought to learn its sound until
 :at this rate all the line has the usual, clean, clear sound.
 :As soon as the usual rate is lost one can hear it as a slip.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L27

#                                                             ../orig/r.typ:123
I:(7)
*:_R_R_L28
#                                                             ../orig/r.typ:128
O:Total lines that one turns out tell all that one is young.
 :In order that this class also can print a large line total,
 :it still helps to spell; it also helps to print all the line
 :as one line, and it helps less and less to drill single
 :letters.  Each one in the class can tell his total lines.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L28

#                                                             ../orig/r.typ:129
I:(8) One- to three-letter words (a to l)
*:_R_R_L29
#                                                             ../orig/r.typ:146
P:Dear Ted,
 :
 :     A day ago Ann got a bad cut on her arm and a few by her
 :eye and ear.  It is an act of God she did not die.  Her car
 :did the job.  It is the end of her car.  She has no use for a
 :car.  The fee is to be big.  She is in bed, but she can not
 :eat.  She can not eat a bit of egg.  It is no fun at all.
 :
 :     It is hot.  It is too hot for her fur hat, but I can buy
 :a box for it.  I am due any day.  I can cut a day if I fly.
 :It is not far if I go by air.  If I go by car, I add a day.
 :
 :     How is Dan?  Did he get his job?  Dan had to beg for it
 :if he did.  He is big and fat but not bad.  The boy can do
 :it if he can act to fit his age.  Ask him not to act as a kid.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L29

#                                                             ../orig/r.typ:147
I:(9) Test Paragraph
*:_R_R_L30
#                                                             ../orig/r.typ:154
P:     To tell this class all there is to learn is not a real
 :help later.  Let the class plan the loose ease that can hold
 :each hand in place, or plan to end this or that poor slip,
 :or plan to do its total lines in less hours.  As a rule, to
 :plan and to do are also to learn.  The class plans to drop
 :the old action to clear the road.  Those old slips are lost.
 :The class has large plans; gains in hours and less slips.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L30

#                                                             ../orig/r.typ:155
I:(10) Rhythmic Review
*:_R_R_L31
#                                                             ../orig/r.typ:156
O:To learn to read or spell a rule helps less than to drill.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L31

G:_R_E_R3
#------------------------------------------------------------------------------
# Lesson R4
#------------------------------------------------------------------------------
*:R4
*:_R_S_R4
#                                                             ../orig/r.typ:160
I:(1) Warming-Up Drill
*:_R_R_L32
#                                                             ../orig/r.typ:161
O:After that date I believe he can not say that it is not a fact.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L32

#                                                             ../orig/r.typ:162
I:(2) Balanced Keyboard Drill
*:_R_R_L33
#                                                             ../orig/r.typ:163
O:any for efo fte day fin you ful ery nly hey afk ays fro say
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L33

#                                                             ../orig/r.typ:164
I:(3) Continuous Copy
*:_R_R_L34
#                                                             ../orig/r.typ:166
O:I feel sorry to say I can not send a full order on that day.
 :Forty-odd pounds is all that I can spare at this early date.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L34

#                                                             ../orig/r.typ:167
I:(4)
*:_R_R_L35
#                                                             ../orig/r.typ:170
O:All loose lots are sent on fast local lines at a half rate,
 :so there is close to no delay and you also do not lose any.
 :It is fine, fresh stuff and our first fancy fruit this year.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L35

#                                                             ../orig/r.typ:171
I:(5)
*:_R_R_L36
#                                                             ../orig/r.typ:175
O:This offer is only for fancy fresh fruit to be used as gifts.
 :Try these and candy to suit the young lady.  They are dandy.
 :You can feel safe.  Sales are easy and final.  They go fast.
 :After at least four days you can order daily or on Friday.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L36

#                                                             ../orig/r.typ:176
I:(6)
*:_R_R_L37
#                                                             ../orig/r.typ:185
P:Dear Ted,
 :
 :     After I read your dandy note I felt sorry for the lady.
 :Here is plenty of cash if you young people agree to spend it
 :sanely.  Is it for a natty sail or only for golf?  Did you and
 :Dan play or fight?  Dan said he felt as if a full load of
 :coal hit his head.  Is that fact or fancy?
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L37

#                                                             ../orig/r.typ:186
I:(7) Pointed Paragraph (a s)
*:_R_R_L38
#                                                             ../orig/r.typ:193
P:     Sadness possesses her as she stands against the panes
 :that the sash separates.  She is sad because the same dress
 :is not washed and in shape; and so she says it is useless to
 :save it.  She is sad also because she has to stay in Alabama
 :next season.  She says to plan to sail across the seas to
 :Alaska or Asia or Spain is useless.  So in June she amuses
 :herself by drawing five or six quaint, small-sized maps.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L38

#                                                             ../orig/r.typ:194
I:(8) Test Paragraph
*:_R_R_L39
#                                                             ../orig/r.typ:201
P:     They say this fruit is the finest.  It is full and good.
 :Dr. Ted feels the first fruit is too green for young or old.
 :After one eats any of it he is sorry.  In fact, if I try it,
 :that night in fancy I sail the the South Seas for eight hours.
 :The air is fine and clear; on the ship are only fruit and I.
 :To a lady in those seas I gladly offer all fruit and candy.
 :There is no reply.  Only the seas run high and I feel ill.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L39

#                                                             ../orig/r.typ:202
I:(9) Rhythmic Review
*:_R_R_L40
#                                                             ../orig/r.typ:203
O:The young lady often has pounds of fruit and candy each day.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L40

G:_R_E_R4
#------------------------------------------------------------------------------
# Lesson R5
#------------------------------------------------------------------------------
*:R5
*:_R_S_R5
#                                                             ../orig/r.typ:207
I:(1) Warming-Up Drill
*:_R_R_L41
#                                                             ../orig/r.typ:208
O:In any case there is only one order that is long past due.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L41

#                                                             ../orig/r.typ:209
I:(2) Balanced Keyboard Drill
*:_R_R_L42
#                                                             ../orig/r.typ:210
O:est ace ric ity red per der pro sel par ish ial ing eal let
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L42

#                                                             ../orig/r.typ:211
I:(3) Continuous Copy--Review
*:_R_R_L43
#                                                             ../orig/r.typ:212
O:To learn to type, first get a nice rate going, then hold it.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L43

#                                                             ../orig/r.typ:213
I:(4)
*:_R_R_L44
#                                                             ../orig/r.typ:215
O:If you read copy set your eyes on that copy and stay on it.
 :If you hear copy then use your eyes to hit sure and fast.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L44

#                                                             ../orig/r.typ:216
I:(5)
*:_R_R_L45
#                                                             ../orig/r.typ:219
O:Do not hurry.  Set a nice rate.  Yet hit each letter fast.
 :To strike letters start easily and fast and use a light touch.
 :You can not type lightly and faster if you start to pound.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L45

#                                                             ../orig/r.typ:220
I:(6)
*:_R_R_L46
#                                                             ../orig/r.typ:224
O:It is a slip if you do not use a letter in its right order,
 :since in line after line each has its place on the paper.
 :You soon learn the usual order for all letters that you type
 :and learn to print the letters in any necessary order.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L46

#                                                             ../orig/r.typ:225
I:(7)
*:_R_R_L47
#                                                             ../orig/r.typ:230
O:It is easy at first to make errors by losing this usual order.
 :If you read, hold the eyes on copy to help get this order.
 :If you do hit this or that letter out of order, it is not
 :that you fail to spell.  You can spell and yet not type;
 :this fine class drill is to help the type fly in fair order.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L47

#                                                             ../orig/r.typ:231
I:(8) One- to three-letter words (m to z)
*:_R_R_L48
#                                                             ../orig/r.typ:249
P:Dear Tom,
 :
 :     Mr. May has one new car.  It has a low red top.  The top
 :is so low you can not see the sun if you sit in the car.  Mr.
 :May has not let his own son use it.  I saw his son try to put
 :the top up.  I ran and met him.  Why not be men and run the car
 :out?  We did.  We set out to run it at six.  We two ran it off
 :to an old lot by the sea.
 :
 :     Did his pa see us?  Yes, sir, who but Pa was at No. Ten
 :as we ran by in the car--and Ma, too.  Oh, it was war--his pa
 :had a lot to say.  Let me lay out the law to you.  You may not
 :use the car as you did not pay for it.  You are not yet a man.
 :Son did not lie nor did he win his way.
 :
 :     How are you all?  Now if you get a new car, let me run it.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L48

#                                                             ../orig/r.typ:250
I:(9) Pointed Paragraph (t c)
*:_R_R_L49
#                                                             ../orig/r.typ:256
P:     Is it quite certain that the citizens could continue the
 :old conditions if they voted a straight ticket?  If we accept
 :as accurate the picture of recent conditions, we can not crave
 :to continue them.  We lack the tact to get the citizens to
 :vote a split ticket.  Tax collectors try to collect taxes on
 :vacant lots.  A discount for cash increases collections.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L49

#                                                             ../orig/r.typ:257
I:(10) Rhythmic Review
*:_R_R_L50
#                                                             ../orig/r.typ:258
O:In order to type fast you hit lightly after each short delay.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L50

G:_R_E_R5
#------------------------------------------------------------------------------
# Lesson R6
#------------------------------------------------------------------------------
*:R6
*:_R_S_R6
#                                                             ../orig/r.typ:262
I:(1) Warming-Up Drill
*:_R_R_L51
#                                                             ../orig/r.typ:263
O:It seems to me that we want to know what was said just now.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L51

#                                                             ../orig/r.typ:264
I:(2) Balanced Keyboard Drill
*:_R_R_L52
#                                                             ../orig/r.typ:266
O:ent ake mon mak tim kin orm omp rom ork mys kno com ome Mr.
 :ant may was way now job wit toi wri jus wil jul whi wou whe
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L52

#                                                             ../orig/r.typ:267
I:(3) Continuous Copy
*:_R_R_L53
#                                                             ../orig/r.typ:268
O:Let me have a horse where the wide West still runs wild.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L53

#                                                             ../orig/r.typ:269
I:(4)
*:_R_R_L54
#                                                             ../orig/r.typ:271
O:I must see the warm colors, and feel the wind on that land.
 :I want to see a few cows among great rocks and sage brush.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L54

#                                                             ../orig/r.typ:272
I:(5)
*:_R_R_L55
#                                                             ../orig/r.typ:275
O:I like to hear a horse stamp.  I like the sweat on a horse.
 :I want to keep a camp, close to water, miles from any crowd.
 :At night, I want to enjoy a moon that shines on all the land.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L55

#                                                             ../orig/r.typ:276
I:(6)
*:_R_R_L56
#                                                             ../orig/r.typ:280
O:Yet I am in this city room to type news items for the paper.
 :I know the ins and outs of my city--its mayor, judge, jail.
 :I know how some men keep in power, and some get only kicks.
 :I am sick of dark ways to make money, of bribery and fraud.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L56

#                                                             ../orig/r.typ:281
I:(7)
*:_R_R_L57
#                                                             ../orig/r.typ:286
O:I want to hear the talk of folks who know hot sun and stock.
 :I like to join in jokes with men whose names I do not ask.
 :So had I just an old motor car and some gas to make it jump,
 :I would come at forty miles an hour, past fields of wheat,
 :till the grade grows high and rough, in keen air out West.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L57

#                                                             ../orig/r.typ:287
I:(8) Pointed Paragraph (p y)
*:_R_R_L58
#                                                             ../orig/r.typ:293
P:     Please report the people who study typing.  You may
 :truly say that money paid for this study is happily spent.
 :Today typing plays a very practical part in acquiring a
 :paying position.  We can use plenty of these days for exact
 :work in typing:  Monday, Tuesday, Wednesday, Thursday, Friday,
 :and Saturday.  Have you this sized type to print your copy?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L58

#                                                             ../orig/r.typ:294
I:(9) Test Paragraph
*:_R_R_L59
#                                                             ../orig/r.typ:302
P:     Were you the judge in a case like this, could you do the
 :just thing?  An old woman who keeps rooms hides her money
 :under a clock.  A man using one of the rooms motors rapidly
 :away.  The old woman says her money is gone.  We join in a
 :hunt for the man who is found in the West.  We take from him
 :the same sum of money.  We try to make him sweat and talk.
 :I use my power to set his term at ten years.  After he is put
 :in jail, the old woman finds her money still under the clock.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L59

#                                                             ../orig/r.typ:303
I:(10) Rhythmic Review
*:_R_R_L60
#                                                             ../orig/r.typ:304
O:How do we know which way so wild a horse will kick or jump?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L60

G:_R_E_R6
#------------------------------------------------------------------------------
# Lesson R7
#------------------------------------------------------------------------------
*:R7
*:_R_S_R7
#                                                             ../orig/r.typ:308
I:(1) Warming-Up Drill
*:_R_R_L61
#                                                             ../orig/r.typ:309
O:With that end in view I may soon have to put this question.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L61

#                                                             ../orig/r.typ:310
I:(2) Balanced Keyboard Drill
*:_R_R_L62
#                                                             ../orig/r.typ:311
O:ave hav eve ver ove quo not ive giv qui vis que ved eiv tha
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L62

#                                                             ../orig/r.typ:312
I:(3) Continuous Copy
*:_R_R_L63
#                                                             ../orig/r.typ:313
O:At our new villa a very novel event was given for the navy.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L63

#                                                             ../orig/r.typ:314
I:(4)
*:_R_R_L64
#                                                             ../orig/r.typ:316
O:Covers were laid in the unique ivory room.  Even the king
 :and queen were there with a quota of fair and lovely ladies.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L64

#                                                             ../orig/r.typ:317
I:(5)
*:_R_R_L65
#                                                             ../orig/r.typ:320
O:The queen was ready to quaff when her glass fell.  At once
 :all was quiet.  Every one, save one alone, quit the dance.
 :In all their lives, to quote, was never a thing more grave.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L65

#                                                             ../orig/r.typ:321
I:(6)
*:_R_R_L66
#                                                             ../orig/r.typ:325
O:Who was the lady with the vivid hair in the dress of heavy
 :gold?  Who was this queer one who dared so treat the queen?
 :Each guest did quail.  Could such quiet nerve ever avail?
 :With a move quite free and easy the lady let fall her glass.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L66

#                                                             ../orig/r.typ:326
I:(7)
*:_R_R_L67
#                                                             ../orig/r.typ:331
O:The queen put this query in a quick voice to quell them all:
 :Why does the whole world love a lover?  Why do we value you?
 :All did laugh.  The queen asked that, as a favor, you give us
 :those who have nerve, for they can love and serve.  Quite as
 :one who gave an equal favor, the queen sang over the radio.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L67

#                                                             ../orig/r.typ:332
I:(8) Pointed Paragraph (l s)
*:_R_R_L68
#                                                             ../orig/r.typ:338
P:     The earliest possible sales lessen the total losses.
 :Please enclose the latest details in those lists yourself.
 :On almost all calls I could save six dollars, especially in
 :July.  Tell the girls all the usual questions asked will be
 :useful shortly.  Use a small-sized envelope to post letters.
 :Last but not least, all else should still go on as usual.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L68

#                                                             ../orig/r.typ:339
I:(9) Test Paragraph
*:_R_R_L69
#                                                             ../orig/r.typ:347
P:     In our queen city I used to value two covers set every
 :day.  At these I used to serve a young man and a girl.  I did
 :love to see her quiet dress and quick smile favor her so.
 :I have never quite seen her equal, or a girl so very alive.
 :After I had given over this work, I went there to see them.
 :One night I saw a query form on her lips until she gave it
 :up and took leave.  The way she quit the boy was very queer
 :even if the papers did quote his prison term as five years.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L69

#                                                             ../orig/r.typ:348
I:(10) Rhythmic Review
*:_R_R_L70
#                                                             ../orig/r.typ:349
O:Even her very quick smile never makes us quite at our ease.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L70

G:_R_E_R7
#------------------------------------------------------------------------------
# Lesson R8
#------------------------------------------------------------------------------
*:R8
*:_R_S_R8
#                                                             ../orig/r.typ:353
I:(1) Warming-Up Drill
*:_R_R_L71
#                                                             ../orig/r.typ:354
O:I don't know why he can't have a large-sized order for you.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L71

#                                                             ../orig/r.typ:355
I:(2) Balanced Keyboard Drill
*:_R_R_L72
#                                                             ../orig/r.typ:357
O:sen aze hen ose hat ous had ize tte see hin oze to- zoo n't
 :e'l e's u'l h's d's n's s's e'r a's t's y's r's n't m's es'
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L72

#                                                             ../orig/r.typ:358
I:(3) Continuous Copy
*:_R_R_L73
#                                                             ../orig/r.typ:359
O:I'd never call Dan lazy; still, I can't say he wins prizes.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L73

#                                                             ../orig/r.typ:360
I:(4)
*:_R_R_L74
#                                                             ../orig/r.typ:362
O:Doesn't Dan know how to make an exclamation point?  He'll
 :have to hold down the spacer and hit the apostrophe and period.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L74

#                                                             ../orig/r.typ:363
I:(5)
*:_R_R_L75
#                                                             ../orig/r.typ:366
O:Owing to Dan's zeal, he'll get the point; he'll realize it's
 :faster.  He'll use it when amazed, as:  Whiz!  He'll use it
 :when he feels real zest, as:  Zip!  Let's go!  It's a fire!
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L75

#                                                             ../orig/r.typ:367
I:(6)
*:_R_R_L76
#                                                             ../orig/r.typ:372
O:A dozen small-sized craft frozen in the ice are afire under
 :a cold azure sky.  It's near zero in the fire zone; and over
 :the ships now razed to the water's edge, a light haze hangs.
 :I'm dazed as I gaze at my own ship; I'd never recognize that
 :crazy maze of still fizzing ruins as a deck.  What a fizzle!
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L76

#                                                             ../orig/r.typ:373
I:(7)
*:_R_R_L77
#                                                             ../orig/r.typ:379
O:Isn't there a lot of zip and zest to your work on a paper of
 :this size?  Don't you like to seize some amazing news item
 :that's good for the first page?  If Tom's hazy fire story is
 :a fizzle, why won't you squeeze it to a dozen lines?  Isn't
 :that easy for you?  I've wanted to see my name in print; I
 :guess I'll sail in a zeppelin to see if you'll print that.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L77

#                                                             ../orig/r.typ:380
I:(8) Pointed Paragraph (r n)
*:_R_R_L78
#                                                             ../orig/r.typ:387
P:     A note from Ann says her friend prefers to change her
 :return to Arizona from next February to November.  The reason
 :is an error of the owner of the ranch who will not refund
 :her rent.  The janitor is running some errand, for he has
 :worked in the rain near the northern entrance during dinner.
 :I hear that now neither her friends from North Carolina nor
 :Virginia can remain an afternoon and refrain from a quarrel.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L78

#                                                             ../orig/r.typ:388
I:(9) Test Paragraph
*:_R_R_L79
#                                                             ../orig/r.typ:396
P:     I'll admit I seize a chance to go with these dozen
 :people.  We left under an azure sky, yet today it's rainy
 :and hazy.  That Dr. Tedd is odd; he won't play; he's doing
 :a report on how to zone cities of any size; so he won't let
 :us dance to radio jazz.  Tonight we're to try a play that
 :hasn't any zest or zip.  Its prize is Tom's money, and he'll
 :not stay; he feels it's a fizzle.  My zeal for gazing on the
 :crowd is at zero.  They don't and can't pass any play quiz.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L79

#                                                             ../orig/r.typ:397
I:(10) Rhythmic Review
*:_R_R_L80
#                                                             ../orig/r.typ:398
O:It's crazy for me to type news items on paper of this size!
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L80

G:_R_E_R8
#------------------------------------------------------------------------------
# Lesson R9
#------------------------------------------------------------------------------
*:R9
*:_R_S_R9
#                                                             ../orig/r.typ:402
I:(1) Warming-Up Drill
*:_R_R_L81
#                                                             ../orig/r.typ:403
O:To some extent he has been able to do the next best thing.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L81

#                                                             ../orig/r.typ:404
I:(2) Balanced Keyboard Drill
*:_R_R_L82
#                                                             ../orig/r.typ:405
O:abo bet bee ble bou bef ext ber six sib nex abl aby mbe box
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L82

#                                                             ../orig/r.typ:406
I:(3) Continuous Copy
*:_R_R_L83
#                                                             ../orig/r.typ:407
O:Dad just about broke down at the bad news.  Bill has no job.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L83

#                                                             ../orig/r.typ:408
I:(4)
*:_R_R_L84
#                                                             ../orig/r.typ:410
O:Dad was vexed.  He said that he might as well burn his bonds
 :next.  He has sixty bonds but the prices sent all below par.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L84

#                                                             ../orig/r.typ:411
I:(5)
*:_R_R_L85
#                                                             ../orig/r.typ:414
O:Dad talks about a jinx.  He says that maybe their bank will
 :close so he cannot pay up taxes and bills before Christmas.
 :Dad says they all may have to exist on home-grown wax beans.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L85

#                                                             ../orig/r.typ:415
I:(6)
*:_R_R_L86
#                                                             ../orig/r.typ:419
O:Dad adds that boys ought to be busy and maybe play ball or
 :box at the club.  Bill excels, but says he cannot box on
 :wax beans alone.  Beef must be back on the board.  Bill has
 :boxed as an extra at a bazaar.  He is big, and able to box.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L86

#                                                             ../orig/r.typ:420
I:(7)
*:_R_R_L87
#                                                             ../orig/r.typ:425
O:Bill begs Dad not to be blue, and his text is this:  We
 :are all in the same boat.  No one can buy.  No one can build.
 :Labor is hard hit, too.  I, for one, would like to toss the
 :cards on the table and start a new deal.  When exact codes
 :are fixed, as best for all, every person must do his bit.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L87

#                                                             ../orig/r.typ:426
I:(8) Pointed Paragraph (f y)
*:_R_R_L88
#                                                             ../orig/r.typ:433
P:     Satisfy yourself that it will be funny, but perfectly
 :satisfactory, for forty or fifty of the faculty to fly from
 :Buffalo to New York on the first Friday in February.  If
 :they prefer, we will offer them waffles, jelly, and coffee
 :before they fly or get dizzy.  Sixty flyers can qualify
 :confidently to face any difficulty.  A friendly inquiry
 :from any family will be very cheerfully and fully answered.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L88

#                                                             ../orig/r.typ:434
I:(8a) Pointed Paragraph (i d)
*:_R_R_L89
#                                                             ../orig/r.typ:440
P:     Children find being quizzed in division, addition, and
 :reading difficult.  They studied daily during their third
 :period and tried to be confident.  I think they did include
 :Florida and Rhode Island in their wide reading; and have
 :just decided to dispose of Detroit, Grand Rapids, Richmond,
 :Providence, and Philadelphia next week.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L89

#                                                             ../orig/r.typ:441
I:(9) Test Paragraph
*:_R_R_L90
#                                                             ../orig/r.typ:451
P:     By using the new banks of keys on the new keyboard, you
 :are able to learn or excel with less labor.  These new banks
 :have been based on an exact table of words used.  You begin
 :at once on the best bank.  On the old keyboard you have to
 :type most of the text on the next bank above and on the bank
 :below.  Because of this fact your fingers bound back and
 :forth between the upper and lower banks of keys.  But those
 :extra jumps necessary on the old keyboard do not exist on the
 :new keyboard.  Nor is your left hand taxed with extra labor.
 :The keys are fixed to keep both hands busy and in balance.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L90

#                                                             ../orig/r.typ:452
I:(10) Rhythmic Review
*:_R_R_L91
#                                                             ../orig/r.typ:453
O:Those boxes of books for New Mexico may be ready next week.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L91

G:_R_E_R9
#------------------------------------------------------------------------------
# Lesson R10
#------------------------------------------------------------------------------
*:R10
*:_R_S_R10
#                                                             ../orig/r.typ:457
I:(1) Warming-Up Drill
*:_R_R_L92
#                                                             ../orig/r.typ:458
O:Next time we must ask to have you make them just as he does.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L92

#                                                             ../orig/r.typ:459
I:(2) Balanced Keyboard Drill
*:_R_R_L93
#                                                             ../orig/r.typ:461
O:ite ith ine nce tio she hou how ime ibl ece muc out oth our
 :ate and een ind oon und one thi lix his ise wer jun ett exp
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L93

#                                                             ../orig/r.typ:462
I:(3) Continuous Copy--Review
*:_R_R_L94
#                                                             ../orig/r.typ:463
O:I am going to be lazy this weekend and do just what I want.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L94

#                                                             ../orig/r.typ:464
I:(4)
*:_R_R_L95
#                                                             ../orig/r.typ:466
O:Today I quit being vexed with the old job.  I must seize
 :one extra bit of zest and join the exit from the big city.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L95

#                                                             ../orig/r.typ:467
I:(5)
*:_R_R_L96
#                                                             ../orig/r.typ:470
O:To begin with, the same old auto will bear us to the beach
 :where a good-sized boat floats easily in the blue water.
 :Our boat is build for room.  Her cabin has a busy table.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L96

#                                                             ../orig/r.typ:471
I:(6)
*:_R_R_L97
#                                                             ../orig/r.typ:475
O:I know Nan will come if Bill does, and Ted likes to be with
 :Ann.  I would never quite have the nerve to keep my good
 :board back when our club navy moves out into the quiet water.
 :We leave at an early hour when the sun is still under cover.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L97

#                                                             ../orig/r.typ:476
I:(7)
*:_R_R_L98
#                                                             ../orig/r.typ:481
O:All day will be warm and novel.  The far banks will slide by
 :while we gaze.  She is an out-and-out able boat, heavy but
 :never gives trouble.  She is never taxed in quick water.  I
 :feel the water jump and break.  Queer how I feel the bond
 :that exists between me and my boat.  She is a prize I value.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L98

#                                                             ../orig/r.typ:482
I:(8) Pointed Paragraph (m w)
*:_R_R_L99
#                                                             ../orig/r.typ:488
P:     Some women swim in the spring.  Some women swim in
 :the warm water of summer.  Women in Brazil may swim even in
 :November.  Some women from Japan will swim tomorrow.  We want
 :to show the women from New Mexico and Wyoming how to swim in
 :winter.  We will work with them for a few weeks.  When they
 :go home we wonder if they will write from time to time.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L99

#                                                             ../orig/r.typ:489
I:(8A) Pointed Paragraph (i o)
*:_R_R_L100
#                                                             ../orig/r.typ:495
P:     I'm going to obtain oil options tonight and to file my
 :copies without noise, or outside notice.  I am anxious to
 :avoid an action.  If I voice an official opinion, I will omit
 :serious points.  Knowing conditions, I am hoping that I'll
 :be enjoying a glorious addition to my income.  I am going to
 :join society and be social with juniors and seniors alike.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L100

#                                                             ../orig/r.typ:496
I:(9) Test Paragraph
*:_R_R_L101
#                                                             ../orig/r.typ:504
P:     Bound for some place where the sun sets in the west,
 :soon it is the night that I favor.  Next to the night and
 :boat and water, maybe I judge our sail by its excellent bill
 :of fare.  Here I am very exact, as I never set a poor table.
 :I stock an up-to-date table, set out under the first dozen
 :stars.  I enjoy having every boy able to quaff his quota of
 :soup and boast or sing with zeal and make any queer joke.
 :With a moon, I can name no event to equal a boat and water.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L101

#                                                             ../orig/r.typ:505
I:(10) Rhythmic Review
*:_R_R_L102
#                                                             ../orig/r.typ:506
O:It is good drill to keep going in even time for ten minutes.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L102

G:_R_E_R10
#------------------------------------------------------------------------------
# Lesson R11
#------------------------------------------------------------------------------
*:R11
*:_R_S_R11
*:_R_R_L103
#                                                             ../orig/r.typ:514
T:
 :In this lesson we start on the top row, which has the numerals and
 :a lot of the special characters.  Note that the F-finger presses the
 :4-key and the 5-key; the J-finger presses the 7-key and the 8-key.
 :Either the F-finger or the J-finger may press the 6-key.
Q: Press Y to continue, or Fkey12 to exit 
N:_R_R_L103

#                                                             ../orig/r.typ:515
I:(1) Warming-Up Drill
*:_R_R_L104
#                                                             ../orig/r.typ:516
O:She can tell us all there is to say on her side and what to do.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L104

#                                                             ../orig/r.typ:517
I:(2) Rhythm and Keyboard Drill
*:_R_R_L105
#                                                             ../orig/r.typ:519
O:ki9 de3 ju8 fr4 ju7 fr5 jy6 ft6 lo0 sw2 ju7 fr5 jy6 ft6 ;p-
 :k9 d3 j8 f4 j7 f5 f6 l0 s2 j8 f4 j7 f5 j6 f6 k9 d3 ;- s2
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L105

#                                                             ../orig/r.typ:520
I:(3) Continuous Copy
*:_R_R_L106
#                                                             ../orig/r.typ:521
O:To buy an air-mail stamp I save 1, 2, 4, and at last 6 cents.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L106

#                                                             ../orig/r.typ:522
I:(4)
*:_R_R_L107
#                                                             ../orig/r.typ:524
O:In two years my dollar earns 1, 3, 5, 7, and perhaps 8 cents.
 :Buy at once:  4 candy balls,9 bars, 6 or 8 of gum, 2 cakes.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L107

#                                                             ../orig/r.typ:525
I:(5)
*:_R_R_L108
#                                                             ../orig/r.typ:528
O:2 and 2 are 4; 3 and 3 are 6; 4 and 4 are 8; 5 and 0 are 5.
 :3 and 4 are 7; 5 and 4 are 9; 2 and 6 are 8; 7 and 0 are 7.
 :1 and 1 are 2; 3 and 1 are 4; 5 and 1 are 6; 7 and 1 are 8.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L108

#                                                             ../orig/r.typ:529
I:(6)
*:_R_R_L109
#                                                             ../orig/r.typ:533
O:I have finished Grade 9B.  In my first weeks of typing in
 :Grade 10A, I learned to use all the keys in Lessons 3 and 4.
 :In Lessons 1 and 2, and in part of No.5, I tried my hands on
 :the home row.  Both Lessons 6 and 7 were in the bank above.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L109

#                                                             ../orig/r.typ:534
I:(7)
*:_R_R_L110
#                                                             ../orig/r.typ:539
O:Typing is clerical work.  Twenty years ago less than 5 per
 :cent of all those at work had clerical jobs; today, about 8
 :per cent have such jobs.  Does it interest you that of all
 :paid typists only 3 per cent are more than 44 years of age?
 :Most of the 810,000 typists in the last census are young.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L110

#                                                             ../orig/r.typ:540
I:(8-9)
*:_R_R_L111
#                                                             ../orig/r.typ:546
P:To throw a carriage do you take 6 or 7 times--or to shift for
 :a capital, 2 or 3 times--as long as to hit one letter?  And
 :do you know the common keys?  One common pair of letters is used
 :for every 3 or 4 other pairs, even though there are more than
 :600 other pairs.  The digits are 0, 1, 2, 3, 4, 5, 6, 7, 8, 9.
 :You will spell these out more often than you will type them.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L111

#                                                             ../orig/r.typ:547
I:(10) Rhythmic Review
*:_R_R_L112
#                                                             ../orig/r.typ:548
O:I am vexed if my prize went to my old address, 55 Fifth Avenue.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L112

G:_R_E_R11
#------------------------------------------------------------------------------
# Lesson R12
#------------------------------------------------------------------------------
*:R12
*:_R_S_R12
#                                                             ../orig/r.typ:552
I:(1) Warming-Up Drill
*:_R_R_L113
#                                                             ../orig/r.typ:553
O:I should like to arrange to have you see me here next week.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L113

#                                                             ../orig/r.typ:554
I:(2) Rhythm and Keyboard Drill
*:_R_R_L114
#                                                             ../orig/r.typ:556
O:k9 d3 j8 f4 j7 f5 f6 j6 10 s2 j8 f4 j7 f5 f6 j6 k9 d3 ;- s2
 :k98 d34 j87 f45 109 s23 k93 d39 j84 f48 j75 f57 j76 f56 102
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L114

#                                                             ../orig/r.typ:557
I:(3) Continuous Copy
*:_R_R_L115
#                                                             ../orig/r.typ:558
O:10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L115

#                                                             ../orig/r.typ:559
I:(4)
*:_R_R_L116
#                                                             ../orig/r.typ:561
O:As soon as you can type at 12 words a minute, jump to 24;
 :later to 30, 36, 42, 48, or other rate that seems to fit.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L116

#                                                             ../orig/r.typ:562
I:(5)
*:_R_R_L117
#                                                             ../orig/r.typ:565
O:On one day in June the heat ran to 106, 103, 98, 95, 92, in
 :some cities, but only to 40, 43, 47, 50, 51, 52, 60 in other
 :cities.  Rain fell from .00 or .04 to .40 or to .68 inches.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L117

#                                                             ../orig/r.typ:566
I:(6)
*:_R_R_L118
#                                                             ../orig/r.typ:570
O:The next step in better typing is to learn to graph a curve.
 :If your test score each week rises from 22 to 28, 32, 37,
 :40, 44, 48, 51, 53, and 55 words a minute, put these on a
 :chart.  See this curve grow higher each week.  Or use bars.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L118

#                                                             ../orig/r.typ:571
I:(7)
*:_R_R_L119
#                                                             ../orig/r.typ:576
O:The usual test scores point to waste in many a class.  After
 :all the work of a first term, girls may reach only 25 words
 :a minute, boys only 22 words.  At the end of 34 weeks these
 :usual scores might be 29 or 31 or 34.  Indeed, 25 to 33 per
 :cent of the students may type less than 20 words per minute.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L119

#                                                             ../orig/r.typ:577
I:(8) Pointed Paragraph (n v)
*:_R_R_L120
#                                                             ../orig/r.typ:584
P:     Eleven invitations for Thanksgiving vacation arrived in
 :advance of November.  In vain have a dozen relatives invited
 :me to visit Vermont, Virginia, and Nevada.  I love being
 :invited and I believe in never avoiding an invitation to any
 :Thanksgiving banquet.  I even plan to have the sixth to the
 :seventeenth of November for varied ventures and to visit
 :that novel Denver University on my vacation.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L120

#                                                             ../orig/r.typ:585
I:(9) Test Paragraph
*:_R_R_L121
#                                                             ../orig/r.typ:593
P:     How much do you weigh?  A young boy who is 5 feet tall
 :may weigh 112 pounds; with an extra inch, 115 pounds.  Add 3
 :pounds for any inch added.  Thus if 5 feet and 4 inches, he
 :may weigh 124.  If taller, add 4 pounds for each added inch.
 :If 5 feet and 7 inches, he may weigh 136; if 5 feet and 9
 :inches, 144; if 5 feet and 10 inches, he may weigh 148.  Now
 :add 5 pounds for each added inch.  Thus to stand 6 feet tall
 :may mean 158 pounds.  It is better to be a little over-weight.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L121

#                                                             ../orig/r.typ:594
I:(10) Rhythmic Review
*:_R_R_L122
#                                                             ../orig/r.typ:595
O:In order to park on Sixth at 11:05 we have to beat 135 cars!
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L122

G:_R_E_R12
#------------------------------------------------------------------------------
# Lesson R13
#------------------------------------------------------------------------------
*:R13
*:_R_S_R13
*:_R_R_L123
#                                                             ../orig/r.typ:601
T:
 :In this lesson we will learn the rest of the special characters
 :on the keyboard.
Q: Press Y to continue, or Fkey12 to exit 
N:_R_R_L123

#                                                             ../orig/r.typ:602
I:(1) Warming-Up Drill
*:_R_R_L124
#                                                             ../orig/r.typ:603
O:If you do not hear soon, I want you to write again and again.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L124

#                                                             ../orig/r.typ:604
I:(2) Rhythm and Keyboard Drill
*:_R_R_L125
#                                                             ../orig/r.typ:607
O:k9( d3# j8* f4$ j7& f5% f6^ j6^ l0) s2@ ;-_ ;[] ;`~ d3# ;/?
 :k( d# j* f$ j& f% j^ f^ l) s@ ;_ s@ ;{ d# ;@ f% ;? f^ j^ s@
 :"A "S "O "W "E "C "P "F "I "M "E "B e5" t4" u3" h2" u1' n6'
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L125

#                                                             ../orig/r.typ:608
I:(3) Continuous Copy
*:_R_R_L126
#                                                             ../orig/r.typ:609
O:Send at once:  Form #93* @ $18.50 per dozen, 12% discount.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L126

#                                                             ../orig/r.typ:610
I:(4)
*:_R_R_L127
#                                                             ../orig/r.typ:613
O:Sold to Smith & Sons, terms 1%, 10 days; 8 doz. 3" screws @
 :5.25 cents, 42 cents; 16 files @ 5-3/8 cents, 86 cents; 3 #9 drills
 :@ 75 cents, $2.75.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L127

#                                                             ../orig/r.typ:614
I:(5)
*:_R_R_L128
#                                                             ../orig/r.typ:617
O:Arrange to have A. C. Whitman & Co. deliver to our Seattle
 :office, Wednesday, October, 26:  30 reams white paper, #99,
 :@ 75 cents, $22.50; 4 files, Style 6**, @ $9 each, $26.....$58.50.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L128

#                                                             ../orig/r.typ:618
I:(6)
*:_R_R_L129
#                                                             ../orig/r.typ:624
O:In his speech on "Can a Business Man Be Honest?" he proved:
 :
 :(1) There are may ways, some hardly honest, to make money.
 :(2) It may pay to treat fairly a business rival or employee.
 :(3) Saving time and material often leads to a large profit.
 :(4) The most desirable kinds of success are gained honestly.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L129

#                                                             ../orig/r.typ:625
I:(7)
*:_R_R_L130
#                                                             ../orig/r.typ:630
O:The common stock has paid from 8% to 27% cash before 1929.
 :Both the common and the "B" stocks have received 12% this
 :year, or $3 per share.  The class "B" stock has made a new
 :record, the range in price being 38.5 high and 32.25 low.  As
 :the market improves the common and "B" stocks may pay 15%.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L130

#                                                             ../orig/r.typ:631
I:(8)
*:_R_R_L131
#                                                             ../orig/r.typ:645
P:A. C. White & Company
 :Idaho Falls, Idaho
 :
 :Gentlemen:
 :
 :Ship to our general office, by express, the following order:
 :
 :75 boxes, style 2**, 14.25" x 18.5", @ 60 cents each . . . . .$45.00
 : 5 boxes, style 3**, 16.25" x 20.5", @ 65 cents each . . . . .  3.25
 : 9 dozen boxes, style #7, @ $2 a doz. (less 10%) . . . . . . . 16.20
 :
 :We will send our check January 4; less 2% for cash.
 :
 :Very truly yours,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L131

#                                                             ../orig/r.typ:646
I:(9) Rhythmic Review
*:_R_R_L132
#                                                             ../orig/r.typ:647
O:He said, "I long to get home after seven days in the country."
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L132

G:_R_E_R13
#------------------------------------------------------------------------------
# Lesson R14
#------------------------------------------------------------------------------
*:R14
*:_R_S_R14
#                                                             ../orig/r.typ:651
I:(1) Warming-Up Drill
*:_R_R_L133
#                                                             ../orig/r.typ:652
O:I trust that you will be able to call upon us very soon.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L133

#                                                             ../orig/r.typ:653
I:(2) Rhythm and Keyboard Drill
*:_R_R_L134
#                                                             ../orig/r.typ:656
O:k( d# j* f$ j& f% j& f^ l) s@ ;_ d# ;` f% ;` f$ j^ s@
 :(3 8% #9 2) @0 [@ *4 2_ $8 [% 3 1/5 3 @ 5 & 3^ $7 5* $8 `)
 :as" nt" et" re" us" me" is" de" it" t." e." r," o," ?" ?" ?"
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L134

*:_R_R_L135
#                                                             ../orig/r.typ:659
O:t( e# h* u$ h& u% h& u^ n) o@ s~ e# s/ u% s/ u$ h^ o@
 :(3 8% #9 2) @0 [@ *4 2_ $8 [% 3 1/5 3 @ 5 & 3^ $7 5* $8 `)
 :as" nt" et" re" us" me" is" de" it" t." e." r," o," ?" ?" ?"
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L135

#                                                             ../orig/r.typ:660
I:(3) Continuous Copy
*:_R_R_L136
#                                                             ../orig/r.typ:661
O:The Herald, the Daily News, and the Post reported the story.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L136

#                                                             ../orig/r.typ:662
I:(4)
*:_R_R_L137
#                                                             ../orig/r.typ:664
O:Read "National Affairs" in Time for December 6, 1940.  You
 :may think that Snappy Stories has more news than Time.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L137

#                                                             ../orig/r.typ:665
I:(5)
*:_R_R_L138
#                                                             ../orig/r.typ:668
O:He goes November 6, on Train #2 (North Coast), at 9:15 p.m.
 :Train #35-4 (Southern Route) leaves at 6:00 but stops often.
 :He likes to go by bus (Overland Route), but it goes at 2:10.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L138

#                                                             ../orig/r.typ:669
I:(6)
*:_R_R_L139
#                                                             ../orig/r.typ:673
O:"Good morning," said the clerk.  "May I be of help to you?"
 :"Thank you," she replied, "but I must wait to see Mr. Burd."
 :"He will be in his office at 10:20," the clerk assured her.
 :"That will be fine," the clerk said, "I'll wait for him, too."
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L139

#                                                             ../orig/r.typ:674
I:(7)
*:_R_R_L140
#                                                             ../orig/r.typ:679
O:SOIL--Remove to depth of 9" under house and 5' on all sides.
 :FRAME WORK--Beams 2" x 8"; braces 2" x 4"; rafters 2" x 6".
 :ROOF--Use 18", #1 cedar shingles, laid 5" to the weather.
 :PLUMBING--Use #1 materials; 4" cast iron pipe; sink 2' x 6'.
 :LATH AND PLASTER--Use #1 spruce 3/8 x 1.5"; 2 coats plaster.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L140

#                                                             ../orig/r.typ:680
I:(8) Pointed Paragraph (a o)
*:_R_R_L141
#                                                             ../orig/r.typ:688
P:     To attain a personal association with so popular an
 :author is an approved social ambition.  To loan him money or
 :catalog his books we consider a favor.  Today his tailor, later
 :with a coat, loads on him a thousand pardons.  A normal Mon-
 :day program allows a lazy forenoon to ocean and boat; after-
 :noon to various auto roads in orange season; night to play
 :contract or follow the local opera.  As soon as he can account
 :for another book, our author is anxious to go abroad.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L141

#                                                             ../orig/r.typ:689
I:(9) Test Paragraph
*:_R_R_L142
#                                                             ../orig/r.typ:697
P:     "Has #4-4 gone?" she asked, rushing in out of the cold.
 :     "No--why $4?" the station agent* answered (he had won-
 :dered why she was so worried).  But he wasn't to find out--
 :for a white hand pushed back $15 and picked up an old copy
 :of Good Housekeeping from a seat.  She began to read.  When
 :he noted she had chosen "Winter Comfort" he was 100% amused.
 :------------------------------------------------------------
 :*Red Wild (heir to $750,000 at 5%, working on the B. & O.).
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L142

#                                                             ../orig/r.typ:698
I:(10) Rhythmic Review
*:_R_R_L143
#                                                             ../orig/r.typ:699
O:I said, "There is the city and this bus won't be long now."
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_R_R_L143

G:_R_E_R14
#------------------------------------------------------------------------------
# Lesson series R jump tables
#------------------------------------------------------------------------------
*:_R_E_R1
Q: Do you want to continue to lesson R2 [Y/N] ? 
N:_R_MENU
G:_R_M_R2
*:_R_E_R2
Q: Do you want to continue to lesson R3 [Y/N] ? 
N:_R_MENU
G:_R_M_R3
*:_R_E_R3
Q: Do you want to continue to lesson R4 [Y/N] ? 
N:_R_MENU
G:_R_M_R4
*:_R_E_R4
Q: Do you want to continue to lesson R5 [Y/N] ? 
N:_R_MENU
G:_R_M_R5
*:_R_E_R5
Q: Do you want to continue to lesson R6 [Y/N] ? 
N:_R_MENU
G:_R_M_R6
*:_R_E_R6
Q: Do you want to continue to lesson R7 [Y/N] ? 
N:_R_MENU
G:_R_M_R7
*:_R_E_R7
Q: Do you want to continue to lesson R8 [Y/N] ? 
N:_R_MENU
G:_R_M_R8
*:_R_E_R8
Q: Do you want to continue to lesson R9 [Y/N] ? 
N:_R_MENU
G:_R_M_R9
*:_R_E_R9
Q: Do you want to continue to lesson R10 [Y/N] ? 
N:_R_MENU
G:_R_M_R10
*:_R_E_R10
Q: Do you want to continue to lesson R11 [Y/N] ? 
N:_R_MENU
G:_R_M_R11
*:_R_E_R11
Q: Do you want to continue to lesson R12 [Y/N] ? 
N:_R_MENU
G:_R_M_R12
*:_R_E_R12
Q: Do you want to continue to lesson R13 [Y/N] ? 
N:_R_MENU
G:_R_M_R13
*:_R_E_R13
Q: Do you want to continue to lesson R14 [Y/N] ? 
N:_R_MENU
G:_R_M_R14
*:_R_E_R14
G:_R_MENU

*:_R_M_R1
B:                             Lesson R1
K:12:_R_MENU
G:_R_S_R1
*:_R_M_R2
B:                             Lesson R2
K:12:_R_MENU
G:_R_S_R2
*:_R_M_R3
B:                             Lesson R3
K:12:_R_MENU
G:_R_S_R3
*:_R_M_R4
B:                             Lesson R4
K:12:_R_MENU
G:_R_S_R4
*:_R_M_R5
B:                             Lesson R5
K:12:_R_MENU
G:_R_S_R5
*:_R_M_R6
B:                             Lesson R6
K:12:_R_MENU
G:_R_S_R6
*:_R_M_R7
B:                             Lesson R7
K:12:_R_MENU
G:_R_S_R7
*:_R_M_R8
B:                             Lesson R8
K:12:_R_MENU
G:_R_S_R8
*:_R_M_R9
B:                             Lesson R9
K:12:_R_MENU
G:_R_S_R9
*:_R_M_R10
B:                            Lesson R10
K:12:_R_MENU
G:_R_S_R10
*:_R_M_R11
B:                            Lesson R11
K:12:_R_MENU
G:_R_S_R11
*:_R_M_R12
B:                            Lesson R12
K:12:_R_MENU
G:_R_S_R12
*:_R_M_R13
B:                            Lesson R13
K:12:_R_MENU
G:_R_S_R13
*:_R_M_R14
B:                            Lesson R14
K:12:_R_MENU
G:_R_S_R14
#------------------------------------------------------------------------------
# Lesson series R menu
#------------------------------------------------------------------------------
*:_R_MENU
*:_R_MENU_PAGE0
B:                 Lesson selection menu - series R [page 1 of 2]
K:1:_R_M_R1
K:2:_R_M_R2
K:3:_R_M_R3
K:4:_R_M_R4
K:5:_R_M_R5
K:6:_R_M_R6
K:7:_R_M_R7
K:8:_R_M_R8
K:9:_R_M_R9
K:10:_R_M_R10
K:11:_R_MENU_PAGE1
K:12:_R_QEXIT
T:The R series contains the following 14 lessons:
 :
 :        Fkey 1 - Lesson R1     Practise
 :        Fkey 2 - Lesson R2     Practise
 :        Fkey 3 - Lesson R3     Practise
 :        Fkey 4 - Lesson R4     Practise
 :        Fkey 5 - Lesson R5     Practise
 :        Fkey 6 - Lesson R6     Practise
 :        Fkey 7 - Lesson R7     Practise
 :        Fkey 8 - Lesson R8     Practise
 :        Fkey 9 - Lesson R9     Practise
 :        Fkey10 - Lesson R10    Practise
 :
 :        Fkey11 - Next menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_R_MENU_PAGE0
*:_R_MENU_PAGE1
B:                 Lesson selection menu - series R [page 2 of 2]
K:1:_R_M_R11
K:2:_R_M_R12
K:3:_R_M_R13
K:4:_R_M_R14
K:5:NULL
K:6:NULL
K:7:NULL
K:8:NULL
K:9:NULL
K:10:NULL
K:11:_R_MENU_PAGE0
K:12:_R_QEXIT
T:The R series contains the following 14 lessons:
 :
 :        Fkey 1 - Lesson R11    Practise
 :        Fkey 2 - Lesson R12    Practise
 :        Fkey 3 - Lesson R13    Practise
 :        Fkey 4 - Lesson R14    Practise
 :
 :
 :
 :
 :
 :
 :
 :        Fkey11 - First menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_R_MENU_PAGE1
*:_R_QEXIT
Q: Do you want to leave this lesson series? [Y/N] ? 
N:_R_MENU
G:_R_EXIT
*:_R_EXIT
#------------------------------------------------------------------------------
# End of file r.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_T_SERIES
# Start of file t.typ
#------------------------------------------------------------------------------
# Series T
#------------------------------------------------------------------------------
G:_T_MENU
*:_T_NO_MENU
#------------------------------------------------------------------------------
# Lesson T1
#------------------------------------------------------------------------------
*:T1
*:_T_S_T1
*:_T_R_L0
#                                                              ../orig/t.typ:21
T:			Welcome to lesson T1.
 :
 :In the T series of lessons, we will be learning to touch-type on the standard
 :keyboard.  I will introduce you to each letter on the keyboard, one at a time.
 :By the time you have completed this series, you will be able to type the entire
 :alphabet, the numbers, and most of the punctuation keys by touch.
 :
 :If you have never taken any lessons in typing before, please be patient.  Typing
 :is not difficult but it does take a lot of practice.  Avoid the tendency to
 :look down at your fingers while typing.  This is a very bad habit and is hard
 :to break later.  If you hit the wrong key, I will let you know.  (But, I won't
 :tell anyone else, so don't worry about it.)
 :
 :If you have always used the hunt-and-peck method, you will have an even harder
 :time keeping yourself from looking.  Don't be surprised if you find touch
 :typing slower than your old ways.  It may be slower when you first start.
 :But, touch typing is far faster once you get the hang of it.
 :
 :If you can already touch type, you should be able to go through these lessons
 :fairly quickly.  Or, you may want to go directly to the S series.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L0

*:_T_R_L1
#                                                              ../orig/t.typ:42
T:
 :			The HOME Keys.
 :
 :In order to hit the correct keys by touch alone, you must always know where your
 :fingers are.  The way to do this is to have a special place for each finger.
 :This key is called the HOME position.
 :
 :Place the first finger of your right hand on the J-key.  Now, place your second
 :finger on the K-key, your third finger on the L-key, and your fourth-finger on
 :the ;-key (the one with the : and ; on it).
 :
 :Similarly place the four fingers of your left hand on the F, D, S, and A-keys.
 :Place your right thumb over the SPACE bar.  (Henceforth, always hit the SPACE
 :bar with this thumb.)  Now, lift all your fingers slightly so that they are
 :poised just over the keys.  Each finger should be just barely touching its home
 :key.  This is an electronic keyboard and does not take much pressure to ac-
 :cidentally press the key down.
 :
 :Learn these positions well.  Whenever you are about to type a line, look at your
 :fingers and make sure they are in the HOME position.  Then don't look at them
 :again.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L1

*:_T_R_L2
#                                                              ../orig/t.typ:63
T:
 :			DRILL PATTERNS
 :
 :For the rest of this lesson, I will display a line of text in the middle of the
 :screen and instructions at the top of the screen.
 :
 :All you have to do is type in the characters that you see in the middle of
 :the screen.  If you hit the correct key, I will not do anything.  If you make
 :a mistake, I will display a large X under the letter that you got wrong and 
 :beep the terminal. In either event, just keep going by typing the next letter.
 :
 :When you have finished typing the line, hit the RETURN key.  To do this, extend
 :the little finger of your right hand over to the RETURN key.  Hit the key and
 :zip the finger back to its home position.  Be careful not to let your other
 :fingers move far from their home positions in the process.  Also, be careful
 :not to type an extra space at the end of the line.
 :
 :If you made no mistakes on the line, I will display the next drill pattern.  If
 :you did make a mistake, I will beep at you and make you do the line again.  If
 :on the second try you made more than two mistakes, I will beep again and make
 :you try again, etc.  Don't forget to use your right thumb for the SPACE bar.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L2

#                                                              ../orig/t.typ:64
I:Hit the F-key four times with the first finger of your left hand.
*:_T_R_L3
#                                                              ../orig/t.typ:65
O:ffff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L3

#                                                              ../orig/t.typ:66
I:Alternately, hit the F-key and the SPACE bar.
*:_T_R_L4
#                                                              ../orig/t.typ:67
O:fff fff fff ff ff ff f f f
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L4

#                                                              ../orig/t.typ:68
I:Don't look at your hands!
#                                                              ../orig/t.typ:69
 :Hit the J-key with the first finger of your right hand.
*:_T_R_L5
#                                                              ../orig/t.typ:70
O:jjj jjj jjj jj jj jj j j j
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L5

#                                                              ../orig/t.typ:71
I:Use the left hand for the F and the right hand for the J.
*:_T_R_L6
#                                                              ../orig/t.typ:72
O:fff jjj fff jj ff jj f j f j
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L6

#                                                              ../orig/t.typ:73
I:Now intermix them.
*:_T_R_L7
#                                                              ../orig/t.typ:74
O:ffjj jjff fjf fjf jfj jfj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L7

#                                                              ../orig/t.typ:75
I:Use the second finger of the left hand for the D-key.
*:_T_R_L8
#                                                              ../orig/t.typ:76
O:ddd ddd ddd dd dd dd d d d
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L8

#                                                              ../orig/t.typ:77
I:Use the second finger of the right hand for the K-key.
*:_T_R_L9
#                                                              ../orig/t.typ:78
O:kkk kkk kkk kk kk kk k k k
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L9

#                                                              ../orig/t.typ:80
I:Now both.
*:_T_R_L10
#                                                              ../orig/t.typ:81
O:ddd kkk dd kk dkd kdk ddd kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L10

#                                                              ../orig/t.typ:82
I:Use the third fingers of the each hand for the S and L-keys.
*:_T_R_L11
#                                                              ../orig/t.typ:83
O:sss lll sss lll sss ss ll ss ll s l
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L11

#                                                              ../orig/t.typ:84
I:Use the fourth fingers for the A and ;-keys.
*:_T_R_L12
#                                                              ../orig/t.typ:85
O:aaa ;;; aaa ;;; aa ;; aa ;; a ;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L12

#                                                              ../orig/t.typ:86
I:That's enough keys for today.  Let's review them.
*:_T_R_L13
#                                                              ../orig/t.typ:87
O:fff jjj ddd kkk sss lll aaa ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L13

#                                                              ../orig/t.typ:88
I:Again.
*:_T_R_L14
#                                                              ../orig/t.typ:89
O:fff jjj ddd kkk sss lll aaa ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L14

#                                                              ../orig/t.typ:90
I:Try mixing them together.
*:_T_R_L15
#                                                              ../orig/t.typ:91
O:asdf jkl; asdf jkl; asdf jkl;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L15

#                                                              ../orig/t.typ:92
I:And still more.
*:_T_R_L16
#                                                              ../orig/t.typ:93
O:fjf kdk sls ;a;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L16

#                                                              ../orig/t.typ:94
I:Before, we finish, let's try some words.
*:_T_R_L17
#                                                              ../orig/t.typ:95
O:sad add all; alas flask fad
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L17

#                                                              ../orig/t.typ:96
I:How about a sentence.
*:_T_R_L18
#                                                              ../orig/t.typ:97
O:ask a sad lad
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L18

#                                                              ../orig/t.typ:98
I:Sentences are kind of limited with only one vowel!
*:_T_R_L19
#                                                              ../orig/t.typ:99
O:dad asks a lad; a lass falls
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L19

G:_T_E_T1
#------------------------------------------------------------------------------
# Lesson T2
#------------------------------------------------------------------------------
*:T2
*:_T_S_T2
*:_T_R_L20
#                                                             ../orig/t.typ:114
T:
 :In this lesson, we will review the letters that you have already practiced
 :and will add the letters E, G, and H and the period.
 :
 :When you reach for any of these keys, be sure to return your finger to its
 :home position.  For example, to hit the H-key, move the first finger of your
 :right hand (the J-finger) slightly to the left.  Tap the H-key and immediately
 :bring your finger back over the J.
 :
 :If you lose track of where your fingers are guess.  Don't look!
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L20

#                                                             ../orig/t.typ:115
I:First let's review
*:_T_R_L21
#                                                             ../orig/t.typ:116
O:fff jjj ddd kkk sss lll aaa ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L21

*:_T_R_L22
#                                                             ../orig/t.typ:120
O:asdf jkl; fdsa ;lkj
 :fjf jfj dkd kdk sls lsl a;a ;a;
 :jkj jlj j;j fdf fsf faf
 :a sad lass; ask dad;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L22

#                                                             ../orig/t.typ:121
I:Use your J-finger for the H key.
*:_T_R_L23
#                                                             ../orig/t.typ:122
O:jjj jhj jjj jhj jjj jhj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L23

*:_T_R_L24
#                                                             ../orig/t.typ:125
O:jjj hhh jjj hhh jj hh j h j h
 :jjj had jjj ash jjj has jjj
 :jjj sash jjj hash jjj hall jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L24

#                                                             ../orig/t.typ:126
I:Use your F-finger for the G-key.
*:_T_R_L25
#                                                             ../orig/t.typ:127
O:fff fgf fff fgf fff fgf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L25

*:_T_R_L26
#                                                             ../orig/t.typ:130
O:fff ggg fff ggg fff ggg
 :fff gag fff lag fff flag fff
 :fff sag fff slag fff hag fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L26

#                                                             ../orig/t.typ:131
I:Use your D-finger for the E-key
*:_T_R_L27
#                                                             ../orig/t.typ:132
O:ddd ded ddd ded ddd ded ddd
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L27

*:_T_R_L28
#                                                             ../orig/t.typ:135
O:ddd eee ddd eee dd ee dd ee d e
 :ddd fee ddd see ddd elf ddd
 :lake asked fake gale egg
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L28

#                                                             ../orig/t.typ:136
I:Use your K-finger for the comma.
*:_T_R_L29
#                                                             ../orig/t.typ:137
O:kkk k,k kkk k,k kkk k,k
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L29

*:_T_R_L30
#                                                             ../orig/t.typ:138
O:kkk ,,, kkk ,,, kkk ,,, kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L30

#                                                             ../orig/t.typ:139
I:Let's finish with some sentences.
*:_T_R_L31
#                                                             ../orig/t.typ:140
O:a lad had a flask, dad had a keg
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L31

*:_T_R_L32
#                                                             ../orig/t.typ:141
O:she had a fake egg, he had a salad
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L32

G:_T_E_T2
#------------------------------------------------------------------------------
# Lesson T3
#------------------------------------------------------------------------------
*:T3
*:_T_S_T3
#                                                             ../orig/t.typ:145
I:Let's review first.
*:_T_R_L33
#                                                             ../orig/t.typ:146
O:fff jjj ddd kkk sss lll aaa ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L33

*:_T_R_L34
#                                                             ../orig/t.typ:147
O:fgf jhj ded k,k fgf jhj ded k,k
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L34

#                                                             ../orig/t.typ:149
I:Use your K-finger for the I key.
*:_T_R_L35
#                                                             ../orig/t.typ:150
O:kkk kik kkk kik kkk iii kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L35

*:_T_R_L36
#                                                             ../orig/t.typ:154
O:kkk iii kkk iii kk ii kk ii
 :kkk lid kkk hill kkk did kkk
 :kkk kill kkk kid kkk like kkk
 :kkk kiss kkk hide kkk fill kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L36

#                                                             ../orig/t.typ:155
I:Use your F-finger for the R key.
*:_T_R_L37
#                                                             ../orig/t.typ:156
O:fff frf fff frf fff frf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L37

*:_T_R_L38
#                                                             ../orig/t.typ:160
O:fff rrr fff rrr ff rr ff rr
 :fff rake fff rag fff her fff
 :fff red fff read fff rage fff
 :fff far fff red fff jar fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L38

*:_T_R_L39
#                                                             ../orig/t.typ:161
O:fff fare fff rare fff rake fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L39

*:_T_R_L40
#                                                             ../orig/t.typ:162
O:fff rid fff ire fff fair fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L40

#                                                             ../orig/t.typ:163
I:Use your L-finger for the period.
*:_T_R_L41
#                                                             ../orig/t.typ:164
O:lll l.l lll l.l lll l.l lll
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L41

*:_T_R_L42
#                                                             ../orig/t.typ:167
O:lll ... lll ... ll .. ll .. l .
 :lll adj. lll id. lll
 :lll eg. lll i.e. lll
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L42

*:_T_R_L43
#                                                             ../orig/t.typ:179
T:The next key we are going to practice is the right shift key.
 :
 :Whenever you want to capitalize a key on the left side, you must use the
 :right shift-key.  To do so, follow these steps:
 :
 :	a.)  Without moving your first finger from the J-key, swing the
 :	     fourth finger of your right hand over to the SHIFT-key and
 :	     hold it down.
 :
 :	b.)  Strike the key that you want to type with your left hand.
 :
 :	c.)  Immediately bring your fourth finger back to the ;-key.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L43

#                                                             ../orig/t.typ:180
I:Don't look at your fingers!
*:_T_R_L44
#                                                             ../orig/t.typ:181
O:;;; ;A; ;;; ;F; ;;; ;D; ;;; ;S;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L44

*:_T_R_L45
#                                                             ../orig/t.typ:182
O:;;; Dear ;;; Sir ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L45

*:_T_R_L46
#                                                             ../orig/t.typ:183
O:;;; Fred ;;; Gail ;;; Alf ;;; Dale ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L46

*:_T_R_L47
#                                                             ../orig/t.typ:185
O:;;; Ada ;;; Al ;;; Greg ;;;
 :jjj Dr. jjj Sr. jjj Fr. jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L47

#                                                             ../orig/t.typ:186
I:Let's try some (strange) sentences.
*:_T_R_L48
#                                                             ../orig/t.typ:187
O:Sir, idle disks seek flags.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L48

*:_T_R_L49
#                                                             ../orig/t.typ:191
O:She sells seashells.
 :Sailfish sail idle seas.
 :She seeks a fig leaf.
 :Red hair is like a fire.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L49

#                                                             ../orig/t.typ:192
I:Always double space after a period.
*:_T_R_L50
#                                                             ../orig/t.typ:193
O:A free red jade is fake.  Girls like silk.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L50

*:_T_R_L51
#                                                             ../orig/t.typ:195
O:She seeks a safe reef, if she sails.  A gale is rare.
 :Alf fed her egg salad.  Gail likes hash.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L51

G:_T_E_T3
#------------------------------------------------------------------------------
# Lesson T4
#------------------------------------------------------------------------------
*:T4
*:_T_S_T4
#                                                             ../orig/t.typ:199
I:First a quick review:
*:_T_R_L52
#                                                             ../orig/t.typ:200
O:jkl; fdsa ded fgf jhj k,k kik frf l.l
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L52

#                                                             ../orig/t.typ:202
I:Use your L-finger for the O-key.
*:_T_R_L53
#                                                             ../orig/t.typ:203
O:lll lol lll ooo lll lol
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L53

*:_T_R_L53A
#                                                             ../orig/t.typ:206
O:lll log lll rod lll for lll
 :lll load lll roll lll oleo lll
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L53A

#
I:Use your ;-finger for the P-key.
*:_T_R_L54
#                                                             ../orig/t.typ:207
O:;;; ;p; ;;; ppp ;;; ;p; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L54

*:_T_R_L55
#                                                             ../orig/t.typ:210
O:;;; pad ;;; peg ;;; ape ;;;
 :;;; poke ;;; pear ;;; peek ;;;
 :;;; opera ;;; hope ;;; drape ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L55

*:_T_R_L56
#                                                             ../orig/t.typ:219
T:			The Left-Shift key.
 :
 :To capitalize letters on the right-side of the keyboard:
 :
 :	1.)  Move your A-finger to the LEFT-shift key and hold it down.
 :
 :	2.)  Strike the key that you want to capitalize with your right hand.
 :
 :	3.)  Immediately swing your A-finger back to its home position.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L56

*:_T_R_L57
#                                                             ../orig/t.typ:220
O:aaa Pi aaa Lord aaa Jill aaa
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L57

#                                                             ../orig/t.typ:221
I:Try capitalizing each of the keys on the right-side:
*:_T_R_L58
#                                                             ../orig/t.typ:222
O:Joe Kip Leif Peg Olaf Ira Heidi
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L58

#                                                             ../orig/t.typ:223
I:Don't forget to use your right-shift key for letters on the left side:
*:_T_R_L59
#                                                             ../orig/t.typ:224
O:a;a P.S. a;a I.R.S. a;a
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L59

#                                                             ../orig/t.typ:225
I:Use your ;-finger for the ?-key.
*:_T_R_L60
#                                                             ../orig/t.typ:226
O:;;; ;?; ;;; ??? ;;; ;?; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L60

*:_T_R_L61
#                                                             ../orig/t.typ:227
O:;;; He? ;;; She? ;;; I? ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L61

#                                                             ../orig/t.typ:228
I:Let's try some sentences.
*:_T_R_L62
#                                                             ../orig/t.typ:229
O:Dad fell off a ladder.  Is he safe?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L62

#                                                             ../orig/t.typ:230
I:Always double space after a question mark.
*:_T_R_L63
#                                                             ../orig/t.typ:231
O:Is he here?  Sal said he fell hard.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L63

*:_T_R_L64
#                                                             ../orig/t.typ:233
O:Did she see his fall?  Jake heard he is OK.
 :I hope people keep off high ladders.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L64

G:_T_E_T4
#------------------------------------------------------------------------------
# Lesson T5
#------------------------------------------------------------------------------
*:T5
*:_T_S_T5
#                                                             ../orig/t.typ:237
I:As always, let's start with a review:
*:_T_R_L65
#                                                             ../orig/t.typ:238
O:ade fgh ijk lop rs; ?.,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L65

#                                                             ../orig/t.typ:239
I:Again.
*:_T_R_L66
#                                                             ../orig/t.typ:240
O:ade fgh ijk lop rs; ?.,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L66

#                                                             ../orig/t.typ:242
I:Use your F-finger for the T-key.
*:_T_R_L67
#                                                             ../orig/t.typ:243
O:fff ftf fff ttt fff ftf fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L67

*:_T_R_L68
#                                                             ../orig/t.typ:244
O:ftf the ftf top ftf ate ftf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L68

*:_T_R_L69
#                                                             ../orig/t.typ:245
O:ftf three ftf often ftf there
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L69

*:_T_R_L70
#                                                             ../orig/t.typ:246
O:The talk is that those three are threatening her.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L70

#                                                             ../orig/t.typ:247
I:Use your J-finger for the N-key.
*:_T_R_L71
#                                                             ../orig/t.typ:248
O:jjj jnj jjj nnn jjj jnj jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L71

*:_T_R_L72
#                                                             ../orig/t.typ:251
O:jnj not jnj ton jnj one jnj
 :jnj neither jnj opening jnj kneeling jnj
 :No one has an interest in it.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L72

#                                                             ../orig/t.typ:252
I:Use your ;-finger for the :-key.
*:_T_R_L73
#                                                             ../orig/t.typ:253
O:;;; ;:; ;;; ::: ;;; ;:; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L73

#                                                             ../orig/t.typ:254
I:Always double space after a colon.
*:_T_R_L74
#                                                             ../orig/t.typ:255
O:Dear Sirs:  Dear John:  Dear Alfred:
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L74

*:_T_R_L75
#                                                             ../orig/t.typ:256
O:Dear Dr. Stone:  To Heathkit:
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L75

*:_T_R_L76
#                                                             ../orig/t.typ:271
T:			SPEED EXERCISES
 :
 :From now on, I will be mixing speed exercises in with the lessons.  In the
 :drills that you have been doing, I make you keep practicing a line until
 :you get it right.  In a speed exercise, I will only display the text once.
 :
 :What will be different is that I will be timing you.  From the time you type
 :the first letter of the line until you hit the final carriage return, my
 :stopwatch will be running.  When you finish, I will calculate your typing speed
 :and convert it to words per minute (WPM).  I will also count each of the
 :mistakes you make and display the total number of errors.
 :
 :If you make a mistake, I will beep at you and light up the letter that you
 :should have typed in inverse video (a black letter on a white background).
 :Just keep going and try to make as few errors as possible.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L76

#                                                             ../orig/t.typ:272
I:Try this sentence:
*:_T_R_L77
#                                                             ../orig/t.typ:273
P:Sarah has liked knitting all her life.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L77

#                                                             ../orig/t.typ:274
I:Try a little longer sentence.
*:_T_R_L78
#                                                             ../orig/t.typ:275
P:She looked past her garden to the fields and longed to see the other side.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L78

#                                                             ../orig/t.typ:277
I:When you type a multi-line paragraph, you will have to hit the RETURN-key at
 :the end of each line.
*:_T_R_L79
#                                                             ../orig/t.typ:280
P:All the sane people in this area sold their gold
 :right at the start.  The insane ones held their
 :gold and later it paid off.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L79

*:_T_R_L80
#                                                             ../orig/t.typ:285
P:One fine afternoon the king had an idea.  He
 :sent a letter to all the lords and ladies of
 :his land.  He asked for a great feast.  His
 :people prepared roasts.  His jester did a jig.
 :All the people left hoping to do it again.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L80

G:_T_E_T5
#------------------------------------------------------------------------------
# Lesson T6
#------------------------------------------------------------------------------
*:T6
*:_T_S_T6
#                                                             ../orig/t.typ:289
I:Let's review the letters we've already learned.
*:_T_R_L81
#                                                             ../orig/t.typ:290
O:jkj fdf jlj fsf j;j faf kik ded frf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L81

*:_T_R_L82
#                                                             ../orig/t.typ:293
O:fgf jhj k,k l.l A;A F;F E;E
 :lol ;p; JaJ :a: ftf jnj ;:;
 :jug ton knot poison the neither often
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L82

#                                                             ../orig/t.typ:295
I:Use your F-finger for the B-key.
*:_T_R_L83
#                                                             ../orig/t.typ:296
O:fff fbf fff bbb fff fbf fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L83

#                                                             ../orig/t.typ:297
I:The B-key is the longest reach we've seen so far.  Let's try it again.
*:_T_R_L84
#                                                             ../orig/t.typ:298
O:fff fbf fff bbb fff fbf fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L84

*:_T_R_L84A
#                                                             ../orig/t.typ:301
O:frf bar frf rib frf pub frf
 :frf bring frf abort frf brother frf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L84A

#
I:Use your J-finger for the U-key.
*:_T_R_L85
#                                                             ../orig/t.typ:302
O:jjj juj jjj uuu jjj juj jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L85

*:_T_R_L86
#                                                             ../orig/t.typ:305
O:juj jug juj use juj hug juj
 :juj tulip juj turn juj under juj
 :Please pass the butter and salt, but not the pepper.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L86

#                                                             ../orig/t.typ:306
I:Use your ;-finger for the /-key.
*:_T_R_L87
#                                                             ../orig/t.typ:307
O:;;; ;/; ;;; /// ;;; ;/; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L87

*:_T_R_L88
#                                                             ../orig/t.typ:311
O:;/; n/a ;/; and/or ;/; left/right
 :In this era of E.R.A., I hope he/she likes his/her job.
 :He/she should bring his/her spouse at about noon or just before.
 :Should I be here alone?  Is Bernie and/or Julie going to be here, too?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L88

#                                                             ../orig/t.typ:312
I:Try your speed on some paragraphs:
*:_T_R_L89
#                                                             ../orig/t.typ:315
P:All bills are to be paid in full.  If
 :there is no fee to be paid, return the
 :bill and put n/a in the total due part.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L89

#                                                             ../orig/t.typ:316
I:You should be aiming for 15 WPM.  (If you did better, work on accuracy.)
*:_T_R_L90
#                                                             ../orig/t.typ:319
P:In baseball, bunting is a kind of hit.  But, bunting also
 :refers to a kind of bird and the stuff that is used in
 :flags.  English sure is a strange language.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L90

G:_T_E_T6
#------------------------------------------------------------------------------
# Lesson T7
#------------------------------------------------------------------------------
*:T7
*:_T_S_T7
#                                                             ../orig/t.typ:323
I:First a review of the letters we've learned before:
*:_T_R_L91
#                                                             ../orig/t.typ:324
O:juj ded kik frf lol fgf ;p; jhj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L91

*:_T_R_L92
#                                                             ../orig/t.typ:325
O:ftf jnj ftf jnj fbf juj ;?; l.l k,k
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L92

#                                                             ../orig/t.typ:327
I:Use your D-finger for the C-key.
*:_T_R_L93
#                                                             ../orig/t.typ:328
O:ddd dcd ddd ccc ddd dcd
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L93

*:_T_R_L94
#                                                             ../orig/t.typ:331
O:ddd cat ddd cup ddd can
 :dcd duck dcd card dcd pack dcd
 :dcd crate dcd scrap dcd trick dcd
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L94

#                                                             ../orig/t.typ:332
I:Use your J-finger for the M-key
*:_T_R_L95
#                                                             ../orig/t.typ:333
O:jjj jmj jjj mmm jjj jmj jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L95

*:_T_R_L96
#                                                             ../orig/t.typ:337
O:jjj met jjj rim jjj map jjj
 :jmj man jmj men jmj ham jjj
 :jmj Mr. jmj Mrs. jmj Ms. jmj
 :jmj number jmj stream jmj mankind jmj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L96

#                                                             ../orig/t.typ:338
I:Use your ;-finger for the hyphen.
*:_T_R_L97
#                                                             ../orig/t.typ:339
O:;;; ;-; ;;; --- ;;; ;-; ;;; ;-;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L97

*:_T_R_L98
#                                                             ../orig/t.typ:341
O:;;; one-third ;;; one-half ;;; three-fifths ;;;
 :;;; part-time ;;; self-made ;;; all-American ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L98

#                                                             ../orig/t.typ:342
I:Let's try some sentences:
*:_T_R_L99
#                                                             ../orig/t.typ:343
O:Peter Piper picked a peck of pickled peppers.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L99

*:_T_R_L100
#                                                             ../orig/t.typ:344
O:Motion pictures often depict macabre scenes.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L100

*:_T_R_L101
#                                                             ../orig/t.typ:345
O:Once upon a time, marriages lasted longer than mortgages.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L101

#                                                             ../orig/t.typ:346
I:There are three uses of the hyphen.  It can be used to combine two words:
*:_T_R_L102
#                                                             ../orig/t.typ:347
O:She had on a bluish-green dress.  But, no one noticed.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L102

#                                                             ../orig/t.typ:348
I:To divide a word:
*:_T_R_L103
#                                                             ../orig/t.typ:350
O:At macrame class last night, I made a hanging basket for the philo-
 :dendron in our dining room.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L103

#                                                             ../orig/t.typ:351
I:Or, to form a dash:
*:_T_R_L104
#                                                             ../orig/t.typ:352
O:Fifteen dollars a month--measured in current dollars--is a good rate.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L104

#                                                             ../orig/t.typ:353
I:Let's try a speed drill on these sentences:
*:_T_R_L105
#                                                             ../orig/t.typ:355
P:The clock ran out, signaling the end of
 :the second-half.  The game had been lost.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L105

*:_T_R_L106
#                                                             ../orig/t.typ:364
P:The paper just made an announce-
 :ment about a commotion at the
 :college.  Someone has just
 :produced a micro-organism in the
 :DNA-research lab.  It is a
 :special kind of bacteria that
 :consumes crude oil.  The talk is
 :that it is being patented for use
 :on oil spills at sea.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L106

#                                                             ../orig/t.typ:365
I:Hit the return key twice for blank lines:
*:_T_R_L107
#                                                             ../orig/t.typ:374
P:Dear Mr. Mandrake:
 :
 :All of us appreciated the fine performance of those magic
 :tricks.  Please arrange to come to another of our meet-
 :ings, if possible.  Perhaps our Christmas meeting?
 :
 :Thanks,
 :
 :Mrs. Carmichael
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L107

G:_T_E_T7
#------------------------------------------------------------------------------
# Lesson T8
#------------------------------------------------------------------------------
*:T8
*:_T_S_T8
#                                                             ../orig/t.typ:378
I:As always, we will start with a quick review
*:_T_R_L108
#                                                             ../orig/t.typ:379
O:jfj dkd lsl a;a dcd jmj ;-; fbf juj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L108

#                                                             ../orig/t.typ:381
I:Let's try some long words.
*:_T_R_L109
#                                                             ../orig/t.typ:382
O:meteorology camera bituminous chimera phosphates
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L109

#                                                             ../orig/t.typ:383
I:Use your S-finger for the W-key.
*:_T_R_L110
#                                                             ../orig/t.typ:384
O:sss sws sss www sss sws sss
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L110

*:_T_R_L111
#                                                             ../orig/t.typ:385
O:sss wet sss who sss was sss
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L111

*:_T_R_L112
#                                                             ../orig/t.typ:387
O:sws who sws what sws when sws where sws
 :knowledge whatever Wimbledon know-it-all
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L112

*:_T_R_L113
#                                                             ../orig/t.typ:391
P:How much wood could a woodchuck chuck if a
 :woodchuck could chuck wood?  A woodchuck
 :would chuck all the wood that a woodchuck
 :could chuck, if a woodchuck could chuck wood.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L113

#                                                             ../orig/t.typ:392
I:Use your J-finger for the Y-key.
*:_T_R_L114
#                                                             ../orig/t.typ:393
O:jjj jyj jjj yyy jjj jyj jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L114

*:_T_R_L115
#                                                             ../orig/t.typ:396
O:jjj why jjj you jjj try jjj rye jjj
 :jjj year jjj July jjj your jjj jury jjj
 :Were your yard sales much better last year?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L115

#                                                             ../orig/t.typ:397
I:Try your speed on this sentence:
*:_T_R_L116
#                                                             ../orig/t.typ:398
P:Why are you typing so slowly?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L116

#                                                             ../orig/t.typ:399
I:Use your F-finger for the V-key.
*:_T_R_L117
#                                                             ../orig/t.typ:400
O:fff fvf fff vvv fff fvf fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L117

*:_T_R_L118
#                                                             ../orig/t.typ:401
O:fff vat fff eve fff vow fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L118

*:_T_R_L119
#                                                             ../orig/t.typ:402
O:fvf vine fvf dove fvf ever fvf very fvf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L119

*:_T_R_L120
#                                                             ../orig/t.typ:405
O:driven vertical advent ventrical
 :What a fine vineyard you have.
 :Do you intend to play adventure every night?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L120

*:_T_R_L121
#                                                             ../orig/t.typ:419
T:			THE BACKSPACE
 :
 :Most of the programs that you use will allow you to correct your mistakes by
 :using the BACKSPACE and/or DELETE keys.  These keys will generally delete the
 :previous character that you typed.  (This feature is one of the principal
 :advantages of a word-processing system over a conventional typewriter.)
 :
 :I refuse to accept either of these keys during a drill pattern.  (You should
 :keep practicing until you get it right!)  But, I will accept either a BACK-
 :SPACE or a DELETE during a speed drill.  (I will remove the white error
 :markers but I still count it as an error in my totals.)
 :
 :If you do chose to use the DELETE or BACKSPACE keys, hit the key with your
 :;-finger and immediately return your fingers to the home position.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L121

#                                                             ../orig/t.typ:420
I:Let's try our speed on some nursery rhymes!
*:_T_R_L122
#                                                             ../orig/t.typ:424
P:Mary had a little lamb
 :Its fleece was white as snow
 :And every where that Mary went
 :The lamb was sure to go.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L122

*:_T_R_L123
#                                                             ../orig/t.typ:426
P:Jack and Jill went up a hill to fetch a pail of water.
 :Jack fell down and broke his crown and Jill came tumbling after.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L123

*:_T_R_L124
#                                                             ../orig/t.typ:431
P:Little Miss Muffet sat on a tuffet
 :Eating her curds and whey.
 :Along came a spider
 :Who sat down beside her
 :And frightened Miss Muffet away.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L124

*:_T_R_L125
#                                                             ../orig/t.typ:436
P:Hey, diddle diddle--
 :The cat and the fiddle
 :The cow jumped over the moon.
 :The little dog laughed to see such sport,
 :And the dish ran away with the spoon.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L125

G:_T_E_T8
#------------------------------------------------------------------------------
# Lesson T9
#------------------------------------------------------------------------------
*:T9
*:_T_S_T9
#                                                             ../orig/t.typ:440
I:First, a review.
*:_T_R_L126
#                                                             ../orig/t.typ:441
O:a;a sls dkd fjf sws jyj fvf dcd jmj ;-;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L126

#                                                             ../orig/t.typ:443
I:Notice that the only letters left to go are the Q, X, and Z!
*:_T_R_L127
#                                                             ../orig/t.typ:444
O:abcdefghijklmnoprstuvwy
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L127

#                                                             ../orig/t.typ:445
I:Use your A-finger for the Q-key.
*:_T_R_L128
#                                                             ../orig/t.typ:446
O:aaa aqa aaa qqq aaa aqa aaa
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L128

*:_T_R_L128A
#                                                             ../orig/t.typ:450
O:aaa quit aaa quad aaa quip aaa
 :lacquer inquiry squirt quart
 :quail quiver inquest marquis
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L128A

#
I:Use your S-finger for the X-key.
*:_T_R_L129
#                                                             ../orig/t.typ:451
O:sss sxs sss xxx sss sxs sss
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L129

*:_T_R_L129A
#                                                             ../orig/t.typ:455
O:sss ax sss ox sss vex sss wax xxx
 :examine ex-wife excellent boxer sixteen
 :exactly sphinx oxygen except thorax
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L129A

#
I:Use your A-finger for the Z-key.
*:_T_R_L130
#                                                             ../orig/t.typ:456
O:aaa aza aaa zzz aaa aza aaa
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L130

*:_T_R_L131
#                                                             ../orig/t.typ:459
O:aaa adz aaa azo aaa coz aaa
 :quiz jazz quartz zinc dozen
 :oxidize squeeze azimuth zoology
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L131

#                                                             ../orig/t.typ:460
I:The big event!!!!!!!!!!!!!!!!!!
*:_T_R_L132
#                                                             ../orig/t.typ:461
O:abcdefghijklmnopqrstuvwxyz
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L132

*:_T_R_L132A
#                                                             ../orig/t.typ:463
O:zyxwvutsrqponmlkjihgfedcba
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L132A

#
I:Let's try some sentences:
*:_T_R_L133
#                                                             ../orig/t.typ:464
O:A dozen zebras were grazing quietly nearby.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L133

*:_T_R_L134
#                                                             ../orig/t.typ:465
O:The zeppelin zigzagged quickly from the horizon up to the zenith.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L134

*:_T_R_L135
#                                                             ../orig/t.typ:466
O:Never trust a quack doctor who cannot distinguish oxygen from nitrogen.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L135

*:_T_R_L136
#                                                             ../orig/t.typ:467
O:Imagine having a sextet of sexagenarian sextons?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L136

*:_T_R_L137
#                                                             ../orig/t.typ:469
O:Remember when queer used to mean zany?
 :Quartz crystal watches were at one time extremely expensive.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L137

#                                                             ../orig/t.typ:470
I:Let's try a sentence that contains every letter of the alphabet.
*:_T_R_L138
#                                                             ../orig/t.typ:471
O:A quick brown fox jumped over the lazy dogs.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L138

#                                                             ../orig/t.typ:472
I:Again,
*:_T_R_L139
#                                                             ../orig/t.typ:473
O:A quick brown fox jumped over the lazy dogs.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L139

#                                                             ../orig/t.typ:474
I:See how fast you can type it this time:
*:_T_R_L140
#                                                             ../orig/t.typ:475
P:A quick brown fox jumped over the lazy dogs.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L140

#                                                             ../orig/t.typ:476
I:Again,
*:_T_R_L141
#                                                             ../orig/t.typ:477
P:A quick brown fox jumped over the lazy dogs.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L141

G:_T_E_T9
#------------------------------------------------------------------------------
# Lesson T10
#------------------------------------------------------------------------------
*:T10
*:_T_S_T10
#                                                             ../orig/t.typ:481
I:Let's review the entire alphabet before starting the number keys.
*:_T_R_L142
#                                                             ../orig/t.typ:482
O:abcd efg hijk lmnop qrs tuv wx yz
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L142

#                                                             ../orig/t.typ:484
I:Once more
*:_T_R_L143
#                                                             ../orig/t.typ:485
O:abcdefghijklmnopqrstuvwxyz
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L143

#                                                             ../orig/t.typ:486
I:Use the shift key for each letter (Do not use the CAPS LOCK key)
*:_T_R_L144
#                                                             ../orig/t.typ:487
O:ABCDEFGHIJKLMNOPQRSTUVWXYZ
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L144

#                                                             ../orig/t.typ:488
I:Now, review the punctuations that you've had.
*:_T_R_L145
#                                                             ../orig/t.typ:489
O:l;l l:l k,k l.l ;/; ;?; :?: ;-;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L145

*:_T_R_L146
#                                                             ../orig/t.typ:509
T:
 :			NUMERIC KEYS
 :
 :The terminal has two sets of numeric keys.  One set--directly above the
 :alphabetic keys--conforms to the standard for typewriter keyboards.  The other
 :set--to your right--resembles a calculator keypad.  In this typing series we
 :will be concerned only with the standard numeric keys on the main keyboard.
 :(If you would like to learn to touch type on a numeric keypad, use the N-series
 :lessons instead.)
 :
 :NOTE - not all terminals have the numeric keys in a separate keypad
 :
 :The numeric keys, like all the keys you will be learning from now on, vary
 :somewhat from machine to machine.  The 2 through 0 keys are always in exactly
 :the same place on all typewriter keyboards.  (On keypunch machines and some
 :terminals, however, they are located over the U, I, O, J, K, L, M, comma and
 :period keys.  We will not be concerned with these layouts in this series.)
 :Even if a typewriter or terminal has the standard 2 through 0 keys, it may not
 :have a 1 key.  If it does, the 1 will always be next to the 2.  If it does not,
 :you will have to use the L-key.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L146

#                                                             ../orig/t.typ:510
I:Let's start by using the 1-key, since we have one.  (Use your A-finger.)
*:_T_R_L147
#                                                             ../orig/t.typ:511
O:aaa a1a aaa 111 aaa a1a
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L147

*:_T_R_L148
#                                                             ../orig/t.typ:514
O:a1q qa1 qz1 az1 aq1 a1z
 :111 and 111 ate 111 any 111
 :If 11 men each catch 11 fish in 11 days, how many fish were caught?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L148

#                                                             ../orig/t.typ:515
I:Use your S-finger for the 2-key.
*:_T_R_L149
#                                                             ../orig/t.typ:516
O:sss s2s sss s2s sss s2s
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L149

*:_T_R_L149A
#                                                             ../orig/t.typ:520
O:sss s2w sss 2xw sss w2x sss
 :222 saw 222 was 222 wet 222
 :The 2 men were 2 late 2 catch the 2 PM train.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L149A

#
I:Use your D-finger for the 3-key.
*:_T_R_L150
#                                                             ../orig/t.typ:521
O:ddd d3d ddd d3d ddd d3d ddd
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L150

*:_T_R_L151
#                                                             ../orig/t.typ:524
O:ddd d3e ddd d3c ddd e3c ddd
 :333 did 333 cat 333 eat 333
 :1 plus 2 is 3.  11 plus 22 is 33.  111 plus 222 is 333.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L151

#                                                             ../orig/t.typ:525
I:The last number we will practice today is the 4-key.  (Use your F-finger.)
*:_T_R_L152
#                                                             ../orig/t.typ:526
O:fff f4f fff f4f fff f4f
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L152

*:_T_R_L153
#                                                             ../orig/t.typ:531
O:fff f4r fff 4vr fff 4vr fff
 :444 for fff rat 444 vet 444
 :Flight 423 leaves from gate 42 at 4:24.
 :As the 3 musketeers say: 1 4 all, and all 4 1.
 :If 1/4 plus 2/3 is 11/12, what is 1/2 plus 1/3?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L153

#                                                             ../orig/t.typ:532
I:Try your speed on this line:
*:_T_R_L154
#                                                             ../orig/t.typ:533
P:Our team won 1st, 2nd, and 3rd place at the 12th annual outing.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L154

#                                                             ../orig/t.typ:535
I:As we stated earlier, many typewriters do not have a 1 key.  Let's practice
 :using the L-key as a 1, so you can use any kind of typewriter.
*:_T_R_L155
#                                                             ../orig/t.typ:536
O:One dozen is l2.  A gross is l2 dozen or l44.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L155

*:_T_R_L156
#                                                             ../orig/t.typ:538
O:In both octal and decimal, ll times ll is l2l.  And, 3 minus 4 is -l.
 :But in octal, l2 is not divisible by 3.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L156

G:_T_E_T10
#------------------------------------------------------------------------------
# Lesson T11
#------------------------------------------------------------------------------
*:T11
*:_T_S_T11
#                                                             ../orig/t.typ:542
I:Let's review the numbers that you have already learned.
*:_T_R_L157
#                                                             ../orig/t.typ:543
O:a1a s2s d3d f4f 234 413
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L157

*:_T_R_L158
#                                                             ../orig/t.typ:544
O:f4r d3e s2w a1q az1 sx2 dc3 fv4
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L158

#                                                             ../orig/t.typ:546
I:Use your J-finger for the 7-key
*:_T_R_L159
#                                                             ../orig/t.typ:547
O:jjj j7j jjj j7j jjj j7j jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L159

*:_T_R_L160
#                                                             ../orig/t.typ:551
O:jjj j7u jjj 7um jjj u7m jjj
 :777 map 777 jug 777 rum 777
 :Is flight number 377 for Florida a 707, a 727 or a 747?
 :It is a 727 with 4 stops.  With all those stops it takes almost 7 hours.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L160

#                                                             ../orig/t.typ:552
I:Use your K-finger for the 8-key.
*:_T_R_L161
#                                                             ../orig/t.typ:553
O:kkk k8k kkk k8k kkk k8k kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L161

*:_T_R_L162
#                                                             ../orig/t.typ:557
O:kkk k8i kkk 8,i kkk ,i8 kkk
 :888 kick 888 sink 888 keep 888
 :Agent 88 was supposed to check in at 8:14.  She is 38 minutes late.
 :Her team was assigned to zone 8 of quadrant 828.  Send 8 more agents.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L162

#                                                             ../orig/t.typ:558
I:Use your L-finger for the 9-key.
*:_T_R_L163
#                                                             ../orig/t.typ:559
O:lll l9l lll l9l lll l9l lll
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L163

*:_T_R_L164
#                                                             ../orig/t.typ:563
O:lll 9.o lll o9. lll l9. lll
 :999 Jr. 999 log 999 old 999
 :Oh, 99 bottles of beer on the wall, 99 bottles of beer.
 :If 9 of us take 9 each, there will still be 18 left for the song.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L164

#                                                             ../orig/t.typ:564
I:Use your ;-finger for the 0-key.
*:_T_R_L165
#                                                             ../orig/t.typ:565
O:;;; ;0; ;;; ;0; ;;; ;0; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L165

*:_T_R_L166
#                                                             ../orig/t.typ:570
O:;;; ;0p ;;; /0p ;;; 0/p ;;;
 :000 a/c 000 pup 000 me? 000
 :Dear Sirs:  The 10:00 meeting on March 10 has been postponed until 10:30.
 :The 10:30 meeting was moved to 11:00 in Room 302.
 :But, Room 302 can only hold 10 people.  We will need Conference Room 10.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L166

#                                                             ../orig/t.typ:571
I:Let's try some paragraphs.
*:_T_R_L167
#                                                             ../orig/t.typ:580
P:Zip codes are arranged so that the first 3 digits
 :designate the regional office and the last 2
 :digits designate the local branch.  The numbering
 :is roughly east to west.  That is, numbers
 :starting with 0 are in New England, numbers
 :starting with 1 are the New York area, etc.
 :There are notable exceptions to this rule,
 :however.  The Virgin Islands are south of
 :Florida, but their Zip Codes start with 00.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L167

*:_T_R_L168
#                                                             ../orig/t.typ:587
P:The new nine digit zip codes have upset quite a
 :few people.  It was bad enough being referred to
 :as 73218.  But now, we will have to remember
 :numbers like 73218-4208.  The worst hit will be
 :the companies whose mailing list programs were
 :poorly designed.  Those unstructured programs
 :will be very difficult to change.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L168

G:_T_E_T11
#------------------------------------------------------------------------------
# Lesson T12
#------------------------------------------------------------------------------
*:T12
*:_T_S_T12
#                                                             ../orig/t.typ:591
I:Let's review the numbers that you have learned so far.
*:_T_R_L169
#                                                             ../orig/t.typ:592
O:j7j f4f k8k d3d l9l s2s ;0; a1a
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L169

*:_T_R_L170
#                                                             ../orig/t.typ:593
O:4f4 7j7 3d3 8k8 2s2 9l9 1a1 0;0
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L170

#                                                             ../orig/t.typ:595
I:Use your F-finger for the 5-key.
*:_T_R_L171
#                                                             ../orig/t.typ:596
O:fff f5f fff 555 fff f5f fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L171

*:_T_R_L172
#                                                             ../orig/t.typ:599
O:f5f f54 f5f t5g f5f t5r f5f
 :f5f five f5f two f5f four f5f
 :f5f 453 f5f 585 f5f 475 f5f
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L172

*:_T_R_L173
#                                                             ../orig/t.typ:600
P:The 5 of us each carried 50 pound packs all 45 miles of the trip.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L173

#                                                             ../orig/t.typ:601
I:And now, the longest reach of all!  Use your J-finger for the 6-key.
*:_T_R_L174
#                                                             ../orig/t.typ:602
O:jjj j6j jjj 666 jjj j6j jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L174

*:_T_R_L175
#                                                             ../orig/t.typ:605
O:j6j June j6j much j6j hum j6j
 :j6j y6n j6j u6m j6j h76 j6j
 :j6j 4567 j6j 7654 j6j 6754 j6j
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L175

#                                                             ../orig/t.typ:606
I:The open parenthesis is the shift of the 9-key.  (Use your L-finger).
*:_T_R_L176
#                                                             ../orig/t.typ:607
O:lll l(l lll ((( lll l(l lll
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L176

*:_T_R_L177
#                                                             ../orig/t.typ:608
O:l(l (.l l(l 9(9 l(l
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L177

*:_T_R_L178
#                                                             ../orig/t.typ:609
O:l(l loop l(l oil l(l only l(l
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L178

#                                                             ../orig/t.typ:610
I:The close parenthesis is the shift of the 0-key.  (Use your ;-finger).
*:_T_R_L179
#                                                             ../orig/t.typ:611
O:;;; ;); ;;; ;); ;;; ;);
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L179

*:_T_R_L180
#                                                             ../orig/t.typ:613
O:;;; (.) ;;; (.) ;;; (,) ;;;
 :;); pole ;); loop ;); pile ;);
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L180

*:_T_R_L181
#                                                             ../orig/t.typ:614
O:You (the buyer) should ask him (the seller) for the price (of the goods).
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L181

*:_T_R_L182
#                                                             ../orig/t.typ:615
O:If (X-5) / (X-6) is 56, then what is (X/5) - (X/6)?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L182

*:_T_R_L183
#                                                             ../orig/t.typ:616
O:1 2 3 4 5 6 7 8 9 10
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L183

#                                                             ../orig/t.typ:617
I:Try your speed on this song.
*:_T_R_L184
#                                                             ../orig/t.typ:621
P:1 little, 2 little, 3 little Indians,
 :4 little, 5 little, 6 little Indians,
 :7 little, 8 little, 9 little Indians,
 :10 little Indian boys.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L184

*:_T_R_L185
#                                                             ../orig/t.typ:625
P:If we want to catch the 6:15 flight to Phoenix (which is the
 :non-stop), we will have to leave by 5:00 at the latest (in
 :case we run into traffic).  Otherwise, we will have to take
 :the 6:45 flight (which makes 5 stops).
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L185

#                                                             ../orig/t.typ:626
I:Use the main keyboard keys.  Don't cheat and use the auxilliary keypad!
#                                                             ../orig/t.typ:627
 :Try entering straight numbers: 
*:_T_R_L186
#                                                             ../orig/t.typ:628
O:423 475 925 235 295 175 650
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L186

*:_T_R_L187
#                                                             ../orig/t.typ:630
O:598 693 602 672 315 604 587 307
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L187

*:_T_R_L188
#                                                             ../orig/t.typ:631
O:12.00 67.50 99.95 38.75 19.99
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L188

#                                                             ../orig/t.typ:632
I:Now let's try for some speed.
*:_T_R_L189
#                                                             ../orig/t.typ:633
P:353 648 604 592 468 501 296
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L189

*:_T_R_L190
#                                                             ../orig/t.typ:641
P:3574
 :1937
 :2586
 :1904
 :1837
 :9003
 :7283
 :6745
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L190

G:_T_E_T12
#------------------------------------------------------------------------------
# Lesson T13
#------------------------------------------------------------------------------
*:T13
*:_T_S_T13
*:_T_R_L191
#                                                             ../orig/t.typ:657
T:
 :There is no Lesson 13!  Don't you know that 13 is an unlucky number?
 :
 :If you have completed Lessons T1 through T12, then you are now ready
 :to call yourself a touch typist.  You have learned to touch type all
 :of the keys which are standardized!  You can now begin the SPEED
 :series of lessons if you would like.  (If you come across a punctua-
 :tion symbol which you have not learned, simply look for it.  Use the
 :appropriate finger for the shifted numeric keys.  Use your ;-finger
 :for all the keys on the right-hand side.)
 :
 :We will practice touch typing on the keyboard layout for the remaining
 :lessons.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L191

G:_T_E_T13
#------------------------------------------------------------------------------
# Lesson T14
#------------------------------------------------------------------------------
*:T14
*:_T_S_T14
#                                                             ../orig/t.typ:661
I:Use your ;-finger for the apostrophe.
*:_T_R_L192
#                                                             ../orig/t.typ:662
O:;;; ;'; ;;; ''' ;;; ;'; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L192

*:_T_R_L193
#                                                             ../orig/t.typ:664
O:;'; it's ;'; 'till ;'; won't ;';
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L193

*:_T_R_L194
#                                                             ../orig/t.typ:667
O:;'; 'tis ;'; isn't ;'; 'tis too ;';
 :What's this I've got?  Isn't this yesterday's paper?  Where's today's?
 :Can't you find anything?  It's right next to Dad's chair.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L194

#                                                             ../orig/t.typ:668
I:Shift the apostrophe for the quote key.
*:_T_R_L195
#                                                             ../orig/t.typ:669
O:;;; ;"; ;;; """ ;;; ;"; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L195

*:_T_R_L196
#                                                             ../orig/t.typ:673
O:;"; "." ;"; ":" ;"; "," ;";
 :"What was that I saw you take from the teacher desk?" asked Tom.
 :"It's the answers to tomorrow's quiz", answered Suzy.
 :"If you promise not to tell," she continued, "I'll give you a copy."
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L196

#                                                             ../orig/t.typ:674
I:Use your A-finger for the exclamation point.
*:_T_R_L197
#                                                             ../orig/t.typ:675
O:aaa a!a aaa !!! aaa a!a aaa
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L197

*:_T_R_L198
#                                                             ../orig/t.typ:676
O:a!a Ah! a!a What! a!a Oh! a!a
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L198

#                                                             ../orig/t.typ:677
I:Always double space after an exclamation point.
*:_T_R_L199
#                                                             ../orig/t.typ:678
O:Tomorrow's quiz!  What if we get caught?  We'll be expelled!
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L199

*:_T_R_L200
#                                                             ../orig/t.typ:679
O:He'll never suspect a thing!  We'll get some answers wrong to fool him.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L200

G:_T_E_T14
#------------------------------------------------------------------------------
# Lesson T15
#------------------------------------------------------------------------------
*:T15
*:_T_S_T15
*:_T_R_L201
#                                                             ../orig/t.typ:688
T:
 :
 :In this lesson we will be practicing the special symbols which you will need
 :for BASIC or other programming languages.  I won't give you too much practice
 :with these symbols right now.  (You should be able to get plenty of exercise by
 :simply typing in programs.)
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L201

#                                                             ../orig/t.typ:690
I:Use your ;-finger for the equals key.
*:_T_R_L202
#                                                             ../orig/t.typ:691
O:;;; ;=; ;;; ;=; ;;; ;=; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L202

*:_T_R_L203
#                                                             ../orig/t.typ:693
O:;=; -=- ;=; '=' ;=; :=: ;=;
 :;=; X=2 ;=; Y=3 ;=; Z=0 ;=;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L203

#                                                             ../orig/t.typ:694
I:Use your K-finger for the asterisk key.
*:_T_R_L204
#                                                             ../orig/t.typ:695
O:kkk k*k kkk k*k kkk k*k kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L204

*:_T_R_L205
#                                                             ../orig/t.typ:697
O:k*k 3*2 k*k 5*6 k*k 9*7 k*k
 :k*k i*i k*k *,* k*k 8*8 k*k
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L205

#                                                             ../orig/t.typ:698
I:Use your ;-finger for the plus sign.
*:_T_R_L206
#                                                             ../orig/t.typ:699
O:;;; ;+; ;;; ;+; ;;; ;+; ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L206

*:_T_R_L207
#                                                             ../orig/t.typ:701
O:;+; 2+4 ;+; 7+5 ;+; 8+0 ;+;
 :;+; +=+ ;+; -+- ;+; /+/ ;+;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L207

#                                                             ../orig/t.typ:702
I:Use your L-finger for the greater-than key.
*:_T_R_L208
#                                                             ../orig/t.typ:703
O:lll l>l lll l>l lll l>l lll
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L208

*:_T_R_L209
#                                                             ../orig/t.typ:705
O:l>l X>3 l>l Y>7 l>l Z>0 l>l
 :l>l >>> l>l 9>9 l>l .>. l>l
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L209

#                                                             ../orig/t.typ:706
I:Use your K-finger for the less-than key.
*:_T_R_L210
#                                                             ../orig/t.typ:707
O:kkk k<k kkk k<k kkk k<k kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L210

*:_T_R_L211
#                                                             ../orig/t.typ:709
O:k<k X<0 k<k Y<2 k<k Z<8 k<k
 :k<k <.> k<k >.< k<k <<< k<k
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L211

#                                                             ../orig/t.typ:710
I:Use your J-finger for the up-arrow key.
*:_T_R_L212
#                                                             ../orig/t.typ:711
O:jjj j^j jjj ^^^ jjj j^j jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L212

*:_T_R_L213
#                                                             ../orig/t.typ:713
O:j^j X^2 j^j Y^3 j^j Z^4 j^j
 :j^j <^> j^j .^. j^j "^" j^j
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L213

#                                                             ../orig/t.typ:714
I:Try entering this BASIC program:
*:_T_R_L214
#                                                             ../orig/t.typ:719
P:10 LET x=10
 :20 LET y=20
 :30 PRINT x+y/3
 :40 PRINT y/x*5
 :50 STOP
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L214

#                                                             ../orig/t.typ:720
I:And another:
*:_T_R_L215
#                                                             ../orig/t.typ:728
P:10 REM Program to find square roots with using ^.5 feature
 :20 INPUT "What number do you want the square root of? ";s
 :30 x = 2
 :40 y = s/x
 :50 x = (x+y)/2
 :60 IF ABS(x^2 - s) > s/1000 THEN 40
 :70 PRINT "The square root of ";s;" is ";x
 :80 STOP
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L215

#                                                             ../orig/t.typ:729
I:Press down the CAPS LOCK key to simplify typing in this BASIC program:
*:_T_R_L216
#                                                             ../orig/t.typ:744
P:100 REM PROGRAM TO SOLVE QUADRATIC EQUATION
 :125 PRINT "ENTER THE VALUES OF A, B, AND C WHERE:"
 :150 PRINT
 :175 PRINT "AX^2 + BX + C = 0"
 :200 INPUT A,B,C
 :210 IF A = 0 THEN 400
 :225 D = B^2 - 4*A*C
 :250 IF D < 0 THEN 500
 :275 PRINT "ONE ROOT IS: ";-B+SQR(D)/2/A
 :300 PRINT "THE OTHER IS: ";-B-SQR(D)/2/A
 :325 STOP
 :400 PRINT "NOT A QUADRATIC.  TRY AGAIN."
 :425 GOTO 100
 :500 PRINT "COMPLEX ROOTS.  TRY AGAIN."
 :525 GOTO 125
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L216

G:_T_E_T15
#------------------------------------------------------------------------------
# Lesson T16
#------------------------------------------------------------------------------
*:T16
*:_T_S_T16
*:_T_R_L217
#                                                             ../orig/t.typ:760
T:
 :In this lesson we will be practicing the shifted numeric keys on the
 :terminal keyboard.  I will only be giving you practice in the keystroke
 :motions.  Very few sentence drills or speed exercises are included, since these
 :keys are used so infrequently.
 :
 :If you are typing something which includes one of these special characters and
 :you cannot remember where a key is, look.  But, always make sure to hit the key
 :with the correct finger.  (If you do use the key often, you will eventually
 :learn where it is without looking.)  Since these keys are used infrequently and
 :are in different places on most other keyboards or are totally missing, speed
 :is not important.
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L217

#                                                             ../orig/t.typ:761
I:Use your S-finger for the at-sign.
*:_T_R_L218
#                                                             ../orig/t.typ:762
O:sss s@s sss s@s sss s@s sss
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L218

*:_T_R_L219
#                                                             ../orig/t.typ:764
O:s@s at@ s@s w@x s@s S@w s@s
 :s@s wax s@s mix s@s @we s@s
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L219

#                                                             ../orig/t.typ:765
I:Use your D-finger for the pound-sign (also called the number-sign).
*:_T_R_L220
#                                                             ../orig/t.typ:766
O:ddd d#d ddd d#d ddd d#d ddd
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L220

*:_T_R_L221
#                                                             ../orig/t.typ:768
O:d#d d#e d#d 3#c d#d #c# d#d
 :d#d cat d#d dog d#d eat d#d
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L221

#                                                             ../orig/t.typ:769
I:Use your F-finger for the dollar-sign.
*:_T_R_L222
#                                                             ../orig/t.typ:770
O:fff f$f fff f$f fff f$f fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L222

*:_T_R_L223
#                                                             ../orig/t.typ:773
O:f$f r$v f$f v$4 f$f 4$r f$f
 :f$f rave f$f fare f$f $10.00 f$f
 :Joe keeps cryptic inventory bills like:  4# @ $5.00/# or 6# @ $4.50/#.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L223

#                                                             ../orig/t.typ:774
I:Use your F-finger for the percent sign as well.
*:_T_R_L224
#                                                             ../orig/t.typ:775
O:fff f%f fff f%f fff f%f fff
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L224

*:_T_R_L225
#                                                             ../orig/t.typ:779
O:f%f 12% f%f 10% f%f 20% f%f
 :f%f two f%f ran f%f bug f%f
 :If a $25.00 item is sold at a 10% discount, it will cost $22.50.
 :But, a 10% markup on a item selling for $22.50 is only $24.75!  How come?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L225

#                                                             ../orig/t.typ:780
I:Use your J-finger for the ampersand.
*:_T_R_L226
#                                                             ../orig/t.typ:781
O:jjj j&j jjj j&j jjj j&j jjj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L226

*:_T_R_L227
#                                                             ../orig/t.typ:782
O:j&j 2&4 j&j 9&5 j&j 7&7 j&j
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L227

*:_T_R_L228
#                                                             ../orig/t.typ:783
O:j&j you&me j&j he&she j&j M&M j&j
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_T_R_L228

*:_T_R_L229
#                                                             ../orig/t.typ:801
T:				THE END
 :
 :You have now completed the T-series of these lessons.  If you have not already
 :done so, you should now start the N-series or S-series.
 :
 :There are a few keys which we have not studied.  If you decide to touch-type
 :these keys, use the closest finger.  Thus, the ESC, TAB, CAPS LOCK, and SCROLL
 :keys use the A-finger.  And, the keys to the far right (BACKSPACE, DELETE, LINE
 :FEED, RETURN, }, {, etc.) use the ;-finger.  The upper keys (f1, f2, etc.) are
 :not usually touch typed as the reach is too far.  If you can, fine.
 :
 :The CONTROL and REPEAT keys are difficult to touch type, but are treated like
 :the SHIFT keys whenever possible.  For example, to REPEAT an exclamation point,
 :hold the REPEAT key down with your ;-finger and then hit the ! with your A-
 :finger.  Certain command sequences, such as Control/S, are hard to do this way.
 :Many people simply hold the CONTROL-key down with their A-finger and then hit
 :the other key with whatever finger is convenient (usually the F-finger in this
 :case).
Q: Press Y to continue, or Fkey12 to exit 
N:_T_R_L229

G:_T_E_T16
#------------------------------------------------------------------------------
# Lesson series T jump tables
#------------------------------------------------------------------------------
*:_T_E_T1
Q: Do you want to continue to lesson T2 [Y/N] ? 
N:_T_MENU
G:_T_M_T2
*:_T_E_T2
Q: Do you want to continue to lesson T3 [Y/N] ? 
N:_T_MENU
G:_T_M_T3
*:_T_E_T3
Q: Do you want to continue to lesson T4 [Y/N] ? 
N:_T_MENU
G:_T_M_T4
*:_T_E_T4
Q: Do you want to continue to lesson T5 [Y/N] ? 
N:_T_MENU
G:_T_M_T5
*:_T_E_T5
Q: Do you want to continue to lesson T6 [Y/N] ? 
N:_T_MENU
G:_T_M_T6
*:_T_E_T6
Q: Do you want to continue to lesson T7 [Y/N] ? 
N:_T_MENU
G:_T_M_T7
*:_T_E_T7
Q: Do you want to continue to lesson T8 [Y/N] ? 
N:_T_MENU
G:_T_M_T8
*:_T_E_T8
Q: Do you want to continue to lesson T9 [Y/N] ? 
N:_T_MENU
G:_T_M_T9
*:_T_E_T9
Q: Do you want to continue to lesson T10 [Y/N] ? 
N:_T_MENU
G:_T_M_T10
*:_T_E_T10
Q: Do you want to continue to lesson T11 [Y/N] ? 
N:_T_MENU
G:_T_M_T11
*:_T_E_T11
Q: Do you want to continue to lesson T12 [Y/N] ? 
N:_T_MENU
G:_T_M_T12
*:_T_E_T12
Q: Do you want to continue to lesson T13 [Y/N] ? 
N:_T_MENU
G:_T_M_T13
*:_T_E_T13
Q: Do you want to continue to lesson T14 [Y/N] ? 
N:_T_MENU
G:_T_M_T14
*:_T_E_T14
Q: Do you want to continue to lesson T15 [Y/N] ? 
N:_T_MENU
G:_T_M_T15
*:_T_E_T15
Q: Do you want to continue to lesson T16 [Y/N] ? 
N:_T_MENU
G:_T_M_T16
*:_T_E_T16
G:_T_MENU

*:_T_M_T1
B:                             Lesson T1
K:12:_T_MENU
G:_T_S_T1
*:_T_M_T2
B:                             Lesson T2
K:12:_T_MENU
G:_T_S_T2
*:_T_M_T3
B:                             Lesson T3
K:12:_T_MENU
G:_T_S_T3
*:_T_M_T4
B:                             Lesson T4
K:12:_T_MENU
G:_T_S_T4
*:_T_M_T5
B:                             Lesson T5
K:12:_T_MENU
G:_T_S_T5
*:_T_M_T6
B:                             Lesson T6
K:12:_T_MENU
G:_T_S_T6
*:_T_M_T7
B:                             Lesson T7
K:12:_T_MENU
G:_T_S_T7
*:_T_M_T8
B:                             Lesson T8
K:12:_T_MENU
G:_T_S_T8
*:_T_M_T9
B:                             Lesson T9
K:12:_T_MENU
G:_T_S_T9
*:_T_M_T10
B:                            Lesson T10
K:12:_T_MENU
G:_T_S_T10
*:_T_M_T11
B:                            Lesson T11
K:12:_T_MENU
G:_T_S_T11
*:_T_M_T12
B:                            Lesson T12
K:12:_T_MENU
G:_T_S_T12
*:_T_M_T13
B:                            Lesson T13
K:12:_T_MENU
G:_T_S_T13
*:_T_M_T14
B:                            Lesson T14
K:12:_T_MENU
G:_T_S_T14
*:_T_M_T15
B:                            Lesson T15
K:12:_T_MENU
G:_T_S_T15
*:_T_M_T16
B:                            Lesson T16
K:12:_T_MENU
G:_T_S_T16
#------------------------------------------------------------------------------
# Lesson series T menu
#------------------------------------------------------------------------------
*:_T_MENU
*:_T_MENU_PAGE0
B:                 Lesson selection menu - series T [page 1 of 2]
K:1:_T_M_T1
K:2:_T_M_T2
K:3:_T_M_T3
K:4:_T_M_T4
K:5:_T_M_T5
K:6:_T_M_T6
K:7:_T_M_T7
K:8:_T_M_T8
K:9:_T_M_T9
K:10:_T_M_T10
K:11:_T_MENU_PAGE1
K:12:_T_QEXIT
T:The T series contains the following 16 lessons:
 :
 :        Fkey 1 - Lesson T1     a s d f g h j k l ;
 :        Fkey 2 - Lesson T2     e g h ,
 :        Fkey 3 - Lesson T3     i r . shift
 :        Fkey 4 - Lesson T4     o p shift ?
 :        Fkey 5 - Lesson T5     t n :
 :        Fkey 6 - Lesson T6     b u /
 :        Fkey 7 - Lesson T7     c m -
 :        Fkey 8 - Lesson T8     w y v backspace
 :        Fkey 9 - Lesson T9     q x z
 :        Fkey10 - Lesson T10    1 2 3 4
 :
 :        Fkey11 - Next menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_T_MENU_PAGE0
*:_T_MENU_PAGE1
B:                 Lesson selection menu - series T [page 2 of 2]
K:1:_T_M_T11
K:2:_T_M_T12
K:3:_T_M_T13
K:4:_T_M_T14
K:5:_T_M_T15
K:6:_T_M_T16
K:7:NULL
K:8:NULL
K:9:NULL
K:10:NULL
K:11:_T_MENU_PAGE0
K:12:_T_QEXIT
T:The T series contains the following 16 lessons:
 :
 :        Fkey 1 - Lesson T11    7 8 9 0
 :        Fkey 2 - Lesson T12    5 6 ( )
 :        Fkey 3 - Lesson T13
 :        Fkey 4 - Lesson T14    ' " !
 :        Fkey 5 - Lesson T15    = * + > < ^
 :        Fkey 6 - Lesson T16    @ # $ % &
 :
 :
 :
 :
 :
 :        Fkey11 - First menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_T_MENU_PAGE1
*:_T_QEXIT
Q: Do you want to leave this lesson series? [Y/N] ? 
N:_T_MENU
G:_T_EXIT
*:_T_EXIT
#------------------------------------------------------------------------------
# End of file t.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_V_SERIES
# Start of file v.typ
#------------------------------------------------------------------------------
# Series V
#------------------------------------------------------------------------------
G:_V_MENU
*:_V_NO_MENU
#------------------------------------------------------------------------------
# Lesson V1
#------------------------------------------------------------------------------
*:V1
*:_V_S_V1
*:_V_R_L0
#                                                               ../orig/v.typ:2
T:			Lesson	V1
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L0

#                                                               ../orig/v.typ:3
I:(1)
*:_V_R_L1
#                                                               ../orig/v.typ:5
O:r r r r frf frf frf u u u u juj juj juj juj
 :frf juj frf juj frf juj frf juj frf juj frf juj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L1

#                                                               ../orig/v.typ:6
I:(2)
*:_V_R_L2
#                                                              ../orig/v.typ:14
O:fff jjj fff jjj fff jjj fff jjj fff jjj fff jjj
 :fff jjj fff jjj fff jjj fff jjj fff jjj fff jjj
 :
 :fru fru fru jur jur jur ruj ruj ruj urf urf urf
 :fru fru fru ruf ruf ruf urj urj urj fuj fuj fuj
 :
 :urf urf urf juf juf juf fuj fuj fuj fru fru fru
 :fur fur fur ruf ruf ruf urf urf urf jur jur jur
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L2

G:_V_E_V1
#------------------------------------------------------------------------------
# Lesson V2
#------------------------------------------------------------------------------
*:V2
*:_V_S_V2
*:_V_R_L3
#                                                              ../orig/v.typ:19
T:
 :		       (D K E I)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L3

#                                                              ../orig/v.typ:20
I:(1) Warmup
*:_V_R_L4
#                                                              ../orig/v.typ:25
O:fff jjj fff jjj fff jjj fff jjj fff jjj fff jjj
 :frf juj frf juj frf juj frf juj frf juj frf juj
 :
 :fur fur fur ruf ruf ruf jur jur jur ruj ruj ruj
 :urj urj urj juf juf juf fuj fuj fuj fur fur fur
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L4

#                                                              ../orig/v.typ:26
I:(2) New Key Control
*:_V_R_L5
#                                                              ../orig/v.typ:28
O:d d d d ddd ddd ddd ddd k k k k kkk kkk kkk kkk
 :ddd kkk ddd kkk ddd kkk ddd kkk ddd kkk ddd kkk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L5

#                                                              ../orig/v.typ:29
I:(3)
*:_V_R_L6
#                                                              ../orig/v.typ:31
O:e e e e ded ded ded ded ded i i i i kik kik kik
 :ded kik ded kik ded kik ded kik ded kik ded kik
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L6

#                                                              ../orig/v.typ:32
I:(4)
*:_V_R_L7
#                                                              ../orig/v.typ:37
O:did did did ire ire ire rid rid rid eke eke eke
 :rid rid rid eke eke eke ire ire ire did did did
 :
 :kid kid kid fee fee fee red red red fir fir fir
 :red red red fir fir fir fee fee fee kid kid kid
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L7

#                                                              ../orig/v.typ:38
I:(5)
*:_V_R_L8
#                                                              ../orig/v.typ:43
O:free free free juke juke juke fire fire fire juke
 :fire fire fire juke juke juke free free free juke
 :
 :deer deer deer rude rude rude dire dire dire ride
 :rude rude rude dire dire dire deer deer deer ride
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L8

#                                                              ../orig/v.typ:44
I:(6)
*:_V_R_L9
#                                                              ../orig/v.typ:49
O:fired fired fired rider rider rider freed freed
 :rider rider rider freed freed freed fired fired
 :
 :did red ire fee rid deer rude fire feed juke rider
 :rid fee ire red did juke fire rude juke deed freed
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L9

G:_V_E_V2
#------------------------------------------------------------------------------
# Lesson V3
#------------------------------------------------------------------------------
*:V3
*:_V_S_V3
*:_V_R_L10
#                                                              ../orig/v.typ:54
T:
 :			     (T Y G H)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L10

#                                                              ../orig/v.typ:55
I:(1) Warmup
*:_V_R_L11
#                                                              ../orig/v.typ:60
O:fff jjj ddd kkk frf juj ded kik fff jjj ddd kkk
 :frf juj ded kik fur fur kid kid red red ire ire
 :
 :kid kid kid juke juke juke dire dire dire fire
 :rid rid rid rude rude rude ride ride ride feed
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L11

*:_V_R_L12
#                                                              ../orig/v.typ:63
O:
 :did red ire fee rid deer rude fire feed juke rider
 :rid fee ire red did juke fire rude juke deed freed
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L12

#                                                              ../orig/v.typ:64
I:(2) T and Y
*:_V_R_L13
#                                                              ../orig/v.typ:66
O:t t t t ftf ftf ftf ftf y y y y jyj jyj jyj jyj
 :ftf jyj ftf jyj ftf jyj ftf jyj ftf jyj ftf jyj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L13

#                                                              ../orig/v.typ:67
I:(3) G and H
*:_V_R_L14
#                                                              ../orig/v.typ:69
O:g g g g fgf fgf fgf fgf h h h h jhj jhj jhj jhj
 :fgf jhj fgf jhj fgf jhj fgf jhj fgf jhj fgf jhj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L14

#                                                              ../orig/v.typ:70
I:(4) Word Drill
*:_V_R_L15
#                                                              ../orig/v.typ:72
O:hit hit hit hit hit hit get get get get get get
 :yet yet yet yet yet yet try try try try try try
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L15

#                                                              ../orig/v.typ:73
I:(5)
*:_V_R_L16
#                                                              ../orig/v.typ:78
O:the the the try try try get get get yet yet yet
 :try try try the the the yet yet yet get get get
 :
 :key key key jit hit hit tie tie tie kit kit kit
 :tie tie tie kit kit kit key key key hit hit hit
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L16

#                                                              ../orig/v.typ:79
I:(6)
*:_V_R_L17
#                                                              ../orig/v.typ:84
O:here here here they they they true true true
 :they they they true true true here here here
 :
 :there there there fruit fruit fruit right right right
 :fruit fruit fruit right right right there there there
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L17

#                                                              ../orig/v.typ:85
I:(7)
*:_V_R_L18
#                                                              ../orig/v.typ:90
O:third third third tired tired tired urged urged urged
 :tired tired tired urged urged urged third third third
 :
 :truth truth truth their their their dried dried dried
 :their their their dried dried dried truth truth truth
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L18

#                                                              ../orig/v.typ:91
I:(8)
*:_V_R_L19
#                                                              ../orig/v.typ:93
O:did they get the right dried fruit there yet
 :did they get the right dried fruit there yet
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L19

G:_V_E_V3
#------------------------------------------------------------------------------
# Lesson V4
#------------------------------------------------------------------------------
*:V4
*:_V_S_V4
*:_V_R_L20
#                                                              ../orig/v.typ:98
T:
 :			(S L W O)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L20

#                                                              ../orig/v.typ:99
I:(1) Warmup
*:_V_R_L21
#                                                             ../orig/v.typ:101
O:frf juj ded kik ftf jyj fgf jhj frf juj ded kik
 :ded kik ftf jyj fgf jhj frf juj ded kik ftf jyj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L21

#                                                             ../orig/v.typ:102
I:(2) S and L
*:_V_R_L22
#                                                             ../orig/v.typ:104
O:s s s s sss sss sss sss l l l l lll lll lll lll
 :sss lll sss lll sss lll sss lll sss lll sss lll
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L22

#                                                             ../orig/v.typ:105
I:(3) W and O
*:_V_R_L23
#                                                             ../orig/v.typ:107
O:w w w w sws sws sws sws o o o o lol lol lol lol
 :sws lol sws lol sws lol sws lol sws lol sws lol
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L23

#                                                             ../orig/v.typ:108
I:(4) Words Drill
*:_V_R_L24
#                                                             ../orig/v.typ:110
O:sow sow sow sow sow sow low low low low low low
 :row row row row row row how how how how how how
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L24

#                                                             ../orig/v.typ:111
I:(5)
*:_V_R_L25
#                                                             ../orig/v.typ:116
O:is is is so so so of of of do do do go go go to to to
 :go go go to to to do do do of of of so so so is is is
 :
 :too too too low low low set set set wit wit wit wit
 :sit sit sit lit lit lit wit wit wit low low low low
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L25

#                                                             ../orig/v.typ:117
I:(6)
*:_V_R_L26
#                                                             ../orig/v.typ:125
O:wool wool wool suit suit suit full full full wood wood
 :hole hole hole wool wool wool suit suit suit good good
 :
 :style style style order order order those those
 :loose loose loose style style style order order
 :
 :desire desire desire rulers rulers rulers worker
 :worker worker worker desire desire desire rulers
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L26

#                                                             ../orig/v.typ:126
I:(7)
*:_V_R_L27
#                                                             ../orig/v.typ:131
O:hold your wrists low while you strike the keys
 :we desire the right goods for our wool suits
 :if you will go with us you will see the fleet
 :we will try to fill your order for the wool suits
 :if we get the right goods we will fill your order
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L27

G:_V_E_V4
#------------------------------------------------------------------------------
# Lesson V5
#------------------------------------------------------------------------------
*:V5
*:_V_S_V5
*:_V_R_L28
#                                                             ../orig/v.typ:136
T:
 :		        (A ; Q P)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L28

#                                                             ../orig/v.typ:137
I:(1) Warmup
*:_V_R_L29
#                                                             ../orig/v.typ:139
O:frf juj ded kik ftf jyj fgf jhj frf juj ftf jyj fgf jhj
 :ded kik sws lol ded kik sws lol frf juj ftf jyj fgf jhj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L29

#                                                             ../orig/v.typ:140
I:(2) A and ;
*:_V_R_L30
#                                                             ../orig/v.typ:142
O:a a a a aaa aaa aaa aaa ; ; ; ; ;;; ;;; ;;; ;;;
 :aaa ;;; aaa ;;; aaa ;;; aaa ;;; aaa ;;; aaa ;;;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L30

#                                                             ../orig/v.typ:143
I:(3) Q and P
*:_V_R_L31
#                                                             ../orig/v.typ:145
O:q q q q aqa aqa aqa aqa p p p p ;p; ;p; ;p; ;p;
 :aqa ;p; aqa ;p; aqa ;p; aqa ;p; aqa ;p; aqa ;p;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L31

#                                                             ../orig/v.typ:146
I:(4) Word Drill
*:_V_R_L32
#                                                             ../orig/v.typ:148
O:pa; pa; pa; pa; pa; pa; up; up; up; up; up; up;
 :pa; pa; pa; pa; pa; pa; up; up; up; up; up; up;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L32

#                                                             ../orig/v.typ:149
I:(5)
*:_V_R_L33
#                                                             ../orig/v.typ:151
O:quay quay quay quay quay quip quip quip quip quip
 :quay quay quay quay quay quip quip quip quip quip
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L33

#                                                             ../orig/v.typ:152
I:(6)
*:_V_R_L34
#                                                             ../orig/v.typ:160
O:apt apt apt; put put put; sip sip sip; hip hip hip;
 :sip sip sip; hip hip hip; apt apt apt; put put put;
 :
 :quip quip quip; quit quit quit; aqua aqua aqua;
 :aqua aqua aqua; quip quip quip; quit quit quit;
 :
 :paid paid paid; pair pair pair; pass pass pass;
 :pair pair pair; pass pass pass; paid paid paid;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L34

#                                                             ../orig/v.typ:161
I:(7)
*:_V_R_L35
#                                                             ../orig/v.typ:169
O:quote quote quote; paper paper paper; quite quite;
 :paper paper paper; quite quite quite; quote quote;
 :
 :prefer prefer prefer; prepay prepay prepay; quires;
 :prepay prepay prepay; prefer prefer prefer; quires;
 :
 :postage postage postage; quarter quarter quarter;
 :poultry poultry poultry; quality quality quality;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L35

#                                                             ../orig/v.typ:170
I:(8)
*:_V_R_L35A
#                                                             ../orig/v.typ:179
O:two quires of high quality paper were shipped today;
 :we shall pay you well to prepare the reports for us;
 :we quote a low figure for our high quality paper;
 :we prefer to prepay the postage for the two quires;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L35A

G:_V_E_V5
#------------------------------------------------------------------------------
# Lesson V6
#------------------------------------------------------------------------------
*:V6
*:_V_S_V6
*:_V_R_L36
T:
 :		    (Shift Keys for Capitalization)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L36

#                                                             ../orig/v.typ:180
I:(1) Warmup
*:_V_R_L37
#                                                             ../orig/v.typ:184
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :
 :he will pay jed squire for the sugar this week;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L37

#                                                             ../orig/v.typ:185
I:(2) Capital Letter Drill
*:_V_R_L38
#                                                             ../orig/v.typ:190
O:F F F F F F Fa Fa Fa Fa Fa Fa Fay Fay Fay Fay Fay Fay
 :J J J J J J Ja Ja Ja Ja Ja Ja Jay Jay Jay Jay Jay Jay
 :
 :R R R R R R Ra Ra Ra Ra Ra Ra Ray Ray Ray Ray Ray Ray
 :H H H H H H Ha Ha Ha Ha Ha Ha Hal Hal Hal Hal Hal Hal
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L38

#                                                             ../orig/v.typ:191
I:(3)
*:_V_R_L39
#                                                             ../orig/v.typ:199
O:Kay Kay Kay; Joe Joe Joe; Alf Alf Alf; Lou Lou Lou;
 :Joe Joe Joe; Kay Kay Kay; Lou Lou Lou; Alf Alf Alf;
 :
 :Dora Dora Dora; Ella Ella Ella; Pete Pete Pete;
 :Sara Sara Sara; Lola Lola Lola; Will Will Will;
 :
 :Garry Garry Garry; Harry Harry Harry; Paula Paula;
 :Harry Harry Harry; Taffy Taffy Taffy; Quail Quail;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L39

#                                                             ../orig/v.typ:200
I:(4)
*:_V_R_L40
#                                                             ../orig/v.typ:208
O:Uriah Uriah Uriah; Yetta Yetta Yetta; Ollie Ollie;
 :Yetta Yetta Yetta; Ollie Ollie Ollie; Uriah Uriah;
 :
 :Walter Walter Walter; Esther Esther Esther; Isaiah;
 :Esther Esther Esther; Walter Walter Walter; Isaiah;
 :
 :Arthur Arthur Arthur; Lester Lester Lester; Quezon;
 :Quezon Quezon Quezon; Arthur Arthur Arthur; Philip;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L40

#                                                             ../orig/v.typ:209
I:(5)
*:_V_R_L41
#                                                             ../orig/v.typ:214
O:Joseph likes to study; Joseph likes to study art;
 :Esther will write; Esther will write Larry today;
 :Arthur likes; Arthur likes to play the flute;
 :Kate says; Kate says she will stay till Friday;
 :Paul will take Willa to the Park Sherry Theater;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L41

G:_V_E_V6
#------------------------------------------------------------------------------
# Lesson V7
#------------------------------------------------------------------------------
*:V7
*:_V_S_V7
*:_V_R_L42
#                                                             ../orig/v.typ:219
T:
 :		(Shift Lock and :)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L42

#                                                             ../orig/v.typ:220
I:(1) Warmup
*:_V_R_L43
#                                                             ../orig/v.typ:222
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L43

#                                                             ../orig/v.typ:223
I:(2) Shift Lock Drill
*:_V_R_L44
#                                                             ../orig/v.typ:225
O:It is GOOD WORK; It is GOOD WORK; It is GOOD WORK;
 :It is GOOD WORK; It is GOOD WORK; It is GOOD WORK;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L44

#                                                             ../orig/v.typ:226
I:(3)
*:_V_R_L45
#                                                             ../orig/v.typ:233
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :The TITLE of the REPORT is:  HOUSES FOR SALE
 :The TITLE of the REPORT is:  HOUSES FOR SALE
 :
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :We quote LOW FIGURES for HIGHEST QUALITY paper;
 :We quote LOW FIGURES for HIGHEST QUALITY paper;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L45

#                                                             ../orig/v.typ:234
I:(4)
*:_V_R_L46
#                                                             ../orig/v.typ:245
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :The PARK POSTER reads:  KEEP OFF THE GRASS
 :The PARK POSTER reads:  KEEP OFF THE GRASS
 :
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :Paul quoted the old adage:  THE THRIFTY ARE WISE
 :Paul quoted the old adage:  THE THRIFTY ARE WISE
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L46

*:_V_R_L46A
#
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :You should STRIKE ALL THE KEYS with EQUAL POWER;
 :You should STRIKE ALL THE KEYS with EQUAL POWER;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L46A

#                                                             ../orig/v.typ:246
I:(5)
*:_V_R_L47
#                                                             ../orig/v.typ:257
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :GOOD WORK will lead to a HAPPY LIFE for you;
 :GOOD WORK will lead to a HAPPY LIFE for you;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :The DAILY DRILLS will HELP YOU type with EASE;
 :The DAILY DRILLS will HELP YOU type with EASE;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L47

*:_V_R_L47A
#
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :GOOD SALARIES are USUALLY PAID to FAST TYPISTS;
 :GOOD SALARIES are USUALLY PAID to FAST TYPISTS;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L47A

G:_V_E_V7
#------------------------------------------------------------------------------
# Lesson V8
#------------------------------------------------------------------------------
*:V8
*:_V_S_V8
*:_V_R_L48
#                                                             ../orig/v.typ:262
T:
 :		  (Introducing the Period)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L48

#                                                             ../orig/v.typ:263
I:(1) Warmup
*:_V_R_L49
#                                                             ../orig/v.typ:267
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :
 :He will pay Jed Squire for the sugar this week;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L49

#                                                             ../orig/v.typ:268
I:(2) The Period
*:_V_R_L50
#                                                             ../orig/v.typ:271
O:. . . . . . l.l l.l l.l l.l l.l l.l l.l l.l l.l
 :Hit it lightly.  Hit it lightly.  Hit it lightly.
 :Hit it lightly.  Hit it lightly.  Hit it lightly.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L50

#                                                             ../orig/v.typ:272
I:(3)
*:_V_R_L51
#                                                             ../orig/v.typ:286
P:Strike all the keys with pep.  Strike the keys
 :as though they were red hot.  This is just how the
 :fast typist works.
 :
 :Type with thought.  Put forth your greatest efforts.
 :Let these two ideas guide you while you type.
 :
 :You should follow the daily drills as you are told.
 :These drills will show you that it is quite easy
 :to type well.
 :
 :Start your daily work without delay.  Keep at it
 :regularly.  It is steady work that will take you
 :to your goal.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L51

#                                                             ../orig/v.typ:287
I:(4) Keyboard Review
*:_V_R_L52
#                                                             ../orig/v.typ:292
O:for fat few fur foe fit fed fee for fat fir few fro;
 :fro few fir fat for fee fig foe fop fit fur fat fad;
 :
 :jug jig jut jar joy jag jaw jar jet jot jog jug joy;
 :joy jug jog jag jaw jot jig jut jar jig jaw jog jet;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L52

#                                                             ../orig/v.typ:293
I:(5)
*:_V_R_L53
#                                                             ../orig/v.typ:298
O:rye rut row red rip ray rap rug rig rut rye rug rot;
 :rot rye rut row red rip rat rap rug rig rut rye rug;
 :
 :up us use uses urge ugly usage upper uproar upright;
 :us up use urge uses urge urges udder utters upstart;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L53

G:_V_E_V8
#------------------------------------------------------------------------------
# Lesson V9
#------------------------------------------------------------------------------
*:V9
*:_V_S_V9
*:_V_R_L54
#                                                             ../orig/v.typ:303
T:
 :			(V and M)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L54

#                                                             ../orig/v.typ:304
I:(1) Warmup
*:_V_R_L55
#                                                             ../orig/v.typ:308
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :
 :I will pay Joe Quig for the sugar today.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L55

#                                                             ../orig/v.typ:309
I:(2) New Keys (V, M)
*:_V_R_L56
#                                                             ../orig/v.typ:311
O:v v v v fvf fvf fvf fvf m m m m jmj jmj jmj jmj
 :fvf jmj fvf jmj fvf jmj fvf jmj fvf jmj fvf jmj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L56

#                                                             ../orig/v.typ:312
I:(3)
*:_V_R_L57
#                                                             ../orig/v.typ:320
O:over over over; gave gave gave; have have have;
 :home home home; seem seem seem; time time time;
 :
 :ever ever ever; more more more; item item item;
 :live live live; vast vast vast; five five five;
 :
 :You must devote more time to your daily work.
 :You should go over every item with more thought.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L57

#                                                             ../orig/v.typ:321
I:(4) Paragraph Practice
*:_V_R_L58
#                                                             ../orig/v.typ:333
P:You will surely make good if you give more time to
 :your daily work here.  You must make ever effort
 :to make good.
 :
 :You will improve your skill every day if you
 :devote some thought to your work.  You will surely
 :progress if you keep at your work regularly.  Just
 :have faith.
 :
 :Skillful typists make very good salaries.  All
 :types of firms require them.  So try your utmost to
 :develop your skill.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L58

#                                                             ../orig/v.typ:334
I:(5) Exercises on G, H, T, and Y
*:_V_R_L59
#                                                             ../orig/v.typ:345
O:go got get gas gag gap gay gig gray greed great;
 :go gig gay gap gas gag get gas gray great greed;
 :
 :her has had his hit hot hut hat hay hag had his;
 :his had hag hay hat hut hot hit his had has her;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L59

*:_V_R_L59A
#
O:to try tip tap two tag too to try tip tap two;
 :to two tap tip try too try to top tap tag try;
 :
 :you yes yet yap yell year yoke your yowl yore;
 :yap yet yes you yore yowl your yoke year yell;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L59A

G:_V_E_V9
#------------------------------------------------------------------------------
# Lesson V10
#------------------------------------------------------------------------------
*:V10
*:_V_S_V10
*:_V_R_L60
#                                                             ../orig/v.typ:350
T:
 :			(B and N)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L60

#                                                             ../orig/v.typ:351
I:(1) Warmup
*:_V_R_L61
#                                                             ../orig/v.typ:355
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fgf jhj fvf jmj fgf jhj fvf jmj fgf jhj fvf jmj
 :
 :Paul Quigs will devote more time to his work.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L61

#                                                             ../orig/v.typ:356
I:(2) New Keys
*:_V_R_L62
#                                                             ../orig/v.typ:358
O:b b b b fbf fbf fbf fbf n n n n jnj jnj jnj jnj
 :fbf jnj fbf jnj fbf jnj fbf jnj fbf jnj fbf jnj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L62

#                                                             ../orig/v.typ:359
I:(3) Word Drill
*:_V_R_L63
#                                                             ../orig/v.typ:361
O:bin bin bin bin bin bin nib nib nib nib nib nib
 :big big big big big big now now now now now now
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L63

#                                                             ../orig/v.typ:362
I:(4)
*:_V_R_L64
#                                                             ../orig/v.typ:370
O:bun bun bun; nip nip nip; fib fib fib; win win win;
 :fib fib fib; win win win; bun bun bun; nip nip nip;
 :
 :bent bent bent; nine nine nine; vent vent vent;
 :mend mend mend; vine vine vine; blow blow blow;
 :
 :We require more time to turn out a very good job.
 :Be prompt.  Never shirk.  Make promptness a habit.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L64

#                                                             ../orig/v.typ:371
I:(5) Practice Paragraph
*:_V_R_L65
#                                                             ../orig/v.typ:384
P:Never put off until tomorrow any job you should
 :finish today.  Try to be prompt at all times.  No one
 :likes to be kept waiting.
 :
 :Keep on working just as diligently as you have
 :been doing up to this point.  You will soon be a
 :master of the keyboard.  You will have a valuable
 :skill that will repay you for your efforts.
 :
 :Remember this:  every boy and girl is able to
 :learn typing.  All they have to do is to put forth
 :their very best efforts.  This means thinking while
 :training every finger to strike the right key.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L65

#                                                             ../orig/v.typ:385
I:(6) Words with D, E, K, and I
*:_V_R_L66
#                                                             ../orig/v.typ:390
O:do dot due dye day dew dab den dim dog die dig dry dip
 :do dig dry dip die dog dim dab den dew day dye due dot
 :
 :ebb eke err eve end egg ever even edge earn east evil
 :err eke eve end ebb eel evil east earn edge envy easy
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L66

#                                                             ../orig/v.typ:391
I:(7)
*:_V_R_L67
#                                                             ../orig/v.typ:396
O:kid kin kit keg key king kind know knee knot knew
 :key keg kid kit kin knew knot knee knob king kind
 :
 :it is in if ire ill ink inn imp idle item isle iron
 :if in is it imp inn ill ire ink item idle iron isle
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L67

G:_V_E_V10
#------------------------------------------------------------------------------
# Lesson V11
#------------------------------------------------------------------------------
*:V11
*:_V_S_V11
*:_V_R_L68
#                                                             ../orig/v.typ:401
T:
 :		      (C and Comma)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L68

#                                                             ../orig/v.typ:402
I:(1) Warmup
*:_V_R_L69
#                                                             ../orig/v.typ:406
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fvf jmj fbf jnj fvf jmj fbf jnj fvf jmj fbf jnj
 :
 :The Ben Mavis firm submitted the lowest quotation.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L69

#                                                             ../orig/v.typ:407
I:(2) New Key Review
*:_V_R_L70
#                                                             ../orig/v.typ:409
O:c c c c dcd dcd dcd dcd , , , , k,k k,k k,k k,k
 :dcd k,k dcd k,k dcd k,k dcd k,k dcd k,k dcd k,k
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L70

#                                                             ../orig/v.typ:410
I:(3) Word Drill
*:_V_R_L71
#                                                             ../orig/v.typ:412
O:can, can, can, can, can, cue, cue, cue, cue, cue,
 :can, can, can, can, can, cue, cue, cue, cue, cue,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L71

#                                                             ../orig/v.typ:413
I:(4)
*:_V_R_L72
#                                                             ../orig/v.typ:418
O:cash, cash, cash, lack, lack, lack, lace, lace, lace,
 :lack, lack, lack, lace, lace, lace, cash, cash, cash,
 :
 :could, could, could, clerk, clerk, clerk, camp, camp,
 :clerk, clerk, clerk, could, could, could, cane, cane,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L72

#                                                             ../orig/v.typ:419
I:(5)
*:_V_R_L73
#                                                             ../orig/v.typ:422
O:If you call before five, the bank will cash your check.
 :Charles Condon, sales manager, was in complete charge.
 :He may, if convenient, have it charged to his account.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L73

#                                                             ../orig/v.typ:423
I:(6)
*:_V_R_L74
#                                                             ../orig/v.typ:436
P:Space once after a comma.  Space once after a
 :semicolon.  Space twice after a period that ends a
 :sentence.  Strike each key with the same force.
 :
 :The tabulator is a device which helps you to type faster.
 :It enables you to skip across the page to any point you
 :desire.
 :
 :First, set a tab stop at the point to which you
 :wish the carriage to jump.  Second, move the carriage
 :back to the left margin.  Third, hold the tabulator
 :bar or the tabulator key down until the carriage has
 :stopped.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L74

#                                                             ../orig/v.typ:437
I:(7)
*:_V_R_L75
#                                                             ../orig/v.typ:442
O:sub sum see sun set sit sin sip she ship shall shame
 :sit sin sip set sub sum see sod sob slip sweep super
 :
 :won win who why wet was weak wear west well what when
 :was wet why who win won what well wear west when what
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L75

#                                                             ../orig/v.typ:443
I:(8)
*:_V_R_L76
#                                                             ../orig/v.typ:448
O:lad lid lot let log lie lag lug lip last sate sawn
 :lip lag lug lie log let lot lid lad land lane last
 :
 :own out owl old one oak out oil off over oven open
 :off oil out oak one old owl our own open ours over
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L76

G:_V_E_V11
#------------------------------------------------------------------------------
# Lesson V12
#------------------------------------------------------------------------------
*:V12
*:_V_S_V12
*:_V_R_L77
#                                                             ../orig/v.typ:453
T:
 :			(X and .)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L77

#                                                             ../orig/v.typ:454
I:(1) Warmup
*:_V_R_L78
#                                                             ../orig/v.typ:456
O:frf juj ftf jyj fgf jhj fvf jmj fbf jnj fvf jmj
 :ded kik sws lol aqa ;p; dcd k,k dcd k,k fvf jmj
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L78

#                                                             ../orig/v.typ:457
I:(2)
*:_V_R_L79
#                                                             ../orig/v.typ:460
O:touch...learn...above...typing...talent...
 :average...special...that is...You do......
 :You do not
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L79

#                                                             ../orig/v.typ:461
I:(3) Timed Drill:
*:_V_R_L80
#                                                             ../orig/v.typ:464
P:Touch typing is easy to learn.  You do not need
 :a mind that is above the average.  You do not
 :even need a special talent for typing.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L80

#                                                             ../orig/v.typ:465
I:(4) New Key Tryout
*:_V_R_L81
#                                                             ../orig/v.typ:467
O:x x x x sxs sxs sxs sxs . . . . l.l l.l l.l l.l
 :sxs l.l sxs l.l sxs l.l sxs l.l sxs l.l sxs l.l
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L81

#                                                             ../orig/v.typ:468
I:(5) Word Drill
*:_V_R_L82
#                                                             ../orig/v.typ:470
O:six six six six six six etc. etc. etc. etc. etc.
 :six six six six six six etc. etc. etc. etc. etc.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L82

#                                                             ../orig/v.typ:471
I:(6)
*:_V_R_L83
#                                                             ../orig/v.typ:479
O:fixes fixes fixes; mixes mixes mixes; taxes taxes;
 :mixes mixes mixes; fixes fixes fixes; boxes boxes;
 :
 :expert expert expert; expect expect expect; excels;
 :exceed exceed exceed; excuse excuse excuse; excels;
 :
 :Dr. Lux, tax expert, will examine the tax returns.
 :Mr. Cox examined the mixture with extreme care.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L83

#                                                             ../orig/v.typ:480
I:(7) Practice Paragraph
*:_V_R_L84
#                                                             ../orig/v.typ:493
P:Mr. Roxbury and Mr. Saxton will examine the six
 :boxes of wax with extreme care.  These boxes were
 :returned by Prof. Maxton of Knoxville College.
 :
 :The Government tax experts were exceedingly
 :careful in examining the current tax receipts.  The
 :amount showed an excess of six million dollars over
 :the previous year.
 :
 :Sixteen boxes of explosives were packed with the
 :most extreme care and shipped by Fox Express Company.
 :These explosives are to be used in secret experiments
 :for the U. S. Government.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L84

#                                                             ../orig/v.typ:494
I:(8) Drill on A, Q, ;, P
*:_V_R_L85
#                                                             ../orig/v.typ:502
O:act ant and ask apt any art all age anle acid aged
 :age all art any ask act add axe ant aged able acid
 :
 :quit quip quote quite queer queen quack quaint quorum
 :quip quit quite quote queen queer quail quorum quaint
 :
 :pin pup put; pull palm pant; pint pile push; punch;
 :put pin pup; pant pull palm; push pick pile; paper;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L85

G:_V_E_V12
#------------------------------------------------------------------------------
# Lesson V13
#------------------------------------------------------------------------------
*:V13
*:_V_S_V13
*:_V_R_L86
#                                                             ../orig/v.typ:507
T:
 :			(Z and /)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L86

#                                                             ../orig/v.typ:508
I:(1) Warmup
*:_V_R_L87
#                                                             ../orig/v.typ:510
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fvf jmj fbf jnj dcd k,k sxs l.l dcd k,k sxs l.l
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L87

#                                                             ../orig/v.typ:511
I:(2)
*:_V_R_L88
#                                                             ../orig/v.typ:514
O:touch...learn...above...typing...talent...average
 :special...lessons...you do...for you...is the
 :do the...of the...in this
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L88

#                                                             ../orig/v.typ:515
I:(3)
*:_V_R_L89
#                                                             ../orig/v.typ:522
P:Touch typing is easy to learn.  You do not need a
 :mind that is above the average.  You do not even
 :need a special talent for typing.
 :
 :All you need is the will to learn.  The lessons in
 :this book do the rest of the job for you; they
 :make touch typing easy for you to learn.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L89

#                                                             ../orig/v.typ:523
I:(4) New Key Tryout
*:_V_R_L90
#                                                             ../orig/v.typ:525
O:z z z z aza aza aza aza / / / / ;/; ;/; ;/; ;/;
 :aza ;/; aza ;/; aza ;/; aza ;/; aza ;/; aza ;/;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L90

#                                                             ../orig/v.typ:526
I:(5) Word Drill
*:_V_R_L91
#                                                             ../orig/v.typ:528
O:zip zip zip zip zip c/o c/o c/o c/o c/o c/o
 :zip zip zip zip zip c/o c/o c/o c/o c/o c/o
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L91

#                                                             ../orig/v.typ:529
I:(6)
*:_V_R_L92
#                                                             ../orig/v.typ:537
P:zest zest zest; lazy lazy lazy; size size size; zeal;
 :zero zero zero; zest zest zest; lazy lazy lazy; zeal;
 :
 :blaze blaze blaze; amaze amaze amaze; zebra zebra;
 :dizzy dizzy dizzy; blaze blaze blaze; amaze amaze;
 :
 :The lazy zebra at the zoo quickly drank the mixture.
 :Ship five dozen boxes of zinc trays by Zale Express.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L92

#                                                             ../orig/v.typ:538
I:(7)
*:_V_R_L93
#                                                             ../orig/v.typ:553
P:The slant is controlled by the semicolon finger.
 :It is used in such abbreviations as n/c, which means
 :NO CHARGE; and c/o, which means CARE OF.
 :
 :If you work with zeal and zest, you will soon be a
 :competent typist.  The ability to type well is a
 :very valuable asset.
 :
 :You can develop your typing skill quickly by the proper
 :habits of work.  You should realize that poor work is a
 :mere waste of time.  Try to be exact.
 :
 :Every business firm is dependent on the services of
 :competent typists.  You are now equipping yourself with
 :a skill for which there is a constant demand.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L93

#                                                             ../orig/v.typ:554
I:(8)
*:_V_R_L94
#                                                             ../orig/v.typ:559
O:bag big bug bit bud bed bid bun bale bend bank bask
 :but bid bed bun bid big bag bud bask bale band bank
 :
 :not now nut nor note nose none nude noun nine nest
 :now not nor nut nose note nude none nine nest next
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L94

#                                                             ../orig/v.typ:560
I:(9)
*:_V_R_L95
#                                                             ../orig/v.typ:565
O:vim vet van vex vet vast vote veto vase vine vial
 :van vex vet vim vex vial vine vase veto vote vast
 :
 :man mix mat mad made mail main make mark mask mine
 :mad met mix men mask mark made main male made mint
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L95

G:_V_E_V13
#------------------------------------------------------------------------------
# Lesson V14
#------------------------------------------------------------------------------
*:V14
*:_V_S_V14
*:_V_R_L96
#                                                             ../orig/v.typ:570
T:
 :		   (The Question Mark)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L96

#                                                             ../orig/v.typ:571
I:(1) Warmup
*:_V_R_L97
#                                                             ../orig/v.typ:575
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fvf jmj fbf jnj dcd k,k sxs l.l aza ;/; aza ;/;
 :
 :Liza quickly mixed the very big jar of new soap.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L97

#                                                             ../orig/v.typ:576
I:(2)
*:_V_R_L98
#                                                             ../orig/v.typ:581
O:touch...learn...above...aside...typing
 :talent...amount...average...special...
 :lessons...definite...is the...of the
 :for you...you do...that is...in this
 :you do not
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L98

#                                                             ../orig/v.typ:582
I:(3)
*:_V_R_L99
#                                                             ../orig/v.typ:592
P:Touch typing is easy to learn.  You do not need a mind
 :that is above the average.  You do not even need a
 :special talent for typing.
 :
 :All you need is the will to learn.  The lessons in this
 :book do the rest of the job for you; they make touch
 :typing easy for you to learn.
 :
 :Try to set aside each day a definite amount of time for
 :each lesson.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L99

#                                                             ../orig/v.typ:593
I:(4) New Key Tryout
*:_V_R_L100
#                                                             ../orig/v.typ:595
O:? ? ? ? ? ? Who?  Who?  Who?  Who?  Who?  Who?
 :? ? ? ? ? ? Why?  Why?  Why?  Why?  Why?  Why?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L100

#                                                             ../orig/v.typ:596
I:(5)
*:_V_R_L101
#                                                             ../orig/v.typ:604
O:How much?  How many?  How soon?  How early?  How fast?
 :How many?  How much?  How fast?  How large?  How soon?
 :
 :Where is Max?  Where is Mary?  What is Cora sewing?
 :Where is Sam?  Where is Paul?  What is Zeke fixing?
 :
 :Can Max swim?  Can he dance?  Can he play tennis?
 :Can he dance?  Deos he swim?  Do you like tennis?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L101

#                                                             ../orig/v.typ:605
I:(6)
*:_V_R_L102
#                                                             ../orig/v.typ:610
O:Did you open the mail?  Did you read the note?
 :Did you read the note?  Did you open the mail?
 :
 :Can Van do the work?  Will he require aid?  Who knows?
 :Can Jim complete it?  Is he quite capable?  Who knows?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L102

#                                                             ../orig/v.typ:611
I:(7) Practice Paragraph
*:_V_R_L103
#                                                             ../orig/v.typ:626
P:Do you set aside a definite amount of time each
 :day for practice?  Do you start work promptly?  Can
 :you make the various machine adjustments quickly?
 :
 :Do you keep your fingers curved?  Do you strike each key
 :sharply with the tip of the finger?  Do you keep your eyes
 :on the copy?
 :
 :Do you throw the carriage without looking up?  Do you keep
 :your right hand on the home keys when you throw the carriage?
 :Do you use the paper release to remove your paper?
 :
 :Do you practice the words in which you made errors?  Do you
 :practice them as explained in this book?  Do you follow the
 :instructions exactly as given?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L103

#                                                             ../orig/v.typ:627
I:(8)
*:_V_R_L104
#                                                             ../orig/v.typ:632
O:lax vex six tax fix taxed fixing mixing taxing vexing
 :fix tax vex lax six fixed vexing taxing fixing mixing
 :
 :zip zoo zest zeal zinc zero lazy zone zoom zinc zealot
 :zoo zip zoom zone lazy zinc zeal zest zero zone zealot
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L104

G:_V_E_V14
#------------------------------------------------------------------------------
# Lesson V15
#------------------------------------------------------------------------------
*:V15
*:_V_S_V15
*:_V_R_L105
#                                                             ../orig/v.typ:637
T:
 :			(1, 4, 5, 6, 7)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L105

#                                                             ../orig/v.typ:638
I:(1) Warmup
*:_V_R_L106
#                                                             ../orig/v.typ:640
O:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fvf jmj fbf jnj dcd k,k sxs l.l aza ;/; aza ;/;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L106

#                                                             ../orig/v.typ:641
I:(2)
*:_V_R_L107
#                                                             ../orig/v.typ:647
O:touch...learn...above...aside...typing
 :talent...amount...follow...easily...become
 :typist...average...special...lessons...definite
 :exactly...quickly...surprised...is the...
 :of the...in the...in this...for you...
 :you will...you will be
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L107

#                                                             ../orig/v.typ:648
I:(3)
*:_V_R_L108
#                                                             ../orig/v.typ:651
P:Touch typing is easy to learn.  You do not need a
 :mind that is above the average.  You do not even need
 :a special talent for typing.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L108

#                                                             ../orig/v.typ:652
I:(4)
*:_V_R_L109
#                                                             ../orig/v.typ:664
P:Touch typing is easy to learn.  You do not need a
 :mind that is above the average.  You do not even need
 :a special talent for typing.
 :
 :All you need is the will to learn.  The lessons in this
 :book do the rest of the job for you; they make touch
 :typing easy for you to learn.
 :
 :Try to set aside each day a definite amount of time for
 :each lesson.  Follow each step in the lesson exactly as
 :given.  You will be surprised how easily and quickly
 :you will become a touch typist.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L109

#                                                             ../orig/v.typ:665
I:(5) 4 and 7
*:_V_R_L110
#                                                             ../orig/v.typ:670
O:f4f f4f f4f f4f f4f f4f j7j j7j j7j j7j j7j j7j
 :f4f j7j f4f j7j f4f j7j f4f j7j f4f j7j f4f j7j
 :
 :or 4 or 4 or 4 ru 7 ru 7 ru 7 or 4 ru 7 or 4 ru 7
 :or 4 ru 7 or 4 ru 7 or 4 ru 7 or 4 ru 7 or 4 ru 7
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L110

#                                                             ../orig/v.typ:671
I:(6)
*:_V_R_L111
#                                                             ../orig/v.typ:676
O:June 1; July 4; April 7; January 4; March 17, 1741
 :July 4; June 1; March 4; October 7; April 14, 1471
 :
 :What is the sum of 11 and 7 and 4 and 1 and 714?
 :What is the sum of 17 and 4 and 7 and 1 and 174?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L111

#                                                             ../orig/v.typ:677
I:(7)
*:_V_R_L112
#                                                             ../orig/v.typ:685
O:Florence is 7 years 14 months and 17 days old today.
 :Veronica is 4 years 11 months and 14 days old today.
 :
 :Your order of November 14 was shipped on December 17.
 :Your order of December 11 was shipped on February 14.
 :
 :Policy No. 141174 will expire on Monday, November 14.
 :Policy No. 471714 will expire on Friday, December 17.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L112

#                                                             ../orig/v.typ:686
I:(8) Practice Paragraph
*:_V_R_L113
#                                                             ../orig/v.typ:700
P:Henry Clay, American statesman and orator, was
 :born in Hanover County, Virginia, in 1777.
 :
 :On June 14, 1777, John Paul Jones became commander
 :of the American warship, THE RANGER.
 :
 :In April 1777, Lafayette landed at night on the
 :shore of South Carolina to help the colonies.  In
 :July 1777, Congress made Lafayette a general.
 :
 :June 14 is now observed as Flag Day because the
 :flag was adopted by Congress on June 14, 1777.  The
 :house where Betsy Ross, designer of the flag, lived
 :is now preserved as a shrine.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L113

#                                                             ../orig/v.typ:701
I:(9)
*:_V_R_L114
#                                                             ../orig/v.typ:713
P:Do not erase.  Do not cross out.  Do not strike
 :one letter over another.  Let your errors stand.
 :Finish every line you start.
 :
 :You correct your typing errors by practicing the
 :words in which you made errors.  You have been doing
 :this in the previous lessons.  Keep right on doing so.
 :That is the best practice for training your fingers
 :to strike the right keys.
 :
 :Try your utmost to turn out attractive work.
 :Take pride in your typing product.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L114

#                                                             ../orig/v.typ:714
I:(10) 5 and 6
*:_V_R_L115
#                                                             ../orig/v.typ:719
O:f5f f5f f5f f5f f5f f5f j6j j6j j6j j6j j6j j6j
 :f5f j6j f5f j6j f5f j6j f5f j6j f5f j6j f5f j6j
 :
 :if 5 by 6 if 5 by 6 if 6 by 6 if 5 by 6 if 5 by 6
 :if 5 by 6 if 5 by 6 if 6 by 6 if 5 by 6 if 5 by 6
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L115

#                                                             ../orig/v.typ:720
I:(11)
*:_V_R_L116
#                                                             ../orig/v.typ:727
O:f4f j7j f5f j6j f4f j7j f5f j6j f4f j7j f5f j6j
 :15 lbs. coffee; 16 doz. eggs; 56 boxes oranges;
 :65 lbs. coffee; 14 doz. eggs; 75 boxes oranges;
 :
 :or 4 ru 7 it 5 my 6 or 4 ru 7 it 5 my 6 147 156
 :The Barton Market is at 516 West 147th Street.
 :The Baxter Market is at 165 East 165th Street.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L116

#                                                             ../orig/v.typ:728
I:(12)
*:_V_R_L117
#                                                             ../orig/v.typ:735
O:fr4 ju7 ft5 jy6 f4f j7j f5f j6j f4f j7j f5f j6j
 :Robert Fulton was born in Pennsylvania in 1765.
 :William Penn, English Quaker, was born in 1644.
 :
 :or 4 ru 7 it 5 by 6 or 4 ru 7 it 5 by 6 174 516
 :The sum of 15 and 51 and 65 and 41 and 475 is 647.
 :The sum of 51 and 15 and 56 and 14 and 475 is 611.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L117

#                                                             ../orig/v.typ:736
I:(13)
*:_V_R_L118
#                                                             ../orig/v.typ:749
P:On June 15, 1775, George Washington was elected
 :by Congress the Chief Commander of the American forces.
 :He scored a brilliant victory at Trenton on Christmas
 :night, 1776.
 :
 :The Declaration of Independence, a famous state
 :paper, was issued by the American Continental Congress
 :on July 4w 1776.  It was drawn up by Thomas Jefferson.
 :
 :The invasion fleet consisted of 4 battleships, 15 light
 :cruisers, 6 aircraft carriers, 17 troopships, six submarines,
 :and 2 Dr. Strangeloves.  Air protection consisted of 14
 :bombers, 175 fighters, 6 helicopters, and 75 paratroop planes.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L118

G:_V_E_V15
#------------------------------------------------------------------------------
# Lesson V16
#------------------------------------------------------------------------------
*:V16
*:_V_S_V16
*:_V_R_L119
#                                                             ../orig/v.typ:754
T:
 :			(3 and 8)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L119

#                                                             ../orig/v.typ:755
I:(1) Warmup
*:_V_R_L120
#                                                             ../orig/v.typ:757
O:f4f j7j f5f j6j f4f j7j f5f j6j f4f j7j f5f j6j
 :417 147 517 157 617 167 617 171 714 471 651 174
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L120

#                                                             ../orig/v.typ:758
I:(2)
*:_V_R_L121
#                                                             ../orig/v.typ:763
O:never...typing...office...become...getting...
 :acquire...efforts...valuable...personal...
 :possible...business...shorthand...it is...
 :it can...to it...in the...to use...to have
 :if you...from you...why not
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L121

#                                                             ../orig/v.typ:764
I:(3)
*:_V_R_L122
#                                                             ../orig/v.typ:767
P:Typing is a very valuable skill to acquire.  It is
 :valuable for personal use and as a means of getting
 :an office job.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L122

#                                                             ../orig/v.typ:768
I:(4)
*:_V_R_L123
#                                                             ../orig/v.typ:781
P:Typing is a very valuable skill to acquire.  It is
 :valuable for personal use and as a means of getting
 :an office job.  This skill is yours to use; it can
 :never be taken from you.
 :
 :So why not put forth your best efforts to become a
 :good typist?  You can become a good typist if you
 :put your mind to it.  You should also, if possible,
 :learn shorthand.  Typing and shorthand are two very
 :valuable skills to have.
 :
 :These two skills will help you get a good start
 :in the business world.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L123

#                                                             ../orig/v.typ:782
I:(5) New Key Tryout
*:_V_R_L124
#                                                             ../orig/v.typ:787
O:d3d k8k d3d k8k d3d k8k d3d k8k d3d k8k d3d k8k
 :131 313 311 181 818 381 381 381 183 138 318 813
 :
 :bid 3 bid 3 bid 3 bid 3 oak 8 oak 8 oak 8 oak 8
 :bid 3 bid 3 bid 3 bid 3 oak 8 oak 8 oak 8 oak 8
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L124

#                                                             ../orig/v.typ:788
I:(6)
*:_V_R_L125
#                                                             ../orig/v.typ:795
O:d3d k8k d3d k8k d3d k8k d3d k8k 318 813 138 813 381
 :13 lbs.  lamb roast; 38 lbs. lamb chops; 8 lbs. bananas;
 :31 lbs.  lamb chops; 83 lbs. lamb roast; 3 lbs. peaches;
 :
 :lie 3 dye 3 pie 3 dye 3 Fiji 8 Fiji 8 Fiji 8
 :18 cans grape juice; 138 cans prune juice; 4 lbs. coffee;
 :47 cans prune juice; 143 cans grape juice; 8 lbs. onions;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L125

#                                                             ../orig/v.typ:796
I:(7)
*:_V_R_L126
#                                                             ../orig/v.typ:803
O:d3d k8k d3d k8k d3d k8k 183 381 813 318 138 381
 :8 lbs. Swiss Cheese; 13 lbs. Kraft Cheese; 4 lbs. pears;
 :5 lbs. Kraft Cheese; 17 lbs. Swiss Cheese; 6 lbs. beans;
 :
 :pie 3 dye 3 pie 3 dye 3 Fiji 8 Fiji 8 Fiji 8 Fiji 8
 :The sum of 13 and 83 and 153 and 75 and 47 is 371.
 :The sum of 47 and 75 and 153 and 83 and 13 is 371.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L126

#                                                             ../orig/v.typ:804
I:(8) Practice Paragraph
*:_V_R_L127
#                                                             ../orig/v.typ:824
P:John Jacob Astor was born in 1763 and died in
 :1848.  He came to America from England in 1784 and
 :set up a prosperous fur trade.  In 1811 he founded
 :the settlement of Astoria near the mouth of the
 :Columbia River.
 :
 :Alexander Graham Bell was born in Scotland on
 :March 3, 1847.  He invented the telephone in 1876.
 :The Bell Telephone Company was organized in 1877.
 :Mr. Bell also invented the gramophone in 1887.
 :
 :John Quincy Adams, sixth President of the
 :United States, was born in Massachusetts on July 11,
 :1767.  In 1817 he was appointed Secretary of State.
 :He died in 1848.
 :
 :Oliver Wendell Holmes, American jurist, was born
 :in Massachusetts on March 8, 1841; graduated from
 :Harvard in 1861; from Harvard Law School in 1866;
 :admitted to the Massachusetts Bar in 1867.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L127

G:_V_E_V16
#------------------------------------------------------------------------------
# Lesson V17
#------------------------------------------------------------------------------
*:V17
*:_V_S_V17
*:_V_R_L128
#                                                             ../orig/v.typ:829
T:
 :			(2 and 9)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L128

#                                                             ../orig/v.typ:830
I:(1) Warmup
*:_V_R_L129
#                                                             ../orig/v.typ:834
O:f4f j7j f5f j6j d3d k8k f4f j7j f5f j6j d3d k8k
 :or4 ru7 it5 by6 ie3 ok8 or4 ru7 it5 by6 ie3 ok8
 :
 :The sum of 14 and 16 and 53 and 58 and 174 is 315.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L129

#                                                             ../orig/v.typ:835
I:(2)
*:_V_R_L130
#                                                             ../orig/v.typ:841
O:strike...center...finger...spring...though...
 :expert...sharply...release...quickly...develop...
 :letting...squarely...practice...familiar...
 :fingertip...important...technique...releasing...
 :instantly...it is...do it...do this...with the...
 :you get.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L130

#                                                             ../orig/v.typ:842
I:(3)
*:_V_R_L131
#                                                             ../orig/v.typ:845
P:Strike each key sharply with the fingertip and squarely
 :in the center.  Strike the key quickly, letting the
 :finger spring back as though the key were red hot.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L131

#                                                             ../orig/v.typ:846
I:(4)
*:_V_R_L132
#                                                             ../orig/v.typ:849
P:Strike each key sharply with the fingertip and squarely
 :in the center.  Strike the key quickly, letting the
 :finger spring back as though the key were red hot.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L132

*:_V_R_L133
#                                                             ../orig/v.typ:858
P:
 :To type fast, it is just as important to release the
 :key quickly as it is to strike it quickly.  Expert
 :typists do this; you too, can do it, with practice.
 :
 :One good way to develop this technique is to practice
 :familiar words and phrases.  Type them over and over
 :again until you get the knack of hitting the keys quickly
 :and releasing the fingers instantly.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L133

#                                                             ../orig/v.typ:859
I:(5) New Key Tryout
*:_V_R_L134
#                                                             ../orig/v.typ:864
O:s2s s2s s2s s2s s2s s2s l9l l9l l9l l9l l9l l9l
 :s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l
 :
 :bow 2 bow 2 bow 2 bow 2 two 9 two 9 two 9 two 9
 :bow 2 two 9 bow 2 two 9 bow 2 two 9 bow 2 two 9
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L134

#                                                             ../orig/v.typ:865
I:(6)
*:_V_R_L135
#                                                             ../orig/v.typ:872
O:s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l
 :12 lbs. coffee; 19 lbs. Cottage Cheese; 9 lbs. peaches;
 :19 lbs. apples; 29 lbs. Cheddar Cheese; 2 lbs. bananas;
 :
 :low 2 fro 9 low 2 fro 9 low 2 fro 9 low 2 fro 9 29 192;
 :9 lbs. Smoked Tongue; 2 lbs. tomatoes; 9 lbs. avocados;
 :2 lbs. Cooked Tongue; 9 lbs. avocados; 2 lbs. tomatoes;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L135

#                                                             ../orig/v.typ:873
I:(7)
*:_V_R_L136
#                                                             ../orig/v.typ:880
O:s2s l9l s2s l9l 219 921 192 s2s l9l s2s 191 291 129
 :The sum of 29 and 86 and 33 and 92 and 52 is 292.
 :The sum of 52 and 92 and 86 and 33 and 29 is 292.
 :
 :ow 2 to 9 ow 2 to 9 we 23 ok 98 we 23 ok 98 s2s l9l
 :George Washington was born on February 22, 1732.
 :Horatio Alger was born in 1834 and died in 1899.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L136

#                                                             ../orig/v.typ:881
I:(8)
*:_V_R_L137
#                                                             ../orig/v.typ:898
P:Christopher Latham Sholes was the inventor of the first practical
 :typewriter.  He was born in Columbia County, Pennsylvania,
 :February 14, 1819.
 :
 :James Monroe, fifth President of The United States, was born on
 :April 28, 1758.  In 1782 he entered politics.  In 1799 he was appointed
 :Governor of Virginia.  In 1811 he became Secretary of State; in 1814,
 :Secretary of War; in 1816, President of The United States.
 :
 :On September 1, 1939, Germany launched undeclared war on Poland.
 :On September 3, 1939, Great Britain declared war on Germany.  On
 :December 8, 1941, The United States declared war against the Axis.
 :
 :Samuel F. B. Morse, inventor and artist, was born in 1791 and died in
 :1872.  In 1829 he went to Europe for three years.  For 12 years he
 :worked on perfecting the electrical telegraph, which was exhibited at New
 :York University in 1837.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L137

G:_V_E_V17
#------------------------------------------------------------------------------
# Lesson V18
#------------------------------------------------------------------------------
*:V18
*:_V_S_V18
*:_V_R_L138
#                                                             ../orig/v.typ:903
T:
 :		    (0 and the Hyphen)
Q: Press Y to continue, or Fkey12 to exit 
N:_V_R_L138

#                                                             ../orig/v.typ:904
I:(1) Warmup
*:_V_R_L139
#                                                             ../orig/v.typ:908
O:f4f j7j f5f j6j d3d k8k s2s l9l f4f j7j f5f j6j
 :s2s l9l d3d k8k f4f j7j f5f j6j f4f j7j f5f j6j
 :
 :The sum of 47 and 65 and 38 and 92 and 16 equals 258.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L139

#                                                             ../orig/v.typ:909
I:(2)
*:_V_R_L140
#                                                             ../orig/v.typ:913
O:expert...typing...margin...always...before...
 :permits...others...reached...equipped...machines...
 :carriage...typewriter...approaching...you are...
 :of the...for the...on the...you may...before the
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L140

#                                                             ../orig/v.typ:914
I:(3)
*:_V_R_L141
#                                                             ../orig/v.typ:917
P:Your typewriter is equipped with a bell which
 :rings to warn you that you are approaching the end
 :of the line
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L141

#                                                             ../orig/v.typ:918
I:(4)
*:_V_R_L142
#                                                             ../orig/v.typ:934
P:Your typewriter is equipped with a bell which rings
 :to warn you that you are approaching the end of the
 :line.
 :
 :On some machines, the bell rings five spaces before
 :the margin stop is reached; on other machines, it
 :rings when there are six or seven spaces left.
 :
 :The ring of the bell permits you to keep your eyes
 :on the copy.  When you hear the bell, finish the
 :word you are typing and throw the carriage for the
 :next line.
 :
 :Do not look up to watch for the end of the line; you
 :may lose your place in the copy.  Always keep your
 :eyes on the copy like the expert typist.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L142

#                                                             ../orig/v.typ:935
I:(5) New Key Tryout
*:_V_R_L143
#                                                             ../orig/v.typ:941
O:;0; ;0; ;0; ;0; ;0; ;0; ;-; ;-; ;-; ;-; ;-; ;-;
 :;0; ;-; ;0; ;-; ;0; ;-; ;0; ;-; ;0; ;-; ;0; ;-;
 :
 :10-room; 10-room; 10-room; 10-room; 10-room;
 :20-room; 20-room; 20-room; 20-room; 20-room;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L143

#                                                             ../orig/v.typ:942
I:(6)
*:_V_R_L144
#                                                             ../orig/v.typ:949
O:f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :one-half; one-fourth; one-eighth; three-quarters;
 :one-half; two-thirds; one-fourth; three-sevenths;
 :
 :f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :20-room house; 30-room house; 40-room house;
 :50-room house; 60-room house; 70-room house;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L144

#                                                             ../orig/v.typ:950
I:(7)
*:_V_R_L145
#                                                             ../orig/v.typ:957
O:f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :One-fourth may be typewritten like this:  1/4.
 :One-eighth may be typewritten like this:  1/8.
 :
 :f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :Every expert was once a beginner--with ambition.
 :Every expert was once a beginner--with ambition.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L145

#                                                             ../orig/v.typ:958
I:(8)
*:_V_R_L146
#                                                             ../orig/v.typ:972
P:As you have seen in the above sentence practice, the hyphen is used
 :for typing compound words.  Here are a few more examples:  up-to-date,
 :first-class, by-product.
 :
 :The hyphen is used also to divide words between syllables at the end
 :of a line.  When the bell rings, finish the word if it is short--less
 :than six letters.  If the word is longer, divide it at the end of a syllable.
 :
 :The hyphens in the following words show where they could be divided
 :at the end of a line:  after-noon, state-ment, hesi-tate, cer-ti-fi-
 :cate, exami-na-tion.
 :
 :The sum of 10 and 20 and 30 and 40 and 50 and 60 and 70 and 80 and 90
 :and 100 and 105 and 106 and 107 and 108 and 109 and 110 equals 1,195.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L146

#                                                             ../orig/v.typ:973
I:(9)
*:_V_R_L147
#                                                             ../orig/v.typ:978
P:Have you seen the new 7-room house at 175 West
 :239th Street?  It is equipped with every up-to-date,
 :labor-saving device for the home.  You may inspect
 :it free of charge any day except Sunday between
 :10 a.m. and 4 p.m.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L147

G:_V_E_V18
#------------------------------------------------------------------------------
# Lesson V19
#------------------------------------------------------------------------------
*:V19
*:_V_S_V19

#                                                             ../orig/v.typ:982
I:(1) Warmup
*:_V_R_L149
#                                                             ../orig/v.typ:986
O:f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :s2s l9l ;-; ;=; d3d k8k f4f j7j ;0; ;-; ;0; ;-;
 :
 :Max Zale made a long-distance flight of 2,590 miles.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L149

#                                                             ../orig/v.typ:987
I:(2)
*:_V_R_L150
#                                                             ../orig/v.typ:991
O:called...fourth...typing...letter...always...
 :capital...holding...depress...fingers...release...
 :touching...slightly...position...right-hand...of the
 :for the...all the...with the...you have
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L150

#                                                             ../orig/v.typ:992
I:(3)
*:_V_R_L151
#                                                             ../orig/v.typ:994
P:You type capital letters by holding down a key
 :called the shift key while you strike the letter key.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L151

#                                                             ../orig/v.typ:995
I:(4)
*:_V_R_L152
#                                                            ../orig/v.typ:1010
P:You type capital letters by holding down a key
 :called the shift key while you strike the letter key.
 :
 :There are two shift keys.  Hold down the left
 :shift key for typing right-hand capitals; hold down
 :the right shift key for typing left-hand capitals.
 :Always use the fourth finger for the shift key.
 :
 :Keep your wrists low but not touching the frame
 :of the machine.  Raise the other fingers slightly as
 :you depress the shift key with the fourth finger.
 :
 :Be sure that you hold the shift key all the way
 :down until you have struck the letter key; then re-
 :lease the shift key and return finger to home base.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L152

#                                                            ../orig/v.typ:1011
I:(5)
*:_V_R_L153
#                                                            ../orig/v.typ:1028
P:Prepare a bill for the following items:  29 lbs. butter
 :@ $0.895; 36 doz. eggs @ $0.695;  28 doz. oranges
 :@ $0.575; 15 bu. potatoes @ $0.795.
 :
 :Our company ordered 15 Ajax Pencil Sharpeners at
 :$0.98; 6 doz. Circular Rubber Erasers at $.43; 24 No.  68
 :Spiral Stenographic Notebooks at $.075.
 :
 :Deliver the following order to Mrs. Beverly
 :Vinson at 390 West 135th Street, New York City:  2 lbs.
 :Temple Oranges at $.135; 3 lbs. Red Circle Coffee at
 :$.91; 2 lbs. Lima Beans at $.29.
 :
 :The Johnston Hardware Company, Toledo, Ohio has
 :ordered the following supplies:  15 Pruning Shears,
 :10-inch, at $.795; 24 Steel Rakes, 14-inch, at $.815;
 :16 Steel Spades, D-Handle, at $.935.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L153

#                                                            ../orig/v.typ:1029
I:(6)
*:_V_R_L154
#                                                            ../orig/v.typ:1042
P:The backspace key is one of the most useful time-
 :saving devices on your typewriter.  You use it to back
 :up a space, to darken a light impression, or to pivot.
 :To pivot means to type a line so that the last letter
 :is at the right margin or other chosen point.
 :
 :For example, if you want a date line to end at the
 :right margin, place the carriage with the printing point
 :indicator at the right margin and backspace once for
 :each stroke in the date line.
 :
 :The most important use of the backspace key is in
 :centering words or lines.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_V_R_L154

G:_V_E_V19
#------------------------------------------------------------------------------
# Lesson series V jump tables
#------------------------------------------------------------------------------
*:_V_E_V1
Q: Do you want to continue to lesson V2 [Y/N] ? 
N:_V_MENU
G:_V_M_V2
*:_V_E_V2
Q: Do you want to continue to lesson V3 [Y/N] ? 
N:_V_MENU
G:_V_M_V3
*:_V_E_V3
Q: Do you want to continue to lesson V4 [Y/N] ? 
N:_V_MENU
G:_V_M_V4
*:_V_E_V4
Q: Do you want to continue to lesson V5 [Y/N] ? 
N:_V_MENU
G:_V_M_V5
*:_V_E_V5
Q: Do you want to continue to lesson V6 [Y/N] ? 
N:_V_MENU
G:_V_M_V6
*:_V_E_V6
Q: Do you want to continue to lesson V7 [Y/N] ? 
N:_V_MENU
G:_V_M_V7
*:_V_E_V7
Q: Do you want to continue to lesson V8 [Y/N] ? 
N:_V_MENU
G:_V_M_V8
*:_V_E_V8
Q: Do you want to continue to lesson V9 [Y/N] ? 
N:_V_MENU
G:_V_M_V9
*:_V_E_V9
Q: Do you want to continue to lesson V10 [Y/N] ? 
N:_V_MENU
G:_V_M_V10
*:_V_E_V10
Q: Do you want to continue to lesson V11 [Y/N] ? 
N:_V_MENU
G:_V_M_V11
*:_V_E_V11
Q: Do you want to continue to lesson V12 [Y/N] ? 
N:_V_MENU
G:_V_M_V12
*:_V_E_V12
Q: Do you want to continue to lesson V13 [Y/N] ? 
N:_V_MENU
G:_V_M_V13
*:_V_E_V13
Q: Do you want to continue to lesson V14 [Y/N] ? 
N:_V_MENU
G:_V_M_V14
*:_V_E_V14
Q: Do you want to continue to lesson V15 [Y/N] ? 
N:_V_MENU
G:_V_M_V15
*:_V_E_V15
Q: Do you want to continue to lesson V16 [Y/N] ? 
N:_V_MENU
G:_V_M_V16
*:_V_E_V16
Q: Do you want to continue to lesson V17 [Y/N] ? 
N:_V_MENU
G:_V_M_V17
*:_V_E_V17
Q: Do you want to continue to lesson V18 [Y/N] ? 
N:_V_MENU
G:_V_M_V18
*:_V_E_V18
Q: Do you want to continue to lesson V19 [Y/N] ? 
N:_V_MENU
G:_V_M_V19
*:_V_E_V19
G:_V_MENU

*:_V_M_V1
B:                             Lesson V1
K:12:_V_MENU
G:_V_S_V1
*:_V_M_V2
B:                             Lesson V2
K:12:_V_MENU
G:_V_S_V2
*:_V_M_V3
B:                             Lesson V3
K:12:_V_MENU
G:_V_S_V3
*:_V_M_V4
B:                             Lesson V4
K:12:_V_MENU
G:_V_S_V4
*:_V_M_V5
B:                             Lesson V5
K:12:_V_MENU
G:_V_S_V5
*:_V_M_V6
B:                             Lesson V6
K:12:_V_MENU
G:_V_S_V6
*:_V_M_V7
B:                             Lesson V7
K:12:_V_MENU
G:_V_S_V7
*:_V_M_V8
B:                             Lesson V8
K:12:_V_MENU
G:_V_S_V8
*:_V_M_V9
B:                             Lesson V9
K:12:_V_MENU
G:_V_S_V9
*:_V_M_V10
B:                            Lesson V10
K:12:_V_MENU
G:_V_S_V10
*:_V_M_V11
B:                            Lesson V11
K:12:_V_MENU
G:_V_S_V11
*:_V_M_V12
B:                            Lesson V12
K:12:_V_MENU
G:_V_S_V12
*:_V_M_V13
B:                            Lesson V13
K:12:_V_MENU
G:_V_S_V13
*:_V_M_V14
B:                            Lesson V14
K:12:_V_MENU
G:_V_S_V14
*:_V_M_V15
B:                            Lesson V15
K:12:_V_MENU
G:_V_S_V15
*:_V_M_V16
B:                            Lesson V16
K:12:_V_MENU
G:_V_S_V16
*:_V_M_V17
B:                            Lesson V17
K:12:_V_MENU
G:_V_S_V17
*:_V_M_V18
B:                            Lesson V18
K:12:_V_MENU
G:_V_S_V18
*:_V_M_V19
B:                            Lesson V19
K:12:_V_MENU
G:_V_S_V19
#------------------------------------------------------------------------------
# Lesson series V menu
#------------------------------------------------------------------------------
*:_V_MENU
*:_V_MENU_PAGE0
B:                 Lesson selection menu - series V [page 1 of 2]
K:1:_V_M_V1
K:2:_V_M_V2
K:3:_V_M_V3
K:4:_V_M_V4
K:5:_V_M_V5
K:6:_V_M_V6
K:7:_V_M_V7
K:8:_V_M_V8
K:9:_V_M_V9
K:10:_V_M_V10
K:11:_V_MENU_PAGE1
K:12:_V_QEXIT
T:The V series contains the following 19 lessons:
 :
 :        Fkey 1 - Lesson V1     R F U J
 :        Fkey 2 - Lesson V2     D K E I
 :        Fkey 3 - Lesson V3     T Y G H
 :        Fkey 4 - Lesson V4     S L W O
 :        Fkey 5 - Lesson V5     A ; Q P
 :        Fkey 6 - Lesson V6     Shift Keys for Capitalization
 :        Fkey 7 - Lesson V7     Shift Lock and :
 :        Fkey 8 - Lesson V8     Introducing the Period
 :        Fkey 9 - Lesson V9     V and M
 :        Fkey10 - Lesson V10    B and N
 :
 :        Fkey11 - Next menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_V_MENU_PAGE0
*:_V_MENU_PAGE1
B:                 Lesson selection menu - series V [page 2 of 2]
K:1:_V_M_V11
K:2:_V_M_V12
K:3:_V_M_V13
K:4:_V_M_V14
K:5:_V_M_V15
K:6:_V_M_V16
K:7:_V_M_V17
K:8:_V_M_V18
K:9:_V_M_V19
K:10:NULL
K:11:_V_MENU_PAGE0
K:12:_V_QEXIT
T:The V series contains the following 19 lessons:
 :
 :        Fkey 1 - Lesson V11    C and Comma
 :        Fkey 2 - Lesson V12    X and .
 :        Fkey 3 - Lesson V13    Z and /
 :        Fkey 4 - Lesson V14    The Question Mark
 :        Fkey 5 - Lesson V15    1, 4, 5, 6, 7
 :        Fkey 6 - Lesson V16    3 and 8
 :        Fkey 7 - Lesson V17    2 and 9
 :        Fkey 8 - Lesson V18    0 and the Hyphen
 :        Fkey 9 - Lesson V19    Practise
 :
 :
 :        Fkey11 - First menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_V_MENU_PAGE1
*:_V_QEXIT
Q: Do you want to leave this lesson series? [Y/N] ? 
N:_V_MENU
G:_V_EXIT
*:_V_EXIT
#------------------------------------------------------------------------------
# End of file v.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_U_SERIES
# Start of file u.typ
#------------------------------------------------------------------------------
# Series U
#------------------------------------------------------------------------------
G:_U_MENU
*:_U_NO_MENU
#------------------------------------------------------------------------------
# Lesson U1
#------------------------------------------------------------------------------
*:U1
*:_U_S_U1
*:_U_R_L0
#                                                               ../orig/u.typ:5
T:			Welcome to lesson U1
 :
 :Still don't know how to touch-type?  Let's start from the beginning and
 :drill you starting with the home row.
Q: Press Y to continue, or Fkey12 to exit 
N:_U_R_L0

#                                                               ../orig/u.typ:6
I:(1) Try this:
*:_U_R_L1
#                                                               ../orig/u.typ:8
O:has half hag gad gash glass sash ash slash shall flash
 :had hall gas gaff gall glad dash ask slag shad ah
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L1

G:_U_E_U1
#------------------------------------------------------------------------------
# Lesson U2
#------------------------------------------------------------------------------
*:U2
*:_U_S_U2

#                                                              ../orig/u.typ:13
I:(1) Familiarize yourself with the top row and between the index fingers:
*:_U_R_L3
#                                                              ../orig/u.typ:15
O:juj kik lol ;p; jyj
 :frf ded sws aqa ftf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L3

#                                                              ../orig/u.typ:16
I:(2) Some words:
*:_U_R_L4
#                                                              ../orig/u.typ:20
O:jug part ye aqua their hearty dry great why whose youth
 :kit free use type last lower drug light wheat proper your
 :lot dear its rear were pretty grip quiet where proud yellow
 :hear sweep old easy writer fresh group equip who please yes
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L4

#                                                              ../orig/u.typ:21
I:(3) Now for the bottom row:
*:_U_R_L5
#                                                              ../orig/u.typ:23
O:jmj k,k l.l ;/; jnj
 :fvf dcd sxs aza fbf
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L5

#                                                              ../orig/u.typ:24
I:(4) Some words:
*:_U_R_L6
#                                                              ../orig/u.typ:28
O:man come body vacant many tax ribbon lining believing
 :name can beam make examine none native baby commission
 :vain sex not cancel even mention woman brick quicken
 :become zero cave lazy benzine opening very branch textile
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L6

G:_U_E_U2
#------------------------------------------------------------------------------
# Lesson U3
#------------------------------------------------------------------------------
*:U3
*:_U_S_U3

#                                                              ../orig/u.typ:32
I:(1)
*:_U_R_L8
#                                                              ../orig/u.typ:33
O:Do you live in Scranton, Pennsylvania?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L8

#                                                              ../orig/u.typ:34
I:(2)
*:_U_R_L9
#                                                              ../orig/u.typ:35
O:Mary Brown and Nancy Smith are in New York City.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L9

#                                                              ../orig/u.typ:36
I:(3)
*:_U_R_L10
#                                                              ../orig/u.typ:37
O:Violet, Helen, Dora, Jennie, and Elsie are staying at the Hotel Commodore.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L10

#                                                              ../orig/u.typ:38
I:(4)
*:_U_R_L11
#                                                              ../orig/u.typ:40
O:I have lived in Los Angeles, San Francisco, Portland, Chicago, St. Louis, and
 :Denver; Robert has lived in Boston, Philadelphia, Jersey City, and Utica.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L11

#                                                              ../orig/u.typ:41
I:(5)
*:_U_R_L12
#                                                              ../orig/u.typ:43
O:j7j k8k l9l ;0; j6j
 :f4f d3d s2s a1a f4f
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L12

#                                                              ../orig/u.typ:44
I:(6)
*:_U_R_L13
#                                                              ../orig/u.typ:46
O:j&j k*k l(l ;); j^j
 :f$f d#d s@s a!a f%f
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L13

#                                                              ../orig/u.typ:47
I:(7)
*:_U_R_L14
#                                                              ../orig/u.typ:52
P:Please send me the book "Facts & Figures."
 :Send us the items (3 dozen coats) right away.
 :The amount of the bill is $17,563.49; the discount is 2% 10 days, net 30 days.
 :The cards should be made up in the following sizes: 4 5/16 x 8 3/16 and
 :3 5/8 x 6 7/8.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L14

#                                                              ../orig/u.typ:53
I:(8)
*:_U_R_L15
#                                                              ../orig/u.typ:55
O:2's 3's 4's 5's
 :#' #2 #3 #4 #5
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L15

G:_U_E_U3
#------------------------------------------------------------------------------
# Lesson U4
#------------------------------------------------------------------------------
*:U4
*:_U_S_U4

#                                                              ../orig/u.typ:59
I:(1)
*:_U_R_L15A
#                                                              ../orig/u.typ:60
O:;'; ;"; ;/; ;?; ;[; ;{; ;-; ;_;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L15A

#                                                              ../orig/u.typ:61
I:(2)
*:_U_R_L17
#                                                              ../orig/u.typ:62
O:The quick brown fox jumps over the lazy dog.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L17

#                                                              ../orig/u.typ:63
I:(3)
*:_U_R_L18
#                                                              ../orig/u.typ:64
O:This is a specimen of the work done on this machine.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L18

#                                                              ../orig/u.typ:65
I:(4)
*:_U_R_L19
#                                                              ../orig/u.typ:66
O:Now is the time for all good men to come to the aid of their party.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L19

#                                                              ../orig/u.typ:67
I:(5)
*:_U_R_L20
#                                                              ../orig/u.typ:69
O:1$ 2$ 3$ 4$ 5$ 6$ 7$ 8$ 9$ 10$
 :2 coats @ $20.00 5 hats @ $4.00
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L20

G:_U_E_U4
#------------------------------------------------------------------------------
# Lesson U5
#------------------------------------------------------------------------------
*:U5
*:_U_S_U5
*:_U_R_L21
#                                                              ../orig/u.typ:74
T:
 :		   (Drill on S Combinations)
Q: Press Y to continue, or Fkey12 to exit 
N:_U_R_L21

#                                                              ../orig/u.typ:75
I:(1)
*:_U_R_L22
#                                                              ../orig/u.typ:76
O:sas ses sis sos sus sc scr sh sk sl sm sn sp spl spr st str sw
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L22

#                                                              ../orig/u.typ:77
I:(2)
*:_U_R_L23
#                                                              ../orig/u.typ:80
O:says sides springs slips snows shops sweets streets
 :sees souls spreads schools smiles shoots swings strikes
 :sues speaks splashes screams skates sheets stones stresses
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L23

#                                                              ../orig/u.typ:81
I:(3)
*:_U_R_L24
#                                                              ../orig/u.typ:86
P:She wishes to show us some samples.
 :The sisters wear the same size dresses.
 :She says she speaks to Sally in school.
 :The shipment was shipped by fast express.
 :Simplicity and sincerity are social assets.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L24

#                                                              ../orig/u.typ:87
I:(4)
*:_U_R_L25
#                                                              ../orig/u.typ:91
P:     Safety first.  This slogan is well known.  Yet many care-
 :less people disregard it and so we have accidents.  It is pos-
 :sible to avoid many types of accidents by a little forethought.
 :Don't be careless.  Do your share to avoid mishaps.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L25

G:_U_E_U5
#------------------------------------------------------------------------------
# Lesson U6
#------------------------------------------------------------------------------
*:U6
*:_U_S_U6
*:_U_R_L26
#                                                              ../orig/u.typ:96
T:
 :		(Drill on R Combinations)
Q: Press Y to continue, or Fkey12 to exit 
N:_U_R_L26

#                                                              ../orig/u.typ:97
I:(1)
*:_U_R_L27
#                                                              ../orig/u.typ:98
O:rar rer rir ror rur br cr dr fr gr pr shr tr thr
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L27

#                                                              ../orig/u.typ:99
I:(2)
*:_U_R_L28
#                                                             ../orig/u.typ:102
O:rare rural proper trader drier freer cracker
 :rear broker prefer trapper dresser fresher grammar
 :roar brewer prepare thrower shrewder creamer greater
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L28

#                                                             ../orig/u.typ:103
I:(3)
*:_U_R_L29
#                                                             ../orig/u.typ:108
P:Every promise made should be observed.
 :The price of the property is really $2,500.
 :Try to remember to bring your grammar with you.
 :Proof of your brokerage experience will be required.
 :The orange grower must have favorable weather conditions.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L29

#                                                             ../orig/u.typ:109
I:(4)
*:_U_R_L30
#                                                             ../orig/u.typ:114
P:     Some people break promises as readily as they make them.
 :As a result, they acquire a reputation for unreliability.  It
 :is particularly important to be reliable in the business world.
 :A person or firm that comes to be regarded as unreliable has a
 :poor chance of success.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L30

G:_U_E_U6
#------------------------------------------------------------------------------
# Lesson U7
#------------------------------------------------------------------------------
*:U7
*:_U_S_U7
*:_U_R_L31
#                                                             ../orig/u.typ:119
T:
 :		(Drill on L Combinations)
Q: Press Y to continue, or Fkey12 to exit 
N:_U_R_L31

#                                                             ../orig/u.typ:120
I:(1)
*:_U_R_L32
#                                                             ../orig/u.typ:121
O:lal lel lil lol lul ly bl cl fl gl pl sl
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L32

#                                                             ../orig/u.typ:122
I:(2)
*:_U_R_L33
#                                                             ../orig/u.typ:125
O:loll play blow clear glass flesh slow fully
 :lisle plow blue class globe fleet sleep silly
 :label please blood claim gleam flail slight really
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L33

#                                                             ../orig/u.typ:126
I:(3)
*:_U_R_L34
#                                                             ../orig/u.typ:131
P:The mill will close in April.
 :It is clear to all who will listen.
 :The clerk sells cloth of fine value.
 :You will rely on them to supply you.
 :He held the floor until a relatively late hour.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L34

#                                                             ../orig/u.typ:132
I:(4)
*:_U_R_L35
#                                                             ../orig/u.typ:138
P:     Play is most important to a child.  All of us must play
 :a little.  All work and no play makes Jack a dull boy, the
 :old saying goes.  Play affords relaxation.  Some people claim
 :their work is so enthralling that they do not need to play.
 :Psychologists say that the stress of modern life demands that
 :all adults have some hobby away from their daily pursuit.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L35

G:_U_E_U7
#------------------------------------------------------------------------------
# Lesson U8
#------------------------------------------------------------------------------
*:U8
*:_U_S_U8
*:_U_R_L36
#                                                             ../orig/u.typ:143
T:
 :		(Drill on D-T Combinations)
Q: Press Y to continue, or Fkey12 to exit 
N:_U_R_L36

#                                                             ../orig/u.typ:144
I:(1)
*:_U_R_L37
#                                                             ../orig/u.typ:146
O:dad ded did dod dud dr ld nd rd
 :tat tet tit tot tut th tr ct ft lt nt pt st
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L37

#                                                             ../orig/u.typ:147
I:(2)
*:_U_R_L38
#                                                             ../orig/u.typ:151
O:did bend tot total that last rented mended
 :deed lend toot tutor this kept melted handed
 :dude bold tight taught them chest drafted founded
 :dodo board trait treats there first directed doubted
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L38

#                                                             ../orig/u.typ:152
I:(3)
*:_U_R_L39
#                                                             ../orig/u.typ:157
P:The first shall be last.
 :Credit the cost to the estate.
 :Record your thoughts from time to time.
 :An effort should be made to settle the estate.
 :Rest assured you will succeed if you try hard.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L39

#                                                             ../orig/u.typ:158
I:(4)
*:_U_R_L40
#                                                             ../orig/u.typ:164
O:     To learn to typewrite is not difficult.  The keyboard
 :of the typewriter may be mastered in a few hours, but to
 :get speed in typewriting calls for a good deal of practice.
 :One of the best methods of getting up speed is to write a
 :selection over and over again until it can be written easily
 :and accurately.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L40

G:_U_E_U8
#------------------------------------------------------------------------------
# Lesson U9
#------------------------------------------------------------------------------
*:U9
*:_U_S_U9
*:_U_R_L41
#                                                             ../orig/u.typ:169
T:
 :		(Drill on M-N Combinations)
Q: Press Y to continue, or Fkey12 to exit 
N:_U_R_L41

#                                                             ../orig/u.typ:170
I:(1)
*:_U_R_L42
#                                                             ../orig/u.typ:172
O:am em im om um mb mp ment
 :an en in on un ng nk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L42

#                                                             ../orig/u.typ:173
I:(2)
*:_U_R_L43
#                                                             ../orig/u.typ:178
O:amount damper only singing payment moment
 :emblem camper enter ringing enrollment judgment
 :immense hamper under longing engagement excitement
 :omnibus lumber income banking appointment settlement
 :umbrella bomber answer thinking entertainment employment
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L43

#                                                             ../orig/u.typ:179
I:(3)
*:_U_R_L44
#                                                             ../orig/u.typ:184
P:We are informed that an increase in anticipated.
 :Please inform us if you are interested in an engine.
 :Banks will extend financial aid to the business man.
 :Unless your invoice is paid, no shipment can be made.
 :The amount of your investment in common stocks is $800.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L44

#                                                             ../orig/u.typ:185
I:(8)
*:_U_R_L45
#                                                             ../orig/u.typ:190
P:     The employer must consider any increase in cost that
 :enters into the manufacture of his product.  Unless he includes
 :such cost in his selling price, he is unlikely to show a profit.
 :The installation of a cost system that enables the employer
 :to break down his costs to a unit basis is a prime necessity.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L45

G:_U_E_U9
#------------------------------------------------------------------------------
# Lesson U10
#------------------------------------------------------------------------------
*:U10
*:_U_S_U10
*:_U_R_L46
#                                                             ../orig/u.typ:195
T:
 :		(Drill on com-con Combinations)
Q: Press Y to continue, or Fkey12 to exit 
N:_U_R_L46

#                                                             ../orig/u.typ:196
I:(1)
*:_U_R_L47
#                                                             ../orig/u.typ:198
O:com recom decom discom incom uncom
 :con recon decon discon incon uncon
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L47

#                                                             ../orig/u.typ:199
I:(2)
*:_U_R_L48
#                                                             ../orig/u.typ:204
O:common commit decompose conduct consign incomplete
 :comply comment discomfort connect confuse unconvinced
 :combine compose disconnect consist contrast uncontrolled
 :commerce compare discontinue control contrary incomparable
 :commence complete inconvenient contract convince uncomfortable
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L48

#                                                             ../orig/u.typ:205
I:(3)
*:_U_R_L49
#                                                             ../orig/u.typ:210
P:The lawyer consulted the complainant.
 :Please continue to comply with all recommendations.
 :Their income is derived from common stock commitments.
 :The concern communicated its conclusions convincingly.
 :Under the circumstances, the company will command control.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L49

#                                                             ../orig/u.typ:211
I:(4)
*:_U_R_L50
#                                                             ../orig/u.typ:216
P:     Character shows itself in a man's conduct.  Deeds speak
 :louder than words.  Words sometimes confuse as issue where
 :deeds clarify it.  The test of a man's sincerity is not what
 :he says but what he does.  Consider this well and you will
 :never be confused in estimating a man's worth.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L50

G:_U_E_U10
#------------------------------------------------------------------------------
# Lesson U11
#------------------------------------------------------------------------------
*:U11
*:_U_S_U11
*:_U_R_L51
#                                                             ../orig/u.typ:221
T:
 :		(Drill on sion-tion Combinations)
Q: Press Y to continue, or Fkey12 to exit 
N:_U_R_L51

#                                                             ../orig/u.typ:222
I:(1)
*:_U_R_L52
#                                                             ../orig/u.typ:224
O:asion esion ision osion usion
 :ation etion ition otion ution
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L52

#                                                             ../orig/u.typ:225
I:(2)
*:_U_R_L53
#                                                             ../orig/u.typ:229
O:action motion quotation session caution ambition
 :nation ration invention division exhibition attention
 :portion station intention possession connection situation
 :location creation condition impression completion commission
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L53

#                                                             ../orig/u.typ:230
I:(3)
*:_U_R_L54
#                                                             ../orig/u.typ:235
P:Information on the invention has been sent you.
 :The cancellation of the exhibition was announced.
 :Your communication of February 16 has been received.
 :Students are taught addition, subtraction, and division.
 :Your attention is called to the action of the Commission.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L54

#                                                             ../orig/u.typ:236
I:(4)
*:_U_R_L55
#                                                             ../orig/u.typ:241
P:     Concentration is a valuable faculty.  The ability to direct
 :one's attention exclusively along certain lines accounts for
 :the success of some people.  Diffusion of effort is considered
 :an enemy of success.  We are told that this is an age of
 :specialization, and specialization demands concentration.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L55

G:_U_E_U11
#------------------------------------------------------------------------------
# Lesson U12
#------------------------------------------------------------------------------
*:U12
*:_U_S_U12
*:_U_R_L56
#                                                             ../orig/u.typ:246
T:
 :	(Drill on ter, ther, tor, ture, ster, der Combinations)
Q: Press Y to continue, or Fkey12 to exit 
N:_U_R_L56

#                                                             ../orig/u.typ:247
I:(1)
*:_U_R_L57
#                                                             ../orig/u.typ:250
O:ater oter etor utor ider ather other eture uture ister
 :eter uter itor ader oder ether uther iture aster oster
 :iter ator otor eder uder ither ature oture ester uster
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L57

#                                                             ../orig/u.typ:251
I:(2)
*:_U_R_L58
#                                                             ../orig/u.typ:255
O:water later actor order father future faster
 :alter matter motor wider mother nature poster
 :voter better factor reader rather feature master
 :writer letter doctor modern either fixture register
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L58

#                                                             ../orig/u.typ:256
I:(3)
*:_U_R_L59
#                                                             ../orig/u.typ:261
P:The voter was required to register.
 :The reader made a study of the literature.
 :The actor was better in the theatre than in pictures.
 :The writer wrote a letter to his future sister-in-law.
 :The minister received a letter from his father and mother.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L59

#                                                             ../orig/u.typ:262
I:(4)
*:_U_R_L60
#                                                             ../orig/u.typ:267
P:     The best letter writers express themselves simply.  They
 :avoid long words where shorter words will do.  They have some-
 :thing to say and they say it interestingly and to the point.
 :A business letter should not be a literary masterpiece, but
 :that is not to say that it should not have style.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L60

G:_U_E_U12
#------------------------------------------------------------------------------
# Lesson U13
#------------------------------------------------------------------------------
*:U13
*:_U_S_U13
*:_U_R_L61
#                                                             ../orig/u.typ:274
T:
 :	(Drill on qu, ch, wh, dw, sw, tw Combinations)
 :	(Drill on de, des, dis, ex, self, tran)
 :	(Drill on cial, cious, ology, ship, tive)
Q: Press Y to continue, or Fkey12 to exit 
N:_U_R_L61

#                                                             ../orig/u.typ:275
I:(1)
*:_U_R_L62
#                                                             ../orig/u.typ:279
O:quick each white sweet dwell exist desire transfer
 :quest touch where swell dwarf expose desert transact
 :quiet cheap whole twist expect degree dislike transmit
 :queen child wheat twenty express deprive dismiss translate
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L62

#                                                             ../orig/u.typ:280
I:(2)
*:_U_R_L63
#                                                             ../orig/u.typ:283
O:special gracious active biology worship self-regard
 :official conscious native geology hardship self-respect
 :financial delicious positive pathology steamship self-defense
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L63

#                                                             ../orig/u.typ:284
I:(3)
*:_U_R_L64
#                                                             ../orig/u.typ:289
P:The squadron marched quickly and quietly.
 :When will the twenty cars of wheat go forward?
 :The study of psychology is a "must" in college.
 :We desire to dispose of our financial interests.
 :A selfish person has his own self-interest at heart.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L64

#                                                             ../orig/u.typ:290
I:(4)
*:_U_R_L65
#                                                             ../orig/u.typ:305
P:Raymond Investment Co.
 :120 Wall Street
 :Ney York, NY 10005
 :
 :Gentlemen:
 :
 :     For many years our medium has been the leading adver-
 :tising paper used by responsible investment firms who desire
 :to obtain new accounts.
 :
 :     Our records show that you are not now making use of the
 :Adviser, and we ask that you consider its use in connection
 :with your new promotion effort.
 :
 :Yours truly,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L65

#                                                             ../orig/u.typ:306
I:(5)
*:_U_R_L66
#                                                             ../orig/u.typ:323
P:Mr. Z. Dexter
 :250 Madison Avenue
 :New York, NY 10016
 :
 :Dear Mr. Dexter:
 :
 :I am enclosing herewith the annual report of our corporation
 :for the year just ended; also table showing Profit and Loss
 :Account for the past ten years.
 :
 :I am placing your name on our mailing list for all future
 :reports sent out by the company, and if at any time you have
 :any questions regarding the report or the company, if you
 :will advise me, I shall be happy to give you any additional
 :information that I may have.
 :
 :Very truly yours,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L66

#                                                             ../orig/u.typ:325
I:(6)
*:_U_R_L67
#                                                             ../orig/u.typ:337
P:Strive for typing accuracy.  Speed without accuracy is of little value.
 :Rhythm is the secret of typing skill.  Don't write one part of a word
 :faster than another.  Slow down so that you can maintain a regular rhythm.
 :
 :Think of the letters before you strike them.  Strike the keys evenly, so
 :that the printing impression does not vary.  At the same time, try to
 :develop your stroking speed and make it a habit to release the keys quickly.
 :To get up speed, type each exercise three or four times.
 :
 :To do your best, it is necessary that you be relaxed.  You may be trying so
 :hard that you are all tied up in knots.  Relax consciously.  If you have a
 :feeling of tenseness and hurry, you are not properly relaxed.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_U_R_L67

G:_U_E_U13
#------------------------------------------------------------------------------
# Lesson series U jump tables
#------------------------------------------------------------------------------
*:_U_E_U1
Q: Do you want to continue to lesson U2 [Y/N] ? 
N:_U_MENU
G:_U_M_U2
*:_U_E_U2
Q: Do you want to continue to lesson U3 [Y/N] ? 
N:_U_MENU
G:_U_M_U3
*:_U_E_U3
Q: Do you want to continue to lesson U4 [Y/N] ? 
N:_U_MENU
G:_U_M_U4
*:_U_E_U4
Q: Do you want to continue to lesson U5 [Y/N] ? 
N:_U_MENU
G:_U_M_U5
*:_U_E_U5
Q: Do you want to continue to lesson U6 [Y/N] ? 
N:_U_MENU
G:_U_M_U6
*:_U_E_U6
Q: Do you want to continue to lesson U7 [Y/N] ? 
N:_U_MENU
G:_U_M_U7
*:_U_E_U7
Q: Do you want to continue to lesson U8 [Y/N] ? 
N:_U_MENU
G:_U_M_U8
*:_U_E_U8
Q: Do you want to continue to lesson U9 [Y/N] ? 
N:_U_MENU
G:_U_M_U9
*:_U_E_U9
Q: Do you want to continue to lesson U10 [Y/N] ? 
N:_U_MENU
G:_U_M_U10
*:_U_E_U10
Q: Do you want to continue to lesson U11 [Y/N] ? 
N:_U_MENU
G:_U_M_U11
*:_U_E_U11
Q: Do you want to continue to lesson U12 [Y/N] ? 
N:_U_MENU
G:_U_M_U12
*:_U_E_U12
Q: Do you want to continue to lesson U13 [Y/N] ? 
N:_U_MENU
G:_U_M_U13
*:_U_E_U13
G:_U_MENU

*:_U_M_U1
B:                             Lesson U1
K:12:_U_MENU
G:_U_S_U1
*:_U_M_U2
B:                             Lesson U2
K:12:_U_MENU
G:_U_S_U2
*:_U_M_U3
B:                             Lesson U3
K:12:_U_MENU
G:_U_S_U3
*:_U_M_U4
B:                             Lesson U4
K:12:_U_MENU
G:_U_S_U4
*:_U_M_U5
B:                             Lesson U5
K:12:_U_MENU
G:_U_S_U5
*:_U_M_U6
B:                             Lesson U6
K:12:_U_MENU
G:_U_S_U6
*:_U_M_U7
B:                             Lesson U7
K:12:_U_MENU
G:_U_S_U7
*:_U_M_U8
B:                             Lesson U8
K:12:_U_MENU
G:_U_S_U8
*:_U_M_U9
B:                             Lesson U9
K:12:_U_MENU
G:_U_S_U9
*:_U_M_U10
B:                            Lesson U10
K:12:_U_MENU
G:_U_S_U10
*:_U_M_U11
B:                            Lesson U11
K:12:_U_MENU
G:_U_S_U11
*:_U_M_U12
B:                            Lesson U12
K:12:_U_MENU
G:_U_S_U12
*:_U_M_U13
B:                            Lesson U13
K:12:_U_MENU
G:_U_S_U13
#------------------------------------------------------------------------------
# Lesson series U menu
#------------------------------------------------------------------------------
*:_U_MENU
*:_U_MENU_PAGE0
B:                 Lesson selection menu - series U [page 1 of 2]
K:1:_U_M_U1
K:2:_U_M_U2
K:3:_U_M_U3
K:4:_U_M_U4
K:5:_U_M_U5
K:6:_U_M_U6
K:7:_U_M_U7
K:8:_U_M_U8
K:9:_U_M_U9
K:10:_U_M_U10
K:11:_U_MENU_PAGE1
K:12:_U_QEXIT
T:The U series contains the following 13 lessons:
 :
 :        Fkey 1 - Lesson U1     Home row
 :        Fkey 2 - Lesson U2     Other letters
 :        Fkey 3 - Lesson U3     Shift numerals figs
 :        Fkey 4 - Lesson U4     Practise
 :        Fkey 5 - Lesson U5     Drill on S Combinations
 :        Fkey 6 - Lesson U6     Drill on R Combinations
 :        Fkey 7 - Lesson U7     Drill on L Combinations
 :        Fkey 8 - Lesson U8     Drill on D-T Combinations
 :        Fkey 9 - Lesson U9     Drill on M-N Combinations
 :        Fkey10 - Lesson U10    Drill on com-con Combinations
 :
 :        Fkey11 - Next menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_U_MENU_PAGE0
*:_U_MENU_PAGE1
B:                 Lesson selection menu - series U [page 2 of 2]
K:1:_U_M_U11
K:2:_U_M_U12
K:3:_U_M_U13
K:4:NULL
K:5:NULL
K:6:NULL
K:7:NULL
K:8:NULL
K:9:NULL
K:10:NULL
K:11:_U_MENU_PAGE0
K:12:_U_QEXIT
T:The U series contains the following 13 lessons:
 :
 :        Fkey 1 - Lesson U11    Drill on sion-tion Combinations
 :        Fkey 2 - Lesson U12    Drill on ter, ther, tor, ture, ster, der
 :        Fkey 3 - Lesson U13    Drill on qu, ch, wh, dw, sw, tw, de, des,
 :                                 dis, ex, self, tran, cial, cious,
 :                                 ology, ship, tive
 :
 :
 :
 :
 :
 :
 :        Fkey11 - First menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_U_MENU_PAGE1
*:_U_QEXIT
Q: Do you want to leave this lesson series? [Y/N] ? 
N:_U_MENU
G:_U_EXIT
*:_U_EXIT
#------------------------------------------------------------------------------
# End of file u.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_D_SERIES
# Start of file d.typ
#------------------------------------------------------------------------------
# Series D
#------------------------------------------------------------------------------
G:_D_MENU
*:_D_NO_MENU
#------------------------------------------------------------------------------
# Lesson D1
#------------------------------------------------------------------------------
*:D1
*:_D_S_D1
*:_D_R_L0
#                                                              ../orig/d.typ:20
T:			Welcome to the Dvorak Course
 :
 :This course has been planned for beginners as well as experienced typists.
 :If you are a beginner learning to type on the American Simplified Keyboard
 :(the Dvorak keyboard), you will find this keyboard easier to learn than
 :the QWERTY (Sholes) keyboard.
 :
 :This is because the ASK has been scientifically designed to minimize cumulative
 :finger motion while typing English.  The ten letters on the Home Row
 :(A, O, E, U, I, D, H, T, N, and S) make up about 70% of all keystrokes.
 :These ten letters alone can form over 3000 words.  Needless to say, having
 :these keys in the home row facilitates both speed and accuracy.
 :
 :If you are already an experienced typist on the Sholes keyboard, don't despair:
 :you won't have to unlearn everything you know.  Your basic typing dexterity
 :remains with you, regardless of the keyboard layout.  Learning the Dvorak
 :keyboard is like learning to "play on a new surface", as a tennis player must
 :learn to adjust to grass court or hard court when she has been accustomed to
 :playing on a clay court.
Q: Press Y to continue, or Fkey12 to exit 
N:_D_R_L0

*:_D_R_L1
#                                                              ../orig/d.typ:25
T:			General Instructions
 :
 :The fingers of the left hand should be placed over the A-key, the O-key,
 :the E-key, and the U-key.  Similarly, the fingers of the right hand should be
 :placed over the H-key, the T-key, the N-key, and the S-key.
Q: Press Y to continue, or Fkey12 to exit 
N:_D_R_L1

#                                                              ../orig/d.typ:26
I:(1) Home Row Exercises
*:_D_R_L2
#                                                              ../orig/d.typ:28
O:aoeu ueoa aoeui snth htns snthd uihd uihd
 :asonetuhid asonetuhid dihutenosa dihutenosa
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L2

#                                                              ../orig/d.typ:29
I:(2)
*:_D_R_L3
#                                                              ../orig/d.typ:30
O:a s o n e t u h i d  a s o n e t u h i d
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L3

#                                                              ../orig/d.typ:31
I:(3)
*:_D_R_L4
#                                                              ../orig/d.typ:32
O:d i h u t e n o s a  d i h u t e n o s a
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L4

#                                                              ../orig/d.typ:33
I:(4)
*:_D_R_L5
#                                                              ../orig/d.typ:35
O:as an at ah ad aa ao ae au ai os on ot oh od oi ou oe oo oa
 :es en et eh ed ea eo ee eu ei us un ut uh ud ui uu ue uo ua
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L5

#                                                              ../orig/d.typ:36
I:(5)
*:_D_R_L6
#                                                              ../orig/d.typ:38
O:his hat is an aid in the hot sun
 :in his sad sod hut he sat on his hen
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L6

#                                                              ../orig/d.typ:39
I:(6)
*:_D_R_L7
#                                                              ../orig/d.typ:41
O:sue did not use his hoe and tin hat
 :dan did not see the dot on his tie as he hid his tan hat
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L7

#                                                              ../orig/d.typ:42
I:(7)
*:_D_R_L8
#                                                              ../orig/d.typ:46
O:ada add ado aha aid ann dad dan dee den did die din don dot dud
 :due dun duo eda end had has hat hen hid his hit hod hoe hot hue
 :hut ian ida inn ion its nat ned net nod not nun nut odd ode out
 :sat sit sod son sot sun tan tat tee ten tho tit toe ton too tot
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L8

#                                                              ../orig/d.typ:47
I:(8)
*:_D_R_L9
#                                                              ../orig/d.typ:48
O:i do as i do and the end is not as sad as the one sid had
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L9

G:_D_E_D1
#------------------------------------------------------------------------------
# Lesson D2
#------------------------------------------------------------------------------
*:D2
*:_D_S_D2
*:_D_R_L10
#                                                              ../orig/d.typ:55
T:                    Learning the Shift Key
 :
 :To integrate the shift key rhythmically in your practice, a capital letter
 :should take three beats: 1--press the shift key opposite the hand to press
 :the letter; 2--press the letter; 3--release the shift key.
Q: Press Y to continue, or Fkey12 to exit 
N:_D_R_L10

#                                                              ../orig/d.typ:56
I:(1) Review
*:_D_R_L11
#                                                              ../orig/d.typ:57
O:een ent est ett hin hou ith ion oth sen tha thi tio tte thu
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L11

#                                                              ../orig/d.typ:58
I:(2)
*:_D_R_L12
#                                                              ../orig/d.typ:60
O:Ada An Ana Ann Dad Dan Dee Ed Eta
 :Dan Nan Nat Ned Sid Sue Tad Ted Tod
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L12

#                                                              ../orig/d.typ:61
I:(3)
*:_D_R_L13
#                                                              ../orig/d.typ:63
O:The sad tots sat on a tan seat in his neat tent and ate ten nuts
 :On his date Otis had a thin suit and no tint on his shoes
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L13

#                                                              ../orig/d.typ:64
I:(4)
*:_D_R_L14
#                                                              ../orig/d.typ:66
O:Enos eats a thin hash diet in a hued dish as he sits on an odd seat
 :Dad does not eat suet   He had seen Sue dent his auto
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L14

#                                                              ../orig/d.typ:67
I:(5)
*:_D_R_L15
#                                                              ../orig/d.typ:70
O:ad an de di ed en es ie in ne un ate dis ess eat ied ine
 :ist ite nee nes non nus ses tes tis usi ante anti ates
 :eous eats ines ions ious ists itas itis ness sion tion
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L15

#                                                              ../orig/d.typ:71
I:(6)
*:_D_R_L16
#                                                              ../orig/d.typ:73
O:Adna Anna Anne Dana Dead Edie Edna Enid Etta Heda
 :Nate Nina Neta Nona Odie Ohio Otto Stan Tess Thad Theo
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L16

#                                                              ../orig/d.typ:74
I:(7)
*:_D_R_L17
#                                                              ../orig/d.typ:79
O:adds aids ante ants aunt dead deed dens died dies dine dins dodo
 :heed hens hied hind hint hiss hist hits hods hoed hoes hone hood
 :none noon noun nuns oats odds odes ones sane sash sate seas seed
 :sees sent sets shad shed shin shot side sine sins sons sued suns
 :tide tine tins toad tone toss tote tout tune undo unit used uses
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L17

G:_D_E_D2
#------------------------------------------------------------------------------
# Lesson D3
#------------------------------------------------------------------------------
*:D3
*:_D_S_D3
#                                                              ../orig/d.typ:89
T:                    Home Row and the Period
 :
 :The period is above the E-finger.  Note that the end of a sentence is
 :always followed by two spaces; in abbreviations, it is followed by one
 :space.
Q: Press Y to continue, or Fkey12 to exit 
#
I:(1)
*:_D_R_L18
#                                                              ../orig/d.typ:91
O:e.  e.  e.  e.  a.  s.  o.  n.  e.  t.  u.  h.  i.  d.  a.  a.
 :h.  u.  a.  i.  o.  n.  s.  d.  t.  e.  h.  o.  u.  i.  s.  a.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L18

#                                                              ../orig/d.typ:92
I:(2)
*:_D_R_L19
#                                                              ../orig/d.typ:96
O:anno athe atio atte ause diti enon esen enti este
 :ethe esti ette hese hous hout iate iend ines inst
 :ith itio into ndin ness nnot noth ntio onth osed
 :thei thes tion tten nest nude unti usin tand tate
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L19

#                                                              ../orig/d.typ:97
I:(3)
*:_D_R_L20
#                                                             ../orig/d.typ:100
O:Adana Andie Annie Aonia Audie Denis Diana Dinah
 :Donna Duane Edith Ethan India Susan Susie Thane
 :Adana.  Andie.  Annie.  Aonia.  Audie.  Denis.  Diana.  Dinah.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L20

#                                                             ../orig/d.typ:101
I:(4)
*:_D_R_L21
#                                                             ../orig/d.typ:105
O:In the house Adana dined in haste on toast and dates.
 :Sated as she had eaten she noted the sheen on the dunes
 :asd the shade in the sheds.  She hates to see an idiot
 :stand and shoot his tenth doe in the dense heath.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L21

#                                                             ../orig/d.typ:106
I:(5)
*:_D_R_L22
#                                                             ../orig/d.typ:108
O:An onion heats and stuns stout noses and sends hands
 :to douse teeth and hoist suede hoods onto heads.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L22

#                                                             ../orig/d.typ:109
I:(6)
*:_D_R_L23
#                                                             ../orig/d.typ:111
O:eates eousness eousnesses esses iates iests iness inesses
 :iousness iousnesses iohness iohnesses itions nesses ousness
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L23

G:_D_E_D3
#------------------------------------------------------------------------------
# Lesson D4
#------------------------------------------------------------------------------
*:D4
*:_D_S_D4
*:_D_R_L24
#                                                             ../orig/d.typ:116
T:                    Upper Row and Essential Punctuation
Q: Press Y to continue, or Fkey12 to exit 
N:_D_R_L24

#                                                             ../orig/d.typ:117
I:(1)
*:_D_R_L25
#                                                             ../orig/d.typ:119
O:tctc upup hghg o,o, nrnr a/a/ slsl a?a? s-s- s--- s---- ----
 :tctc upup hghg, hfhf uyuy, nrnr, slsl, s---, s-s-, a/a/-
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L25

#                                                             ../orig/d.typ:120
I:(2)
*:_D_R_L26
#                                                             ../orig/d.typ:122
O:tctc/ upup/ hghg/ uyuy/ hfhf/ nrnr/ slsl/ tctc/ hfhf/ hghg/
 :tctc? upup? hghg? uyuy? nrnr? slsl? hfhf? upup- hghg- tctc-
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L26

#                                                             ../orig/d.typ:123
I:(3)
*:_D_R_L27
#                                                             ../orig/d.typ:125
O:Al el if of or up Al el if of or up
 :go la lo pa pi ye go la lo pa pi ye
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L27

#                                                             ../orig/d.typ:126
I:(4)
*:_D_R_L28
#                                                             ../orig/d.typ:130
O:Can pa go aft and lie on our old cot?
 :The shy ape put on a red hat and ran off the lot.
 :For a top fee, her act is to hop in, lie on the rug, pat her
 :pet cat, fit a fur on her ear, get her fan, and run off.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L28

#                                                             ../orig/d.typ:131
I:(5)
*:_D_R_L29
#                                                             ../orig/d.typ:134
O:ago ail ale all apt arc are art cur cut dig dip dop
 :dry dug eel egg ego fag fig fin fir fly fog for fro
 :fry gag gap gas gay gin gip God goo gun hag hay hep
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L29

G:_D_E_D4
#------------------------------------------------------------------------------
# Lesson D5
#------------------------------------------------------------------------------
*:D5
*:_D_S_D5
#                                                             ../orig/d.typ:138
I:(1) Review
*:_D_R_L30
#                                                             ../orig/d.typ:140
O:The left road can lead the lads and lady to good lots near
 :your land.  The sale of pure gold is held at your door.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L30

#                                                             ../orig/d.typ:141
I:(2)
*:_D_R_L31
#                                                             ../orig/d.typ:144
O:You held no fear of loss for a year.  On each trip to your
 :shop he paid in cash for the caps, fish, cups, pans, fuel,
 :logs, peas, ales, rice and fats you sold.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L31

#                                                             ../orig/d.typ:145
I:(3)
*:_D_R_L32
#                                                             ../orig/d.typ:147
O:It is a fact that a slap on the face can hurt.  The poor
 :apes feel free to find a sure sort of life in the dale.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L32

#                                                             ../orig/d.typ:148
I:(4)
*:_D_R_L33
#                                                             ../orig/d.typ:152
O:aces acts ages ails airs also arcs call caps card cold cops
 :else errs eyes face fair fall fare fate feat feel feet fell
 :gate gets gift gigs glad goat goes gone gosh gray grey gull
 :hole hope hops huff hull ills ires last late lest lets lies
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L33

#                                                             ../orig/d.typ:153
I:(5)
*:_D_R_L34
#                                                             ../orig/d.typ:157
O:pear pert pest pets pits plop pops post pots puns puts rate real
 :ride rids ripe rips rope rote rues ruff runs runt rush rust ruts
 :span spat spin spit spot spun step stop tags tall tape taps tars
 :ugly upon ruge user yard year yeas yell yelp yips yoga yule your
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L34

G:_D_E_D5
#------------------------------------------------------------------------------
# Lesson D6
#------------------------------------------------------------------------------
*:D6
*:_D_S_D6
*:_D_R_L35
#                                                             ../orig/d.typ:162
T:		Learning the Lower Row
Q: Press Y to continue, or Fkey12 to exit 
N:_D_R_L35

#                                                             ../orig/d.typ:163
I:(1)
*:_D_R_L36
#                                                             ../orig/d.typ:164
O:a'sz oqnv ukhm uxhb a"o- oqnv ejtw a'sz uxhb ukkk ukhm a's-
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L36

#                                                             ../orig/d.typ:165
I:(2)
*:_D_R_L37
#                                                             ../orig/d.typ:166
O:uk sz-a' tw nv ej hm uk a" hb oq uk a' nv hm a" oq sz tw ej
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L37

#                                                             ../orig/d.typ:167
I:(3)
*:_D_R_L38
#                                                             ../orig/d.typ:170
O:ale any are ary augh aught ave ay aye ec ece eco el er ere ery ex
 :exa exe far fer fir for ify igh ight il ile ill ily ire aze ize
 :la lly ly my ny ome or ore ough ought ould our re rec sive tive
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L38

#                                                             ../orig/d.typ:171
I:(4)
*:_D_R_L39
#                                                             ../orig/d.typ:174
O:I owe him a bun, a ham, ink, a bed and a job.
 :Sam was mad at his own new ox in the bin.
 :At the zoo, the wee, bad boa in a box bit Tom, Bob and me.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L39

#                                                             ../orig/d.typ:175
I:(5)
*:_D_R_L40
#                                                             ../orig/d.typ:179
O:am ax be ma me ox oz we adz awe ban but eke eve haw hem
 :hub jab jam jaw jet jib job Joe jot jut kid kin kit man
 :mat Max nab new nub now own quo saw sox sum van vex vie
 :vow wan who win won yen you zax
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L40

G:_D_E_D6
#------------------------------------------------------------------------------
# Lesson D7
#------------------------------------------------------------------------------
*:D7
*:_D_S_D7
#                                                             ../orig/d.typ:183
I:(1)
*:_D_R_L41
#                                                             ../orig/d.typ:184
O:In a daze the band hums the same new tune as they zoom down the exit.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L41

#                                                             ../orig/d.typ:185
I:(2)
*:_D_R_L42
#                                                             ../orig/d.typ:187
O:Next time, I must have a town home, with a book and a vast tome,
 :bees, oxen, hams in the oven, rows of beans, the wind and a view.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L42

#                                                             ../orig/d.typ:188
I:(3)
*:_D_R_L43
#                                                             ../orig/d.typ:190
O:I know six men wait to put down their axes.  They want to quit
 :their jobs when the job zone size is too wide.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L43

#                                                             ../orig/d.typ:191
I:(4)
*:_D_R_L44
#                                                             ../orig/d.typ:194
O:ahem aims ajax akin asks atom axis bans bath beak beck been
 :hoax husk inks item jabs jade jamb Java jazz Jean jest jinx
 :knot Knox made maid mail mate mean meet mend mess mind mine
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L44

#                                                             ../orig/d.typ:195
I:(5)
*:_D_R_L45
#                                                             ../orig/d.typ:199
O:miss mist most musk must nabs news next nibs numb owed owes
 :quiz save saws seem sews skat skew skid skin some sums take
 :vend vent vest veto vise void vote wand weed week wend wins
 :whet whit whiz whom wish wont zebu zest zinc Zion zone zulu
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L45

G:_D_E_D7
#------------------------------------------------------------------------------
# Lesson D8
#------------------------------------------------------------------------------
*:D8
*:_D_S_D8
#                                                             ../orig/d.typ:203
I:(1)
*:_D_R_L46
#                                                             ../orig/d.typ:204
O:He asked about those zebra waits in his beans.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L46

#                                                             ../orig/d.typ:205
I:(2)
*:_D_R_L47
#                                                             ../orig/d.typ:206
O:It seems that in a month taxes on homes have taken all we saved.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L47

#                                                             ../orig/d.typ:207
I:(3)
*:_D_R_L48
#                                                             ../orig/d.typ:209
O:John Smith makes a quiet visit to the bases in the winds and
 :weeds on the mound.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L48

#                                                             ../orig/d.typ:210
I:(4)
*:_D_R_L49
#                                                             ../orig/d.typ:214
O:ovals ovoid oxide quake queen quest quite quits quote saves seams
 :skein skink skunk sweat takes taken taxed teams teems thank think
 :thumb times towns ukase vaunt vests vises visit vista vivid vixen
 :waits wands wants wends whine white whose zebus zoned zones zulus
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L49

G:_D_E_D8
#------------------------------------------------------------------------------
# Lesson D9
#------------------------------------------------------------------------------
*:D9
*:_D_S_D9
#                                                             ../orig/d.typ:218
I:(1)
*:_D_R_L50
#                                                             ../orig/d.typ:219
O:hghm hbfb upxp uxyx twcw ej.j nvrv oq,q szlz a'?' a"/"
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L50

#                                                             ../orig/d.typ:220
I:Again...
*:_D_R_L51
#                                                             ../orig/d.typ:221
O:hghm hbfb upxp uxyx twcw ej.j nvrv oq,q szlz a'?' a"/"
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L51

#                                                             ../orig/d.typ:222
I:(2)
*:_D_R_L52
#                                                             ../orig/d.typ:223
O:gm mg fb bf pk kp yx xy cw wc .j j. rv vr ,q q, lz zl
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L52

#                                                             ../orig/d.typ:224
I:(3)
*:_D_R_L53
#                                                             ../orig/d.typ:225
O:My big boy may buy a gem at the labs by the bay.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L53

#                                                             ../orig/d.typ:226
I:(4)
*:_D_R_L54
#                                                             ../orig/d.typ:228
O:Mort awes boys with the way he can ward off a blow, kill
 :elks and game, row a yawl, or ram awls into bars.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L54

#                                                             ../orig/d.typ:229
I:(5)
*:_D_R_L55
#                                                             ../orig/d.typ:232
O:ah Al am an as at ax ba be do ed eh el go
 :ha he hi ho if in is it Jo la no ma me no
 :of oh on or ox pa pi Si so to up us we ye
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L55

G:_D_E_D9
#------------------------------------------------------------------------------
# Lesson D10
#------------------------------------------------------------------------------
*:D10
*:_D_S_D10
#                                                             ../orig/d.typ:236
I:(1)
*:_D_R_L56
#                                                             ../orig/d.typ:238
O:In barns on farms chicks, boars, veals, bucks and stock might
 :enjoy and value an extra quart of water daily.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L56

#                                                             ../orig/d.typ:239
I:(2)
*:_D_R_L57
#                                                             ../orig/d.typ:241
O:Do zebras roam the miles of bleak velds which cover parts of the
 :world while packs of brown bears and wart hogs prowl in the woods?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L57

#                                                             ../orig/d.typ:242
I:(3)
*:_D_R_L58
#                                                             ../orig/d.typ:246
O:Some folks claim to favor poems and rhyme, others can wring equal
 :cheer and worth from words and quest and seize all books.  Still
 :others amply quell their needs with vocal music and seek all
 :works on voice.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L58

#                                                             ../orig/d.typ:247
I:(4)
*:_D_R_L59
#                                                             ../orig/d.typ:250
O:To begin to use wrong verbs among boors and bores may be
 :a severe error even if the whole group seems to think
 :that exact terms mean less than is normal for them.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L59

#                                                             ../orig/d.typ:251
I:(5)
*:_D_R_L60
#                                                             ../orig/d.typ:255
O:allow among avail awful Aztec azure backs balls began being belie
 :bells bills black blank bored borne bring can't chalk champ charm
 :check cheek chick chink comes Czech every evict exalt excel exert
 :exile expel exult Felix folks gable gauze gives glaze gleam globe
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L60

#                                                             ../orig/d.typ:256
I:(6)
*:_D_R_L61
#                                                             ../orig/d.typ:260
O:verge verse verve vetch vigil vigor viola virus vital vogue voile
 :vouch vowel vying walks walls wards warts whack whale wharf wheat
 :wheel whelp where which whiff while whirl whole wired wires words
 :world worth would write wrong wrote yards yokes yoks zippy zombie
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L61

G:_D_E_D10
#------------------------------------------------------------------------------
# Lesson D11
#------------------------------------------------------------------------------
*:D11
*:_D_S_D11
#                                                             ../orig/d.typ:264
I:(1)
*:_D_R_L62
#                                                             ../orig/d.typ:266
O:For a meal we lack a room, milk in mugs, warm pork, veal
 :in the oven and cake.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L62

#                                                             ../orig/d.typ:267
I:(2)
*:_D_R_L63
#                                                             ../orig/d.typ:269
O:Mike and Milt were grim, not calm, when Mort came to warn them that
 :the well worn ramp over to the mill was too wet for our mile walk.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L63

#                                                             ../orig/d.typ:270
I:(3)
*:_D_R_L64
#                                                             ../orig/d.typ:272
O:Walt may quip and quote with zeal about too much work, but I
 :saw him melt and mourn about his love for his lost wife.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L64

#                                                             ../orig/d.typ:273
I:(4)
*:_D_R_L65
#                                                             ../orig/d.typ:274
O:The pick of wool from rams can make very soft warm garb.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L65

#                                                             ../orig/d.typ:275
I:(5)
*:_D_R_L66
#                                                             ../orig/d.typ:277
O:For his meal the busy bird will use his bill or beak in many
 :ways to peck at or ably to pick up a worm.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L66

#                                                             ../orig/d.typ:278
I:(6)
*:_D_R_L67
#                                                             ../orig/d.typ:280
O:Owls on the wing may move away with limp easy grace or they
 :may sit on a wire and look ever so wise.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L67

#                                                             ../orig/d.typ:281
I:(7)
*:_D_R_L68
#                                                             ../orig/d.typ:283
O:The word or term--prop, mall, king, mark, romp, lock or link--
 :can vary in what it may mean.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L68

#                                                             ../orig/d.typ:284
I:(8)
*:_D_R_L69
#                                                             ../orig/d.typ:288
O:helm herb hock holy jeep jeer jell jerk John jolt jump jury
 :kale keel kelp kilt lack laws leak leek levy lick like lime
 :limp link live love luck lump lynx mail many mill more much
 :okra oval pack peak peck peek phew puck ramp rime skip talk
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L69

#                                                             ../orig/d.typ:289
I:(9)
*:_D_R_L70
#                                                             ../orig/d.typ:292
O:puck ramp rime skip talk vail vale vary veal veer veld verb vial vice
 :volk walk ware warm warp wars wart ways weal wear well will tilt wire
 :whey whim whip whir wore work worm worn yawn yolk zany zero zinc zing
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L70

G:_D_E_D11
#------------------------------------------------------------------------------
# Lesson D12
#------------------------------------------------------------------------------
*:D12
*:_D_S_D12
#                                                             ../orig/d.typ:296
I:(1)
*:_D_R_L71
#                                                             ../orig/d.typ:298
O:In barns on farms chicks, bears, veals, bucks and stock might
 :enjoy and value an extra quart of water daily.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L71

#                                                             ../orig/d.typ:299
I:(2)
*:_D_R_L72
#                                                             ../orig/d.typ:301
O:Quick quips, awful quotes and queer talks never quite solve
 :the wants of a very small child.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L72

#                                                             ../orig/d.typ:302
I:(3)
*:_D_R_L73
#                                                             ../orig/d.typ:304
O:Do zebras roam the miles of bleak velds which cover parts of the
 :world while packs of brown bears and wart hogs prowl in the woods?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L73

#                                                             ../orig/d.typ:305
I:(4)
*:_D_R_L74
#                                                             ../orig/d.typ:309
O:Some folks claim to favor poems and rhyme, others can wring equal
 :cheer and worth from words and quest and seize all books.  Still
 :others amply quell their needs with vocal music and seek all
 :works on voice.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L74

#                                                             ../orig/d.typ:310
I:(5)
*:_D_R_L75
#                                                             ../orig/d.typ:312
O:The queen was given a query for which an ample reply would
 :take a quire of paper.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L75

#                                                             ../orig/d.typ:313
I:(6)
*:_D_R_L76
#                                                             ../orig/d.typ:315
O:Six husky cooks boiled clam broth, shrmp and prawns and broiled
 :liver for seven lucky elves, then made their hasty exits.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L76

#                                                             ../orig/d.typ:316
I:(7)
*:_D_R_L77
#                                                             ../orig/d.typ:319
O:At the games, Mark was so very badly hurt with many broken bones,
 :lumps on his jaws, and some glands burst.  Blood oozed from a crack
 :in his wart where it had oozed for weeks.  He was lucky to have lived.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L77

#                                                             ../orig/d.typ:320
I:(8)
*:_D_R_L78
#                                                             ../orig/d.typ:322
O:To check pomp and pride, sever from all overt vices, belay all
 :forms of muck raking, and limit all hazards, will bring prime joy.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L78

#                                                             ../orig/d.typ:323
I:(9)
*:_D_R_L79
#                                                             ../orig/d.typ:326
O:To begin to use wrong verbs among boors and bores may be
 :a severe error even if the whole group seems to think
 :that exact terms mean less than is normal for them.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L79

#                                                             ../orig/d.typ:327
I:(10)
*:_D_R_L80
#                                                             ../orig/d.typ:331
O:allow among avail awful Aztec azure backs balls began being belie
 :bells bills black blank bored borne bring can't chalk champ charm
 :check cheek chick chink comes Czech every evict exalt excel exert
 :exile expel exult Felix folks gable gauze gives glaze gleam globe
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L80

#                                                             ../orig/d.typ:332
I:(11)
*:_D_R_L81
#                                                             ../orig/d.typ:336
O:grams grave graze havoc hazel helix hobby jazzy jelly jerky jewel
 :joker jolly jolts jowls judge junco kapok kayak keels keeps kitty
 :knack kneel knelt knock knurl kopek kraal Krupp leave liver money
 :never Ozark pawns peaks pecks peeks phlox pirks power proms prove
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L81

#                                                             ../orig/d.typ:337
I:(12)
*:_D_R_L82
#                                                             ../orig/d.typ:341
O:quack quaff quail qualm quays quell quill quilt ramps romps rooms
 :rumps salve serve shack shark shawl shirk shock shrew shuck sieve
 :seize skiff skill skimp skirt skulk small spank speak spoke stick
 :stuck threw throw thyme vague valid value valve vapid vault venal
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L82

#                                                             ../orig/d.typ:342
I:(13)
*:_D_R_L83
#                                                             ../orig/d.typ:346
O:verge verse verve vetch vigil vigor viola virus vital vogue voile
 :vouch vowel vying walks walls wards warts whack whale wharf wheat
 :wheel whelp where which whiff while whirl whole wired wires words
 :world worth would write wrong wrote yards yokes yolks zippy zombi
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L83

G:_D_E_D12
#------------------------------------------------------------------------------
# Lesson D13
#------------------------------------------------------------------------------
*:D13
*:_D_S_D13
*:_D_R_L84
#                                                             ../orig/d.typ:353
T:
 :The following 135 words are so frequently used that they comprise 50%
 :of all words normally typed.  If you can type the next two exercises without
 :errors, half of your typed words will be correct!
Q: Press Y to continue, or Fkey12 to exit 
N:_D_R_L84

*:_D_R_L85
#                                                             ../orig/d.typ:358
O:a about after all also an and another any are as at back be because
 :been before being between both but by can could day did do down each
 :even first for from get good had has have he her here him his how I
 :if in into is it its just know last life like little long made make
 :many may me men more most Mr.  Ms.  much must my never new no not now
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L85

*:_D_R_L86
#                                                             ../orig/d.typ:363
O:of or on one only or other our out over own people said same see she
 :should so some state still such than that the their them then there
 :these they this those through time to too two under up very was way
 :we well were what when where which while who will with work would
 :years you your
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L86

*:_D_R_L87
#                                                             ../orig/d.typ:364
T:We now concentrate on home row words.
Q: Press Y to continue, or Fkey12 to exit 
N:_D_R_L87

#                                                             ../orig/d.typ:365
I:(1)
*:_D_R_L88
#                                                             ../orig/d.typ:367
O:The duteous dietitian hesitated at the intense nauseousness inside
 :the dishonest institution.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L88

#                                                             ../orig/d.typ:368
I:(2)
*:_D_R_L89
#                                                             ../orig/d.typ:370
O:In addition, the unastute assassin had another unsound idea.  He
 :intended to assassinate the dishonest attendant at the institute.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L89

#                                                             ../orig/d.typ:371
I:(3)
*:_D_R_L90
#                                                             ../orig/d.typ:376
O:The unintentioned noisiness and untidiness in the hostess house
 :astonished, astounded and nauseated Antonietta.  Undaunted and
 :unassisted, she did not hesitate to initiate a statute at the state
 :house.  The statute stated that no attendant in an untenanted haunted
 :hostess house is to attain hostess status.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L90

G:_D_E_D13
#------------------------------------------------------------------------------
# Lesson D14
#------------------------------------------------------------------------------
*:D14
*:_D_S_D14
*:_D_R_L91
#                                                             ../orig/d.typ:381
T:
 :In this lesson we practice alphabetic sentences.
Q: Press Y to continue, or Fkey12 to exit 
N:_D_R_L91

#                                                             ../orig/d.typ:382
I:(1)
*:_D_R_L92
#                                                             ../orig/d.typ:383
O:Sixty-five quizzical sheep kept their jaws dry in a farm bungalow.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L92

#                                                             ../orig/d.typ:384
I:(2)
*:_D_R_L93
#                                                             ../orig/d.typ:385
O:Balky Zulus find they can hoax weary men with quavery jumping.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L93

#                                                             ../orig/d.typ:386
I:(3)
*:_D_R_L94
#                                                             ../orig/d.typ:387
O:Jerome quickly began to be vexed by the powerful blizzards.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L94

#                                                             ../orig/d.typ:388
I:(4)
*:_D_R_L95
#                                                             ../orig/d.typ:389
O:Squawking gorillas could vex the brazen nymphs in a jiffy.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L95

#                                                             ../orig/d.typ:390
I:(5)
*:_D_R_L96
#                                                             ../orig/d.typ:391
O:Can Jerry's equipment file saws, ax, hoe, knives and grind adz?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L96

#                                                             ../orig/d.typ:392
I:(6)
*:_D_R_L97
#                                                             ../orig/d.typ:393
O:Ben works at squeezing very juicy plums with flexed thumbs.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L97

#                                                             ../orig/d.typ:394
I:(7)
*:_D_R_L98
#                                                             ../orig/d.typ:395
O:The black wizard quipping jovially flexed his muscles.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L98

#                                                             ../orig/d.typ:396
I:(8)
*:_D_R_L99
#                                                             ../orig/d.typ:397
O:Will you pack my jugs of liquid veneer in five dozen boxes?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L99

#                                                             ../orig/d.typ:398
I:(9)
*:_D_R_L100
#                                                             ../orig/d.typ:399
O:Could the wizard jinx quivering folks by magic yelps?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L100

#                                                             ../orig/d.typ:400
I:(10)
*:_D_R_L101
#                                                             ../orig/d.typ:401
O:Brazen gazelles quickly examined the forward jeep.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L101

#                                                             ../orig/d.typ:402
I:(11)
*:_D_R_L102
#                                                             ../orig/d.typ:403
O:The brown dog quickly jumped over the lazy fox.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L102

#                                                             ../orig/d.typ:404
I:(12)
*:_D_R_L103
#                                                             ../orig/d.typ:405
O:Will the kind judge squelch the five or six brazen nymphs?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L103

#                                                             ../orig/d.typ:406
I:(13)
*:_D_R_L104
#                                                             ../orig/d.typ:407
O:Mix zippy Kadota figs with quivering cranberry jelly.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L104

#                                                             ../orig/d.typ:408
I:(14)
*:_D_R_L105
#                                                             ../orig/d.typ:409
O:The wives quickly jerked extra big pizzas from the stand.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L105

#                                                             ../orig/d.typ:410
I:(15)
*:_D_R_L106
#                                                             ../orig/d.typ:411
O:Lisa quickly mixed the very big jar of new soap.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L106

#                                                             ../orig/d.typ:412
I:(16)
*:_D_R_L107
#                                                             ../orig/d.typ:413
O:The major will fix a quiet cozy nook for the vexed, bad Gypsy.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L107

#                                                             ../orig/d.typ:414
I:(17)
*:_D_R_L108
#                                                             ../orig/d.typ:415
O:Pairs of lazy knowing oxen came by quietly evading the jam.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L108

#                                                             ../orig/d.typ:416
I:(18)
#                                                             ../orig/d.typ:417
I:Juvenile zest for excitement whetted interest in parking by the quay.
#                                                             ../orig/d.typ:418
I:(19)
*:_D_R_L109
#                                                             ../orig/d.typ:419
O:Put your big ax, shovel and quartz where Mike's fence joins ours.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L109

#                                                             ../orig/d.typ:420
I:(20)
*:_D_R_L110
#                                                             ../orig/d.typ:421
O:The brawny jaguar held fast till the quaking Zouave victim expired.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_D_R_L110

G:_D_E_D14
#------------------------------------------------------------------------------
# Lesson series D jump tables
#------------------------------------------------------------------------------
*:_D_E_D1
Q: Do you want to continue to lesson D2 [Y/N] ? 
N:_D_MENU
G:_D_M_D2
*:_D_E_D2
Q: Do you want to continue to lesson D3 [Y/N] ? 
N:_D_MENU
G:_D_M_D3
*:_D_E_D3
Q: Do you want to continue to lesson D4 [Y/N] ? 
N:_D_MENU
G:_D_M_D4
*:_D_E_D4
Q: Do you want to continue to lesson D5 [Y/N] ? 
N:_D_MENU
G:_D_M_D5
*:_D_E_D5
Q: Do you want to continue to lesson D6 [Y/N] ? 
N:_D_MENU
G:_D_M_D6
*:_D_E_D6
Q: Do you want to continue to lesson D7 [Y/N] ? 
N:_D_MENU
G:_D_M_D7
*:_D_E_D7
Q: Do you want to continue to lesson D8 [Y/N] ? 
N:_D_MENU
G:_D_M_D8
*:_D_E_D8
Q: Do you want to continue to lesson D9 [Y/N] ? 
N:_D_MENU
G:_D_M_D9
*:_D_E_D9
Q: Do you want to continue to lesson D10 [Y/N] ? 
N:_D_MENU
G:_D_M_D10
*:_D_E_D10
Q: Do you want to continue to lesson D11 [Y/N] ? 
N:_D_MENU
G:_D_M_D11
*:_D_E_D11
Q: Do you want to continue to lesson D12 [Y/N] ? 
N:_D_MENU
G:_D_M_D12
*:_D_E_D12
Q: Do you want to continue to lesson D13 [Y/N] ? 
N:_D_MENU
G:_D_M_D13
*:_D_E_D13
Q: Do you want to continue to lesson D14 [Y/N] ? 
N:_D_MENU
G:_D_M_D14
*:_D_E_D14
G:_D_MENU

*:_D_M_D1
B:                             Lesson D1
K:12:_D_MENU
G:_D_S_D1
*:_D_M_D2
B:                             Lesson D2
K:12:_D_MENU
G:_D_S_D2
*:_D_M_D3
B:                             Lesson D3
K:12:_D_MENU
G:_D_S_D3
*:_D_M_D4
B:                             Lesson D4
K:12:_D_MENU
G:_D_S_D4
*:_D_M_D5
B:                             Lesson D5
K:12:_D_MENU
G:_D_S_D5
*:_D_M_D6
B:                             Lesson D6
K:12:_D_MENU
G:_D_S_D6
*:_D_M_D7
B:                             Lesson D7
K:12:_D_MENU
G:_D_S_D7
*:_D_M_D8
B:                             Lesson D8
K:12:_D_MENU
G:_D_S_D8
*:_D_M_D9
B:                             Lesson D9
K:12:_D_MENU
G:_D_S_D9
*:_D_M_D10
B:                            Lesson D10
K:12:_D_MENU
G:_D_S_D10
*:_D_M_D11
B:                            Lesson D11
K:12:_D_MENU
G:_D_S_D11
*:_D_M_D12
B:                            Lesson D12
K:12:_D_MENU
G:_D_S_D12
*:_D_M_D13
B:                            Lesson D13
K:12:_D_MENU
G:_D_S_D13
*:_D_M_D14
B:                            Lesson D14
K:12:_D_MENU
G:_D_S_D14
#------------------------------------------------------------------------------
# Lesson series D menu
#------------------------------------------------------------------------------
*:_D_MENU
*:_D_MENU_PAGE0
B:                 Lesson selection menu - series D [page 1 of 2]
K:1:_D_M_D1
K:2:_D_M_D2
K:3:_D_M_D3
K:4:_D_M_D4
K:5:_D_M_D5
K:6:_D_M_D6
K:7:_D_M_D7
K:8:_D_M_D8
K:9:_D_M_D9
K:10:_D_M_D10
K:11:_D_MENU_PAGE1
K:12:_D_QEXIT
T:The D series contains the following 14 lessons:
 :
 :        Fkey 1 - Lesson D1     The home row
 :        Fkey 2 - Lesson D2     Learning the Shift Key
 :        Fkey 3 - Lesson D3     Home Row and the Period
 :        Fkey 4 - Lesson D4     Upper Row and Essential Punctuation
 :        Fkey 5 - Lesson D5     Review
 :        Fkey 6 - Lesson D6     Learning the Lower Row
 :        Fkey 7 - Lesson D7     Practise
 :        Fkey 8 - Lesson D8     Practise
 :        Fkey 9 - Lesson D9     Practise
 :        Fkey10 - Lesson D10    Practise
 :
 :        Fkey11 - Next menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_D_MENU_PAGE0
*:_D_MENU_PAGE1
B:                 Lesson selection menu - series D [page 2 of 2]
K:1:_D_M_D11
K:2:_D_M_D12
K:3:_D_M_D13
K:4:_D_M_D14
K:5:NULL
K:6:NULL
K:7:NULL
K:8:NULL
K:9:NULL
K:10:NULL
K:11:_D_MENU_PAGE0
K:12:_D_QEXIT
T:The D series contains the following 14 lessons:
 :
 :        Fkey 1 - Lesson D11    Practise
 :        Fkey 2 - Lesson D12    Practise
 :        Fkey 3 - Lesson D13    Frequent words
 :        Fkey 4 - Lesson D14    Alphabetic sentences
 :
 :
 :
 :
 :
 :
 :
 :        Fkey11 - First menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_D_MENU_PAGE1
*:_D_QEXIT
Q: Do you want to leave this lesson series? [Y/N] ? 
N:_D_MENU
G:_D_EXIT
*:_D_EXIT
#------------------------------------------------------------------------------
# End of file d.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_M_SERIES
# Start of file m.typ
#------------------------------------------------------------------------------
# Series M
#------------------------------------------------------------------------------
G:_M_MENU
*:_M_NO_MENU
#------------------------------------------------------------------------------
# Lesson M1
#------------------------------------------------------------------------------
*:M1
*:_M_S_M1
#                                                               ../orig/m.typ:3
I:(1) Warming-Up Drill
*:_M_R_L0
#                                                               ../orig/m.typ:4
O:If you can do so, will you kindly let us know by return mail.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L0

#                                                               ../orig/m.typ:5
I:(2) Continuous Copy
*:_M_R_L1
#                                                               ../orig/m.typ:6
O:My totals were:  $2,309, $5,687, $3,498, $2,408, and $3,697.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L1

#                                                               ../orig/m.typ:7
I:(3)
*:_M_R_L2
#                                                               ../orig/m.typ:9
O:A student may type 1 word per minute faster for each added
 :year of age: i.e., 13 to 14, to 15, to 16, to 17, to 18.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L2

#                                                              ../orig/m.typ:10
I:(4)
*:_M_R_L3
#                                                              ../orig/m.typ:13
O:Often 25% of first-year students never do 25 words a minute.
 :Many second-year students can type about 45 words a minute.
 :More than 50% do not equal the practical rate of 50 words.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L3

#                                                              ../orig/m.typ:14
I:(5)
*:_M_R_L4
#                                                              ../orig/m.typ:18
O:Why do we all thrill over sports?  Maybe it is the tireless
 :skill of the winner that we feel.  Ask the players.  They
 :may agree (Rice,* famous as a sports writer, said the cham-
 :pions all agreed) that skill is only part (50%) of it.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L4

#                                                              ../orig/m.typ:19
I:(6)
*:_M_R_L5
#                                                              ../orig/m.typ:24
O:"When you step on the first tee," says the four-time gold
 :champion, Bobby Jones, "you know you can't afford to make
 :one careless slip."  A tired Bobby Jones (this was the way
 :Bobby told it to Rice) has stood on the 16th tee, leading
 :Smith by 18 strokes.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L5

#                                                              ../orig/m.typ:25
I:(7)
*:_M_R_L6
#                                                              ../orig/m.typ:29
O:"Up to this point," says Bobby, "I had played 33 holes in 11
 :under par.  I believe it was the best golf I ever played in
 :my life.  But after easing up on the mental side I played
 :the last three holes in 5 over par."
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L6

#                                                              ../orig/m.typ:30
I:(8)
*:_M_R_L7
#                                                              ../orig/m.typ:36
O:In 1919 Babe Ruth shot into the records with 29 home runs.
 :Yet few know that the Babe worked five years in big games
 :before this start that led past Home Run #600.  You may
 :have cheered Jimmy Foxx and many another.  Yet you can still
 :picture the Babe after two strikes, smashing to the very
 :spot he had "called" a famous home run.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L7

#                                                              ../orig/m.typ:37
I:(9)
*:_M_R_L8
#                                                              ../orig/m.typ:45
O:It is the effort against odds that thrills.  We feel these
 :drives that never let down.  We feel (this was the way Rice
 :put it) the champion forces himself into the winning frame of
 :mind.  Can the fast typist afford to do less?  A typist has
 :to face such days of "mental torture" too.  Some days he has
 :to force himself along.  He need not punish his machine.  He
 :must pull himself together (100%) to type his steady, smooth
 :way over all upsets.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L8

#                                                              ../orig/m.typ:46
I:(9A) Pointed Paragraph (m b)
*:_M_R_L9
#                                                              ../orig/m.typ:53
P:     Men are bound to believe that business is bad in winter
 :months.  Maybe Mr. Smith remembers that most building became
 :better in September but both November and December seemed to
 :be much behind.  Monday morning my mail box became blocked
 :by urgent requests of many families that small-sized homes
 :be built.  Some jobs may begin to come now from the Chamber
 :of Commerce members.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L9

#                                                              ../orig/m.typ:54
I:(10) Rhythmic Review
*:_M_R_L10
#                                                              ../orig/m.typ:55
O:I said, "Never promise to take much money to such places."
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L10

G:_M_E_M1
#------------------------------------------------------------------------------
# Lesson M2
#------------------------------------------------------------------------------
*:M2
*:_M_S_M2
#                                                              ../orig/m.typ:59
I:(1) Warming-Up Drill
*:_M_R_L11
#                                                              ../orig/m.typ:60
O:How do I lose if I read a book that doesn't have much in it?
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L11

#                                                              ../orig/m.typ:61
I:(2) Balanced Keyboard Drill
*:_M_R_L12
#                                                              ../orig/m.typ:63
O:non ana dis dia cle pan ard pur ern eer off age suf ame amb
 :ess ean ist ian cel apo col ary tra neo sur ity sub ele mis
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L12

#                                                              ../orig/m.typ:64
I:(3) Four-letter words (a to d)
*:_M_R_L13
#                                                              ../orig/m.typ:81
P:Dear Dan,
 :
 :     Yes, I came out of the corn, back to the city, both to
 :draw and to do copy on the new cars.  To date I am able to
 :put cash in the bank and bear a bill or two.  The new deed
 :has done it.
 :
 :     The city has been busy but cold for two days.  Dear baby
 :has been to see her best aunt.  A band came by the door.
 :Baby let the bird cage drop down with a blow.  The bird died.
 :Boys put its dead body deep in a dark card case.  Baby also
 :has a ball and blue book to drop.  I put the boat away.  Its
 :deck did burn, but I care not as it does not cost a cent.
 :
 :     Come, call on me at the club.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L13

#                                                              ../orig/m.typ:82
I:(4) Four-letter words (e to g)
*:_M_R_L14
#                                                              ../orig/m.typ:97
P:Dear Bea,
 :
 :     I am glad you feel so for the farm in the East.  Even
 :as a girl of four or five I was ever so glad to find the
 :farm.  In my eyes it was all as good as gold.  Even my feet
 :felt good.  A girl can gain and grow fast on farm food and
 :the fine free air.  Why else did face and form grow full
 :and fair so fast?
 :
 :     On each foot of my farm I felt free from fear.  It
 :gave me my fill of fun.  I felt no fear of any fire in the
 :fall.  Now the fire is a fact and my farm is gone.  Give me
 :my full life, etc.  The game goes on.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L14

#                                                              ../orig/m.typ:98
I:(5) Four-letter words (h to l)
*:_M_R_L15
#                                                             ../orig/m.typ:119
P:Dear Hal,
 :
 :     Just a line to say I am lost if I cannot fly.  I
 :have to keep on here.  I knew it was but a hope last May.
 :It was just my last idea in June.  Yet I held my head high
 :and did not lose hope.
 :
 :     Why not fly up in the air a half hour or less and
 :look at my lake and our home on the hill?  I left it late
 :last July with one item on my list.  Bill gave me half an
 :hour of help.  Like the lady of the lake I met the king.
 :Bill was a kind king, too.
 :
 :     To lead off into the air and see all our lake so
 :long and lots of land so low, was to live a high hour.  I
 :kept my hand at my ear so as to help hear.  In the air my
 :hair was a loss.  It did not kill me.  I have to fly to know
 :life can be less hard.  I like to hold on and help Bill.  I
 :love to fly.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L15

G:_M_E_M2
#------------------------------------------------------------------------------
# Lesson M3
#------------------------------------------------------------------------------
*:M3
*:_M_S_M3
#                                                             ../orig/m.typ:123
I:(1) Warming-Up Drill
*:_M_R_L16
#                                                             ../orig/m.typ:124
O:He says he hasn't been very blue once in his two weeks here.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L16

#                                                             ../orig/m.typ:125
I:(2) Balanced Keyboard Drill
*:_M_R_L17
#                                                             ../orig/m.typ:127
O:sus ase sis uni suc epi cor ory tri acy fic ify dom isk ism
 :ante than ance ling para less plea lent leas post rece cata
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L17

#                                                             ../orig/m.typ:128
I:(3) Four-letter words (m to p)
*:_M_R_L18
#                                                             ../orig/m.typ:145
P:Dear "Pie,"
 :
 :     I open most of my mail and meet the news.  I note that
 :you say Mrs. Page is a mere name but you met the Miss Page.
 :
 :     You must need the car.  Once the pass is open I can move
 :the car over to you.  Do you mind if I make it part of a nice
 :plan to meet Miss Page, too?  Mrs. Page was only a mile past
 :us.  Her son was my age and I made the mile at noon to play a
 :bit.  She paid us for milk.  She did not mean much to me, but
 :her son did.
 :
 :     Next we had more fun up the pass near the poor old No.
 :Nine mine.  I can mark many a mile we once ran.  I must mail
 :this note or I may miss the post.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L18

#                                                             ../orig/m.typ:146
I:(4) Four-letter words (r to s)
*:_M_R_L19
#                                                             ../orig/m.typ:166
P:Dear Ross,
 :
 :     It is a real rain.  The road is so soft my car can but
 :roll, stop, and roll on.  Are you on the ship?  If I get as
 :far as the ship, can we sail in such a rain?  If we try to
 :sail, the ship is sure to rock or ride on one side.  If I get
 :sick, it is up to you to stay by and show us how to save the
 :ship.  Ann has some sort of song to sing in the rain.  She
 :said she sent it to you.
 :
 :     Did you read of our sale?  We set out a big sign.  Now
 :any sort of suit and any size seem to sell.  We are not rich
 :but we can soon step out or be sold out, if any such rate is
 :to rule.
 :
 :     Ann has not seen the ship as yet.  Rain or no rain, Ann
 :says to send her out.  All the rest of us say the same.  Can
 :you ring me in my room at the shop?
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L19

#                                                             ../orig/m.typ:167
I:(5) Pointed Paragraph (i u)
*:_M_R_L20
#                                                             ../orig/m.typ:173
P:     The public is quite unfair about airing quibbles over
 :house furniture and fruit juices for the university crew.
 :The alumni inquiry into the failure of equipment figures in
 :the issue.  The alumni attitude is useful but continues to
 :put a premium on a victorious crew.  Only genius can guide
 :this outfit uphill and build a suitable crew that won't quit.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L20

#                                                             ../orig/m.typ:174
I:(6) Pointed Paragraph (d s -)
*:_M_R_L21
#                                                             ../orig/m.typ:182
P:     Students should be assisted in studying seated at their
 :desks; cross-questioned as to their needs and desires; ad-
 :vised to use up-to-date leads based on studies of standards.
 :By-products of student days, well-bred friends, kindness,
 :self-help, with good grades and degrees, are listed as far-
 :sighted aids.  In Dad's old-fashioned address to his co-
 :workers, he said sadly that ideas are missed less than first-
 :class friends and good-natured wishers.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L21

G:_M_E_M3
#------------------------------------------------------------------------------
# Lesson M4
#------------------------------------------------------------------------------
*:M4
*:_M_S_M4
#                                                             ../orig/m.typ:186
I:(1) Warming-Up Drill
*:_M_R_L22
#                                                             ../orig/m.typ:187
O:Get any piece, since I can't guess the color he always used.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L22

#                                                             ../orig/m.typ:188
I:(2) Balanced Keyboard Drill
*:_M_R_L23
#                                                             ../orig/m.typ:190
O:anti thin atic fast hypo ness your ther fore ship cial ible
 :ette hter here mber ough over eive with ived just ever mono
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L23

#                                                             ../orig/m.typ:191
I:(3) Four-letter words (t to z)
*:_M_R_L24
#                                                             ../orig/m.typ:208
P:Dear Tris,
 :
 :     It is so very warm at this time of year, I told my wife
 :that you and I wish to go west for a week or two.  Did I
 :tell you what a wind we had?  I went to town to vote for the
 :one man whom I want.  I took a well-used tire.  When it went
 :down on a bad turn, in the woods, I had to walk.  Then the
 :wind more than set in, and I had to wait by a wall.  It got
 :our old tree.
 :
 :     I saw two men and set them to work on the car, till
 :they told me it was no use.  If I were to turn it in, is it
 :true that you can take your car?  I want a wide view and I
 :want to talk with you.  Thus I wait upon your word.  Wire
 :yes if you will take this trip.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L24

#                                                             ../orig/m.typ:209
I:(4) Five-letter words (a to c)
*:_M_R_L25
#                                                             ../orig/m.typ:227
P:Dear "Cab,"
 :
 :     Could you apply to the court to allow my claim as agent
 :for Mr. Blank?  I could bring in his books and see about his
 :bills.  If asked, he can cover the costs by checks on a bank
 :that did not break.
 :
 :     Will you allow your child to come alone to see me?  He
 :can have every apple he can carry.  By the way, being clean
 :and above board, you must be above bad cases, but you began
 :to bring in off-color cases after April.
 :
 :     I agree you do not cross the law, but why let men win
 :in a black cause on any basis?  Why not build up your cases
 :from among men of our own class?  Close the awful cases you
 :now carry along to court, and begin again.
 :
 :Sincerely yours,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L25

#                                                             ../orig/m.typ:228
I:(5) Pointed Paragraph (r t)
*:_M_R_L26
#                                                             ../orig/m.typ:236
P:     In our motor party on the return trip an attractive
 :quartet first tried to tell thirty or forty short travel
 :stories.  By turns they transferred to the theater, to art
 :matters, to court trial stories.  In the latter a certain
 :doctor is hurt by a first truck, another truck is struck,
 :and three contractors are thrown to the street.  The girl's
 :strong brother has been hurt.  Further, there are arrests
 :and the sort of extra details that enter into true stories.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L26

G:_M_E_M4
#------------------------------------------------------------------------------
# Lesson M5
#------------------------------------------------------------------------------
*:M5
*:_M_S_M5
#                                                             ../orig/m.typ:240
I:(1) Warming-Up Drill
*:_M_R_L27
#                                                             ../orig/m.typ:241
O:Some women who could write her won't raise a hand to help.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L27

#                                                             ../orig/m.typ:242
I:(2) Balanced Keyboard Drill
*:_M_R_L28
#                                                             ../orig/m.typ:244
O:teen arch acle ward ence ency ease ster tele trix wise some
 :atte tter tion fold ount ancy auto ttle cule mony cion come
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L28

#                                                             ../orig/m.typ:245
I:(3) Five-letter words (d to h)
*:_M_R_L29
#                                                             ../orig/m.typ:262
P:Dear Fred,
 :
 :     I have dared to ask you for an extra favor on the first.
 :If you are not dated, I am to draft you to drive me by horse
 :or car up the grade to the field house at eight.  I guess you
 :have not heard fully about the great dance to be given by the
 :girls on the floor of the field house.
 :
 :     My hands have put fresh green goods on the walls.  Every
 :girl has a green dress, on its front a funny glass heart that
 :she gives as a favor.  The old folks can drive up early, eat
 :and drink and enjoy it all.  We will delay the dance till the
 :girls enter in a dozen files.  It would crush me to death if
 :an error were found in the plans.  Happy hours on earth are
 :never heavy.  Can you doubt that you are going?
 :
 :Sincerely yours,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L29

#                                                             ../orig/m.typ:263
I:(4) Five-letter words (i to p)
*:_M_R_L30
#                                                             ../orig/m.typ:283
P:Dear Madam,
 :
 :     I have your two later notes of March 1.  Maybe it is a
 :large order for you to leave for the north in the month of
 :March.
 :
 :     Our place is miles away, but the real issue is that mu-
 :sic means much to us.  A night of music, even one piece of
 :music, has often meant more to me than my local paper and all
 :the power I have known.  If I can plant a love of music in all
 :parts of this place so that all who hear you sing can learn to
 :love it, it will mean more to me than money.
 :
 :     I never laugh at money, but isn't it plain in these
 :lines that price ought to be the least of all the items?  The
 :point is that our plans for your party are more important.  If
 :you read our other offer in the light of our love for music,
 :we might not seem so far away.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L30

#                                                             ../orig/m.typ:284
I:(5) Pointed Paragraph (u y)
*:_M_R_L31
#                                                             ../orig/m.typ:297
P:     If truly quoted, you and Guy, mere youths, fly a con-
 :tinuous journey of thousands of miles yearly in your study
 :of numerous flying routes.  You say you were south in July
 :in the dry country conspicuous for yucca, but now you are
 :busy buying a quota of various useful items to supply your
 :outfit for the famous Yukon.  Yet I am suspicious when you
 :say this unusual survey is monotonous rather than glorious.
 :You should hurry surely to Vancouver for some delicious
 :yuletide fare.  It seems only yesterday that I was conscious
 :of being young and vigorous enough to fly my buoyant plane.
 :If you lucky boys are victorious over any unusually furious,
 :dangerous, or anxious double duty on this survey, write a
 :quotable account yourself for the Journal.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L31

G:_M_E_M5
#------------------------------------------------------------------------------
# Lesson M6
#------------------------------------------------------------------------------
*:M6
*:_M_S_M6
#                                                             ../orig/m.typ:301
I:(1) Warming-Up Drill
*:_M_R_L32
#                                                             ../orig/m.typ:302
O:They were often too tired to be certain they heard the hour.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L32

#                                                             ../orig/m.typ:303
I:(2) Balanced Keyboard Drill
*:_M_R_L33
#                                                             ../orig/m.typ:305
O:hood ight sion full ould able like ment ical tial ambi semi
 :hand part king itio hing tory ding enti ting thou ving very
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L33

#                                                             ../orig/m.typ:306
I:(3) Five-letter words (q to s)
*:_M_R_L34
#                                                             ../orig/m.typ:326
P:Dear Alice,
 :
 :     I shall start my river story since you have shown you like
 :my style.
 :
 :     The scene is a state in the South.  A sweet girl speaks of
 :the sound and sight of the river.  Seven men without shame raise
 :the stock sales and the boy tries to spend too much at the store.
 :In order to make a quiet and quick slide down the river, the men
 :seize the boat while the others, who are quite ready to serve the
 :girl, sleep.
 :
 :     It seems the girl has sense, for on a sheet of paper she
 :writes that her stock of gold is within reach from a round stone
 :under the small shade tree.  She does not quote the boy, but does
 :refer to the sorry end of his short study, and in her reply to his
 :folks she will state how the gold may still be spent in the right
 :way, which will stamp the story as real.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L34

#                                                             ../orig/m.typ:327
I:(4) Five-letter words (t to z)
*:_M_R_L35
#                                                             ../orig/m.typ:348
P:Dear Mrs. White,
 :
 :     I wish to thank you for the words you wrote three weeks ago,
 :and I trust you will write again on the wrong and waste of war.
 :
 :     As I watch the wheels of events today, I think you value a
 :thing it has taken me a third of my years to see.  In its total
 :trade the world is one whole, and each part in touch with the
 :other at most times.
 :
 :     The usual farm woman won't see a trade table or understand
 :its terms, for she is tired with her efforts to train and teach
 :her young.  She has tried to throw her value into her home, which
 :to her is worth so much.  War can not be put under until these
 :women see there is but one world, which truly is their world.
 :
 :     Where will you be while the thick wheat is harvested?  If
 :not across the water, would you visit us, using your voice to
 :teach us these things?
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L35

#                                                             ../orig/m.typ:349
I:(5) Pointed Paragraph (n m)
*:_M_R_L36
#                                                             ../orig/m.typ:357
P:     Important dinner company in our small apartment was
 :not common, and November ninth mamma was solemn in manner.
 :The moment nine American gentlemen were announced, fun and
 :argument began.  I remember one ancient gentleman, manager
 :of much more income than mine, who was not solemn as imag-
 :ined, but funny and human, even if normal demand, planned
 :movements of modern machines to Canada, long term payments,
 :and columns of numbers meant much more to him than to me.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L36

G:_M_E_M6
#------------------------------------------------------------------------------
# Lesson M7
#------------------------------------------------------------------------------
*:M7
*:_M_S_M7
#                                                             ../orig/m.typ:361
I:(1) Warming-Up Drill
*:_M_R_L37
#                                                             ../orig/m.typ:362
O:Though I don't seem to hear the doctor, I know he is early.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L37

#                                                             ../orig/m.typ:363
I:(2) Balanced Keyboard Drill
*:_M_R_L38
#                                                             ../orig/m.typ:364
O:stat each ning ieve ring side nder emen turn embe llow ours
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L38

#                                                             ../orig/m.typ:365
I:(3) Continuous Copy
*:_M_R_L39
#                                                             ../orig/m.typ:381
P:Dear Mr. and Mrs. Blank,
 :
 :     Your son has not called on me.  If he is to become almost an
 :annual charge upon the county, the church will answer with action.
 :Yet, I am afraid his arrest can not assure his coming around and
 :asking us for advice.  Of course he has to appear before August.
 :He bought on credit, got behind in cash, and the amount became too
 :big.  I shall pay it.
 :
 :     You are an old couple, and I advise you to accept this.  Any-
 :way, he is not a common boy and must have a chance.  He always does
 :appear to anyone as fit.  I run across copies of his art.  I can
 :advise your son, attend to his credit, and try to help him arrive
 :at a change for the better.
 :
 :Sincerely yours,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L39

#                                                             ../orig/m.typ:382
I:(4) Six-letter words (d to k)
*:_M_R_L40
#                                                             ../orig/m.typ:400
P:Dear Dick
 :
 :     I have a dollar.  I expect you to follow me and take dinner.
 :Friday I didn't have cash, but a friend of the family had enough
 :for both of us.
 :
 :     Father is having all the lot, except the garden, filled in
 :during the week.  Giving in to his desire, I intend to work the
 :ground.  Doctor says that my health is hardly an excuse, so I had
 :better decide to make an effort.  Indeed, I am driven either to
 :finish the work in the near future or pay to have it done.
 :
 :     I am hoping you will happen upon some kindly fellow to whom
 :a flower garden itself is fun, and inform me.  I shall direct him,
 :as the entire effect will lie in the way we handle the ground
 :plan.  Don't forget.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L40

#                                                             ../orig/m.typ:401
I:(5) Pointed Paragraph (q z)
*:_M_R_L41
#                                                             ../orig/m.typ:408
P:     I quit the quiz when I saw the quantity of queer hazy
 :questions.  To seize lesser prizes required answers to a
 :dozen queries.  Only a quarter of the quotas qualified with
 :zest.  Many had zero when the quiz asked:  In what zones are
 :Brazil, Switzerland, Arizona, or Texas?  Zebras in our zoos
 :grow to what sizes?  Analyze and quote one great citizen's
 :query as to zeppelins.  Criticize the quality of jazz music.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L41

G:_M_E_M7
#------------------------------------------------------------------------------
# Lesson M8
#------------------------------------------------------------------------------
*:M8
*:_M_S_M8
#                                                             ../orig/m.typ:412
I:(1) Warming-Up Drill
*:_M_R_L42
#                                                             ../orig/m.typ:413
O:At the last minute he wrote that he knew it was done again.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L42

#                                                             ../orig/m.typ:414
I:(2) Balanced Keyboard Drill
*:_M_R_L43
#                                                             ../orig/m.typ:415
O:trans ition there lease craft hyper etter esque ceive where
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L43

#                                                             ../orig/m.typ:416
I:(3) Six-letter words (l to r)
*:_M_R_L44
#                                                             ../orig/m.typ:437
P:Dear Rollin,
 :
 :     I did notice a number of the pretty places I passed in
 :the air nearly two months ago, and I can at length locate
 :the best.  If prices remain rather low, I will not return
 :for any person or be prompt at orders.  I can play a record
 :or two, and not regret there is no report to be looked at.
 :I want to be myself and regard nature, not people.
 :
 :     To obtain this latter result is the proper reason for
 :making this quiet trip.  So far from the public, matter in
 :the papers will be old and market policy of little moment.
 :It will please me to have you with us longer than the others.
 :I was really living for the period when I would be placed with
 :you both.  Your mother has a lovely manner.  I am glad to
 :oblige so recent a member of our office, too.
 :
 :     This letter is being mailed Monday, and in two days we
 :shall go.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L44

#                                                             ../orig/m.typ:438
I:(4) Six-letter words (s to z)
*:_M_R_L45
#                                                             ../orig/m.typ:458
P:Dear Sylvia,
 :
 :     I wonder if my sister talked to you on Sunday of the
 :thirty things we wanted to do this summer?  We were trying
 :all the spring season at school to secure a supply of sim-
 :ple but strong materials for a camp in the valley.
 :
 :     It struck me as we were taking a walk down the street
 :that we would surely be unable to do as we stated unless you
 :took a sudden notion to help.  It seemed to me on second
 :thought we should give thanks to you for giving tongue to our
 :wishes last winter, for you turned the folks in our favor.
 :
 :     My sister was saying that girls from twenty states had
 :signed our pledge, so we are united.  Though this is off the
 :subject, I saw a pretty yellow and silver dress within a win-
 :dow on Main Street toward our corner.  Would you think it
 :suitable for the writer?
 :
 :Sincerely yours,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L45

#                                                             ../orig/m.typ:470
I:(5) Pointed Paragraph (a q)
*:_M_R_L45A
#
P:     I acquired a bequest from a quizzical Quaker.  How
 :to apply it was a quandary.  As a quasi artist, I began in
 :Albuquerque to make a quantity of plaques of chance Indian
 :acquaintances.  My masquerade as an artist of quality in
 :that quaint land of quite Spanish art and adobe was adequate
 :and equally unique.  Squeezed in quiet, antiquated adobe
 :quarters, I began quickly and without qualms to qualify as
 :an artist.  After quarrels and questions over my queer tech-
 :niques, I acquired my quota of opaque plaques.
Q: Press Y to continue, N to repeat, or Shft+Fkey10 to exit 
N:_M_R_L45A

G:_M_E_M8
#------------------------------------------------------------------------------
# Lesson M9
#------------------------------------------------------------------------------
*:M9
*:_M_S_M9
#                                                             ../orig/m.typ:471
I:(1) Warming-Up Drill
*:_M_R_L46
#                                                             ../orig/m.typ:472
O:Instead of having us tonight he is making ready for Tuesday.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L46

#                                                             ../orig/m.typ:473
I:(2) Balanced Keyboard Drill
*:_M_R_L47
#                                                             ../orig/m.typ:474
O:stead ation retro geous contr ourse ultra super ntion under
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L47

#                                                             ../orig/m.typ:475
I:(3) Continuous Copy; Seven-letter words (a-f)
*:_M_R_L48
#                                                             ../orig/m.typ:498
P:Dear Annabel,
 :
 :     My brother and his college friends in the factory decided to arrange an
 :evening exactly as in the old days.  After calling us, they arrived and we
 :carried out the idea.  We used an old college catalog and each girl had an
 :old college dress.
 :
 :     Further to advance the evening, my brother advised us of an old address
 :near the freight yard where certain college boys brought this or that article
 :and were allowed a few dollars.  As we went in, an old man came a step farther,
 :fell forward and against me.  Brother charged him.  Will you believe this care-
 :ful account I enclose?  Between brother and me lay this old man who did seem
 :dead.  I can't express my feeling.  His head was covered with marks of blows.
 :
 :     Already we were anxious to go.  Yet his safe was open, as if to furnish us
 :the old books with the many expense charges against the college boys.  When I
 :looked to see who of our company were in them, I read one balance after another
 :paid from the old country to My Dearest Son.  You are correct if you guess we
 :now ran, because we did.  What follows?  Today's paper doesn't have a line.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L48

#                                                             ../orig/m.typ:499
I:(4) Seven-letter words (g to o)
*:_M_R_L49
#                                                             ../orig/m.typ:518
P:Dear Mrs. White,
 :
 :     I have been holding on, but this January I am getting out.
 :My wife herself may have told you of our opening.  However, I go
 :at ten o'clock this morning, and your husband is still out.  He is
 :to do my general work himself, and may not imagine there is any
 :measure of justice in that.  We married men are obliged to do as
 :ordered.
 :
 :     I am leaving a hundred matters.  He has my opinion on each.
 :Tell him the minutes of the last meeting of the members are on my
 :table.  Tell him I haven't an invoice, but have instead an October
 :bill, for our new machine parts.  He may mention this item to the
 :manager, as he has neither its history nor my letters of inquiry.
 :
 :     I find nothing else to include.  We shall miss you greatly,
 :and we shall be looking for you at our new home.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L49

#                                                             ../orig/m.typ:519
I:(4) Seven-letter words (p to z)
*:_M_R_L50
#                                                             ../orig/m.typ:539
P:Dear Patrick,
 :
 :     I realize that this letter I am sending may subject you to some trouble.
 :I am writing tonight without waiting to go through various reports on our
 :present program.  If I had thought that you would be willing to give me an
 :extra day, perhaps I would have come myself.
 :
 :     As soon as this letter has reached you, and you have finished reading the
 :several items about which I have written, I hope you can give extra working
 :time to my request for special records. These items will suggest a new plan as
 :I picture it.  I shall add them to this note.
 :
 :     It is my purpose to prepare a fast station-to-station service that should
 :be in running order soon.  I suppose it could be started next month.  Let me
 :ask, also, whether we could receipt each payment, as we receive it, on a
 :regular form similar to those in the package shipped you Tuesday.  I am pleased
 :with your showing.  You have been like a soldier on duty in any and all
 :weather.  Success is your teacher.
 :
 :With my best regards,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L50

G:_M_E_M9
#------------------------------------------------------------------------------
# Lesson M10
#------------------------------------------------------------------------------
*:M10
*:_M_S_M10
#                                                             ../orig/m.typ:542
B:				Lesson M10
#                                                             ../orig/m.typ:543
I:(1) Warming-Up Drill
*:_M_R_L51
#                                                             ../orig/m.typ:544
O:He would separate the whole business and buy out their half.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L51

#                                                             ../orig/m.typ:545
I:(2) Balanced Keyboard Drill
*:_M_R_L52
#                                                             ../orig/m.typ:546
O:inter itude circu gious right cious after extra micro sible
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L52

#                                                             ../orig/m.typ:547
I:(3) Continuous Copy; Eight-letter words(a to m)
*:_M_R_L53
#                                                             ../orig/m.typ:566
P:Dear Thomas,
 :
 :     First, I consider of definite interest anything from
 :the business of as good a customer as you.  As director of
 :our division, I am to continue handling building material.
 :My judgment on all the evidence, which I send herewith
 :enclosed in a second envelope, is one of complete approval.
 :Let me have a contract covering the earliest delivery date.
 :Are you advising me what increase in your discount is to be
 :expected?
 :
 :     Second, this forenoon I saw your son and he told me of
 :his marriage in February.  Although you had not entirely
 :finished the addition to your lake house by last December,
 :couldn't you exchange it, as it is, for my mountain home?
 :Your son said that his young wife wants to live on this
 :mountain to which all your children seem so attached.
 :
 :Sincerely yours,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L53

#
I:(4) Eight-letter words (n to z)
*:_M_R_L54
#                                                             ../orig/m.typ:587
P:Dear Nathan,
 :
 :     My last shipment has probably been received, for the purchase was made
 :Thursday.  Tomorrow is Saturday, a pleasant day, for I go on my vacation.
 :
 :     Do you remember an original idea you proposed last November relative
 :to planning for some shipping from my property?  My neighbor recently
 :called it a plan in a thousand, and we must get together so that I can
 :thank you properly.  This is a national as well as personal question,
 :and I am trusting that you will be thinking that it is possible for you to
 :help put it into practice.
 :
 :     If you can possibly separate yourself from teachers and your
 :teaching position sometime soon, plan to get a standard car and
 :whatever else is required for the trip.  The car would also be a
 :pleasure after you return to New York.  May I persuade you in re-
 :plying to state that you are planning to come promptly?  We will
 :make you one of the officers of the shipping business.
 :
 :Your sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L54

#                                                             ../orig/m.typ:588
I:(5) Nine-letter words (a to i)
*:_M_R_L55
#                                                             ../orig/m.typ:605
P:Dear Son,
 :
 :     I am beginning this afternoon to give my immediate attention
 :to a Christmas that should be beautiful.  I have addressed, to be
 :forwarded and delivered in good condition, some new equipment
 :according to your wish.  I note, too, that your committee met.
 :What these gentlemen said is important and may be a sort of in-
 :surance that your plan does not fail.  I certainly would not want
 :to duplicate for you the kind of education given me.
 :
 :     Be different by following more than one new idea, including
 :some of your own.  If you can carefully take fair advantage of
 :every available condition, everybody should accept you cordially,
 :as answering to the character of a gentleman.  Mother is enclosing
 :a few lines.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L55

G:_M_E_M10
#------------------------------------------------------------------------------
# Lesson M11
#------------------------------------------------------------------------------
*:M11
*:_M_S_M11
#                                                             ../orig/m.typ:608
B:				Lesson M11
#                                                             ../orig/m.typ:609
I:(1) Warming-Up Drill
*:_M_R_L56
#                                                             ../orig/m.typ:610
O:My country friend is beginning to believe trouble is coming.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L56

#                                                             ../orig/m.typ:611
I:(2) Balanced Keyboard Drill
*:_M_R_L57
#                                                             ../orig/m.typ:612
O:thing pleas ought quest ember count ditio state recei ction
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L57

#                                                             ../orig/m.typ:613
I:(3) Nine-letter words (j to z)
*:_M_R_L58
#                                                             ../orig/m.typ:633
P:Dear Gertrude,
 :
 :     This letter has no reference to shipments which you have
 :so kindly purchased from me in the past.  Rather, as you are
 :returning to this territory by September, our president has re-
 :quested me as secretary to ask that you make a statement before
 :our club the first Wednesday.
 :
 :     Let me say something of the questions we have been receiving
 :for the year.  Recently I read that the old principle today still
 :applies.  It is wonderful what our new knowledge has surprised us
 :into regarding as necessary for ourselves--sometimes things not
 :even mentioned yesterday.
 :
 :     Will you therefore represent this new deal and present the
 :situation to us in principle, sincerely, as you see it?  Other-
 :wise, if you cannot make this provision now, I shall be glad to
 :call upon you later.
 :
 :Yours sincerely,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L58

#                                                             ../orig/m.typ:634
I:(4) Ten-letter words (a to z)
*:_M_R_L59
#                                                             ../orig/m.typ:655
P:Dear Alex,
 :
 :     We are especially interested in the settlement run by a
 :new department at the University.  We appreciate the importance
 :of its additional study to understand impossible conditions in
 :the poor parts of our city, and its use for adjustment of some
 :particular boy or girl.  Have you read our memorandum in this
 :connection?
 :
 :     Our city is absolutely too big.  With the automobile we can
 :distribute every person to his home along a line, our wide road,
 :run far out from the city.  The difference between country and
 :city grows less and less, in accordance with such use of the auto-
 :mobile.
 :
 :     Concerning our collection of any remittance from you, this
 :would serve to form a Conference which would develop everything
 :that can make city governments bring full and rich experience
 :to all.
 :
 :Sincerely yours,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L59

#                                                             ../orig/m.typ:656
I:(5) Eleven- to fourteen-letter words (a to z)
*:_M_R_L60
#                                                             ../orig/m.typ:673
P:Dear Sir,
 :
 :     I wish to acknowledge the recent interesting correspondence
 :from your office on the very considerable requirements of the new
 :law that have to do with any unfortunate advertising that might
 :appear in my papers.
 :
 :     Our association also has appreciated both your instructions
 :and the opportunity for prompt examination and understanding of
 :the new arrangement, particularly its application to all informa-
 :tion given the public about merchandise for sale.  This has been
 :a real convenience in our consideration of the entire proposition.
 :
 :     I want to assure you that our co-operation under the new law
 :will be satisfactory in every way.
 :
 :Yours respectfully,
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L60

#                                                             ../orig/m.typ:674
I:(6) Pointed Paragraph (l r z)
*:_M_R_L61
#                                                             ../orig/m.typ:687
P:     The JOURNAL learned that the relatives on their arrival in
 :April had already referred the trouble to lawyers.  Their early re-
 :turn surprises me.  As to the children themselves, the older girls
 :are personally agreeable, slender, and certainly full of zest.  They
 :travel yearly and already are familiar with the world.  Their father
 :was a quizzical old man who fairly idolized them.  His will leaves
 :them very nearly a half-million dollars.  Only the earlier, first
 :will is very irregular.  I've already quizzed them about the real
 :hazards of quarrels over legal prizes of similar size.  From their
 :replies I've realized slowly that the girls are all right.  It
 :really amazes me that even persons like ourselves promptly seize
 :upon some hostile relative's version of an earlier will, which
 :should be recognized easily as false.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_M_R_L61

G:_M_E_M11
#------------------------------------------------------------------------------
# Lesson series M jump tables
#------------------------------------------------------------------------------
*:_M_E_M1
Q: Do you want to continue to lesson M2 [Y/N] ? 
N:_M_MENU
G:_M_M_M2
*:_M_E_M2
Q: Do you want to continue to lesson M3 [Y/N] ? 
N:_M_MENU
G:_M_M_M3
*:_M_E_M3
Q: Do you want to continue to lesson M4 [Y/N] ? 
N:_M_MENU
G:_M_M_M4
*:_M_E_M4
Q: Do you want to continue to lesson M5 [Y/N] ? 
N:_M_MENU
G:_M_M_M5
*:_M_E_M5
Q: Do you want to continue to lesson M6 [Y/N] ? 
N:_M_MENU
G:_M_M_M6
*:_M_E_M6
Q: Do you want to continue to lesson M7 [Y/N] ? 
N:_M_MENU
G:_M_M_M7
*:_M_E_M7
Q: Do you want to continue to lesson M8 [Y/N] ? 
N:_M_MENU
G:_M_M_M8
*:_M_E_M8
Q: Do you want to continue to lesson M9 [Y/N] ? 
N:_M_MENU
G:_M_M_M9
*:_M_E_M9
Q: Do you want to continue to lesson M10 [Y/N] ? 
N:_M_MENU
G:_M_M_M10
*:_M_E_M10
Q: Do you want to continue to lesson M11 [Y/N] ? 
N:_M_MENU
G:_M_M_M11
*:_M_E_M11
G:_M_MENU

*:_M_M_M1
B:                             Lesson M1
K:12:_M_MENU
G:_M_S_M1
*:_M_M_M2
B:                             Lesson M2
K:12:_M_MENU
G:_M_S_M2
*:_M_M_M3
B:                             Lesson M3
K:12:_M_MENU
G:_M_S_M3
*:_M_M_M4
B:                             Lesson M4
K:12:_M_MENU
G:_M_S_M4
*:_M_M_M5
B:                             Lesson M5
K:12:_M_MENU
G:_M_S_M5
*:_M_M_M6
B:                             Lesson M6
K:12:_M_MENU
G:_M_S_M6
*:_M_M_M7
B:                             Lesson M7
K:12:_M_MENU
G:_M_S_M7
*:_M_M_M8
B:                             Lesson M8
K:12:_M_MENU
G:_M_S_M8
*:_M_M_M9
B:                             Lesson M9
K:12:_M_MENU
G:_M_S_M9
*:_M_M_M10
B:                            Lesson M10
K:12:_M_MENU
G:_M_S_M10
*:_M_M_M11
B:                            Lesson M11
K:12:_M_MENU
G:_M_S_M11
#------------------------------------------------------------------------------
# Lesson series M menu
#------------------------------------------------------------------------------
*:_M_MENU
*:_M_MENU_PAGE0
B:                 Lesson selection menu - series M [page 1 of 2]
K:1:_M_M_M1
K:2:_M_M_M2
K:3:_M_M_M3
K:4:_M_M_M4
K:5:_M_M_M5
K:6:_M_M_M6
K:7:_M_M_M7
K:8:_M_M_M8
K:9:_M_M_M9
K:10:_M_M_M10
K:11:_M_MENU_PAGE1
K:12:_M_QEXIT
T:The M series contains the following 11 lessons:
 :
 :        Fkey 1 - Lesson M1     Practise
 :        Fkey 2 - Lesson M2     Practise
 :        Fkey 3 - Lesson M3     Practise
 :        Fkey 4 - Lesson M4     Practise
 :        Fkey 5 - Lesson M5     Practise
 :        Fkey 6 - Lesson M6     Practise
 :        Fkey 7 - Lesson M7     Practise
 :        Fkey 8 - Lesson M8     Practise
 :        Fkey 9 - Lesson M9     Practise
 :        Fkey10 - Lesson M10    Practise
 :
 :        Fkey11 - Next menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_M_MENU_PAGE0
*:_M_MENU_PAGE1
B:                 Lesson selection menu - series M [page 2 of 2]
K:1:_M_M_M11
K:2:NULL
K:3:NULL
K:4:NULL
K:5:NULL
K:6:NULL
K:7:NULL
K:8:NULL
K:9:NULL
K:10:NULL
K:11:_M_MENU_PAGE0
K:12:_M_QEXIT
T:The M series contains the following 11 lessons:
 :
 :        Fkey 1 - Lesson M11    Practise
 :
 :
 :
 :
 :
 :
 :
 :
 :
 :
 :        Fkey11 - First menu page...
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_M_MENU_PAGE1
*:_M_QEXIT
Q: Do you want to leave this lesson series? [Y/N] ? 
N:_M_MENU
G:_M_EXIT
*:_M_EXIT
#------------------------------------------------------------------------------
# End of file m.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_S_SERIES
# Start of file s.typ
#------------------------------------------------------------------------------
# Series S
#------------------------------------------------------------------------------
G:_S_MENU
*:_S_NO_MENU
#------------------------------------------------------------------------------
# Lesson S1
#------------------------------------------------------------------------------
*:S1
*:_S_S_S1
*:_S_R_L0
#                                                              ../orig/s.typ:14
T:			SPEED PRACTICE SERIES
 :
 :The S series of lessons is designed to help you improve your typing speed
 :and accuracy.  It is assumed that you have already learned how to touch
 :type either from a previous course in touch typing or from the T series of
 :these lessons.
 :
 :You can use this series even if you do not know how to touch type.  But, it is
 :recommended that you at least learn to touch type most of the letters of the
 :alphabet before starting this series.  When you encounter a letter or symbol
 :which you have not learned, you will have to look.  This is a very bad habit to
 :get into and is hard to break.  (You needn't worry if you only need to glance
 :down for unusual keys, like the dollar sign.)
Q: Press Y to continue, or Fkey12 to exit 
N:_S_R_L0

*:_S_R_L1
#                                                              ../orig/s.typ:30
T:			   RULES OF THE GAME
 :
 :I will display a paragraph on the screen.  You should then type the entire
 :paragraph as quickly and as accurately as possible.   As you type each
 :character, I will immediately check it for accuracy.  If it was right, I won't
 :do anything.  But, if you made a mistake, I will beep and write that letter in
 :inverse video (a black character on a white background).  You can ignore the
 :error and continue going; or, you can backup and correct it with the DELETE
 :or BACKSPACE keys.  (I will still count it as an error though.)
 :
 :I will also be timing you.  From the time you type the first character until
 :you hit the final carriage return, my stop watch will be going.  At the
 :end of the paragraph, I will tell you your rating (in words-per-minute).
 :
 :If you made too many mistakes, try the next paragraph slower.  If you made no
 :mistakes or only one or two, try the next one faster.
Q: Press Y to continue, or Fkey12 to exit 
N:_S_R_L1

#                                                              ../orig/s.typ:31
I:First, a quick warm-up.
*:_S_R_L2
#                                                              ../orig/s.typ:32
P:The quick brown fox jumped over the lazy dogs.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L2

#                                                              ../orig/s.typ:33
I:Once more:
*:_S_R_L3
#                                                              ../orig/s.typ:34
P:The quick brown fox jumped over the lazy dogs.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L3

#                                                              ../orig/s.typ:35
I:Don't forget to hit the return key twice for blank lines.
*:_S_R_L4
#                                                              ../orig/s.typ:48
P:Dear Sirs:
 :
 :I have just purchased a Heathkit H89 computer system and would
 :like to order two boxes of diskettes for it.  This system uses
 :5 1/4 inch, hard-sectored, ten-sector, single-sided, single-
 :density diskettes.
 :
 :Enclosed is my check for $45.00.  Please rush this order, as I
 :can not use my system before they arrive.
 :
 :Sincerely,
 :
 :Mr. Smith
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L4

*:_S_R_L5
#                                                              ../orig/s.typ:61
P:Dear Sirs:
 :
 :Thank you for sending the diskettes so promptly.  How-
 :ever, the diskettes which you sent are for soft-sectored
 :drives.  As I stated in my original letter my system
 :accepts only ten-sector, hard-sectored diskettes.
 :
 :I will return these two boxes as soon as I receive the
 :correct ones.
 :
 :Sincerely,
 :
 :Mr. Smith
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L5

*:_S_R_L6
#                                                              ../orig/s.typ:76
P:Dear Mr. Smith:
 :
 :Thank you for informing us that the diskettes which you pur-
 :chased from us are not satisfactory.  We are sorry for the
 :inconvenience you have been caused in this transaction.
 :
 :We shall be glad to replace the diskettes you now have or to
 :allow you to select a different brand.  If you will let us know
 :your wishes we shall be glad to give the matter our immediate
 :attention.
 :
 :We hope you will give us the opportunity to prove to you that
 :this incident is most unusual and that we do strive to render
 :to our customers an efficient and courteous service at all
 :times.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L6

G:_S_E_S1
#------------------------------------------------------------------------------
# Lesson S2
#------------------------------------------------------------------------------
*:S2
*:_S_S_S2
*:_S_R_L7
#                                                              ../orig/s.typ:83
T:
 :In this lesson we will practice some quotes by some famous (and not
 :so famous) people.
Q: Press Y to continue, or Fkey12 to exit 
N:_S_R_L7

#                                                              ../orig/s.typ:84
I:Marcus Aurelius
*:_S_R_L8
#                                                              ../orig/s.typ:85
P:A man can live well even in a palace.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L8

#                                                              ../orig/s.typ:86
I:Ralph Waldo Emerson
*:_S_R_L9
#                                                              ../orig/s.typ:87
P:My chief want in life is someone who shall make me do what I can.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L9

#                                                              ../orig/s.typ:88
I:Elizabeth Barrett Browning
*:_S_R_L10
#                                                              ../orig/s.typ:90
P:No man can be called friendless when he has God and the
 :companionship of good books.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L10

#                                                              ../orig/s.typ:91
I:Ralph Waldo Emerson
*:_S_R_L11
#                                                              ../orig/s.typ:92
P:I like the silent church before the service begins better than any preaching.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L11

#                                                              ../orig/s.typ:93
I:George Washington
*:_S_R_L12
#                                                              ../orig/s.typ:94
P:True friendship is a plant of slow growth.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L12

#                                                              ../orig/s.typ:95
I:Aristotle
*:_S_R_L13
#                                                              ../orig/s.typ:96
P:There is a foolish corner in the brain of the wisest men.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L13

#                                                              ../orig/s.typ:97
I:Goethe
*:_S_R_L14
#                                                              ../orig/s.typ:98
P:Tell me what you are busy about, and I will tell you what you are.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L14

#                                                              ../orig/s.typ:99
I:Gelett Burgess
*:_S_R_L15
#                                                             ../orig/s.typ:101
P:If in the last few years you haven't discarded a major opinion or
 :acquired a new one, check your pulse.  You may be dead.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L15

#                                                             ../orig/s.typ:102
I:James B. Conant
*:_S_R_L16
#                                                             ../orig/s.typ:104
P:Democracy is a small hard core of common agreement, surrounded
 :by a rich variety of individual differences.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L16

#                                                             ../orig/s.typ:105
I:Albert Einstein
*:_S_R_L17
#                                                             ../orig/s.typ:106
P:I never think of the future.  It comes soon enough.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L17

#                                                             ../orig/s.typ:107
I:Harry S. Truman
*:_S_R_L18
#                                                             ../orig/s.typ:109
P:Men often mistake notoriety for fame, and would rather be
 :remarked for their vices than not be noticed at all.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L18

#                                                             ../orig/s.typ:110
I:Will Rogers
*:_S_R_L19
#                                                             ../orig/s.typ:112
P:I could study all my life and not think up half the amount
 :of funny things they can think of in one session of Congress.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L19

#                                                             ../orig/s.typ:113
I:Ralph Waldo Emerson
*:_S_R_L20
#                                                             ../orig/s.typ:114
P:Hospitality consists in a little fire, a little food and an immense quiet.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L20

#                                                             ../orig/s.typ:115
I:H. L. Mencken
*:_S_R_L21
#                                                             ../orig/s.typ:116
P:Puritanism is the haunting fear that someone, somewhere, may be happy.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L21

#                                                             ../orig/s.typ:117
I:William James
*:_S_R_L22
#                                                             ../orig/s.typ:118
P:When you have to make a choice and don't make it, that is in itself a choice.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L22

#                                                             ../orig/s.typ:119
I:James Holt McGravran.
*:_S_R_L23
#                                                             ../orig/s.typ:121
P:There is a way of transferring funds that is even faster
 :than electronic banking.  It is called marriage.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L23

#                                                             ../orig/s.typ:122
I:Woody Allen
*:_S_R_L24
#                                                             ../orig/s.typ:123
P:Showing up is 80 percent of life.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L24

#                                                             ../orig/s.typ:124
I:Robert Frost
*:_S_R_L25
#                                                             ../orig/s.typ:125
P:A poem begins in delight and ends in wisdom.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L25

#                                                             ../orig/s.typ:126
I:Louis Pasteur
*:_S_R_L26
#                                                             ../orig/s.typ:128
P:When I approach a child, he inspires in me two sentiments:  tenderness
 :for what he is, and respect for what he may become.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L26

G:_S_E_S2
#------------------------------------------------------------------------------
# Lesson S3
#------------------------------------------------------------------------------
*:S3
*:_S_S_S3
*:_S_R_L27
#                                                             ../orig/s.typ:134
T:
 :In this lesson you will be given several excerpts from the classics.
 :Take your time and type them carefully.
Q: Press Y to continue, or Fkey12 to exit 
N:_S_R_L27

#                                                             ../orig/s.typ:135
I:A Christmas Carol, Stave One, Marley's Ghost
*:_S_R_L28
#                                                             ../orig/s.typ:151
P:Now, it is a fact, that there was nothing at all par-
 :ticular about the knocker on the door, except that it
 :was very large.  It is also a fact, that Scrooge had
 :seen it, night and morning, during his whole residence
 :in that place; also that Scrooge has as little of what
 :is called fancy about him as any man in the city of
 :London, even including--which is a bold word--the
 :corporation, aldermen, and livery.  Let it also be
 :borne in mind that Scrooge had not bestowed one
 :thought on Marley, since his last mention of his
 :seven year's dead partner that afternoon.  And then
 :let any man explain to me, if he can, how it happened
 :that Scrooge, having his key in the lock of the door,
 :saw in the knocker, without its undergoing any inter-
 :mediate process of change--not a knocker, but Mar-
 :ley's face.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L28

#                                                             ../orig/s.typ:152
I:Gulliver's Travels, Chapter One, A Voyage to Lilliput
*:_S_R_L29
#                                                             ../orig/s.typ:167
P:When I awaked it was just daylight.  I attempted to rise, but I
 :found my arms and legs were strongly fastened on each side to
 :the ground; and my hair, which was long and thick, tied to the
 :ground in the same manner.  I likewise felt several slender
 :ligatures across my body, from my armpits to my thighs.  I
 :could only look upward; the sun began to grow hot, and the
 :light offended my eyes.  I heard a confused noise about me;
 :but in the posture I lay could see nothing except the sky.  In a
 :little time I felt something alive moving on my left leg,
 :which, advancing gently forward over my breast, came almost up
 :to my chin; when bending my eyes downward as much as I could, I
 :perceived it to be a human creature not six inches high, with a
 :bow and arrow in his hands, and a quiver at his back.  In the
 :mean time I felt at least forty more of the same kind (as I
 :conjectured) following the first.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L29

#                                                             ../orig/s.typ:168
I:Treasure Island, Chapter IV, "The Sea Chest", by Stevenson.
*:_S_R_L30
#                                                             ../orig/s.typ:182
P:I lost no time, of course, in telling my mother all that
 :I knew, and perhaps should have told her long before,
 :and we saw ourselves at once in a difficult and dangerous
 :position.  Some of the man's money--if he had any--was
 :certainly due to us; but it was not likely that our
 :captain's shipmates, above all the two specimens seen by
 :me, Black Dog and the blind beggar, would be inclined to
 :give up their booty in payment of the dead man's debts.
 :The captain's order to mount at once and ride for Dr.
 :Livesey would have left my mother alone and unprotected,
 :which was not to be thought of.  Indeed, it seemed
 :impossible for either of us to remain much longer in the
 :house:  the fall of coals in the kitchen grate, the very
 :ticking of the clock, filled us with alarms.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L30

#                                                             ../orig/s.typ:183
I:Treasure Island, Chapter IV, "The Sea Chest", by Stevenson.
*:_S_R_L31
#                                                             ../orig/s.typ:194
P:The neighborhood, to our ears, seemed haunted by
 :approaching footsteps; and what between the dead
 :body of the captain on the parlor floor, and the thought
 :of that detestable blind beggar hovering near at hand,
 :and ready to return, there were moments when, as the
 :saying goes, I jumped in my skin for terror.  Something
 :must speedily be resolved upon; and it occurred to us at
 :last to go forth together and seek help in the neighbor-
 :ing hamlet.  No sooner said than done.  Bareheaded as we
 :were, we ran out at once in the gathering evening and
 :the frosty fog.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L31

G:_S_E_S3
#------------------------------------------------------------------------------
# Lesson S4
#------------------------------------------------------------------------------
*:S4
*:_S_S_S4
*:_S_R_L32
#                                                             ../orig/s.typ:202
T:
 :In this lesson you will be given several soliloquies from
 :Shakespeare's plays.  The spelling and punctuation are
 :quite hard.  Take your time and type them carefully.
Q: Press Y to continue, or Fkey12 to exit 
N:_S_R_L32

#                                                             ../orig/s.typ:203
I:Romeo and Juliet, Act II, Scene II (Capulet's Garden).
*:_S_R_L33
#                                                             ../orig/s.typ:216
P:But, soft! what light through yonder window breaks?
 :It is the east, and Juliet is the sun!--
 :Arise, fair sun, and kill the envious moon,
 :Who is already sick and pale with grief,
 :That thou her maid art far more fair than she:
 :Be not her maid, since she is envious;
 :Her vestal livery is but sick and green,
 :And none but fools do wear it; cast it off.--
 :It is my lady; O, it is my love!
 :O, that she knew she were!--
 :She speaks, yet she says nothing:  what of that?
 :Her eye discourses, I will answer it.--
 :I am too bold, 'tis not to me she speaks:
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L33

*:_S_R_L34
#                                                             ../orig/s.typ:227
P:Two of the fairest stars in all the heaven,
 :Having some business, do entreat her eyes
 :To twinkle in their spheres till they return.
 :What if her eyes were there, they in her head?
 :The brightness of her cheek would shame those stars,
 :As daylight doth a lamp; her eyes in heaven
 :Would through the airy region stream so bright
 :That birds would sing, and think it were not night.--
 :See how she leans her cheek upon her hand!
 :O, that I were a glove upon that hand,
 :That I might touch that cheek!
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L34

#                                                             ../orig/s.typ:228
I:Julius Caesar, Act III, Scene II (The Forum).
*:_S_R_L35
#                                                             ../orig/s.typ:243
P:Friends, Romans, countrymen, lend me your ears;
 :I come to bury Caesar, not to praise him.
 :The evil that men do lives after them;
 :The good is oft interred with their bones;
 :So let it be with Caesar:  The noble Brutus
 :Hath told you Caesar was ambitious:
 :If it were so, it was a grievous fault;
 :And grievously hath Caesar answer'd it.
 :Here, under leave of Brutus and the rest,--
 :For Brutus is an honourable man;
 :So are they all, all honourable men,--
 :Come I to speak in Caesar's funeral.
 :He was my friend, faithful and just to me;
 :But Brutus says he was ambitious;
 :And Brutus is an honourable man.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L35

*:_S_R_L36
#                                                             ../orig/s.typ:255
P:He hath brought many captives home to Rome.
 :Whose ransoms did the general coffers fill:
 :Did this in Caesar seem ambitious?
 :When that the poor have cried, Caesar hath wept:
 :Ambition should be made of sterner stuff:
 :Yet Brutus says he was ambitious;
 :And Brutus is an honourable man.
 :You all did see that on the Lupercal
 :I thrice presented him a kingly crown,
 :Which he did thrice refuse:  was this ambition?
 :Yet Brutus says he was ambitious;
 :And, sure, he is an honourable man.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L36

*:_S_R_L37
#                                                             ../orig/s.typ:263
P:I speak not to disprove what Brutus spoke,
 :But here I am to speak what I do know.
 :You all did love him once,--not without cause:
 :What cause withholds you, then, to mourn for him?
 :O judgement, thou art fled to brutish beasts,
 :And men have lost their reason!--Bear with me;
 :My heart is in the coffin there with Caesar,
 :And I must pause till it come back to me.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L37

#                                                             ../orig/s.typ:264
I:The Merchant of Venice, Act IV, Scene I (A Court of Justice).
*:_S_R_L38
#                                                             ../orig/s.typ:273
P:The quality of mercy is not strain'd;
 :It droppeth as the gentle rain from heaven
 :Upon the place beneath: it is twice bless'd;
 :It blesseth him that gives and him that takes:
 :'Tis mightiest in the mightiest; it becomes
 :The throned monarch better than his crown;
 :His sceptre shows the force of temporal power,
 :The attribute to awe and majesty,
 :Wherein doth sit the dread and fear of kings;
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L38

*:_S_R_L39
#                                                             ../orig/s.typ:286
P:But mercy is above this scepter'd sway,--
 :It is enthroned in the heart of kings,
 :It is an attribute to God himself;
 :And earthly power doth then show likest God's
 :When mercy seasons justice.  Therefore, Jew,
 :Though justice be thy plea consider this--
 :That in the course of justice none of us
 :Should see salvation: we do pray for mercy;
 :And that same prayer doth teach us all to render
 :The deeds of mercy.  I have spoke thus much
 :To mitigate the justice of thy plea;
 :Which if thou follow, this strict court of Venice
 :Must needs give sentence 'gainst the merchant there.
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_S_R_L39

G:_S_E_S4
#------------------------------------------------------------------------------
# Lesson series S jump tables
#------------------------------------------------------------------------------
*:_S_E_S1
Q: Do you want to continue to lesson S2 [Y/N] ? 
N:_S_MENU
G:_S_M_S2
*:_S_E_S2
Q: Do you want to continue to lesson S3 [Y/N] ? 
N:_S_MENU
G:_S_M_S3
*:_S_E_S3
Q: Do you want to continue to lesson S4 [Y/N] ? 
N:_S_MENU
G:_S_M_S4
*:_S_E_S4
G:_S_MENU

*:_S_M_S1
B:                             Lesson S1
K:12:_S_MENU
G:_S_S_S1
*:_S_M_S2
B:                             Lesson S2
K:12:_S_MENU
G:_S_S_S2
*:_S_M_S3
B:                             Lesson S3
K:12:_S_MENU
G:_S_S_S3
*:_S_M_S4
B:                             Lesson S4
K:12:_S_MENU
G:_S_S_S4
#------------------------------------------------------------------------------
# Lesson series S menu
#------------------------------------------------------------------------------
*:_S_MENU
*:_S_MENU_PAGE0
B:                 Lesson selection menu - series S
K:1:_S_M_S1
K:2:_S_M_S2
K:3:_S_M_S3
K:4:_S_M_S4
K:5:NULL
K:6:NULL
K:7:NULL
K:8:NULL
K:9:NULL
K:10:NULL
K:11:NULL
K:12:_S_QEXIT
T:The S series contains the following 4 lessons:
 :
 :        Fkey 1 - Lesson S1     Speed tests
 :        Fkey 2 - Lesson S2     Speed tests
 :        Fkey 3 - Lesson S3     Speed tests
 :        Fkey 4 - Lesson S4     Speed tests
 :
 :
 :
 :
 :
 :
 :
 :
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_S_MENU_PAGE0
*:_S_QEXIT
Q: Do you want to leave this lesson series? [Y/N] ? 
N:_S_MENU
G:_S_EXIT
*:_S_EXIT
#------------------------------------------------------------------------------
# End of file s.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_N_SERIES
# Start of file n.typ
#------------------------------------------------------------------------------
# Series N
#------------------------------------------------------------------------------
G:_N_MENU
*:_N_NO_MENU
#------------------------------------------------------------------------------
# Lesson N1
#------------------------------------------------------------------------------
*:N1
*:_N_S_N1
*:_N_R_L0
#                                                              ../orig/n.typ:21
T:
 :			Numeric Keypad Lessons
 :
 :The N series lessons are provided for practice with the numeric keys available
 :on the H89/H19 terminal.  You do not need to know how to touch type on the
 :standard keyboard in order to learn touch typing on a calculator keypad.  So,
 :you can begin this series right away.
 :
 :When entering numeric values, accuracy is usually more important than speed.
 :Take these lessons very slowly.  Speed will come naturally later.
 :
 :As with the standard keypad, you must start in the HOME position.  Place the
 :first three fingers of your right hand over the 4, 5, and 6 keys of the keypad.
 :(Your thumb and fifth finger are not used.)  Your fingers should be poised just
 :over the keys gently brushing them.  Use the thumb or any finger of your left
 :hand for other keys, such as the SPACE bar.
 :
 :After entering each line, hit the ENTER key with the 6-finger (the third finger
 :of your right hand).  Immediately return your finger to the 6 key.  It is very
 :important that you bring the finger back without looking.
Q: Press Y to continue, or Fkey12 to exit 
N:_N_R_L0

#                                                              ../orig/n.typ:22
I:Use your third finger only.
*:_N_R_L1
#                                                              ../orig/n.typ:23
O:666666
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L1

#                                                              ../orig/n.typ:24
I:Use your second finger for the 5.
*:_N_R_L2
#                                                              ../orig/n.typ:25
O:6565656
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L2

#                                                              ../orig/n.typ:26
I:Use your first finger for the 4.
*:_N_R_L3
#                                                              ../orig/n.typ:27
O:666444555444666
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L3

#                                                              ../orig/n.typ:28
I:Now let's try several lines.
*:_N_R_L4
#                                                              ../orig/n.typ:36
P:666444666
 :444555666
 :555444555
 :666444666
 :646464646
 :656565656
 :445566555
 :456456456
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L4

#                                                              ../orig/n.typ:37
I:Use your second finger for the period.
*:_N_R_L5
#                                                              ../orig/n.typ:38
O:555...555
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L5

*:_N_R_L6
#                                                              ../orig/n.typ:43
P:5.54.45.56.6
 :444.555
 :45.56.6
 :64.65.4
 :54.65.4
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L6

*:_N_R_L7
#                                                              ../orig/n.typ:48
P:445566.654
 :654456.546
 :546546.564
 :554466.645
 :555444.666
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L7

#                                                              ../orig/n.typ:49
I:Use your first finger for the 1-key.
*:_N_R_L8
#                                                              ../orig/n.typ:50
O:444111444.444111444
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L8

*:_N_R_L9
#                                                              ../orig/n.typ:55
P:111.444
 :414.141
 :456.546
 :415.164
 :541.146
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L9

#                                                              ../orig/n.typ:56
I:Now, let's review the keys we've learned.
*:_N_R_L10
#                                                              ../orig/n.typ:57
O:444555666111...555444666111
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L10

*:_N_R_L11
#                                                              ../orig/n.typ:66
P:414.564
 :546.145
 :546.145
 :644.146
 :615.645
 :564.145
 :546.164
 :111.555
 :514.651
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L11

G:_N_E_N1
#------------------------------------------------------------------------------
# Lesson N2
#------------------------------------------------------------------------------
*:N2
*:_N_S_N2
#                                                              ../orig/n.typ:69
I:First, let's review the keys from lesson 1.
*:_N_R_L12
#                                                              ../orig/n.typ:70
O:444.555.666.111.6541.6541
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L12

#                                                              ../orig/n.typ:71
I:Use your 5-finger for the 2 key.
*:_N_R_L13
#                                                              ../orig/n.typ:72
O:555222555.525.525.525
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L13

*:_N_R_L14
#                                                              ../orig/n.typ:79
P:45.25
 :52.52
 :62.62
 :22.22
 :51.12
 :12.52
 :24.42
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L14

#                                                              ../orig/n.typ:80
I:Use your 6-finger for the 3 key.
*:_N_R_L15
#                                                              ../orig/n.typ:81
O:666333666.636.636
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L15

*:_N_R_L16
#                                                              ../orig/n.typ:88
P:456.123
 :321.654
 :666.333
 :323.353
 :343.313
 :353.363
 :313.434
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L16

*:_N_R_L17
#                                                              ../orig/n.typ:97
P:12.33
 :45.33
 :65.35
 :12.35
 :65.25
 :25.63
 :43.53
 :13.36
 :34.31
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L17

#                                                              ../orig/n.typ:98
I:Use your 4-finger for the zero.
*:_N_R_L18
#                                                              ../orig/n.typ:99
O:444000444.401.410
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L18

*:_N_R_L19
#                                                             ../orig/n.typ:100
O:410.020.030.040.060.104
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L19

*:_N_R_L20
#                                                             ../orig/n.typ:106
P:12.00
 :23.00
 :51.50
 :46.25
 :54.00
 :13.04
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L20

#                                                             ../orig/n.typ:107
I:Use your 5-finger for the 8-key.
*:_N_R_L21
#                                                             ../orig/n.typ:108
O:555888555.852.258
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L21

*:_N_R_L22
#                                                             ../orig/n.typ:109
O:585.080.808.818.282
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L22

*:_N_R_L23
#                                                             ../orig/n.typ:115
P:81.05
 :84.80
 :88.88
 :58.28
 :80.18
 :28.38
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L23

#                                                             ../orig/n.typ:116
I:Use your 6-finger for the 9-key.
*:_N_R_L24
#                                                             ../orig/n.typ:117
O:666999666.393.696
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L24

*:_N_R_L25
#                                                             ../orig/n.typ:118
O:595.989.696.393.295
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L25

*:_N_R_L26
#                                                             ../orig/n.typ:126
P:.91
 :.90
 :.94
 :.95
 :.96
 :.93
 :.90
 :.95
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L26

#                                                             ../orig/n.typ:127
I:And, the last number is 7. (Use your 4-finger for it.)
*:_N_R_L27
#                                                             ../orig/n.typ:128
O:444777444.0147.7410
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L27

*:_N_R_L28
#                                                             ../orig/n.typ:129
O:767.737.797.727.707.717
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L28

*:_N_R_L29
#                                                             ../orig/n.typ:130
O:1234567890.1234567890
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L29

*:_N_R_L30
#                                                             ../orig/n.typ:140
P:17.19
 :71.70
 :19.37
 :57.07
 :71.37
 :27.72
 :37.73
 :76.67
 :45.17
 :70.07
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L30

*:_N_R_L31
#                                                             ../orig/n.typ:149
P:75856
 :87237
 :21570
 :24870
 :47258
 :21573
 :21573
 :21584
 :35827
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L31

G:_N_E_N2
#------------------------------------------------------------------------------
# Lesson N3
#------------------------------------------------------------------------------
*:N3
*:_N_S_N3
#                                                             ../orig/n.typ:152
I:First, let's review all the numbers.
*:_N_R_L32
#                                                             ../orig/n.typ:153
O:1234567890.0987654321
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L32

*:_N_R_L33
#                                                             ../orig/n.typ:154
O:12.34.56.78.90.10.29.38.47.57
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L33

*:_N_R_L34
#                                                             ../orig/n.typ:165
P:123.654
 :212.658
 :908.000
 :285.080
 :288.381
 :398.813
 :286.187
 :924.156
 :684.028
 :354.459
 :321.840
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L34

*:_N_R_L35
#                                                             ../orig/n.typ:178
P:12345
 :35840
 :25874
 :93682
 :71489
 :31265
 :97824
 :28617
 :39715
 :17935
 :28460
 :52846
 :28469
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L35

*:_N_R_L36
#                                                             ../orig/n.typ:187
P:1.00
 :2.05
 :3.50
 :4.52
 :5.81
 :6.95
 :7.00
 :8.45
 :9.50
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L36

*:_N_R_L37
#                                                             ../orig/n.typ:195
P:879.359
 :286.498
 :357.159
 :654.852
 :159.357
 :571.392
 :284.293
 :231.879
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L37

*:_N_R_L38
#                                                             ../orig/n.typ:203
P:100.200
 :258.246
 :369.741
 :123.987
 :582.714
 :239.900
 :273.194
 :372.973
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L38

#                                                             ../orig/n.typ:204
I:Use any finger of your left hand for the SPACE bar.
*:_N_R_L39
#                                                             ../orig/n.typ:205
O:111 222 333 444 555 666 777 888 999 000
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L39

*:_N_R_L40
#                                                             ../orig/n.typ:211
P:123 654 879 264
 :128 364 928 187
 :987 234 681 287
 :357 159 671 077
 :350 950 137 940
 :320 487 364 197
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L40

*:_N_R_L41
#                                                             ../orig/n.typ:220
P:82.01 35
 :28.50 12
 :50.00 79
 :40.25 37
 :82.50 19
 :99.95 61
 :12.95 87
 :40.00 55
 :64.50 99
Q: Press Y to continue, N to repeat, or Fkey12 to exit 
N:_N_R_L41

G:_N_E_N3
#------------------------------------------------------------------------------
# Lesson series N jump tables
#------------------------------------------------------------------------------
*:_N_E_N1
Q: Do you want to continue to lesson N2 [Y/N] ? 
N:_N_MENU
G:_N_M_N2
*:_N_E_N2
Q: Do you want to continue to lesson N3 [Y/N] ? 
N:_N_MENU
G:_N_M_N3
*:_N_E_N3
G:_N_MENU

*:_N_M_N1
B:                             Lesson N1
K:12:_N_MENU
G:_N_S_N1
*:_N_M_N2
B:                             Lesson N2
K:12:_N_MENU
G:_N_S_N2
*:_N_M_N3
B:                             Lesson N3
K:12:_N_MENU
G:_N_S_N3
#------------------------------------------------------------------------------
# Lesson series N menu
#------------------------------------------------------------------------------
*:_N_MENU
*:_N_MENU_PAGE0
B:                 Lesson selection menu - series N
K:1:_N_M_N1
K:2:_N_M_N2
K:3:_N_M_N3
K:4:NULL
K:5:NULL
K:6:NULL
K:7:NULL
K:8:NULL
K:9:NULL
K:10:NULL
K:11:NULL
K:12:_N_QEXIT
T:The N series contains the following 3 lessons:
 :
 :        Fkey 1 - Lesson N1     4 5 . 6 1
 :        Fkey 2 - Lesson N2     2 3 0 8 9 7
 :        Fkey 3 - Lesson N3     Practise
 :
 :
 :
 :
 :
 :
 :
 :
 :
 :        Fkey12 - Leave this lesson series
Q: Please select a lesson, or Fkey12 to exit 
G:_N_MENU_PAGE0
*:_N_QEXIT
Q: Do you want to leave this lesson series? [Y/N] ? 
N:_N_MENU
G:_N_EXIT
*:_N_EXIT
#------------------------------------------------------------------------------
# End of file n.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
# Series menu
#==============================================================================
*:__SERIESMENU
K:1:__S_Q_SERIES
K:2:__S_R_SERIES
K:3:__S_T_SERIES
K:4:__S_V_SERIES
K:5:__S_U_SERIES
K:6:__S_D_SERIES
K:7:__S_M_SERIES
K:8:__S_S_SERIES
K:9:__S_N_SERIES
K:10:NULL
K:11:__MENUHELP
K:12:__SERIESQEXIT
*:__SERIESMENU_DISP
B:                       Series selection menu
T:The following 9 lesson series are available:
 :
 :        Fkey 1 - Series Q     Quick QWERTY course (Q1 - Q5)
 :        Fkey 2 - Series R     Long QWERTY course  (R1 - R14)
 :        Fkey 3 - Series T     QWERTY touch typing (T1 - T16)
 :        Fkey 4 - Series V     Yet Another QWERTY  (V1 - V19)
 :        Fkey 5 - Series U     QWERTY Review       (U1 - U13)
 :        Fkey 6 - Series D     Dvorak touch typing (D1 - D14)
 :        Fkey 7 - Series M     Typing drills       (M1 - M11)
 :        Fkey 8 - Series S     Speed drills        (S1 - S4)
 :        Fkey 9 - Series N     Calculator keypad   (N1 - N3)
 :
 :
 :        Fkey11 or Ctrl-A - Help on using function keys
 :        Fkey12           - Exit the program
Q: Please select a series, or Fkey12 to exit 
G:__SERIESMENU_DISP
*:__MENUHELP
T:
 :                      Function key help screen
 :
 :Use the function keys on the keyboard to navigate through the lesson
 :series and lesson selection menus.  In a lesson series, pressing the
 :function key Fkey12 will return you to the series menu; when already at
 :the series menu, it will take you to the main program menu.  At the
 :main program menu, Fkey12 exits the program.
 :
 :If a lesson series has more than one menu page of lessons, use Fkey11 to
 :go to the additional pages.
 :
 :When in an exercise, you can use the Esc key to abort the drill or test.
 :
 :If you do not have function keys available on your terminal, or if they
 :do not work for some reason (for example, they are intercepted by
 :another program), you can use Ctrl keys instead.  Ctrl-Q to Ctrl-P are
 :alternatives for Fkey1 to Fkey10, and Ctrl-A and Ctrl-S for Fkey11
 :and Fkey12.
Q: Press Y to continue, or Fkey12 to exit 
Y:__SERIESMENU_DISP
G:__MENUHELP
*:__SERIESQEXIT
Q: Do you want to exit the program ? [Y/N] ? 
N:__SERIESMENU
G:__SERIESEXIT
*:__SERIESEXIT
#==============================================================================
