/*
 * Mouse handling
 *
 * Copyright (C) Evan Harris, 1994, 1995.
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

#include "vga16.h"
#include "mouse.h"


#define LIGHT 0
#define DARK 1

#define MOUSE_IMAGE_PTS 37

struct mouse_image_data {
    int x_offset;
    int y_offset;
    int colour;
};

struct mouse_image_data mouse_image_data[MOUSE_IMAGE_PTS] = {
{ 0, 0, LIGHT },
{ 1, 0, LIGHT },
{ 2, 0, LIGHT },
{ 3, 0, LIGHT },
{ 4, 0, LIGHT },
{ 5, 0, LIGHT },
{ 0, 1, LIGHT },
{ 1, 1, DARK },
{ 2, 1, DARK },
{ 3, 1, LIGHT },
{ 0, 2, LIGHT },
{ 1, 2, DARK },
{ 2, 2, DARK },
{ 3, 2, LIGHT },
{ 4, 2, LIGHT },
{ 0, 3, LIGHT },
{ 1, 3, LIGHT },
{ 2, 3, LIGHT },
{ 3, 3, DARK },
{ 4, 3, LIGHT },
{ 5, 3, LIGHT },
{ 0, 4, LIGHT },
{ 2, 4, LIGHT },
{ 3, 4, LIGHT },
{ 4, 4, DARK },
{ 5, 4, LIGHT },
{ 6, 4, LIGHT },
{ 0, 5, LIGHT },
{ 3, 5, LIGHT },
{ 4, 5, LIGHT },
{ 5, 5, DARK },
{ 6, 5, LIGHT },
{ 7, 5, LIGHT },
{ 4, 6, LIGHT },
{ 5, 6, LIGHT },
{ 6, 6, LIGHT },
{ 5, 7, LIGHT },
};


void
RenderMousePointer(int x, int y, int light, int dark, int width, int height)
{
    int i;
    
    for (i = 0; i < MOUSE_IMAGE_PTS; i++) {
	if (x + mouse_image_data[i].x_offset < width &&
	    y + mouse_image_data[i].y_offset < height) {
	    if (mouse_image_data[i].colour == LIGHT) {
		vga16_setpixel(light, x + mouse_image_data[i].x_offset,
			       y + mouse_image_data[i].y_offset);
	    } else {
		vga16_setpixel(dark, x + mouse_image_data[i].x_offset,
			       y + mouse_image_data[i].y_offset);
	    }
	}
    }
}


void
RestoreUnderMousePointer(int x, int y, int width, int height, int *colour)
{
    int i;

    for (i = 0; i < MOUSE_IMAGE_PTS; i++) {
	if (x + mouse_image_data[i].x_offset < width &&
	    y + mouse_image_data[i].y_offset < height) {
	    vga16_setpixel(colour[i], x + mouse_image_data[i].x_offset,
			   y + mouse_image_data[i].y_offset);
	}
    }
}


void
SaveUnderMousePointer(int x, int y, int width, int height, int *colour)
{
    int i;
    
    for (i = 0; i < MOUSE_IMAGE_PTS; i++) {
	if (x + mouse_image_data[i].x_offset < width &&
	    y + mouse_image_data[i].y_offset < height) {
	    colour[i] = vga16_getpixel(x + mouse_image_data[i].x_offset,
				       y + mouse_image_data[i].y_offset);
	}
    }
}
