/* Definitions for game transport protocol.
   Copyright (C) 1996, 1997 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

typedef struct a_rui {
    int rid;
    int active;
} RUI;

extern int numremotes;
extern int numremotewaiting;
extern int my_rid;
extern int master_rid;
extern int tmprid;
extern int downloading;

extern void init_remote_ui PARAMS ((Side *side));

extern void init_file_port PARAMS ((int hosting));
extern void add_remote_player PARAMS ((char *name));
extern void download_to_player PARAMS ((Player *player));
extern int send_packet PARAMS ((int id, char *buf));
extern void low_file_send PARAMS ((int id, char *buf));

extern int launch_game PARAMS ((void));
extern void set_you_player PARAMS ((int id));

extern void send_game_checksum PARAMS ((int rid));
extern void broadcast_game_checksum PARAMS ((void));
extern void send_version PARAMS ((int rid));
extern int send_join PARAMS ((char *str));
extern void send_assignment PARAMS ((int id, Side *side, Player *player));
extern void send_id PARAMS ((int id));
extern void send_randstate PARAMS ((int id));
extern void broadcast_next_action PARAMS ((Unit *unit));
extern void send_quit PARAMS ((void));
extern void close_file_port PARAMS ((void));
extern void receive_data PARAMS ((int timeout));
extern void receive_packet PARAMS ((int id, char *buf));
extern int low_file_receive PARAMS ((int *id, char *buf, int maxchars, int timeout));
