.\" X-BASED SKEWB
.\"
.\" xskewb.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 97	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH XSKEWB 6 "10 November 1997" "V5.4"
.SH NAME
xskewb \- Skewb X widgets
.SH SYNOPSIS
.B /usr/games/xskewb
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-mono]
[-{foreground|fg} <color>] [-{background|bg} <color>]
[-{border|bd} <color>] [-face{0|1|2|3|4|5} <color>]
[-[no]orient] [-[no]practice] [-username {string}]
.SH DESCRIPTION
.LP
The original puzzle has each face cut by a diamond, so that there are 5
pieces, 4 corner pieces and one diamond piece in the center.  The was
designed by Uwe Meffert and called the Pyraminx Cube.  Douglas
Hofstadter later coined it a Skewb and it stuck.  The puzzle has period
3 turning (i.e. each half turns with 120 degree intervals).  The Skewb
has 2^5*3^8*6!/2^6 or 3,149,280 different combinations (with centers
oriented 2^5*3^8*6!/2 or 100,766,960 different combinations).
.sp
More recently, Disney released Mickey's Challenge, its a spherical skewb
with a pretty good internal mechanism.  Mickey's challenge has
2^5*3^8*6!/36 5,598,720 visually different combinations).  It also comes
with a pretty neat book.  Also released is the Creative Puzzle Ball or
Meffert's Challenge which has 4 rings in different colors.
.sp
Mach Balls of the Hungarian Gyula Mach are similar but they do not have
a ratchet mechanism and do not turn as easily or smoothly.  One must
match the 12 different symbols of 4 each at the 12 intersection points.
.SH FEATURES
.LP
Press "\fBmouse-left\fP" button to move a piece.  Release
"\fBmouse-left\fP" button on a piece on the same face.  (Click on the
diamonds are ignored).  The pieces will then turn towards where the mouse
button was released.
.LP
Press "\fBmouse-center\fP", or press "\fBP\fP" or "\fBp\fP" keys to toggle
the practice mode (in practice mode the record should say "practice").
One must double click on "\fBmouse-center\fP" if the puzzle is being worked
on.  This is good for learning moves and experimenting.
.LP
Click "\fBmouse-right\fP", or press "\fBR\fP" or "\fBr\fP" keys to randomize
(this must be done first to set a new record).  One must double click on
"\fBmouse-right\fP" if the puzzle is being worked on.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to toggle the orient mode.  One has to
orient the faces in orient mode, besides getting all the faces to be the
same color.  To do this one has to get the lines to be oriented in the
same direction, this only matters with center diamond piece.  This does add
complexity so there are 2 sets of records.
.LP
"\fBS\fP" or "\fBs\fP" keys reserved for the auto-solver (unimplemented).
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo move.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to write or save a puzzle.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Use the key pad, "R" keys, or arrow keys to move without mouse clicks.
.br
Key pad is defined for the Skewb2d as:
.br
  /     Counterclockwise
.sp
7 8 9   Upper Left, Up, Upper Right
.br
  ^
.br
4<5>6   Left, Clockwise, Right
.br
  v
.br
1 2 3   Lower Left, Down, Lower Right
.br
Note: Top, Left, Right, and Bottom only work when the control key is
pressed and there is no analog for the Skewb3d.
.sp
If the mouse is on a diamond, the above keys will not move cube because the
move is ambiguous.  Also if the mouse is on a triangle, not all the keys
will function because the puzzle will only rotate on the cuts, i.e. a
triangle with a Upper Left - Lower Right cut will rotate only Upper Left &
Lower Right, a triangle with a Upper Right - Lower Left cut will rotate
only Upper Right & Lower Left.  Therefore, a triangle can only move
tangential to the center of the face. No doubt this is confusing, but the
physical skewb is the same way. In fact, that is part of its appeal.
.sp
Key pad for Rubik3d, use must use your intuition (is this a cop out or
what?).  The key pad is defined differently depending on which side of the
cube your mouse is pointing at.  One thing that stays the same is "5" is
Clockwise and "/" is Counterclockwise.
.LP
.LP
Use the control key and the left mouse button, keypad, or arrow keys to
move the whole cube.  This is not recorded as a turn.
.LP
The title is in the following format (non-motif version):
.RS    
xskewb{2|3}d<dimension>: (<Number of moves>/{<Record number of moves>
<username>|"NEVER noaccess"|"practice"}) - <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the skewb window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-mono
This option allows you to access the mono mode on a color monitor
(resource name "\fImono\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the skewb window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the skewb window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the cubelets in the skewb
window (resource name "\fIborderColor\fP").
.TP 8
.B \-face{0|1|2|3|4|5} <\fIcolor\fP>
This option allows you to change the color of a face (resource name
"\fIfaceColorN\fP"). In mono-mode, color is represented as the first letter
of the color name. On the 2-D version, the faces are ordered top to bottom
and left to right on the "t" configuration. The "+-" configuration is
physically consistent with the former, so it is ordered "0, 1, 2, 3, 5, 4".
If you has two colors that begin with the same letter you should have one
in uppercase and one in lowercase to distinguish them in mono-mode. You can
change the colors of the faces to make a stupid cube (i.e. all White or in
mono-mode all "W"). Unfortunately, it will not normally say its solved when
its randomized. This would be cheating.
.TP 8
.B \-[no]orient
This option allows you to access the orient mode (resource name
"\fIorient\fP").
.TP 8
.B \-[no]practice
This option allows you to access the practice mode (resource name
"\fIpractice\fP").
.TP 8
.B \-username \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.SH SAVE FORMAT
The format is not standard.  The reason for this is that this is simple and
I do not know what the standard is.
.sp  
Skewb2d with default colors, not randomized:
.br
  0       R     Red
.br 
1 2 3   B W G   Blue, White, Green
.br       
  4       P     Pink
.br
  5       Y     Yellow
.sp
.RS
orient: 0-1 <0 false, 1 true; if 1 then lines on cubies to be oriented>
.br
practice: 0-1 <0 false, 1 true>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <2 dimensional array of face and corner position and
center diamond position, each face has 4 corner pieces and one center
piece, if orient mode then orientation number follows face number: 0 up,
1 right, 2 down, and 3 left>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <face> <corner> <direction> <control>
.RE
Each turn is with respect to a corner on a face.
.br
The corners start at the upper right and work clockwise.
.br
Direction is represented as 0 upper right, 1 lower right, 2 lower left,
3 upper left, 5 clockwise, 7 counterclockwise, 8 up, 9 right, 10 down,
and 11 left.
.br
Control is represented as 0 or 1, 1 if the whole cube is moved at once
(here the corner does not matter), 0 if not.  The xskewb record keeper does
not count a control move as a move, but here we do.
.sp
Caution: the program may crash on corrupted input.
.SH REFERENCES
Beyond Rubik's Cube: spheres, pyramids, dodecahedrons and God knows what
else by Douglas R. Hofstadter, Scientific American, July 1982, pp 16-31.
.sp
Mickey's Challenge by Christoph Bandelow.
.sp
Magic Cubes 1996 Catalog of Dr. Christoph Bandelow.
.SH SEE ALSO
.LP
X(1), xrubik(6), xdino(6), xpyraminx(6), xoct(6), xmball(6),
xmlink(6), xpanex(6), xcubes(6), xtriangles(6), xhexagons(6), xabacus(1)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-97, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author
.RS
David Albert Bagley, <\fIbagleyd@bigfoot.com\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIftp://ftp.tux.org/pub/people/david-bagley/xpuzzles\fP
.br
\fIftp://ftp.x.org/contrib/games\fP

