#include <ctype.h>
#include <string.h>

#include "../include/strexp.h"


char **strexp(char *str, int *n)
{
	char **ret;
	char *head, *tail;
	int num;
        int len;


	/* return NULL if given an empty string */
	if(!str)
		return(NULL);

	num = 0;
	head = tail = str;
	ret = NULL;

	/* iterate while we're inside the string */
	while(*head)
	{
		/* skip to next non-blank character */
		while(isblank(*head))
			head++;

		/* find next blank character */
		tail = head;
		while(*tail && !isblank(*tail))
			tail++;

		/* determine length of substring */
		len = (tail - head);

		/* add string to list */
		num++;
		ret = (char **)realloc(ret, num*sizeof(char *));
		ret[num - 1] = (char *)malloc(len + 1);

		/* copy string over and null-terminate */
		strncpy (ret[num - 1], head, len);
		ret[num-1][len] = '\0';

		/* get ready for next substring */
		head = tail;
	}

	/* we're done... */
	*n = num;
	return ret;
}

char **strchrexp(char *str, char c, int *n)
{
	char **ret;
	char *head, *tail;
	int num;
        int len;


	/* return NULL if given an empty string */
	if(!str)
		return(NULL);

	num = 0;
	head = tail = str;
	ret = NULL;

	/* iterate while we're inside the string */
	while (*head && *tail)
	{
		/* find next blank character */
		tail = head;
		while (*tail && (*tail != c))
			tail++;

		/* determine length of substring */
		len = (tail - head);

		/* add string to list */
		num++;
		ret = (char **)realloc(ret, num*sizeof(char *));
		ret[num - 1] = (char *)malloc(len + 1);

		/* copy string over and null-terminate */
		strncpy (ret[num - 1], head, len);
		ret[num-1][len] = '\0';

		/* get ready for next field */
		head = tail + 1;
	}

	/* we're done... */
	*n = num;
	return ret;
}
