#include <unistd.h>
#include <errno.h>

#include "solaris-io.h"

void
outb(unsigned short int port, unsigned char data) 
{
    iopbuf tmpbuf;
    
    tmpbuf.port = port;
    tmpbuf.port_value = data;
    if(ioctl(iopfd, IOPWRITE, &tmpbuf)) {
	perror("IOCTL failed");
    }
}

unsigned int
inb(unsigned short int port)
{
    iopbuf tmpbuf;
    tmpbuf.port = port;
    if (ioctl(iopfd, IOPREAD, &tmpbuf)) {
	perror("IOCTL failed");
    }
    return tmpbuf.port_value;
}
