/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    A pix_buf

    Copyright (c) 1997-1998 Mark Danks
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_PIX_BUF_H_
#define INCLUDE_PIX_BUF_H_

#include "Base/GemBase.h"
#include "Base/GemPixUtil.h"
#include "Base/GemState.h"

class GemCache;

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    pix_buf
    
    Creates a pix_buf

KEYWORDS
    pix
    
DESCRIPTION
    This makes an assumption that the size of the image doesn't
    	change once the rendering has started    

-----------------------------------------------------------------*/
class GEM_EXTERN pix_buf : public GemBase
{
    CPPEXTERN_HEADER(pix_buf, GemBase)

    public:

	    //////////
	    // Constructor
    	pix_buf();
    	
    protected:
    	
    	//////////
    	// Destructor
    	virtual ~pix_buf();

    	//////////
    	// Do the rendering
    	virtual void 	render(GemState *state);

    	//////////
    	// After the rendering
    	virtual void 	postrender(GemState *state);

    	//////////
    	virtual void	startRendering();
    	
    	//////////
    	virtual void	stopRendering();
    	
    	//////////
    	// Clean everything up
    	void	    	cleanImage();
    	   	
    	//////////
    	// The buffered block
    	pixBlock    	m_pixBlock;
    	
    	//////////
    	// The old cache
    	GemCache    	*m_oldcache;
};

#endif	// for header file
