// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLAllocator.C

  Stephane Rehel

  November 28 1996
*/

#include <stdio.h>

#include "kernel/MLKernel.h"

#include "Interface.h"
#include "KoalaNodeTypes.h"

#include "MLAllocator.h"

#include "MLModule.h"
#include "MLCanvas.h"
#include "MLEngine.h"
#include "MLScrollingDialog.h"

/////////////////////////////////////////////////////////////////////////////

// never called
MLAllocator::MLAllocator()
{}

/////////////////////////////////////////////////////////////////////////////

// never called
MLAllocator::~MLAllocator()
{}

/////////////////////////////////////////////////////////////////////////////

//static const int max_modules= 100;
//static MLModule** modules= 0;
//static int nModules= 0;

//static const int max_canvas= 500;
//static MLCanvas** canvas= 0;
//static int nCanvas= 0;

//static const int max_engines= 2000;
//static MLEngine** engines= 0;
//static int nEngines= 0;

static const int max_scrolling_dialogs= 1000;
static MLScrollingDialog** scrolling_dialogs= 0;
static int nScrollingDialogs= 0;

Interface* MLAllocator::interface= 0;
MLKernel* MLAllocator::kernel= 0;

/////////////////////////////////////////////////////////////////////////////

// static
void MLAllocator::init( Interface* _interface )
{
  interface= _interface;
  kernel= _interface->getKernel();

  int i;

//  assert( modules == 0 );
//  modules= new MLModule* [ max_modules + 1 ];
//  nModules= 0;
//  for( i= 0; i <= max_modules; ++i )
//    modules[i]= 0;

//  assert( canvas == 0 );
//  canvas= new MLCanvas* [ max_canvas + 1 ];
//  nCanvas= 0;
//  for( i= 0; i <= max_canvas; ++i )
//    canvas[i]= 0;

//  assert( engines == 0 );
//  engines= new MLEngine* [ max_engines + 1 ];
//  nEngines= 0;
//  for( i= 0; i <= max_engines; ++i )
//    engines[i]= 0;

  assert( scrolling_dialogs == 0 );
  scrolling_dialogs= new MLScrollingDialog* [ max_scrolling_dialogs + 1 ];
  nScrollingDialogs= 0;
  for( i= 0; i <= max_scrolling_dialogs; ++i )
    scrolling_dialogs[i]= 0;
}

/////////////////////////////////////////////////////////////////////////////

// static
/*
int MLAllocator::allocModule( MLModule* m )
{
  if( m == 0 )
    return 0;

  if( nModules >= max_modules )
    {
    fprintf( stderr, "ML panic: too many modules (%d)\n", max_modules );
    return 0;
    }

  if( modules[nModules+1] == 0 )
    {
    int i= nModules+1;
    modules[i]= m;
    ++nModules;
    if( nModules >= max_modules )
      nModules= 1;

    m->alloc_object_id= i;
    return i;
    }

  for( int i= 1; i <= max_modules; ++i )
    {
    if( modules[i] == 0 )
      {
      modules[i]= m;
      ++nModules;
      m->alloc_object_id= i;
      return i;
      }
    }

  return 0; // never reached
}
*/

/////////////////////////////////////////////////////////////////////////////

/*
// static
int MLAllocator::allocCanvas( MLCanvas* c )
{
  if( c == 0 )
    return 0;

  if( nCanvas >= max_canvas )
    {
    fprintf( stderr, "ML panic: too many canvas (%d)\n", max_canvas );
    return 0;
    }

  if( canvas[nCanvas+1] == 0 )
    {
    int i= nCanvas+1;
    canvas[i]= c;
    ++nCanvas;
    if( nCanvas >= max_canvas )
      nCanvas= 1;

    c->alloc_object_id= i;
    return i;
    }

  for( int i= 1; i <= max_canvas; ++i )
    {
    if( canvas[i] != 0 )
      {
      canvas[i]= c;
      ++nCanvas;
      c->alloc_object_id= i;
      return i;
      }
    }

  return 0; // never reached
}
*/

/////////////////////////////////////////////////////////////////////////////

/*
// static
int MLAllocator::allocEngine( MLEngine* e )
{
  if( e == 0 )
    return 0;

  if( nEngines >= max_engines )
    {
    fprintf( stderr, "ML panic: too many engines (%d)\n", max_engines );
    return 0;
    }

  if( engines[nEngines+1] == 0 )
    {
    int i= nEngines+1;
    engines[i]= e;
    ++nEngines;
    if( nEngines >= max_engines )
      nEngines= 1;

    e->alloc_object_id= i;
    return i;
    }

  for( int i= 1; i <= max_engines; ++i )
    {
    if( engines[i] != 0 )
      {
      engines[i]= e;
      ++nEngines;
      e->alloc_object_id= i;
      return i;
      }
    }

  return 0; // never reached
}
*/

/////////////////////////////////////////////////////////////////////////////

// static
int MLAllocator::allocScrollingDialog( MLScrollingDialog* sd )
{
  if( sd == 0 )
    return 0;

  if( nScrollingDialogs >= max_scrolling_dialogs )
    {
    fprintf( stderr, "ML panic: too many dialogs (%d)\n",
                     max_scrolling_dialogs );
    return 0;
    }

  if( scrolling_dialogs[nScrollingDialogs+1] == 0 )
    {
    int i= nScrollingDialogs+1;
    scrolling_dialogs[i]= sd;
    ++nScrollingDialogs;
    if( nScrollingDialogs >= max_scrolling_dialogs )
      nScrollingDialogs= 1;

    sd->alloc_object_id= i;
    return i;
    }

  for( int i= 1; i <= max_scrolling_dialogs; ++i )
    {
    if( scrolling_dialogs[i] != 0 )
      {
      scrolling_dialogs[i]= sd;
      ++nScrollingDialogs;
      sd->alloc_object_id= i;
      return i;
      }
    }

  return 0; // never reached
}

/////////////////////////////////////////////////////////////////////////////

// static
MLModule* MLAllocator::getModule( int id )
{
  MLNode* node= kernel->getNode(id);
  if( node == 0 )
    return 0;

  KoalaNodeTypes* types= interface->getKoalaNodeTypes();

  if( node->getNodeType() != types->module )
    return 0;

  return (MLModule*) node;
/*
  if( id < 1 || id > max_modules )
    return 0;

  return modules[id];
*/
}

/////////////////////////////////////////////////////////////////////////////

// static
MLCanvas* MLAllocator::getCanvas( int id )
{
  MLNode* node= kernel->getNode(id);
  if( node == 0 )
    return 0;

  KoalaNodeTypes* types= interface->getKoalaNodeTypes();

  if( node->getNodeType() != types->canvas )
    return 0;

  return (MLCanvas*) node;

/*
  if( id < 1 || id > max_canvas )
    return 0;

  return canvas[id];
*/
}

/////////////////////////////////////////////////////////////////////////////

// static
MLEngine* MLAllocator::getEngine( int id )
{
  MLNode* node= kernel->getNode(id);
  if( node == 0 )
    return 0;

  KoalaNodeTypes* types= interface->getKoalaNodeTypes();

  if( node->getNodeType() != types->engine )
    return 0;

  return (MLEngine*) node;

/*
  if( id < 1 || id > max_engines )
    return 0;

  return engines[id];
*/
}

/////////////////////////////////////////////////////////////////////////////

// static
MLScrollingDialog* MLAllocator::getScrollingDialog( int id )
{
  if( id < 1 || id > max_scrolling_dialogs )
    return 0;

  return scrolling_dialogs[id];
}

/////////////////////////////////////////////////////////////////////////////

/*
// static
void MLAllocator::freeModule( int id )
{
  if( id >= 1 && id <= max_modules )
    modules[id]= 0;
}
*/

/////////////////////////////////////////////////////////////////////////////

/*
// static
void MLAllocator::freeCanvas( int id )
{
  if( id >= 1 && id <= max_canvas )
    canvas[id]= 0;
}
*/

/////////////////////////////////////////////////////////////////////////////

/*
// static
void MLAllocator::freeEngine( int id )
{
  if( id >= 1 && id <= max_engines )
    engines[id]= 0;
}
*/

/////////////////////////////////////////////////////////////////////////////

// static
void MLAllocator::freeScrollingDialog( int id )
{
  if( id >= 1 && id <= max_scrolling_dialogs )
    scrolling_dialogs[id]= 0;
}

/////////////////////////////////////////////////////////////////////////////

/*
// private static
void MLAllocator::freeModule( MLModule* m )
{
  if( m == 0 )
    return;

  assert( findModule(m) == m->getID() ); // is it the good one?

  freeModule(m->getID());
}
*/

/////////////////////////////////////////////////////////////////////////////

/*
// private static
void MLAllocator::freeCanvas( MLCanvas* c )
{
  if( c == 0 )
    return;

  assert( findCanvas(c) == c->getID() ); // is it the good one?

  freeCanvas(c->getID());
}
*/

/////////////////////////////////////////////////////////////////////////////

/*
// private static
void MLAllocator::freeEngine( MLEngine* e )
{
  if( e == 0 )
    return;

  assert( findEngine(e) == e->getID() ); // is it the good one?

  freeEngine(e->getID());
}
*/

/////////////////////////////////////////////////////////////////////////////

// private static
void MLAllocator::freeScrollingDialog( MLScrollingDialog* sd )
{
  if( sd == 0 )
    return;

  assert( findScrollingDialog(sd) == sd->getID() ); // is it the good one?

  freeScrollingDialog(sd->getID());
}

/////////////////////////////////////////////////////////////////////////////

/*
// private static
int MLAllocator::findModule( MLModule* m )
{
  if( m == 0 )
    return 0;

  for( int i= 1; i <= max_modules; ++i )
    if( modules[i] == m )
      return i;

  return 0;
}
*/

/////////////////////////////////////////////////////////////////////////////

/*
// private static
int MLAllocator::findCanvas( MLCanvas* c )
{
  if( c == 0 )
    return 0;

  for( int i= 1; i <= max_canvas; ++i )
    if( canvas[i] == c )
      return i;

  return 0;
}
*/

/////////////////////////////////////////////////////////////////////////////

/*
// private static
int MLAllocator::findEngine( MLEngine* e )
{
  if( e == 0 )
    return 0;

  for( int i= 1; i <= max_engines; ++i )
    if( engines[i] == e )
      return i;

  return 0;
}
*/

/////////////////////////////////////////////////////////////////////////////

// private static
int MLAllocator::findScrollingDialog( MLScrollingDialog* sd )
{
  if( sd == 0 )
    return 0;

  for( int i= 1; i <= max_scrolling_dialogs; ++i )
    if( scrolling_dialogs[i] == sd )
      return i;

  return 0;
}

/////////////////////////////////////////////////////////////////////////////

