// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  PhotoPopups.C

  Stephane Rehel

  October 25 1997
*/

#include "interface/MLPopup.h"
#include "interface/MLButtonsPanel.h"

#include "PhotoModule.h"

#include "PhotoPopups.h"

/////////////////////////////////////////////////////////////////////////////

PhotoPopups::PhotoPopups( PhotoModule* _photo )
{
  photo= _photo;
}

/////////////////////////////////////////////////////////////////////////////

PhotoPopups::~PhotoPopups()
{}

/////////////////////////////////////////////////////////////////////////////

// called by PhotoModule::init()
void PhotoPopups::init( MLButtonsPanel* buttons )
{
  MLPopup* p;

  // File
  p= new MLPopup(photo);
  popups.file= p;

  open= p->add("Open Image");

#ifndef NDEBUG
  p= new MLPopup(photo);
  photo_open_test= p->getPopupLabel();
  buttons->setButton(15,"TEST",p);
#endif

  // Quit
  p= new MLPopup(photo);
  popups.quit= p;
  quit= p->getPopupLabel();

  buttons->setButton( 1,  "File", popups.file );
  buttons->setButton( 20, "Quit", popups.quit );
}

/////////////////////////////////////////////////////////////////////////////

void PhotoPopups::updateFlags()
{}

/////////////////////////////////////////////////////////////////////////////
