/****************************************************************************
** main.cpp 19980824 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft, Andreas Mustun.  All rights reserved.
**
*****************************************************************************/


#include <qapplication.h>
#include <qdatetime.h>
#include <qfileinfo.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qplatinumstyle.h>
#include <qtimer.h>
#include <qwindowsstyle.h>

#include "rappwin.h"
#include "rconfig.h"
#include "rfonts.h"
#include "rconfig.h"
#include "rlog.h"

int 
main(int argc, char** argv) {

  int ret;

  QApplication app(argc, argv);

  // Read INI/CXL-File:
  //
  QFileInfo prgInfo(argv[0]);
  QDir prgDir(prgInfo.dirPath(true));
  RCONFIG->setPrgDir(prgDir);        // CWD is program directory
  RCONFIG->createConfigFile(false);  // Create config file ~/.qcad/qcad.conf if there's none
  RCONFIG->readConfigFile();         // Read config file
  RCONFIG->createLanguageList();     // Compile the list of available languages (for Options dialog)
  RCONFIG->readCxlFile();            // Read language file

  RAppWin* appWin = RAppWin::getRAppWin();

  // Set Application style:
  //
  QApplication::setStyle( new QWindowsStyle() );
  //QApplication::setStyle( new QPlatinumStyle() );
  app.setMainWidget(appWin);

  // Show application window:
  //
  appWin->show();
  appWin->resizeChildren();
 
  // Show Intro:
  //
#ifndef DEF_LESS_DIALOGS
  appWin->showIntro();
  QTimer::singleShot(1500, appWin, SLOT(closeIntro()));
#endif

  // Read Fonts:
  //
  RFonts::getRFonts();

#ifdef DEF_DEMO
  QDate today = QDate::currentDate();
  QDate expiryDate;
  
  expiryDate.setYMD(DEF_EXPIRY_DATE);
  
  if(today>=expiryDate) {
    QMessageBox::warning(appWin, DEF_APPNAME, DEF_EXPIRED_MESSAGE);
  }
  else {
    char msg[255];
    sprintf(msg, "%s %d %s", RMES(420), today.daysTo(expiryDate), RMES(421));
    QMessageBox::warning(appWin, DEF_APPNAME, msg);
  }
#endif

  // Load file if given:
  //
  if(argc>1) {
    for(int i=1; i<argc; ++i) {
      appWin->fileOpen(argv[i]);
    }
  }
  
  // Execute application:
  //
  ret=app.exec();

  RCONFIG->createConfigFile(true);

  return ret;

}


// EOF








