/***************************************************************************
                          rfile.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rfile.h 1998/09/25 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RFILE_H
#define RFILE_H

#include <qfile.h>
#include <qstring.h>
#include <qwidget.h>

/*! Copy file _source to _dest 
    \param _source String which contains absolute path of source file
    \param _dest   String which contains absolute path of destination file
    \param _what   What is this file? (A very brief description of the file for overwrite warning)
    \param _parent Parent Widget (used for overwrite warning)
    
    \return true if the file was copied
*/
bool     fileCopy(QString _source, QString _dest, const char* _what, QWidget* _parent=0);

/*! Show file overwrite warning
    \param _file Path and name of the file
    \param _what   What is this file? (A very brief description of the file)
    \param _parent Parent Widget
    
    \return true if the user gave his OK for the overwriting
*/
bool     fileOverwriteWarning(const char* _file, const char* _what, QWidget* _parent=0);

/*! Delete a file with warning
    \param _file   Path and name of the file
    \param _what   What is this file? (A very brief description of the file)
    \param _parent Parent Widget
    
    \return true if the file was successfully removed
*/
bool     fileDelete(const char* _file, const char* _what, QWidget* _parent=0);

/*! Check file format<br>
    The file format must look like this example:<br>
    # Format: CAM Expert Font<br>
    # Version: 2.0.0<br>
    \param _file Path and name of the file
    \param _format String which must stand after "# Format:" or 0
    \param _version String which must stand after "# Version:" or 0
    
    \return true if the Format is OK
*/
bool     fileCheckFormat(const char* _file, const char* _format, const char* _version=0);

/*! Get Format info
    The file format must look like this example:<br>
    # Format: CAM Expert Font<br>
    # Version: 2.0.0<br>
    \param _file Path and name of the file
    \param _name String which's value we want ("Format" for the value after "# Format:"
    \param _value The function fills this memory with the result
    \param _maxLength maximal Length for _value
    
    \return The value after this string or 0
*/
void     fileGetFormatInfo(const char* _file, const char* _name, char* _value, int _maxLength);


/**
 * Searchs a file with a given subdir and a file name.
 */
QString  fileSearchFile(QString _subdir, QString _name);


/**
 * Searchs a subdir.
 */
QString  fileSearchSubdir(QString _subdir);


#endif


// EOF

