/***************************************************************************
                          rinputdialog.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rinputdialog.h 1998/09/03 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RINPUTDIALOG_H
#define RINPUTDIALOG_H

#include <qdialog.h>

#define DEF_INPUTDLG_WIDTH  256
#define DEF_INPUTDLG_HEIGHT 120

class RLabel;
class RLineEdit;
class RComboBox;
class RGraphic;

class RInputDialog : public QDialog
{
  Q_OBJECT
public:
  /*! Constructor for a textline input
      \param _label   Label (Message)
      \param _maxLen  Max length for input
      \param _default Default value
      \param _parent  Parent widget
  */
  RInputDialog(const char* _label,
               int _maxLen=255,
               const char* _default=0, 
               QWidget* _parent=0, 
               const char* _name=0);
               
  /*! Constructor for a combobox input
      \param _label   Label (Message)
      \param _maxLen  Max length for input
      \param _default Default value
      \param _typ     Typ of combobox ('l'=Layer)
      \param _rw      true = Read and write
      \param _graphic Pointer to graphic doc or 0
      \param _parent  Parent widget
  */
  RInputDialog(const char* _label,
               const char* _default, 
               char _typ,
               bool _rw,
               RGraphic* _graphic,
               QWidget* _parent, 
               const char* _name=0);
               
  ~RInputDialog();
  
private:
  
  /*! Create static elements
      \param _label   Label (Message)
      \param _maxLen  Max length for input
      \param _default Default value
  */
  void createStaticElements(const char* _label);


public:
  const char* getInput();
    
private:
  QPushButton* bOk;
  QPushButton* bCancel;
  QPushButton* bHelp;

  RLabel*      lText;
  RLineEdit*   eInput;
  RComboBox*   cInput;
  
};


#endif

// EOF

