/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _HEIGHT_FIELD_H
#define _HEIGHT_FIELD_H


#include "glib--glist.h"
#include "HeightFieldCore.h"
#include "RenderOptions.h"
#include "tf_glistFlexArr.h"
#include <time.h>

#define PTYPE			float
#define TF_DEFAULT_FILENAME	"Untitled"

/*
 *  HeightField: a class to hold the basic info for 1 height field
 */ 
class HeightField : public HeightFieldCore
	{
	public:
				HeightField(PTYPE *_hf, int xsize, int ysize, char *name=NULL);
				HeightField(int xsize=0, int ysize=0, char *name=NULL);
				~HeightField();

		// other methods 
		void		init (PTYPE *hf, int xsize, int ysize, 
				      char *name=NULL, bool keepDerived=FALSE);
		static char	*getNewName ();		// generate a new name
		PTYPE		*getCopyOfData ();	// get a copy of the physical data array 
		PTYPE		*releaseData ();	// release the data pointer (be Careful!)
		void		newHF (int xsize, int ysize, bool generateName=FALSE);
		void		backup ();		// create a backup
		void		restoreBackup ();	// restore the backup
		void		destroyBackup ();	// clear backup
		void		destroyContourList ();	// clear conour line list

		// accessors which return data 
		bool		isLoadedFromFile ()	{return b_loadedFromFile;}
		bool		isSaved ()		{return b_isSaved;}
		bool		haveBackup ()		{return (p_hfBck ? TRUE : FALSE);}
		char		*getName ()		{return p_name;}
		Glib_GList	*getContourList ()	{return p_contourList;}
		RenderOptions	*getRenderOptions ()	{return p_renderOptions;}
		time_t		getUpdateTime ()	{return d_updateTime;}
		time_t		getBackupTime ()	{return d_backupTime;}

		// mutators to change data 
		void		setName (char *name);
		void		setSaved (bool isSaved, bool keepDerived=FALSE);
		void		setContourList(TFGListFlexArr *l, time_t timestamp);
		void		setRenderOptions (RenderOptions *r);

		// inline 
		void		setLoadedFromFile (bool lff) { b_loadedFromFile = lff; }

	protected:
		char			*p_name;
		Glib_GList		*p_contourList;
		RenderOptions		*p_renderOptions;
		bool			b_loadedFromFile;
		bool			b_isSaved;
		static int		s_HFcount;		// counter for versioning

	private: 
		PTYPE			*p_hfBck,		// backup copy
					p_hfBckSealevel;	// waterlevel of backup
		time_t			d_updateTime,
					d_backupTime,
					d_contourTime;		// contour list 
	};


#endif // _HEIGHT_FIELD_H
