/******************************************************************************
    Xplanet 0.43 - render an image of the earth into an X window
    Copyright (C) 1999 Hari Nair <hari@alumni.caltech.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

******************************************************************************/

#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

enum projection       { MERCATOR, ORTHOGRAPHIC };
enum ortho_pos        { FIXED, SUNREL, DAYSIDE, NIGHTSIDE, 
			MOONSIDE, EARTHSIDE };
enum render           { ROOT, WINDOW, ANIMATE, OUTPUT };

class options 
{
 public:
  char        *background;
  int          blend;
  int          body;
  int          centx;
  int          centy;
  char        *cloud;
  char        *color;
  char        *day;
  float        dellat;
  float        dellon;
  char        *dem;
  float        demscale;
  render       display;
  char        *font;
  int          fuzz;
  int          grid;
  int          gridspace;
  int          label;
  float        localtime;
  int          markers;
  char        *markerfile;
  projection   mode;
  char        *night;
  float        obslat, obslon;
  char        *output;
  ortho_pos    position;
  int          radius;
  float        range;
  float        rotate;
  float        shade;
  int          size;
  float        star_den;
  int          swap;
  struct timeval time;
  char        *title;
  int          trans;

  unsigned int window_width;
  unsigned int window_height;
  int          window_x;
  int          window_y;
  unsigned int temp;
  int          label_x;
  int          label_y;
  int          label_mask;
  Window       XID;

  options() 
    {
      background       = NULL;
      blend            = 0;
      body             = 0;
      centx            = -1;
      centy            = -1;
      cloud            = NULL; 
      color            = NULL;
      day              = NULL;
      dellon           = 0;
      dellat           = 0;
      dem              = NULL;
      demscale         = 0.05;
      display          = ROOT;
      font             = NULL;
      fuzz             = 6;
      grid             = 0;
      gridspace        = 90;
      label            = 0;
      label_x          = -15;
      label_y          = 15;
      label_mask       = XNegative;
      localtime        = 999;
      markers          = 0;
      markerfile       = NULL;
      mode             = MERCATOR;
      night            = NULL;
      obslat           = 0;
      obslon           = 0;
      output           = NULL;
      position         = FIXED;
      radius           = 50;
      range            = 1000;
      rotate           = 0;
      shade            = 0.3;
      star_den         = 1E-3;
      swap             = 0;
      trans            = 1;
      window_width     = 512;
      window_height    = 512;
      window_x         = 0;
      window_y         = 0;
      XID              = 0;
      gettimeofday (&time, NULL);
    }
  
}; 

extern options opts;

extern void process_args (int argc, char **argv);
