/* Zgv v3.3 - GIF, JPEG and PBM/PGM/PPM viewer, for VGA PCs running Linux.
 * Copyright (C) 1993-1999 Russell Marks. See README for license details.
 *
 * zgv.h - constants, typedefs.
 */

#define ZGV_VER		"3.3"


#define _PIC_OK			 0
#define _PICERR_NOFILE		-1
#define _PICERR_NOMEM		-2
#define _PICERR_BADMAGIC	-3
#define _PICERR_NOCOLOURMAP	-4
#define _PICERR_NOIMAGE		-5
#define _PICERR_UNSUPPORTED	-6
#define _PICERR_CORRUPT		-7
#define _PICERR_SEE_ERRMSG	-8
#define _PICERR_ISRLE		-9
#define _PICERR_TOOMANYCOLS	-10
#define _PICERR_BADXCOL		-11
#define _PICERR_BADTIFFRUN	-12

/* macro often used to close input file and return an error from above */
#define CLOSE_AND_RET(x)	do { fclose(in); return(x); } while(0)


typedef struct
  {
  int width,height;
  int bpp,numcols;
  char type[4];
  } PICINFO;

typedef void (*hffunc)(int,int);

typedef unsigned char byte;

extern int idx_light,idx_medium,idx_dark,idx_black;
extern int tagview_mode;
extern int zgv_ttyfd;
extern int has_mouse;
extern char jpeg_png_errmsg[];
extern int fs_vgamode;		/* needed by msgbox() and helppage() */

extern void wait_for_foreground(void);

/* vgadrawtext_bmp() needs to know what the current colour is, so... */
extern int current_colour;
#define vga_setcolor(x) vga_setcolor(current_colour=(x))
