// dbfile.h
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef DBFILE_H
#define DBFILE_H

#include "qsofile.h"

class RDbFile : public RQsoFile {

    typedef struct field_entry {
       char            name[11];
       char            type;
       char            filler1[4]; 
       unsigned char  length;
       unsigned char  decimals;
       char            filler2[2];
       char            work_area;
       char            filler3[10];
       char            index_key;
    } FieldEntry;

    typedef struct dbase_header {
       char             db_version;
       char             update_year;
       char             update_month;
       char             update_day;
       unsigned long   num_recs;
       unsigned short  header_length;
       unsigned short  record_length;
       char             filler1[2];
       char             transact_flag;
       char             encrypt_flag;
       char             filler2[12];
       char             mdx_flag;
       char             filler3[3];
    } DBHeader;

    DBHeader dbheader;

    boolean writeFieldEntry(char *fieldName, char fieldType,
                            unsigned char fieldSize, unsigned char decimalSize = 0);
    void writeField(const char *fieldInfo, const unsigned char dataLength,
                        const unsigned char writeLength);
    
public:

    RDbFile();
    RDbFile(char *name);
#ifdef LINUX
    boolean open(char *name, int mode = ios::in);
#else
    boolean open(char *name, int mode = ios::in | ios::binary);
#endif
    virtual boolean close();

    boolean writeHeader(header_data newheader);  /* Write new header to the file. */
    virtual boolean nextQso(qso_data *);         /* Return next generic QSO record. */
    virtual boolean writeQso(qso_data *);        /* Write a generic QSO record */
};
#endif
