// qsofile.cpp
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include "qsofile.h"

#include <string.h>

static char *contestName[] = {NULL, "SS", "ARRLDX", "CQWW", "WPX", "IARU", "ARRL10",
                               "ARRL160", "CQ160", "FD", "CQP", "ARDXDX", "WAE", "VHFQSO",
                               "DXPED", "AA", "NAQP", "GRIDLOC", "YODX", "KCJ", "1010",
                               "SPRINT", "SAC", "TOEC", "JADX", "ARCI", "IOTA", "INTSPR",
                               "QSO", "STEWP", "HELV", "WAG", "ARI"};

RQsoFile::RQsoFile()
{
    location = 0;
    headerWritten = FALSE;
    memset(&header, '\0', sizeof(header_data));
    memset(&fileOptions, '\0', sizeof(struct fileoptions_struct));
}

boolean RQsoFile::setOptions(char *cmdLine)
{
    char *tmpPtr;
    
    if (strstr(cmdLine, "-tApproach"))
        fileOptions.time = TIME_APPROACH;

    if (strstr(cmdLine, "-bNumeric"))
        fileOptions.band = BAND_METERS;

    if (strstr(cmdLine, "-freq"))
        fileOptions.fields |= FIELD_FREQ;

    if (strstr(cmdLine, "-qsonum"))
        fileOptions.fields |= FIELD_QSONUM;

    if ((tmpPtr = strstr(cmdLine, "-c")) != NULL)
    {
        tmpPtr += 2;
        for (unsigned char c = 1; c <= MAX_CONTEST; c++)
            if (strncmp(tmpPtr, contestName[c], strlen(contestName[c])) == 0)
            {
                header.contest = c;
                break;
            }
    }

    if ((tmpPtr = strstr(cmdLine, "-n")) != NULL)
    {
        char *cpNote = fileOptions.szNote;
        
        memset(cpNote, '\0', NOTE_SIZE);

        while (*tmpPtr != '"')          // Read up to the next quote character
            tmpPtr++;

        tmpPtr++;
        while (*tmpPtr != '"')          // Keep copying the note field until another
            *cpNote++ = *tmpPtr++;       // quote character is found.
    }

    return TRUE;
}


