// sdffile.h
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef _SDFFILE_H_
#define _SDFFILE_H_

#include "qsofile.h"
#include "areafile.h"

/*#define CT8_CALL_SIZE           32
#define CT8_NAME_SIZE           32
#define CT8_ADDRESS_SIZE        64
#define CT8_TOWN_SIZE           32
#define CT8_STATE_SIZE          8
#define CT8_ZIP_SIZE            16
#define CT8_ZONE_SIZE           8
#define CT8_GRID_SIZE           8
#define CT8_CLUB_SIZE           64
#define CT8_CHECK_SIZE          4
#define CT8_SECTION_SIZE        8*/

class RSdfFile : public RQsoFile {

private:
    RAreaFile *areaFile;
    
public:

typedef struct log_data_struct  // binary records kept in .BIN file 
{
   char call[11];         // callsign of station worked
   char prefix[4];
   char zone[2];
   char band[2];
   char mode;
   char confirmed;
   char date[6];
   char time[4];
   char receivedRST[3];
   char sentRST[3];
   char printQSL;
   char notes[30];
   char countsCW;
   char countsDXCC;
   char oblast[2];
   char submitARRL;
   char submitCQ;
   char QSOYL;
   char SatQSO;
   char QSLSendDate[6];
   char state[2];
   char IOTA[5];
   char QSLSentVia;
   char MgrNum;
   char grid[4];
   char QRP;
   char County[25];
   char TenTenNum[6];
} sdf_log_data;

    RSdfFile()                   {location = 0;};
    RSdfFile(char *name);
#ifdef LINUX
    boolean open(char *name, int mode = ios::in);
#else
    boolean open(char *name, int mode = ios::in | ios::binary);
#endif
    virtual boolean nextQso(qso_data *);         /* Return next generic QSO record */
    virtual boolean writeQso(qso_data *);        /* Write a generic QSO record */
    virtual boolean writeHeader(header_data);

};

#endif
