#include <termios.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <ncurses.h>

#include "afos.h"

/*
 * $Id: afui.c,v 1.10 1996/09/18 18:14:31 ron Exp $
 */
#define TITLE_STRING	"Skywarn AFOS Processing System"
FILE *disp_fp ;
static WINDOW *wp ;

typedef struct _AFUI_HANDLER_ {
	int (*key_handler)();
	int (*display_refresh)();
	int (*update)();
	} AFUI_HANDLER ;

static int title_key_handler() ;
static int title_display() ;
static int log_key_handler() ;
static int log_display() ;
static int monitor_key_handler() ;
static int monitor_display() ;
static int monitor_update() ;
static int status_key_handler() ;
static int status_display() ;
static int status_update() ;
static int filter_key_handler() ;
static int filter_display() ;
static int filter_update() ;
static int afui_update() ;

static AF_HIST *filter_set_pointer(int count) ;

static AFUI_HANDLER *display_state ;
static AFUI_HANDLER title_display_state = 
	{ title_key_handler, title_display, NULL } ;
static AFUI_HANDLER log_display_state = 
	{ log_key_handler, log_display, NULL } ;
static AFUI_HANDLER monitor_display_state = 
	{ monitor_key_handler, monitor_display, monitor_update } ;
static AFUI_HANDLER status_display_state = 
	{ status_key_handler, status_display, status_update } ;
static AFUI_HANDLER filter_display_state = 
	{ filter_key_handler, filter_display, filter_update } ;

static int filter_page ;
static AF_HIST *filter_page_pointer ;

#define FILTDISP_LINES 23
#define FILTDISP_COLS  1


static int 
filter_number_on_list()
{
	AF_HIST *p ;
	int count ;

	count = 0 ;
	for (p = history_list ; p ; p = p->next )
		count++ ;

	return count ;
}

static AF_HIST *filter_set_pointer(int count)
{
	AF_HIST *p; 
	int i ;

	p = history_list ;
	i = 0 ;

	while ( p && ( i < count ) )
	{
		p = p->next ;
		i++ ;
	}
	
	/* 
		p either points to the appropriate node,
		  or its NULL (loop hit end of list)
	 */
	return p ;
}

static int filter_key_handler(int dat)
{
	AF_HIST *p;

	switch (dat)
	{
		case 'k':
			if ( filter_page )
			{
				filter_page-- ;
				p = 
				filter_set_pointer(filter_page*(FILTDISP_LINES*FILTDISP_COLS));
				if ( !p )
				{
					filter_page = 0 ;
					filter_page_pointer = history_list ;
					clear();
				}
				else
				{
					filter_page_pointer = p ;
					clear();
				}
				filter_update();
			}
			break ;
		case ' ':
		case 'j':
			filter_page++ ;
			p = 
			 filter_set_pointer(filter_page*(FILTDISP_LINES*FILTDISP_COLS));
			if ( !p )
				filter_page -- ;
			else
			{
				filter_page_pointer = p ;
				clear();
			}
			filter_update();
			break;
		case 'q':
		default :
			display_state = &title_display_state ;
			display_state->display_refresh();
			return ;
		break;
	}
}

static int filter_display() 
{
	clear();
	filter_page = 0 ;
	filter_page_pointer = history_list ;
	filter_update();
}

static int filter_update() 
{
	AF_HIST *p;
	AF_CHANNEL_LINK *l ;
	int count ;
	int i;

	mvwprintw(wp,0,0,
	"     Product: ---- Channels ------------------------------------ "
	"Page %d of %d",
	filter_page+1, filter_number_on_list()/(FILTDISP_LINES*FILTDISP_COLS)+1 ) ;
	count = 0 ;
	for ( p = filter_page_pointer ; p ; p = p->next )
	{
		mvwprintw(wp, 1 + (count % FILTDISP_LINES), 40*(count/FILTDISP_LINES),
			"%12s:", p->name ) ;
		wclrtoeol(wp);
		i = 0 ;
		for ( l = p->chanlist ; l ; l = l->next )
		{
			mvwprintw (wp, 1 + (count%FILTDISP_LINES),
						  40*(count/FILTDISP_LINES) + 14 + i * 10,
						  "%-9s", l->channel->name ) ;
			if (++i > 5 )
				break ;
		}

		if (++count >=  ( FILTDISP_LINES * FILTDISP_COLS) )
			break ;
	}
	refresh ();
}

static int log_key_handler() 
{
	int dat ;
	int ret ;

#ifdef DISPLAY_DEBUG
	fprintf(stderr,"log_key_handler sees a '%c'\n", dat ) ;
#endif
	logwin_disable_display();
	display_state = &title_display_state ;
	display_state->display_refresh();
}

static int log_display()
{
	clear();
	mvwprintw(wp,0,0,"Raw AFOS input dump.  Press any key to return to menu");
	mvwprintw(wp,1,0,"-----------------------------------------------------");
	mvwprintw(wp,2,0,"");
	refresh();
	logwin_enable_display();
}
static int monitor_key_handler(int dat) 
{
	switch (dat)
	{
		case ' ':
		case 'q':
		default :
			display_state = &title_display_state ;
			display_state->display_refresh();
			return ;
		break;
	}
}
static int monitor_display() 
{
	clear();
	monitor_update();
}

#define HISTDISP_LINES 23
#define HISTDISP_COLS  4
static int monitor_update() 
{
	AF_HIST *p;
	int count ;

	mvwprintw(wp,0,13,"-----------------  PIL TALLY SCREEN  -----------------");
	count = 0 ;
	for ( p = history_list ; p ; p = p->next )
	{
		mvwprintw(wp, 1 + (count % HISTDISP_LINES), 20*(count/HISTDISP_LINES),
			"%12s:%-6d", p->name, p->count ) ;

		if (++count > ( HISTDISP_LINES * HISTDISP_COLS) )
			break ;
	}
	refresh ();
}

static 
title_display()
{
	clear();
	mvwprintw(wp,5,40-strlen(TITLE_STRING)/2,TITLE_STRING);
	mvwprintw(wp,6,40-strlen(af_release_version)/2,af_release_version);
	mvwprintw(wp,7,40-strlen("Test Link Time:")/2,"Test Link Time:");
	mvwprintw(wp,8,40-strlen(af_link_time)/2,af_link_time);
	mvwprintw(wp,9,40-strlen(af_link_date)/2,af_link_date);
	mvwprintw(wp,11,40-strlen("Copyright 1996  Ron Luse,  KD9KX")/2,
							  "Copyright 1996  Ron Luse,  KD9KX");
	mvwprintw(wp,20,8,
"----------------------------------------------------------------");
	mvwprintw(wp,21,8,
"  Menu:  ( Hit one of the following keys to change display )    ");
	mvwprintw(wp,22,8,
"  L:view incoming AFOS data   M:Monitor   S:view channel stats  ");
	mvwprintw(wp,23,8,
"----------------------------------------------------------------");
	refresh();
}
static 
title_key_handler( int dat )
{
	int ret ;
#ifdef DISPLAY_DEBUG
	fprintf(stderr,"title_key_handler sees a '%c'\n", dat ) ;
#endif

	if ( ( dat == 'l' ) || ( dat == 'L' ) )
	{
		display_state = &log_display_state ;
		display_state->display_refresh();
	}
	if ( ( dat == 's' ) || ( dat == 'S' ) )
	{
		display_state = &status_display_state ;
		display_state->display_refresh();
	}
	if ( ( dat == 'm' ) || ( dat == 'M' ) )
	{
		display_state = &monitor_display_state ;
		display_state->display_refresh();
	}
	if ( ( dat == 'f' ) || ( dat == 'F' ) )
	{
		display_state = &filter_display_state ;
		display_state->display_refresh();
	}
}

static int status_key_handler(int dat)
{
	display_state = &title_display_state ;
	display_state->display_refresh();
}

static int 
status_update() 
{
	PORT_STRUCT *p ;
	APRS_STRUCT *a ;
	AF_CHANNEL *q ;
	int count ;

	mvwprintw(wp,0,19,"--------------Status  Screen--------------");
	mvwprintw(wp,1,0,"------ AFOS Input Details : ------");
	mvwprintw(wp,2,0,"AFOS input channel: '%s'",afos_in_channel_name);
	p = afos_in_channel->private ;
	if ( isatty(afos_in_channel->fd) ) {
		mvwprintw(wp,3,0,"AFOS input device : '%s'",
			p->device_name);
		mvwprintw(wp,4,0,"AFOS channel parms: %d,%d,%c,%d",
			p->baud, p->bits, p->parity, p->stops);
	}
	mvwprintw(wp,5,0,"character count        : %d",
		   filter_stats.char_count ) ;
	mvwprintw(wp,6,0,"zczc count             : %d",
		   filter_stats.zczc_count ) ;
	mvwprintw(wp,7,0,"nnnn count             : %d",
		   filter_stats.nnnn_count ) ;
	mvwprintw(wp,8,0,"buffer count           : %d",
		   filter_stats.buffer_count ) ;
	mvwprintw(wp,9,0,"incomplete buffer count: %d",
		   filter_stats.incomplete_buffers ) ;
	mvwprintw(wp,10,0,"match count            : %d",
		   filter_stats.match_count ) ;
	mvwprintw(wp,11,0,"buffer overrun count   : %d",
		   filter_stats.buffer_overruns ) ;
	mvwprintw(wp,12,0,"error character  count : %d",
		   filter_stats.errchar_count );
	if ( aprs_list )
	{
		mvwprintw(wp,13,0,"-------- APRS stats --------");
		a = aprs_list->channel->private ;
		p = a->aprs_pc->private ;
		mvwprintw(wp,14,0,"PC channel device : '%s'",
			p->device_name);
		mvwprintw(wp,15,0,"PC channel parms  : %d,%d,%c,%d",
			p->baud, p->bits, p->parity, p->stops);
		p = a->aprs_tnc->private ;
		mvwprintw(wp,16,0,"TNC channel device: '%s'",
			p->device_name);
		mvwprintw(wp,17,0,"TNC channel parms : %d,%d,%c,%d",
			p->baud, p->bits, p->parity, p->stops);
		mvwprintw(wp,18,0,"AFOS bytes sent  : %d",a->aprs_out_count );
		mvwprintw(wp,19,0,"TNC bytes echoed : %d",a->from_tnc_echo_count );
		mvwprintw(wp,20,0,"PC bytes echoed  : %d",a->from_pc_echo_count );
	}
	mvwprintw(wp,1,40," -Output Channel-  tx-msgs  tx-bytes");
	count = 0 ;
	for ( q = channel_list ; q ; q = q->next )
	{
		if (++count > 20)
			break ;
		mvwprintw(wp,count+1,40,"%-16s%10d%10d", 
					q->name, q->write_count, q->bytes_written);
	}
	refresh();
}

static int status_display() 
{
	clear();
	status_update();
}


afui_handler( void *private, int event )
{
	int dat ;
	int ret ;

	ret = read (0, &dat, 1 );
	if (ret != 1)
		return ;

#ifdef DISPLAY_DEBUG
	fprintf(stderr,"afui_handler sees a '%c'\n", dat ) ;
#endif

	if ( dat == 'Q' )
	{
		printf( "\r\nafosd received 'Q' command.\r\nExiting.\r\n");
		endwin();
		exit() ;
	}
	if (display_state)
		display_state->key_handler( 0xff & dat ) ;
}

afui_init()
{
	af_timeout_set_handler ( afui_update ) ;
	afloop_select_list_add( 0, afui_handler, NULL ) ;


#if 0
	disp_fp = fopen ( AFOS_TERM, "rw" ) ;
	if (disp_fp == NULL)
	{
		perror("afui_init can't open display device");
		exit (-1 ) ;
	}
	sp = newterm("linux", disp_fp, disp_fp );
	set_term ( sp ) ;
#endif
	wp = initscr ();
	cbreak();
	noecho();
	nonl();
/* Commented out to build on jv. --REL
	intrflush(wp, FALSE);
*/
	keypad(wp,TRUE);
/*
	init_time_window(wp);
	init_log_window(wp);
*/
	refresh();
	display_state = &title_display_state ;
	display_state->display_refresh();
}


afui_update()
{
	/* This code calls the appropriate state's update routine */
	if ( display_state->update )
		display_state->update();
}
