// ---------------------------------------------------------------------------
// - Argument.hpp                                                           -
// - aleph engine - argument class definition                               -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_ARGUMENT_HPP
#define  ALEPH_ARGUMENT_HPP

#ifndef  ALEPH_STRING_HPP
#include "String.hpp"
#endif

namespace aleph {

  /// The argument class defines a binding between a name and an index for
  /// the execution stack. The index is relative to the frame pointer. The 
  /// class behaves like the symbol class.
  /// @author amaury darsch

  class Argument : public Object {
  private:
    /// the argument name
    String d_name;
    /// the argument index
    long   d_index;
    /// the const flag
    bool   d_const;

  public:
    /// create a new argument with a name and an index
    /// @param name   the argument name
    /// @param index  the index in the interpreter stack
    Argument (const String& name, const long index);

    /// @return the class name
    String repr (void) const;

    /// set the const flag for this argument
    /// @param flag the flag to set
    void setconst (const bool flag);

    /// @return the const flag for this argument
    inline bool getconst (void) const {
      return d_const;
    }

    /// @return the argument name
    inline String getname (void) const {
      return d_name;
    }

    /// set this argument as a const object
    /// @param interp the current interpreter
    /// @param nset   the current nameset
    /// @param object the object to set
    Object* cdef (Interp* interp, Nameset* nset, Object* object);

    /// set this argument with an object
    /// @param interp the current interpreter
    /// @param nset   the current nameset
    /// @param object the object to set
    Object* vdef (Interp* interp, Nameset* nset, Object* object);

    /// evaluate an object in this argument
    /// @param interp the current interpreter
    /// @param nset   the current nameset
    /// @return the evaluated object
    Object* eval (Interp* interp, Nameset* nset);

  private:
    // make the copy constructor private
    Argument (const Argument&);
    // make the assignment operator private
    Argument& operator = (const Argument&);
  };
}

#endif
