// ---------------------------------------------------------------------------
// - Libasio.cpp                                                             -
// - aleph:sio library - declaration & implementation                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Meta.hpp"
#include "Interp.hpp"
#include "Terminal.hpp"
#include "Function.hpp"
#include "Predasio.hpp"
#include "Pathasio.hpp"
#include "Directory.hpp"
#include "InputFile.hpp"
#include "OutputFile.hpp"

extern "C" {
  aleph::Object* initialize (aleph::Interp* interp, aleph::Nameset* nset, 
			     aleph::Cons* args) {
    using namespace aleph;

    // make sure we are not called from something crazy
    if ((interp == nilp) || (nset == nilp)) return nilp;

    // create the aleph:sio nameset
    Nameset* aset = interp->mknset ("aleph", interp->getnset ());
    Nameset* asio = interp->mknset ("sio",   aset);

    // bind all symbols in the aleph.sio nameset
    asio->symcst ("Terminal",      new Meta (Terminal::mknew));
    asio->symcst ("Directory",     new Meta (Directory::mknew));
    asio->symcst ("InputFile",     new Meta (InputFile::mknew));
    asio->symcst ("InputTerm",     new Meta (InputTerm::mknew));
    asio->symcst ("ErrorTerm",     new Meta (OutputTerm::mkerr));
    asio->symcst ("OutputFile",    new Meta (OutputFile::mknew));
    asio->symcst ("OutputTerm",    new Meta (OutputTerm::mkout));

    // bind the predicates
    asio->symcst ("dir-p",         new Function (asio_dirp));
    asio->symcst ("file-p",        new Function (asio_filep));
    asio->symcst ("input-p",       new Function (asio_inputp));
    asio->symcst ("output-p",      new Function (asio_outputp));
    asio->symcst ("terminal-p",    new Function (asio_termp));
    asio->symcst ("directory-p",   new Function (asio_odirp));
    asio->symcst ("input-file-p",  new Function (asio_ifilep));
    asio->symcst ("input-term-p",  new Function (asio_itermp));
    asio->symcst ("output-file-p", new Function (asio_ofilep));
    asio->symcst ("output-term-p", new Function (asio_otermp));

    // bind other functions
    asio->symcst ("absolute-path", new Function (asio_absolute_path));
    asio->symcst ("relative-path", new Function (asio_relative_path));
    
    // not used but needed
    return nilp;
  }
}
