// ---------------------------------------------------------------------------
// - Iterator.cpp                                                            -
// - standard object library - iterator abstract class implementation        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Method.hpp"
#include "Boolean.hpp"
#include "Iterator.hpp"

namespace aleph {

  // evaluate this list with a member name

  Object* Iterator::eval (Interp* interp, Nameset* nset, const String& name) {
    return new Method (name, this);
  }

  // apply an iterator method by name

  Object* Iterator::apply (Interp* interp, Nameset* nset, const String& name,
			   Cons* args) {
    // evaluate the arguments
    Vector* argv = Vector::eval (interp, nset, args);
    long    argc = (argv == nilp) ? 0 : argv->length ();

    // dispatch 0 argument
    if ((name == "begin") && (argc == 0)) {
      delete argv;
      begin ();
      return nilp;
    }
    if ((name == "end") && (argc == 0)) {
      delete argv;
      end ();
      return nilp;
    }
    if ((name == "next") && (argc == 0)) {
      delete argv;
      next ();
      return nilp;
    }
    if ((name == "previous") && (argc == 0)) {
      delete argv;
      prev ();
      return nilp;
    }
    if ((name == "get-object") && (argc == 0)) {
      delete argv;
      return getobj ();
    }
    if ((name == "valid-p") && (argc == 0)) {
      delete argv;
      return new Boolean (valid ());
    }
    if ((name == "end-p") && (argc == 0)) {
      delete argv;
      return new Boolean (isend ());
    }

    // call the object method
    Object* result = nilp;
    try {
      result =  Object::apply (interp, nset, name, argv);
    } catch (...) {
      delete argv;
      throw;
    }
    return result;
  }
}
