// ---------------------------------------------------------------------------
// - csys.cxx                                                                -
// - standard system library - c system function implementation              -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cio.hxx"
#include "csys.hxx"
#include "cstring.hxx"
#include <time.h>
#include <stdlib.h>

namespace aleph {

  // write an assertion failure message

  void c_assert (const char* file, const long line) {
    int sid = c_stderr ();
    const char* banner1 = "assertion failure: in file ";
    c_write (sid, banner1, c_strlen (banner1));
    c_write (sid, file,   c_strlen (file));
    const char* banner2 = "at line ";
    c_write (sid, banner2, c_strlen (banner2));
    c_write (sid,line);
    c_write (sid,"\n",1);
  }

  // return the os dependant directory separator
  
  char c_dirsep (void) {
    return '/';
  }

  // return the native option separator

  char c_optsep (void) {
    return '-';
  }

  // exit unconditionnaly with a status code

  void c_exit (int status) {
    exit (status);
  }

  // pause for a certain time

  void c_sleep (const long time) {
    struct timespec tval;
    if (time <= 0) return;
    long sval = time / 1000;
    long nval = (time % 1000) * 1000;
    tval.tv_sec  = sval;
    tval.tv_nsec = nval;
    nanosleep (&tval, NULL);
  }
}
