// ---------------------------------------------------------------------------
// - t_cserial.cpp                                                           -
// - standard system library - serial function tester                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cserial.hxx"

int main (int, char**) {
  using namespace aleph;

  // test int conversion
  char iarray[4];
  c_ihton (0x12345678,iarray);
  if (iarray[0] != (char) 0x78)       return 1;
  if (iarray[1] != (char) 0x56)       return 1;
  if (iarray[2] != (char) 0x34)       return 1;
  if (iarray[3] != (char) 0x12)       return 1;
  if (c_intoh (iarray) != 0x12345678) return 1;

  // test long long int conversion
  char larray[8];
  c_llhton (0x0123456789abcdefLL,larray);
  if (larray[0] != (char) 0xef)       return 1;
  if (larray[1] != (char) 0xcd)       return 1;
  if (larray[2] != (char) 0xab)       return 1;
  if (larray[3] != (char) 0x89)       return 1;
  if (larray[4] != (char) 0x67)       return 1;
  if (larray[5] != (char) 0x45)       return 1;
  if (larray[6] != (char) 0x23)       return 1;
  if (larray[7] != (char) 0x01)       return 1;
  if (c_llntoh (larray) != 0x0123456789abcdefLL) return 1;

  // here it is
  return 0;
}
