/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.14 of 01-November-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * string.c ---		The Optional String Word Set
 * (duz 08Jul93)
 */

#include "forth.h"
#include "support.h"
#include "compiler.h"

#include <string.h>
#include <ctype.h>

#include "missing.h"


Code (dash_trailing)
{
  sp[0] = dash_trailing ((char *)sp[1], sp[0]);
}

Code (slash_string)
{
  uCell a = *sp++;
  if (a < sp[0])
    {
      sp[0] -= a;
      sp[1] += a;
    }
  else
    {
      sp[1] += sp[0];
      sp[0] = 0;
    }
}

Code (blank)
{
  memset ((char *)sp[1], ' ', (uCell)sp[0]);
  sp += 2;
}

Code (cmove)
{
  char *p = (char *)sp[2];
  char *q = (char *)sp[1];
  uCell n = sp[0];
  sp += 3;
  while (n--)
    *q++ = *p++;
}

Code (cmove_up)
{
  char *p = (char *)sp[2];
  char *q = (char *)sp[1];
  uCell n = sp[0];
  sp += 3;
  p += n;
  q += n;
  while (n--)
    *--q = *--p;
}

Code (compare)
{
  char *p1 = (char *)sp[3];
  uCell u1 = sp[2];
  char *p2 = (char *)sp[1];
  uCell u2 = sp[0];
  int d;

  sp += 3;
  if (u1 < u2)
    *sp = (d = memcmp (p1, p2, u1)) == 0
      ? -1
      : d < 0 ? -1 : 1;
  else
    *sp = (d = memcmp (p1, p2, u2)) == 0
      ? u1 == u2 ? 0 : 1
      : d < 0 ? -1 : 1;
}

Code (search)
{
  const char *p =
    search ((char *)sp[3], sp[2], (char *)sp[1], sp[0]);
  ++sp;
  if (p == NULL)
    sp[0] = FALSE;
  else
    {
      sp[0] = TRUE;
      sp[1] += (char *)sp[2] - p;
      sp[2] = (Cell)p;
    }
}

Code (sliteral)
{
  compile1 ();
  alloc_string ((char *)sp[1], sp[0]);
  sp += 2;
}
code (s_quote_execution);
COMPILES (sliteral, s_quote_execution,
	  SKIPS_STRING, DEFAULT_STYLE);


LISTWORDS (string) =
{
  CO ("-TRAILING",	dash_trailing),
  CO ("/STRING",	slash_string),
  CO ("BLANK",		blank),
  CO ("CMOVE",		cmove),
  CO ("CMOVE>",		cmove_up),
  CO ("COMPARE",	compare),
  CO ("SEARCH",		search),
  CS ("SLITERAL",	sliteral)
};
COUNTWORDS (string, "String + extensions");
