#
# $Header: /usr/local/cvsroot/pythondoc/geninfo.py,v 1.2 1999/05/01 00:59:44 daniel Exp $
#
# Copyright (C) Daniel Larsson
# All Rights Reserved.
#
# See copyright notice in the file 'LICENSE.TXT', which should have accompanied
# this distribution.
#

"""Document generation information.

Holding information about what the doc generator is currently doing.
This class is mainly used by the graphical interface to show progress.
"""

__author__ = "Daniel Larsson, Daniel.Larsson@telia.com"
__version__ = "$Revision: 1.2 $"[11:-2]

try:
    import threading

    class _Info:
	def __init__(self):
	    self.__lock = threading.RLock()
	    self.__message = ''
	    self.__stop = 0

	def message(self, msg):
	    """Send message to GUI.

	    Drops a message here for the GUI to pick up.
	    It also checks if the GUI asked the generation to stop,
	    and if so, exits gently.
	    """
	    if self.__stop:
		import sys
		sys.exit(0)
	    self.__lock.acquire()
	    self.__message = msg
	    print msg
	    self.__lock.release()

	def get_message(self):
	    self.__lock.acquire()
	    msg = self.__message
	    self.__lock.release()
	    return msg

	def stop(self):
	    self.__stop = 1

    _info = _Info()
    message = _info.message
    get_message = _info.get_message
    stop = _info.stop

except:

    def message(msg):
	pass

#
# $Log: geninfo.py,v $
# Revision 1.2  1999/05/01 00:59:44  daniel
# Fixed header.
#
# Revision 1.1  1999/05/01 00:59:23  daniel
# New file.
#
# 

    
