/********************************************************************************
*                                                                               *
*         M u l t i p l e   D o c u m e n t   C l i e n t   W i n d o w         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMDIClient.h,v 1.5 1999/11/09 23:58:37 jeroen Exp $                    *
********************************************************************************/
#ifndef FXMDICLIENT_H
#define FXMDICLIENT_H


class FXMDIChild;
  

// Base class for scrolled stuff
class FXAPI FXMDIClient : public FXScrollArea {
  FXDECLARE(FXMDIClient)
  friend class FXMDIChild;
protected:
  FXint       cascadex;           // Cascade offset X
  FXint       cascadey;           // Cascade offset Y
  FXint       xmin;               // Space taken up by all children
  FXint       xmax;
  FXint       ymin;
  FXint       ymax;
private:
  FXMDIChild *mdifirst;
  FXMDIChild *mdilast;
  FXMDIChild *active;
protected:
  FXMDIClient();
  void recompute();
  virtual void layout();
private:
  FXMDIClient(const FXMDIClient&);
  FXMDIClient &operator=(const FXMDIClient&);
public:
  long onChanged(FXObject*,FXSelector,void*);
  long onCmdActivateNext(FXObject*,FXSelector,void*);
  long onCmdActivatePrev(FXObject*,FXSelector,void*);
  long onCmdTileHorizontal(FXObject*,FXSelector,void*);
  long onCmdTileVertical(FXObject*,FXSelector,void*);
  long onCmdCascade(FXObject*,FXSelector,void*);
  long onUpdActivateNext(FXObject*,FXSelector,void*);
  long onUpdActivatePrev(FXObject*,FXSelector,void*);
  long onUpdTileVertical(FXObject*,FXSelector,void*);
  long onUpdTileHorizontal(FXObject*,FXSelector,void*);
  long onUpdCascade(FXObject*,FXSelector,void*);
  long onUpdClose(FXObject*,FXSelector,void*);
  long onUpdMenuClose(FXObject*,FXSelector,void*);
  long onUpdRestore(FXObject*,FXSelector,void*);
  long onUpdMenuRestore(FXObject*,FXSelector,void*);
  long onUpdMinimize(FXObject*,FXSelector,void*);
  long onUpdMenuMinimize(FXObject*,FXSelector,void*);
  long onUpdMaximize(FXObject*,FXSelector,void*);
  long onUpdMenuWindow(FXObject*,FXSelector,void*);
  long onCmdCloseDocument(FXObject*,FXSelector,void*);
  long onCmdCloseAllDocuments(FXObject*,FXSelector,void*);
  long onUpdCloseDocument(FXObject*,FXSelector,void*);
  long onUpdCloseAllDocuments(FXObject*,FXSelector,void*);
public:
  
  /// Construct MDI Client window
  FXMDIClient(FXComposite* p,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  
  /// Recalculate interior for scrollbars
  virtual void recalc();
  
  /// Move MDI Children around
  virtual void moveContents(FXint x,FXint y);

  /// Get first MDI Child
  FXMDIChild* getMDIChildFirst() const { return mdifirst; }

  /// Get last MDI Child
  FXMDIChild* getMDIChildLast() const { return mdilast; }

  /// Pass message to all MDI Child windows
  long forallWindows(FXObject* sender,FXSelector sel,void* ptr);
  
  /// Pass message to all MDI Child windows whose target is document
  long forallDocWindows(FXObject* document,FXObject* sender,FXSelector sel,void* ptr);
  
  /// Recompute content size
  virtual FXint getContentWidth();
  virtual FXint getContentHeight();
  
  /// For message forwarding
  virtual long handle(FXObject* sender,FXSelector key,void* data);
  
  /// Get current active child; may be NULL!
  FXMDIChild* getActiveChild() const { return active; }

  /// Set active MDI Child
  FXbool setActiveChild(FXMDIChild* child=NULL);
  
  /// Change cascade offset X
  void setCascadeX(FXint off){ cascadex=off; }
  
  /// Change cascade offset Y
  void setCascadeY(FXint off){ cascadey=off; }

  /// Get cascade offset X
  FXint getCascadeX() const { return cascadex; }

  /// Get cascade offset Y
  FXint getCascadeY() const { return cascadey; }

  /// Serialization
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  
  virtual ~FXMDIClient();
  };


#endif
