/********************************************************************************
*                                                                               *
*                                 Test Switcher                                 *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* $Id: switcher.cpp,v 1.2 1999/10/29 07:58:41 jeroen Exp $                      *
********************************************************************************/
#include "fx.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>



  
  
/*******************************************************************************/


// Switcher Test Window
class SwitcherTest : public FXMainWindow {
  FXDECLARE(SwitcherTest)
protected:
  FXMenuBar*         menubar;
  FXMenuPane*        filemenu;
  FXHorizontalFrame* contents;
  FXVerticalFrame*   buttons;
  FXSwitcher*        switcher;
  FXList*            simplelist;   
  FXFileList*        filelist;
  FXDirList*         dirlist;
protected:
  SwitcherTest(){}
public:
  SwitcherTest(FXApp *a);
  void create();
  };


/*******************************************************************************/
  

// SwitcherApp implementation
FXIMPLEMENT(SwitcherTest,FXMainWindow,NULL,0)

  
  
/*******************************************************************************/

  
// Make some windows
SwitcherTest::SwitcherTest(FXApp *a):FXMainWindow(a,"Switcher Test",NULL,NULL,DECOR_ALL,0,0,600,400){
  
  // Tooltip
  new FXTooltip(getApp());
  
  // Menubar
  menubar=new FXMenuBar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
  
  // Separator
  new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|SEPARATOR_GROOVE);

  // Contents
  contents=new FXHorizontalFrame(this,LAYOUT_SIDE_TOP|FRAME_NONE|LAYOUT_FILL_X|LAYOUT_FILL_Y|PACK_UNIFORM_WIDTH);

  // Buttons
  buttons=new FXVerticalFrame(contents,LAYOUT_FILL_Y|LAYOUT_LEFT|PACK_UNIFORM_WIDTH);
  
  // Switcher
  switcher=new FXSwitcher(contents,LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_RIGHT|FRAME_THICK|FRAME_RAISED);
  
  // First item in switcher is a list
  simplelist=new FXList(switcher,1,NULL,0,LIST_EXTENDEDSELECT);
  simplelist->appendItem("First Entry");
  simplelist->appendItem("Second Entry");
  simplelist->appendItem("Third Entry");
  simplelist->appendItem("Fourth Entry");
    
  // Second item is a file list
  filelist=new FXFileList(switcher,NULL,0,ICONLIST_EXTENDEDSELECT);
  
  // Third item is a directory list
  dirlist=new FXDirList(switcher,0,NULL,0,TREELIST_SHOWS_LINES|TREELIST_SHOWS_BOXES);
  
  // Add buttons
  new FXLabel(buttons,"These buttons below\nare connected to the\nFXSwitcher Control.\nSo they are checked\nautomatically depending\non the active page\nof the switcher.",NULL,LAYOUT_FILL_Y|JUSTIFY_LEFT|JUSTIFY_TOP);
  new FXButton(buttons,"&Simple List\tMake Switcher go to list",NULL,switcher,FXSwitcher::ID_OPEN_FIRST+0,FRAME_THICK|FRAME_RAISED);
  new FXButton(buttons,"&File List\tMake Switcher go to files",NULL,switcher,FXSwitcher::ID_OPEN_FIRST+1,FRAME_THICK|FRAME_RAISED);
  new FXButton(buttons,"&Tree List\tMake Switcher go to tree",NULL,switcher,FXSwitcher::ID_OPEN_FIRST+2,FRAME_THICK|FRAME_RAISED);
  
  // File Menu
  filemenu=new FXMenuPane(this);
  new FXMenuCommand(filemenu,"&Simple List",NULL,switcher,FXSwitcher::ID_OPEN_FIRST+0);
  new FXMenuCommand(filemenu,"&File List",NULL,switcher,FXSwitcher::ID_OPEN_FIRST+1);
  new FXMenuCommand(filemenu,"&Tree List",NULL,switcher,FXSwitcher::ID_OPEN_FIRST+2);
  new FXMenuCommand(filemenu,"Dump widgets",NULL,getApp(),FXApp::ID_DUMP);
  new FXMenuCommand(filemenu,"&Quit\tCtl-Q",NULL,getApp(),FXApp::ID_QUIT,0);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
  
  }
  

// Start
void SwitcherTest::create(){
  FXMainWindow::create();
  show();
  }


/*******************************************************************************/


// Start the whole thing
int main(int argc,char *argv[]){

  // Make application
  FXApp* application=new FXApp("Switcher","Test");
  
  // Open display
  application->init(argc,argv);
  
  new SwitcherTest(application);
  
  // Create app
  application->create();
  
  // Run
  application->run();
  }


