-----------------------------------------------------------------------
--          GtkAda - Ada95 binding for the Gimp Toolkit              --
--                                                                   --
--                     Copyright (C) 1998-1999                       --
--        Emmanuel Briot, Joel Brobecker and Arnaud Charlet          --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-- As a special exception, if other files instantiate generics from  --
-- this unit, or you link this unit with other files to produce an   --
-- executable, this  unit  does not  by itself cause  the resulting  --
-- executable to be covered by the GNU General Public License. This  --
-- exception does not however invalidate any other reasons why the   --
-- executable file  might be covered by the  GNU Public License.     --
-----------------------------------------------------------------------

with Gtk.Check_Menu_Item;
with Gtk.Widget; use Gtk.Widget;

package Gtk.Radio_Menu_Item is

   type Gtk_Radio_Menu_Item_Record
      is new Gtk.Check_Menu_Item.Gtk_Check_Menu_Item_Record with private;
   type Gtk_Radio_Menu_Item is access all Gtk_Radio_Menu_Item_Record'Class;

   function Group (Radio_Menu_Item : access Gtk_Radio_Menu_Item_Record)
                   return               Widget_SList.GSlist;
   procedure Gtk_New
      (Widget : out Gtk_Radio_Menu_Item;
       Group  : in Widget_SList.GSlist;
       Label  : in String := "");
   procedure Initialize
      (Widget : access Gtk_Radio_Menu_Item_Record'Class;
       Group  : in Widget_SList.GSlist;
       Label  : in String := "");
   procedure Set_Group
      (Radio_Menu_Item : access Gtk_Radio_Menu_Item_Record;
       Group           : in Widget_SList.GSlist);


   function Selected_Button (In_Group : in Widget_SList.GSlist) return Natural;
   --  Returns the button number of the selected button in the group
   --  NOTE: This function is not part of Gtk itself, but is provided as a
   --  convenient function

private
   type Gtk_Radio_Menu_Item_Record
     is new Gtk.Check_Menu_Item.Gtk_Check_Menu_Item_Record with null record;

end Gtk.Radio_Menu_Item;
