///-*-C++-*-//////////////////////////////////////////////////////////////////
//
// Hoard: A Fast, Scalable, and Memory-Efficient Allocator
//        for Shared-Memory Multiprocessors
// Contact author: Emery Berger, http://www.cs.utexas.edu/users/emery
//
// Copyright (c) 1998-2000, The University of Texas at Austin.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as
// published by the Free Software Foundation, http://www.fsf.org.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
//////////////////////////////////////////////////////////////////////////////
#ifndef _CONFIG_H_
#define _CONFIG_H_

#ifndef _REENTRANT
#define _REENTRANT		// If defined, generate a multithreaded-capable version.
#endif

// The logarithmic base used for size classes.
// (i.e., an object is in size class i if
//        base^(i-1) * ALIGNMENT < size <= base^i * ALIGNMENT.)
// Note that this puts an upper-limit on internal fragmentation:
//   if SIZE_CLASS_BASE is 1.2, then we will never see more than
//   20% internal fragmentation (for aligned requests).

#define SIZE_CLASS_BASE 1.2

// The number of groups of superblocks we maintain based on what
// fraction of the superblock is empty. NB: This number must be at
// least 2.

enum { SUPERBLOCK_FULLNESS_GROUP = 3 };


#if 0
#define DEBUG_PRINT printf
#else
#define DEBUG_PRINT dummy_printf
#endif

#define HEAP_DEBUG 0		// If non-zero, keeps extra info for sanity checking.
#define HEAP_STATS 0		// If non-zero, maintain blowup statistics.
#define HEAP_FRAG_STATS 0		// If non-zero, maintain fragmentation statistics.
#define HEAP_LOG 0		// If non-zero, keep a log of heap accesses.

#define USER_LOCKS 1		// Use our own user-level locks if they're available for the current architecture.

// CACHE_LINE = The number of bytes in a cache line.

#ifdef i386
#define CACHE_LINE 32
#endif

#ifdef sparc
#define CACHE_LINE 64
#endif

#ifdef __sgi
#define CACHE_LINE 128
#endif

#ifndef CACHE_LINE
// We don't know what the architecture is,
// so go for the gusto.
#define CACHE_LINE 64
#endif

// dummy_printf():
//   a stub that is used when we disable HEAP_DEBUG
//   so that nothing is printed.

inline void dummy_printf (...) {}

#ifdef __GNUG__
// Use the max operator, an extension to C++ found in GNU C++.
#define MAX(a,b) ((a) >? (b))
#else
#define MAX(a,b) (((a) > (b)) ? (a) : (b))
#endif


#endif // _CONFIG_H_

