/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_timer.h,v 1.6 1999/06/29 19:15:08 slouken Exp $";
#endif

#ifndef _SDL_timer_h
#define _SDL_timer_h

/* Header for the SDL time management routines */

#include "SDL_mangle.h"
#include "SDL_types.h"

#include "begin_code.h"

#define TIMER_RESOLUTION	10	/* Experimentally determined */

/* Get the number of milliseconds since the SDL library initialization.
 * Note that this value wraps if the program runs for more than ~49 days.
 */ 
SDL_DEFUN(Uint32, SDL_GetTicks, (void))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_GetTicks _SDL_GetTicks
#endif
/**/

/* Wait a specified number of milliseconds before returning */
SDL_DEFUN(void, SDL_Delay, (Uint32 ms))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_Delay _SDL_Delay
#endif
/**/

/* Function prototype for the timer callback function */
typedef Uint32 (*SDL_TimerCallback)(Uint32 interval);

/* Set a callback to run after the specified number of milliseconds has
 * elapsed. The callback function is passed the current timer interval
 * and returns the next timer interval.  If the returned value is the 
 * same as the one passed in, the periodic alarm continues, otherwise a
 * new alarm is scheduled.
 *
 * To cancel a currently running timer, call SDL_SetTimer(0, NULL);
 *
 * The timer callback function may run in a different thread than your
 * main code, and so shouldn't call any functions from within itself.
 *
 * The maximum resolution of this timer is 10 ms, which means that if
 * you request a 16 ms timer, your callback will run approximately 20 ms
 * later on an unloaded system.  If you wanted to set a flag signaling
 * a frame update at 30 frames per second (every 33 ms), you might set a 
 * timer for 30 ms:
 *   SDL_SetTimer((33/10)*10, flag_update);
 *
 * If you use this function, you need to pass SDL_INIT_TIMER to SDL_Init().
 *
 * Under UNIX, you should not use raise or use SIGALRM and this function
 * in the same program, as it is implemented using setitimer().  You also
 * should not use this function in multi-threaded applications as signals
 * to multi-threaded apps have undefined behavior in some implementations.
 */
SDL_DEFUN(int, SDL_SetTimer, (Uint32 interval, SDL_TimerCallback callback))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_SetTimer _SDL_SetTimer
#endif
/**/

#include "close_code.h"

#endif /* _SDL_timer_h */
