//=======================================================================
//	videCmdw.cpp:	Source for videCmdwindow class
//  Copyright (C) 1995-1999  Bruce E. Wampler
//
//  This program is part of the V C++ GUI Framework example programs.
//=======================================================================

// ###########################################################################
// Keep the menu bar, command bar, and status bar definitions
// here in a single file so that it will be easy to keep them all
// the same for the debug window
//
//	Start defines for the main window with 100

#ifndef VCMDCMDS_H
#define VCMDCMDS_H

    enum {
        lblMkFile = 4000,
	lblLineCol,			// Status Bar
	lblIns,
	lblSBlank,
	lblEMsg,
        lblStatTitle,
	blkLast			// Last non-debug item
      };

//@V@:BeginPulldownMenu FileMenu
    static vMenu FileMenu[] =
      {
	{"&New", M_New, isSens, notChk, noKeyLbl, noKey, noSub},
	{"&Open...", M_Open, isSens, notChk, noKeyLbl, noKey, noSub},
        {"&View...", m_View, isSens, notChk, noKeyLbl, noKey, noSub},
	{"&Save", M_Save, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Save &as...", M_SaveAs, isSens, notChk, noKeyLbl, noKey, noSub},
	{"&Close", M_CloseFile, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Save All", m_saveAll, isSens, notChk, noKeyLbl, noKey, noSub},
        {"Save / Close", M_SaveClose, isSens, notChk, noKeyLbl, noKey, noSub},
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
        {"Send to Browser", m_sendToBrowser, isSens, notChk, noKeyLbl, noKey, noSub},
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{"E&xit", M_Exit, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
      };

//@V@:BeginPulldownMenu EditMenu
    static vMenu EditMenu[] =
      {
	{"Undo", M_UnDo, notSens, notChk, noKeyLbl, noKey, noSub},
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{"Cut  ", M_Cut, notSens, notChk, "^X", noKey, noSub},
	{"Copy ", M_Copy, notSens, notChk, "^C", noKey, noSub},
	{"Paste", M_Paste, notSens, notChk, "^V", noKey, noSub},
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{"Find...", edFind, isSens,notChk,noKeyLbl,noKey,noSub},
	{"Find Next", edFindNext, isSens,notChk,noKeyLbl,noKey,noSub},
	{"Replace...", edReplace, isSens,notChk,noKeyLbl,noKey,noSub},
	{"Find Matching Paren", edBalMatch, isSens,notChk,noKeyLbl,noKey,noSub},
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
        {"Editor Help", edHelp, isSens, notChk, noKeyLbl, noKey, noSub},

	{NULL}
      };
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu OptMenu
    static vMenu OptMenu[] =
      {
	{"VIDE", m_VidePrefs,isSens,notChk,noKeyLbl,noKey,noSub},
	{"Editor", m_EditorPrefs,isSens,notChk,noKeyLbl,noKey,noSub},
	{"Font", M_Font,isSens,notChk,noKeyLbl,noKey,noSub},
	{NULL}
      };
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu MakeMenu
    static vMenu MakeMenu[] =
      {
        {"Make C++/Compile Java", m_MakeAll, notSens, notChk, noKeyLbl, noKey, noSub},
        {"Make Clean", m_MakeClean, notSens, notChk, noKeyLbl, noKey, noSub},
        {"Make <target>", m_MakeArgs, notSens, notChk, noKeyLbl, noKey, noSub},
//        {"Make Debug", m_MakeDebug, notSens, notChk, noKeyLbl, noKey, noSub},
        {"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
        {"Stop Make", m_StopMake, notSens, notChk, noKeyLbl, noKey, noSub},
        {NULL}
      };
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu ToolsMenu
    static vMenu ToolsMenu[] =
      {
        {"Run program w/ args", m_RunCmdArgs, isSens, notChk, noKeyLbl, noKey, noSub},
        {"Run project", m_RunProject, isSens, notChk, noKeyLbl, noKey, noSub},
        {"Run OS Shell", m_RunShell, isSens, notChk, noKeyLbl, noKey, noSub},
        {"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
        {"V App Gen", m_RunVgen, isSens, notChk, noKeyLbl, noKey, noSub},
        {"V Icon Editor", m_RunViconed, isSens, notChk, noKeyLbl, noKey, noSub},
        {NULL}
      };
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu ProjectMenu
    static vMenu ProjectMenu[] =
      {
	{"&Open", m_ProjectOpen, isSens, notChk, noKeyLbl, noKey, noSub},
	{"&New C++ Project", m_ProjectNewC, isSens, notChk, noKeyLbl, noKey, noSub},
	{"New &Java Project", m_ProjectNewJava, isSens, notChk, noKeyLbl, noKey, noSub},
	{"&Edit", m_ProjectEdit, notSens, notChk, noKeyLbl, noKey, noSub},
	{"&Close", m_ProjectClose, notSens, notChk, noKeyLbl, noKey, noSub},
	{"Save Project &as...", m_ProjectSaveAs, notSens, notChk, noKeyLbl, noKey, noSub},
	{"&Rebuild Makefile", m_MakeMake, notSens, notChk, noKeyLbl, noKey, noSub},
        {"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
 	{"Select Makefile or Java file", m_SelectMake, isSens, notChk, noKeyLbl, noKey, noSub},
        {NULL}
      };
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu DebugMenu
    static vMenu DebugMenu[] =
      {
	{"Start Debugger", m_Debug, isSens, notChk, noKeyLbl, noKey, noSub},
#ifndef V_VersionX
        {"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{"Set Breakpoint", m_SetBP, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Delete Breakpoint", m_DeleteBP, isSens, notChk, noKeyLbl, noKey, noSub},
        {"Show Breakpoints", m_ShowBreakpoints, isSens, notChk, noKeyLbl, noKey, noSub},
        {"Delete All Breakpoints", m_DeleteBreakpoints, isSens, notChk, noKeyLbl, noKey, noSub},
        {"-", M_Line, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Run program", m_DBRun, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Step over statement", m_StepOver, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Step into statement", m_StepInto, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Continue to line", m_RunTo, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Continue program", m_Continue, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Kill program", m_Kill, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Show call stack", m_CallStack, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Inspect variable", m_Inspect, isSens, notChk, noKeyLbl, noKey, noSub},
	{"Debugger help", m_DBHelp, isSens, notChk, noKeyLbl, noKey, noSub},
#endif
//	{"xx", m_xx, notSens, notChk, noKeyLbl, noKey, noSub},
	
        {NULL}
      };
//@V@:EndPulldownMenu

    static vMenu HelpMenu[] =
      {
        {"VIDE", videHelp, isSens, notChk, noKeyLbl, noKey, noSub},
        {"Editor Command Set", edHelp, isSens, notChk, noKeyLbl, noKey, noSub},
#ifndef V_VersionX
        {"GNU, Other Tools", gnuHelp, isSens, notChk, noKeyLbl, noKey, noSub},
        {"Win32 API", win32Help, isSens, notChk, noKeyLbl, noKey, noSub},
#endif
        {"V GUI", vguiHelp, isSens, notChk, noKeyLbl, noKey, noSub},
        {"Java", javaHelp, isSens, notChk, noKeyLbl, noKey, noSub},
        {"HTML", htmlHelp, isSens, notChk, noKeyLbl, noKey, noSub},
        {"HTML - CSS", htmlCSSHelp, isSens, notChk, noKeyLbl, noKey, noSub},
        {"-", M_Line, isSens, notChk, noKeyLbl, noKey, noSub},
        {"About V IDE", m_AboutVide, isSens, notChk, noKeyLbl, noKey, noSub},
        {NULL}
      };

//@V@:BeginMenu StandardMenu
    static vMenu StandardMenu[] =
      {
	{"&File", M_File, isSens, notUsed, notUsed, noKey, &FileMenu[0]},
	{"&Edit", M_Edit, isSens, notUsed, notUsed, noKey, &EditMenu[0]},
        {"&Project",m_Project,isSens,notUsed,notUsed,noKey,&ProjectMenu[0]},
	{"&Build", m_Build, isSens, notUsed, notUsed, noKey, &MakeMenu[0]},
        {"&Debug", m_DebugMenu, isSens, notUsed, notUsed, noKey, &DebugMenu[0]},
        {"&Tools", m_Tools, isSens, notUsed, notUsed, noKey, &ToolsMenu[0]},
        {"&Options", m_Options, isSens, notUsed, notUsed, noKey, &OptMenu[0]},
        {"&Help", m_Help, isSens, notUsed, notUsed, noKey, &HelpMenu[0]},
	{NULL}
      };
//@V@:EndMenu

//vbm1
#define open_width 16
#define open_height 16
static unsigned char open_bits[] = {
 0x00,0x00,0x00,0x0e,0x00,0x51,0x00,0x60,0x00,0x70,0x1c,0x00,0xe2,0x07,0x02,
 0x04,0x02,0x04,0xc2,0x7f,0xa2,0x2a,0x52,0x15,0xaa,0x0a,0x56,0x05,0xfc,0x03,
 0x00,0x00};
    static vIcon openI(&open_bits[0],open_height,open_width);

//vbm1
#define openprj_depth 1
#define openprj_width 16
#define openprj_height 16
static unsigned char openprj_bits[] = {
 0x00,0x1e,0x00,0xa3,0xbc,0xc0,0x22,0xe0,0x21,0x00,0xe1,0x7f,0x01,0x40,0xdd,
 0x5d,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0xdd,0x5d,0x01,0x40,
 0xff,0x7f};
    static vIcon openprjI(&openprj_bits[0],openprj_height,openprj_width);

//vbm1
#define find_width 16
#define find_height 16
static unsigned char find_bits[] = {
 0x00,0x00,0xf0,0x01,0x08,0x02,0x44,0x04,0xa2,0x08,0x12,0x09,0xf2,0x09,0x12,
 0x09,0x14,0x05,0x08,0x0e,0xf0,0x1d,0x00,0x38,0x00,0x70,0x00,0x60,0x00,0x00,
 0x00,0x00};
    static vIcon findI(&find_bits[0],find_height,find_width);

//vbm1
#define findagn_width 16
#define findagn_height 16
static unsigned char findagn_bits[] = {
 0x00,0x00,0xf0,0x01,0x08,0x02,0x44,0x04,0xa2,0x08,0x12,0x09,0xf2,0x09,0x12,
 0x09,0x14,0x05,0x08,0x0e,0xf0,0x1d,0x66,0x38,0xcc,0x70,0x98,0x61,0xcc,0x00,
 0x66,0x00};
    static vIcon findagnI(&findagn_bits[0],findagn_height,findagn_width);

//vbm1
#define replace_depth 1
#define replace_width 16
#define replace_height 16
static unsigned char replace_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x3c,0x0e,0x44,0x4e,0x44,0xca,0x44,0xdb,
 0x3d,0xdf,0x45,0xd1,0x44,0x51,0x44,0x11,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00};
    static vIcon replaceI(&replace_bits[0],replace_height,replace_width);

//vbm1
#define make_depth 1
#define make_width 16
#define make_height 16
static unsigned char make_bits[] = {
 0xc0,0x03,0x7f,0x12,0x01,0x32,0x01,0x22,0x01,0x22,0x01,0x32,0x01,0x12,0xff,
 0x13,0x00,0x10,0x00,0x7c,0x00,0x38,0x00,0x10,0x9d,0xeb,0x95,0xaa,0x95,0xaa,
 0x9d,0xeb};
    static vIcon makeI(&make_bits[0],make_height,make_width);


//vbm1
#define vrun_depth 1
#define vrun_width 16
#define vrun_height 16
static unsigned char vrun_bits[] = {
 0x00,0x00,0x80,0x1f,0xc0,0x0f,0xe0,0x07,0xf0,0x03,0xf8,0x1f,0xfc,0x1f,0xc0,
 0x0f,0xe0,0x07,0xf0,0x03,0xf8,0x0f,0x80,0x07,0xc0,0x03,0xe0,0x01,0x70,0x00,
 0x00,0x00};
    static vIcon vrunI(&vrun_bits[0],vrun_height,vrun_width);

//vbm1
#define undo_width 16
#define undo_height 16
static unsigned char undo_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xc4,0x10,0x2c,
 0x20,0x1c,0x20,0x3c,0x20,0x7c,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00};
    static vIcon undoI(&undo_bits[0],undo_height,undo_width);

//vbm1
#define debug_depth 1
#define debug_width 16
#define debug_height 16
static unsigned char debug_bits[] = {
 0x00,0x00,0xc0,0x01,0x80,0x00,0xc0,0x01,0x20,0x02,0x53,0x65,0x14,0x14,0x88,
 0x08,0x28,0x0a,0xaf,0x7a,0x28,0x0a,0x88,0x08,0x14,0x14,0x92,0x24,0x21,0x42,
 0xc0,0x01};
    static vIcon debugI(&debug_bits[0],debug_height,debug_width);

//vbm1
#define stepover_depth 1
#define stepover_width 16
#define stepover_height 16
static unsigned char stepover_bits[] = {
 0xc0,0x01,0x38,0x4e,0x04,0x70,0x02,0x70,0x01,0x78,0x00,0x00,0x30,0x0c,0x08,
 0x10,0x08,0x10,0x08,0x30,0x0c,0x30,0x0c,0x10,0x08,0x10,0x08,0x10,0x08,0x10,
 0x30,0x0c};
    static vIcon stepoverI(&stepover_bits[0],stepover_height,stepover_width);

//vbm1
#define stepinto_depth 1
#define stepinto_width 16
#define stepinto_height 16
static unsigned char stepinto_bits[] = {
 0xe0,0x00,0x98,0x01,0x84,0x01,0xe2,0x07,0xc1,0x03,0x80,0x01,0x30,0x0c,0x08,
 0x10,0x08,0x10,0x08,0x30,0x0c,0x30,0x0c,0x10,0x08,0x10,0x08,0x10,0x08,0x10,
 0x30,0x0c};
    static vIcon stepintoI(&stepinto_bits[0],stepinto_height,stepinto_width);

//vbm1
#define stopdbg_depth 1
#define stopdbg_width 16
#define stopdbg_height 16
static unsigned char stopdbg_bits[] = {
 0x03,0xc0,0xc7,0xe1,0x8e,0x70,0xdc,0x39,0x38,0x1e,0x73,0x6f,0xf4,0x17,0xe8,
 0x0b,0xc8,0x0b,0xef,0x7f,0x70,0x0e,0xb8,0x1c,0x1c,0x3c,0x9e,0x74,0x27,0xe2,
 0xc3,0xc1};
    static vIcon stopdbgI(&stopdbg_bits[0],stopdbg_height,stopdbg_width);

//vbm1
#define inspect_depth 1
#define inspect_width 16
#define inspect_height 16
static unsigned char inspect_bits[] = {
 0x00,0x00,0x00,0x30,0xf0,0x49,0x08,0x42,0x04,0x24,0x54,0x15,0xd4,0x16,0x54,
 0x05,0x04,0x14,0x08,0x02,0xf0,0x0d,0x00,0x1c,0x00,0x38,0x00,0x30,0x00,0x00,
 0x00,0x00};
    static vIcon inspectI(&inspect_bits[0],inspect_height,inspect_width);

//vbm1
#define break_depth 1
#define break_width 16
#define break_height 16
static unsigned char break_bits[] = {
 0x00,0x00,0xa0,0x02,0x58,0x05,0x54,0x05,0x54,0x05,0x54,0x05,0x54,0x05,0x04,
 0x34,0x04,0x2c,0x04,0x20,0x08,0x10,0x18,0x08,0x10,0x04,0x10,0x04,0x10,0x00,
 0x00,0x00};
    static vIcon breakI(&break_bits[0],break_height,break_width);

//vbm1
#define stopbreak_depth 1
#define stopbreak_width 16
#define stopbreak_height 16
static unsigned char stopbreak_bits[] = {
 0x00,0x00,0xa6,0x02,0x5e,0x65,0x5c,0x75,0x5c,0x3d,0x7c,0x1d,0x74,0x0f,0xe4,
 0x37,0xc4,0x2f,0xc4,0x23,0xf8,0x17,0x38,0x0e,0x1c,0x1c,0x1e,0x38,0x16,0x30,
 0x00,0x00};
    static vIcon stopbreakI(&stopbreak_bits[0],stopbreak_height,stopbreak_width);

//vbm1
#define runto_depth 1
#define runto_width 16
#define runto_height 16
static unsigned char runto_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x36,0x09,
 0x41,0x19,0x41,0x3f,0x41,0x98,0xc1,0x88,0xc1,0x00,0x41,0x00,0x41,0x00,0x41,
 0x00,0x36};
    static vIcon runtoI(&runto_bits[0],runto_height,runto_width);

//@V@:BeginCmdPane ToolBar
    static CommandObject ToolBar[] =
      {
	{C_IconButton,M_Open,0,"Open",&openI,CA_None,isSens,NoFrame,0,0,0,"Open File"},
	{C_IconButton,m_ProjectOpen,0,"OpenProject",&openprjI,CA_None,isSens,NoFrame,0,0,0,"Open Project"},
	{C_Blank,99,0," ",NoList,CA_None,isSens,NoFrame,0,0},
	{C_IconButton,M_UnDo,0,"Undo",&undoI,CA_None,notSens,NoFrame,0,0,0,"Undo"},
	{C_IconButton,edFind,0,"Find",&findI,CA_None,isSens,NoFrame,0,0,0,"Find"},
	{C_IconButton,edFindNext,0,"Find Next",&findagnI,CA_None,isSens,NoFrame,0,0,0,"Find Next"},
	{C_IconButton,edReplace,0,"Replace",&replaceI,CA_None,isSens,NoFrame,0,0,0,"Replace"},
        {C_Blank,99,0," ",NoList,CA_None,isSens,NoFrame,0,0},
        {C_IconButton,m_MakeAll,0,"MAKE",&makeI,CA_None,notSens,NoFrame,0,0,0,"make all C++ / Compile Java"},
	{C_IconButton,m_RunProject,0,"Run",&vrunI,CA_None,isSens,NoFrame,0,0,0,"Run current program"},
        {C_Blank,99,0," ",NoList,CA_None,isSens,NoFrame,0,0},
	{C_IconButton,m_Debug,0,"Debug",&debugI,CA_None,isSens,NoFrame,0,0,0,"Start debugger"},
#ifndef V_VersionX
	{C_IconButton,m_Kill,0,"KillDebug",&stopdbgI,CA_None,isSens,NoFrame,0,0,0,"Kill program being debugged"},
	{C_IconButton,m_SetBP,0,"SetBreak",&breakI,CA_None,isSens,NoFrame,0,0,0,"Set Breakpoint"},
	{C_IconButton,m_DeleteBP,0,"DelBreak",&stopbreakI,CA_None,isSens,NoFrame,0,0,0,"Delete Breakpoint"},
	{C_IconButton,m_StepOver,0,"StepOver",&stepoverI,CA_None,isSens,NoFrame,0,0,0,"Step over statement"},
	{C_IconButton,m_StepInto,0,"StepInto",&stepintoI,CA_None,isSens,NoFrame,0,0,0,"Step into statement"},
	{C_IconButton,m_RunTo,0,"Run To",&runtoI,CA_None,isSens,NoFrame,0,0,0,"Continue to statement"},
	{C_IconButton,m_Inspect,0,"Inspect",&inspectI,CA_None,isSens,NoFrame,0,0,0,"Inspect variable"},
#endif

  	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };
//@V@:EndCmdPane

//@V@:BeginStatPane StatBar
    static vStatus StatBar[] =
      {
        {" V IDE ", lblStatTitle, CA_NoBorder, isSens, 0},
	{"1/1          .", lblLineCol, CA_None, isSens, 0},
	{"Command........", lblIns, CA_None, isSens, 0},
	// handle messages this big
#ifdef V_VersionX
	{".                                                  .",
#else
	{"                                                    ",
#endif
		 lblEMsg, /* CA_NoBorder */ CA_NoBorder, isSens, 0},
	{0,0,0,0,0}
      };
//@V@:EndStatPane

// ###########################################################################
#endif
