//=======================================================================
//	videapp.cpp:	Source for videApp class
//=======================================================================

#include "videapp.h"		// Header file
#include <v/vos.h>	// <v/vos.h>
#include <v/vutil.h>
#include <v/vnotice.h>
#include "vprefs.h"	// <v/vprefs.h>
#include "vrundlg.h"
#include <fstream.h>

//====================>>> myTimer::TimerTick <<<====================
  void myTimer::TimerTick()
  {
    theApp->SendWindowCommandAll(M_Save,1,C_Button);
    // vBeep();
  }

//=========================>>> videApp::videApp <<<==========================
  videApp::videApp(char* name, int sdi, int h, int w) : vApp(name, sdi, h, w)
  {
    // Constructor

    vdbCmdWin = 0;
    _videCmdWin = 0;
    _videMkFile[0] = 0;
    _videHelpPath[0] = 0;
    _videJavaPath[0] = 0;
    strcpy(_videBrowser,"netscape");
    strcpy(_videHelpViewer,"netscape");
#ifdef V_VersionX
    strcpy(_videDebugger,"ddd");
    strcpy(_videShell,"xterm");
#else
    strcpy(_videDebugger,"gdb");
    strcpy(_videShell,"command.com");	// dynamic change to cmd.exe....
#endif
    _autoSave = 5;			// every 5 minutes
    _backup = 0;
    _tabSpacing = 8;
    _wrapLim = 65;
    _winRows = 40;
    _winCols = 90;

    _saveTimer = new myTimer();

#ifdef DEVEL
    _emulation = See;
#else
     _emulation = Generic;
#endif
  }

//=========================>>> videApp::videApp <<<==========================
  videApp::~videApp()
  {
    // Destructor

//  If we really do the following, things die....
//  if (vdbCmdWin)		
//	delete vdbCmdWin;
//  if (_videCmdWin)
//	delete _videCmdWin;

    // but it is ok to stop the timer...
//    _saveTimer->TimerStop();
//    delete _saveTimer;
  }

//=====================>>> videApp::AppCommand <<<==============================
  void videApp::AppCommand(vWindow* win, ItemVal id, ItemVal val, CmdType cType)
  {
    // Commands not processed by the window will be passed here

    vApp::AppCommand(win, id, val, cType);
  }

//=====================>>> videApp::showHelp <<<==============================
  void videApp::showHelp(int id)
  {
    switch (id)
      {
	case videHelp:
	  {
	    (void)findHelp("videdoc.htm","vrefman/",_videHelpPath);
	    break;
	  }

	case gnuHelp:
	  {
	    (void)findHelp("vhelp.htm","",_videHelpPath);
	    break;
	  }

	case win32Help:
	  {
	    if (!findHelp("win32.hlp","win32/",_videHelpPath,0) )
	    	(void)findHelp("win32.htm","win32/",_videHelpPath);
	    break;
	  }

	case vguiHelp:
	  {
	    if (!findHelp("v.htm","vrefman/",_videHelpPath,0))
		(void) findHelp("vrefman.htm","vrefman/",_videHelpPath);
	    break;
	  }

	case javaHelp:
	  {
	    (void)findHelp("index.html","",_videJavaPath);
	    break;
	  }

	case htmlHelp:
	  {
	    (void)findHelp("index.html","html/",_videHelpPath);
	    break;
	  }

	case htmlCSSHelp:
	  {
	    (void)findHelp("index.html","html/css/",_videHelpPath);
	    break;
	  }
      }
  }

//======================>>> videApp::findHelp <<<===========================
  int videApp::findHelp(const char* name, const char* dir, const char* path,
	 int failNotice, int browser)
  {
    char hName[maxFileNameSize+2];

    strcpy(hName, path);
    int len = strlen(hName);
    if (len > 0 && hName[len-1] != '/' && hName[len-1] != '\\')
	strcat(hName,"/");
    strcat(hName,dir);
    strcat(hName,name);

    ifstream infile(hName);
    if (!infile)
      {
	infile.close();
	if (!failNotice)
	    return 0;

	vNoticeDialog note(this,"Can't find help");

#ifdef V_VersionX
	char msg[] = 
"Sorry, VIDE can't find the help file you requested. Please\n\
use Options:Editor command to set the path to the correct\n\
home path for the help files. For example, \"/usr/local/vhelp\" for\n\
V and C++ help, or \"/usr/local/jdk1.2/docs\" for Java help.";
#else
	char msg[] = 
"Sorry, VIDE can't find the help file you requested. Please\n\
use Options:Editor command to set the path to the correct\n\
home path for the help files. For example, \"C:/egcs/vhelp\" for\n\
V and C++ help, or \"C:/jdk1.2/docs\" for Java help.";
#endif

	note.Notice(msg);
        return 0;
      }
    infile.close();
#ifdef V_VersionWindows
    ::ShellExecute(winHwnd(),"open",hName,0,0,SW_SHOWDEFAULT);
#else
    vOS os;
    char cmd[maxFileNameSize+20];
    if (browser)
	strcpy(cmd,_videBrowser);
    else
	strcpy(cmd,_videHelpViewer);
    strcat(cmd," ");
    strcat(cmd,hName);
    os.vRunProcess(cmd,0,0,0);
#endif
    return 1;
  }

//======================>>> videApp::CloseAppWin <<<===========================
  int videApp::CloseAppWin(vWindow* win)
  {
    // This will be called BEFORE a window has been unregistered or
    // closed.  Default behavior: unregister and close the window.

    videCmdWindow* cw = (videCmdWindow*)win;

    if (vdbCmdWin == (vdbCmdWindow*)win)	// the debugger?
      {
	vdbCmdWin->dbSendCmd("quit\n",false);
	int rv = vApp::CloseAppWin((vWindow*)vdbCmdWin);
	vdbCmdWin = 0;			// done and destroyed
        return 1;
      }
    else if (cw->CheckClose())
        return vApp::CloseAppWin(win);
    else
        return 0;
  }

//=====================>>> videApp::debugCommand <<<==============================
  void videApp::debugCommand(videCmdWindow* win, ItemVal id)
  {
    // Debug Commands handled here...

    if (id == m_Debug)		// check this one first...
      {
	runDebug(win,"");
	return;
      }
    if (!vdbCmdWin)		// No debugger open!
      {
	vBeep();
    	return;
      }

    vdbCmdWin->debugCmd(win, id);
  }

//============================>>> videApp::Exit <<<===========================
  void videApp::Exit(void)
  {
    // This is called to close all windows.

    vApp::Exit();		// Default behavior
  }

//=========================>>> videApp::KeyIn <<<==============================
  void videApp::KeyIn(vWindow* win, vKey key, unsigned int shift)
  {
    // Key strokes not processed by the window will be passed here

    vApp::KeyIn(win, key, shift);
  }

//=====================>>> videApp::NewAppWin <<<==========================
  vWindow* videApp::NewAppWin(vWindow* win, VCONST char* name,
    int w, int h, vAppWinInfo* winInfo)
  {
    vAppWinInfo* awinfo = winInfo;
    VCONST char *appname = name;

    if (w < 0)
	w = getDefaultCols();
    if (h < 0)
	h = getDefaultRows();

    if (!*name)
      {
	 appname = "VIDE";		// Default name
      }
	
    // Create the first window using provided CmdWindow if passed

    videCmdWindow* cw = (videCmdWindow*) win;	// Pointer to instance of passed window

    if (cw != 0 && _videCmdWin == 0)
        _videCmdWin = (videCmdWindow*) cw;		// remember this first window

    if (!cw)
      {
	cw = new videCmdWindow(appname, w, h);
      }

    if (!awinfo)
	awinfo = new vAppWinInfo(appname);

    if (!vApp::NewAppWin((vWindow*) cw, appname, w, h, awinfo))
	return 0;
    return (vWindow*) cw;
  }

//=====================>>> videApp::runDebug <<<=============================
  void videApp::runDebug(videCmdWindow* win, const char* runName)
  {
#ifdef V_VersionWindows
    if (!vdbCmdWin)	// don't open again if already open...
      {
	// put up the window
	vdbCmdWin = new vdbCmdWindow("Debug info", 80, 12);
	(void) NewAppWin((vWindow*) vdbCmdWin,"Debug info", 80, 12, 0);

	char dbgName[maxFileNameSize+2];
	if (runName && *runName)
	    strcpy(dbgName,runName);
	else
	  {
	    vRunDialog note(this);
	    note.GetDebugName("",dbgName);
	  }

	// and start the debugger...
	vdbCmdWin->OpenGDB(dbgName);
      }
#endif
#ifdef V_VersionX
	vOS os;

	char dbgName[maxFileNameSize+2];
	char runLine[maxFileNameSize+12];
	if (runName && *runName)
	    strcpy(dbgName,runName);
	else
	  {
	    vRunDialog note(this);
	    note.GetDebugName("",dbgName);
	  }
	strcpy(runLine,_videDebugger);
	strcat(runLine," ");
	strcat(runLine,dbgName);
	os.vRunProcess(runLine,0,0,0);
 
#endif
    return;
  }

//============================>>> videApp::SetMkFile <<<===========================
  void videApp::SetMkFile(char* mkf)
  {
    // update our global variable CWD and update any open windows
    vOS vos;
    bool hadpath = false;
    char temp[maxFileNameSize + 2];

    if (strlen(mkf) < maxFileNameSize)
      {
	for (char* cp = mkf ; *cp ; ++cp)
	    if (*cp == '/' || *cp == '\\')
	      {
		hadpath = true;
		break;
	      }
	if (hadpath)
	    strcpy(_videMkFile, mkf);
	else
	  {
	    vos.vGetCWD(temp,maxFileNameSize);
	    strcpy(_videMkFile, temp); strcat(_videMkFile,"/");
	    strcat(_videMkFile,mkf);
	  }
      }
    else
        strcpy(_videMkFile,"Makefile");

    if (hadpath)
      {
    strcpy(temp,_videMkFile);
    int ix = strlen(temp);		// strip Makefile part
    while (ix > 0)
      {
        if (temp[ix] == '/' || temp[ix] == '\\')
          {
            temp[ix] = 0;
            break;
          }
        --ix;
      }

    vos.vChDir(temp);			// we will work out of that directory
      }
    theApp->SendWindowCommandAll(m_updateMkFile, 0, C_Button);
  }

//============================>>> videApp::splitFileName <<<===========================
  void videApp::splitFileName(char* fn, char* fdir, char* fbase, char* fext)
  {
    // splits a file into three parts - the directory, the base name
    // (which includes the name+ext), and the extension (with .)
    // assumes output char*'s are at least as long as fn in.
    // Can be called with outputs NULL to skip

    int len = strlen(fn);	// length
    int ix;


    if (fdir)			// want dir?
      {
	strcpy(fdir,fn);		// copy it all
	for (ix = len ; ix > 0 ; --ix)
	  {
#ifdef V_VersionWindows
	    if (fn[ix] == '/' || fn[ix] == '\\' || fn[ix] == ':')
#else
	    if (fn[ix] == '/' || fn[ix] == '\\')
#endif
	      {
		fdir[ix+1] = 0;
		break;
	      }
	  }
      }

    if (fbase)			// want base?
      {
	for (ix = len ; ix > 0 ; --ix)
	  {
#ifdef V_VersionWindows
	    if (fn[ix] == '/' || fn[ix] == '\\' || fn[ix] == ':')
#else
	    if (fn[ix] == '/' || fn[ix] == '\\')
#endif
	      {
		strcpy(fbase,&fn[ix+1]);
		break;
	      }
	  }
      }
    
    if (fext)			// want ext?
      {
	for (ix = len ; ix > 0 ; --ix)
	  {
	    if (fn[ix] == '.')
	      {
		strcpy(fext,&fn[ix]);
		break;
	      }
	  }
      }

  }

//============================>>> videApp::readPrefs <<<===========================
  int videApp::readPrefs()
  {
    // read settings from Vide preferences file

    int fontSet = 0;
    long val;

    vPrefs vp;
    char buff[maxFileNameSize+2];

    if (!vp.openRead("Vide","[VIDE Preferences]"))
      {
	vNoticeDialog note(this,"VIDE needs options set");
	note.Notice(
"This seems to be the first time you've run VIDE.\n\
Please use the Options:Editor and Options:Font menu commands\n\
to set the help path, editor emulation, font, etc.\n\
Then exit VIDE and start it again.");
	return 0;
      }

    (void)vp.getString("HelpPath",_videHelpPath);
    (void)vp.getString("JavaPath",_videJavaPath);
    if (vp.getLong("AutoSave",val))
	_autoSave = val;
    else 
	_autoSave = 5;

    if (vp.getLong("MakeBackup",val))
	_backup = val;
    else 
	_backup = 0;

    if (vp.getLong("Emulation",val))
	_emulation = (Emulation)val;
    else
	_emulation = Generic;
	
    if (vp.getLong("TabSpacing",val))
      {
	_tabSpacing = val;
      }

    if (vp.getLong("TextWrap",val))
      {
	_wrapLim = val;
      }

    if (vp.getLong("DefaultRows",val))
      {
	_winRows = val;
      }

    if (vp.getLong("DefaultCols",val))
      {
	_winCols = val;
      }

    if (vp.getString("CurrentDir",buff))
      {
	vOS os;
	os.vChDir(buff);	// start in last directory
      }

    if (vp.getString("Font",buff) && *buff)
      {
        DefaultFont.SetNativeFontString(buff);
        fontSet = 1;
      }

    (void)vp.getString("VideShell",_videShell);
    (void)vp.getString("Debugger",_videDebugger);

#ifdef V_VersionX
    (void)vp.getString("Browser",_videBrowser);
    (void)vp.getString("HelpViewer",_videHelpViewer);
#endif
    vp.closeRead();

    setAutoSave(_autoSave);	// start the timer....

    return fontSet;
  }

//============================>>> videApp::setAutoSave <<<===========================
  void videApp::setAutoSave(int val)
  {
    _autoSave = val;
    if (_saveTimer)
      {
	_saveTimer->TimerStop();	// stop first
	if (_autoSave > 0)
	    _saveTimer->TimerSet((long)_autoSave * 60000L);
      }
  }

//============================>>> videApp::savePrefs <<<===========================
  void videApp::savePrefs()
  {
    // save settings to Vide preferences file
    char buff[maxFileNameSize+2];

    vOS os;
    vPrefs vp;

    if (!vp.openSave("Vide","[VIDE Preferences]"))
	return;
    vp.addString("HelpPath",_videHelpPath);
    vp.addString("JavaPath",_videJavaPath);
    vp.addLong("AutoSave",(long)_autoSave);
    vp.addLong("MakeBackup",(long)_backup);
    vp.addLong("Emulation",(long)_emulation);
    vp.addLong("TabSpacing",
		(long)(_videCmdWin->GetTextEd())->GetGlobalState().tabspc);
    vp.addLong("TextWrap",
		(long)(_videCmdWin->GetTextEd())->GetGlobalState().wraplm);
    vp.addLong("DefaultRows",(long)_winRows);
    vp.addLong("DefaultCols",(long)_winCols);

    strcpy(buff,".");

    os.vGetCWD(buff,maxFileNameSize);
    vp.addString("CurrentDir",buff);

    DefaultFont.GetNativeFontString(buff);
    vp.addString("Font",buff);

    vp.addString("VideShell",_videShell);
    vp.addString("Debugger",_videDebugger);
#ifdef V_VersionX
    vp.addString("Browser",_videBrowser);
    vp.addString("HelpViewer",_videHelpViewer);
#endif

    vp.closeSave();

  }

//============================>>> videApp::setEditLocals <<<===========================
  void videApp::setEditLocals()
  {
    globalState gs = (_videCmdWin->GetTextEd())->GetGlobalState();
    gs.tabspc = _tabSpacing;
    gs.wraplm = _wrapLim;
    (_videCmdWin->GetTextEd())->SetGlobalState(gs);	// and set!
  }

//###########################################################################

  static videApp vide_App(VIDE_VERS);	// The instance of the app

//============================>>> AppMain <<<==============================
  int AppMain(int argc, char** argv)
  {
    int fontSet = ((videApp*)theApp)->readPrefs();

    if (!fontSet)
      {
#ifdef V_VersionX
	(((videApp*)theApp)->DefaultFont).SetFontValues(vfFixed,12,vfNormal,vfBold);
#else
	(((videApp*)theApp)->DefaultFont).SetFontValues(vfFixed,10,vfNormal,vfBold);
#endif
      }

    // Use AppMain to create the main window
    videCmdWindow* cw = new videCmdWindow("", 0, 0);
    (void) theApp->NewAppWin((vWindow*) cw, "", 0, 0, 0);

    (((videApp*)theApp)->GetMsgWindow())->SetTitle("No Makefile, Project, or .java file Specified");
    (((videApp*)theApp)->GetMsgWindow())->AddLine("------------ V IDE ------------");
    (((videApp*)theApp)->GetMsgWindow())->SetRdOnly(1);

    theApp->CheckEvents();	// make sure window up

    ((videApp*)theApp)->setEditLocals();	// safe to do now that window is up

    if (argc > 1)
      {
        for (int ix = 1 ; ix < argc ; ++ix)
	  {
	    if (argv[ix][0] == '-' || argv[ix][0] == '/')	// switch
	      {
		switch (argv[ix][1])
		  {
		    case 'e':
		    case 'E':
		      {
			switch (argv[ix][2])
			  {
			    case 's':
			    case 'S':
			      {
				((videApp*)theApp)->SetEmulation(See);
				break;
			      }
			    default:
				break;
			  }
			break;
		      }	// case 'e'

		    default:
			break;
		  }
	      }
	    else	// a file name: project or source
	      {
		theApp->CheckEvents();	// make sure window up
		if (strstr(argv[ix],".vpj") != 0)
		  {
		    (((videApp*)theApp)->GetMsgWindow())->OpenProject(argv[ix]);
		  }
		else
		  {
#ifdef V_VersionX
		// can't get LessTif version at least to work...
		    vBeep();
#else
		    videCmdWindow* cmdw = (videCmdWindow*)
		        theApp->NewAppWin(0, "VIDE", -1, -1);
		    if (!cmdw)
			break;
#ifdef OLD_WAY
		    if (!cmdw->OpenFile(argv[ix]))
		      {
			delete cmdw;
			break;
		      }
		    else
		      {
			cmdw->RaiseWindow();
		      }
#else
		    (void)cmdw->OpenFile(argv[ix]);
		    cmdw->RaiseWindow();
#endif
		    cmdw->vedCanvas->Verify();
		    cmdw->ChangeInsMode(1);
#endif
		  }
	      }
	  }
      }
    else
      {

      }

    return 0;
  }
