/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Modify by Salmaso Raffaele <r.salmaso@flashnet.it> 10 Jan 1999
 * added 2 property: Caption and CaptionWrap
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  LABEL_BUTTON_H
#define  LABEL_BUTTON_H

#include <vdk/button.h>

class VDKLabelButton: public VDKButton
{
  GtkWidget* lbl;

public:
    VDKReadWriteValueProp<VDKLabelButton, char*> Caption;
    VDKReadWriteValueProp<VDKLabelButton, bool> CaptionWrap;
    VDKLabelButton(VDKForm* owner, char* label, char* tip = (char*) NULL);
    virtual ~VDKLabelButton() {}
    virtual void SetForeground(VDKRgb color, GtkStateType state = GTK_STATE_NORMAL) {
        _setForeground_(lbl,color.red,color.green,color.blue, state);
    }
    virtual void SetFont(VDKFont* font) {
        _setFont_(lbl,font);
    }
    void SetCaption(char* str) {
        gtk_label_set_text (GTK_LABEL(lbl),str);
    }
    char* GetCaption () {
        return GTK_LABEL (lbl)->label;
    }
    void SetCaptionWrap (bool flag) {
        gtk_label_set_line_wrap (GTK_LABEL (lbl), flag);
    }
    bool GetCaptionWrap () {
        return GTK_LABEL (lbl)->wrap;
    }
};

#endif
