/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef SPINS_H
#define SPINS_H
#include <vdk/vdkobj.h>
#include <vdk/vdkprops.h>

class VDKSpinButton: public VDKObject
{
  static void ValueChanged(GtkWidget *wid, gpointer gp);
  static void OnValueChanged(GtkWidget *wid, gpointer gp);
  GtkObject* adj; 
 public:
  //properties
VDKReadWriteValueProp<VDKSpinButton,float> ValueAsFloat;
VDKReadOnlyValueProp<VDKSpinButton,int>    ValueAsInt;
VDKReadWriteValueProp<VDKSpinButton, int>  Digits;
VDKReadWriteValueProp<VDKSpinButton, float>  LowerBound;
VDKReadWriteValueProp<VDKSpinButton, float>  UpperBound;
 VDKSpinButton(VDKForm* owner,
	    float defValue,
	    float lower,
	    float upper,
	    float step_increment,
	    float climb_rate);
  virtual ~VDKSpinButton();

  void SetDigits(int digits);
  int GetValueAsInt();
  void SetValueAsFloat(float f);
  float GetValueAsFloat();
  void SetLowerBound(float f);
  float GetLowerBound();
  void SetUpperBound(float f);
  float GetUpperBound();
#ifdef USE_SIGCPLUSPLUS 
 public:
  VDKSignal1<void, float> OnSpinValueChanged;
#endif /* USE_SIGCPLUSPLUS */
};
#endif
