/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef STATUSBAR_H
#define STATUSBAR_H
#include <vdk/vdkobj.h>
#include <vdk/frame.h>
class VDKStatusbar: public VDKObject
{
  int contextId;
 protected:
  void SetShadow(int shadow)
    { 
      GtkStatusbar* sbar = GTK_STATUSBAR(widget);
      gtk_frame_set_shadow_type(
				GTK_FRAME(sbar->frame),
				(GtkShadowType) shadow); 
    }
public:
  VDKReadWriteValueProp<VDKStatusbar, int> Shadow;
  VDKStatusbar(VDKForm* owner = NULL);
  virtual ~VDKStatusbar();
  int Push(char* text)
    { 
      return gtk_statusbar_push(
				GTK_STATUSBAR(widget),
				contextId, text);
    }
  void Pop()
    {
      gtk_statusbar_pop(GTK_STATUSBAR(widget),contextId);
    }
};

#endif

