#include <testclasses.h>
#include <string>

class TestForm : public VDKForm
{
 private:
     void mesg_handler(VDKObject*, const char*);
     VDKBox* hbox1;
     VDKBox* hbox2;
     VDKToggleButton* tbtn;
     VDKToggleButtonTest* tbtntest;
     VDKCheckButton* cbtn;
     VDKCheckButtonTest* cbtntest;
     VDKSpinButton* spbtn;
     VDKSpinButtonTest* spbtntest;
     VDKCustomList* clist;
     VDKCustomListTest* clisttest;
     VDKCustomTree* ctree;
     VDKCustomTreeTest* ctreetest;

     VDKCombo* combo;
     VDKComboTest* combotest;
 public:
     TestForm(VDKApplication* app)
       : VDKForm(app)
	  {}
     ~TestForm()
	{
	     delete tbtntest;
	     delete cbtntest;
	     delete spbtntest;
	     delete clisttest;
	     delete ctreetest;
	     delete combotest;
	}
     void Setup();
};

class TestApp : public VDKApplication
{
public:
     TestApp(int* argc, char** argv)
	  : VDKApplication(argc, argv)
     {}
     ~TestApp(){};
     void Setup()
     {
	  MainForm=new TestForm(this);
	  MainForm->Setup();
	  MainForm->Show();
     }
};

void 
TestForm::Setup()
{
     SetTitle("VDK test for sigc++-extension");
     hbox1=new VDKBox(this, h_box);
     hbox2=new VDKBox(this, h_box);
     Add(hbox1);
     Add(hbox2);

     tbtn=new VDKToggleButton(this);
     tbtntest=new VDKToggleButtonTest(tbtn);
     hbox1->Add(tbtn);
     tbtntest->OnMesg.connect(slot(*this,
				   &TestForm::mesg_handler));
     
     cbtn=new VDKCheckButton(this);
     cbtntest=new VDKCheckButtonTest(cbtn);
     hbox1->Add(cbtn);
     cbtntest->OnMesg.connect(slot(*this,
				   &TestForm::mesg_handler));

     spbtn=new VDKSpinButton(this, 5, 0, 10, 1,0);
     spbtntest=new VDKSpinButtonTest(spbtn);
     hbox1->Add(spbtn);
     spbtntest->OnMesg.connect(slot(*this,
				    &TestForm::mesg_handler));
     
     char* titles[4]={"1. word", "2. word", "3. word", "4. word"};
     clist=new VDKCustomList(this, 4, titles);
     clisttest=new VDKCustomListTest(clist);
     hbox2->Add(clist);
     clisttest->OnMesg.connect(slot(*this,
				    &TestForm::mesg_handler));

     char* titles2[1]={"VDKCustomTree"};
     ctree=new VDKCustomTree(this,1,titles2);
     ctreetest=new VDKCustomTreeTest(ctree);
     hbox2->Add(ctree);
     ctreetest->OnMesg.connect(slot(*this,
				    &TestForm::mesg_handler));

     combo=new VDKCombo(this);
     combotest=new VDKComboTest(combo);
     hbox1->Add(combo);
     combotest->OnMesg.connect(slot(*this,
				    &TestForm::mesg_handler));
     // to be continued
}

void
  TestForm::mesg_handler(VDKObject* obj, const char* mesg)
{
     cout << mesg ;
}

int main(int argc, char** argv)
{
     TestApp app(&argc, argv);
     app.Run();
     return 0;
}
