/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4.2
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */               
#include <vdk/vdk.h>
#include <vdk/chart.h>
#include <vdk/combo.h>
#include <time.h>
#define MAX_COLORS 7
///////////////////////////////
class ChartForm: public VDKForm
{
  VDKChart* chart;
  VDKCombo* combo;
  VDKLabelButton *plot,*clear,*quit;
  VDKFrame *frame;
  void PlotSeries(bool, int);
  void LineChart();
  void ScatteredChart();
  void BarChart();
  int z;
public:
  ChartForm(VDKForm* owner):
    VDKForm(owner,"VDK Chart demo") 
    {
      chart = NULL;
      z = 0;
    }
  ~ChartForm() {}
  void Setup();
  bool Quit(VDKObject*) { Close(); return true; }
  bool Plot(VDKObject*);
  bool ClearPlot(VDKObject*);
  bool OnCombo(VDKObject*);
  void OnShow(VDKForm*) { if(chart) chart->Draw(); }  
  DECLARE_SIGNAL_MAP(ChartForm);  
};  







