/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#include "vdk/vdkfont.h"
#include "vdk/forms.h"
/*
 */
VDKFont::VDKFont(char* name): VDKRawObject((VDKObject*) NULL)
{
id = -1;
if(name)
  {
    fontName = new char[strlen(name)+1];
    strcpy(fontName,name);
    if(!(font = gdk_font_load(fontName)) )
      {
	delete[] fontName;
	fontName = (char*) NULL;
      }
    else
      {
	gdk_font_ref(font);
	id = gdk_font_id(font);
      }
     
  } 
else fontName = (char*) NULL;
g_return_if_fail(font != NULL);
}
/*
  VDKFont::VDKFont(VDKForm* form, char* name):VDKRawObject(form)
  {
  id = -1;
  if(name)
  { 
  fontName = new char[strlen(name)+1];
  strcpy(fontName,name);
  if(!(font = gdk_font_load(fontName)) )
  {
  delete[] fontName;
  fontName = (char*) NULL;
  }
  else
  {
  gdk_font_ref(font);
  id = gdk_font_id(font);
  }
  } 
  else fontName = (char*) NULL;
  }
*/
/*
 */
VDKFont::VDKFont(VDKObject* obj, char* name): VDKRawObject(obj)
{
id = -1;
if(name)
  {
    fontName = new char[strlen(name)+1];
    strcpy(fontName,name);
    if(!(font = gdk_font_load(fontName)) )
      {
	delete[] fontName;
	fontName = (char*) NULL;
      }
    else
      {
	gdk_font_ref(font);
	id = gdk_font_id(font);
      }
  }
else fontName = (char*) NULL;
g_return_if_fail(font != NULL);
}
/*
 */
VDKFont::~VDKFont()
{
if(fontName)
  delete[] fontName;
if(font)
  gdk_font_unref(font);
}
/*
 */
bool VDKFont::operator==(VDKFont& f)
{
if(!f.font)
  return false;
else
  return gdk_font_equal(font,f.font);
}
/*
 */
int VDKFont::Height()
{
if(font)
  return font->ascent + font->descent + 1;
else
  return 0;
}
/*
 */
VDKFont::operator char*()
{
return fontName;
}
/*
 */
int VDKFont::FontId()
{
if(font)
  return gdk_font_id (font);
else
  return -1;
}

int VDKFont::Width(char* s)
{
if(font) 
  return gdk_string_width (font,s);
else 
  return 0;
}

VDKFont::operator GdkFont*()
{
return font;
}






