/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * Revision 0.4.1
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdk/widcontain.h"
#include <config.h>
/*
 */
VDKObjectContainer::VDKObjectContainer(VDKForm* owner):
    VDKObject(owner)
{
}

/*
This function will remove an object from a container
without destroying it.
Note:
Should be used to reparent an widget, or it will leak.
Use this:
// remove from source container 
// referencing it otherwise will be destroyed by gtk+
source->RemoveObjectFromContainer(widget);
// add to target container (referencing it again)
target->Add(widget);
// set target as parent
widget->Parent(target);	
// unref widget again (or it will leak)
gtk_widget_unref(widget->Widget());
 */
void 
VDKObjectContainer::RemoveObjectFromContainer(VDKObject* obj)
{
if(obj->Widget() && 
   GTK_IS_WIDGET(obj->Widget()) && 
   GTK_IS_CONTAINER(obj->Widget()->parent))
  {
    int result = 0;
    // remove from source container 
    // referencing it otherwise will be destroyed by gtk+
    gtk_widget_ref(obj->Widget());
    gtk_container_remove(GTK_CONTAINER (obj->Widget()->parent),
			 obj->Widget());
    result = items.remove(obj);
#ifdef VDKDEBUG
    printf("\nremoved from gtk+ container:%p - result:%d",widget,result);
    fflush(stdout);
#endif
  }

}


/*
 */
void VDKObjectContainer::RemoveObjects()
{
  ItemListIterator li(items);
  VDKItem<VDKObject> *p = li.Head();
  VDKItem<VDKObject> *p1;
  while(p)
    {
      p1 = li.Next(p);
      li.Now(p)->Destroy();
      p = p1;
    }
}
/* 
 */
VDKObject* VDKObjectContainer::FindTag(int tag)
{
ItemListIterator li(items);
for(;li;li++)
  if(li.current()->Tag == tag)
    return li.current();
return static_cast<VDKObject*>(NULL);
}
/*
 */void VDKObjectContainer::ForEachDo(void (*action)(VDKObject*))
{
ItemListIterator li(items);
for(;li;li++)
  action(li.current());
}
/*
 */
void VDKObjectContainer::Select(ItemList* list, bool (*condition)(VDKObject*))
{
ItemListIterator li(items);
for(;li;li++)
  if(condition(li.current()))
    list->add(li.current());
return ;
} 


