/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4.2
 * November 1998 
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
 
#include <vdk/vdkgrid.h>
#include <vdk/vdkobj.h>
#include <vdk/forms.h>
#include <vdk/colors.h>
#include <stdlib.h>
/////////////////////// VDKGRID CLASS ////////////////
/*                   SIGNALS HANDLING                */
int
VDKGrid::ActivateCell(GtkWidget* wid, int row, int col, gpointer gp)
{
  if(row < 0 || col < 0)
    return TRUE;
  g_return_val_if_fail(wid != NULL,FALSE);
  g_return_val_if_fail(gp != NULL,FALSE);
  VDKGrid* obj = reinterpret_cast<VDKGrid*>(gp);
  VDKGridCell *cell = obj->ActiveCell; 
  if (cell)
    delete cell;
  cell = new VDKGridCell(GTK_SHEET(wid),row,col);
  cell->grid = obj;
  cell->Text(gtk_sheet_cell_get_text(GTK_SHEET(wid),row,col));
  obj->ActiveCell(cell);
  obj->SignalEmit(grid_select_cell);
  obj->SignalEmit("grid_select_cell"); 
  return TRUE;
}
/*
disabled since is buggy because assumes
that gtksheet is always added to a scrolled
void     
VDKGrid::HAdjChanged(GtkWidget* wid, gpointer gp)
{
g_return_if_fail(wid != NULL); 
g_return_if_fail(gp != NULL);
VDKGrid* obj = reinterpret_cast<VDKGrid*>(gp);
obj->SignalEmit(grid_hor_scrolled);
obj->SignalEmit("grid_hor_scrolled"); 
}
*/

/*
void     
VDKGrid::VAdjChanged(GtkWidget* wid, gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  VDKGrid* obj = reinterpret_cast<VDKGrid*>(gp);
  obj->SignalEmit(grid_vert_scrolled);
  obj->SignalEmit("grid_vert_scrolled"); 
}  
*/

void
VDKGrid::SelectRow(GtkWidget* wid, int row,  gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  VDKGrid* obj = reinterpret_cast<VDKGrid*>(gp);
  obj->SelectedRow(row);
  obj->SignalEmit(grid_select_row);
  obj->SignalEmit("grid_select_row");
} 

void
VDKGrid::SelectColumn(GtkWidget* wid,int col, gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  VDKGrid* obj = reinterpret_cast<VDKGrid*>(gp);
  obj->SelectedColumn(col);
  obj->SignalEmit(grid_select_column);
  obj->SignalEmit("grid_select_column");
}

int
VDKGrid::DeactivateCell(GtkWidget* wid, int row, int col, gpointer gp)
{
  if(row < 0 || col < 0)
    return TRUE;
  g_return_val_if_fail(wid != NULL,FALSE);
  g_return_val_if_fail(gp != NULL,FALSE);
  VDKGrid* obj = reinterpret_cast<VDKGrid*>(gp);
  VDKGridCell *cell = obj->PreviousActiveCell; 
  if (cell)
    delete cell;
  GtkSheet* sheet = GTK_SHEET(wid);
  char* p = gtk_sheet_cell_get_text(sheet,row,col);
  cell = new VDKGridCell(GTK_SHEET(wid),row,col);
  cell->grid = obj;
  cell->Text(p);
  obj->PreviousActiveCell(cell);
  obj->SignalEmit(grid_unselect_cell);
  obj->SignalEmit("grid_unselect_cell");
  return TRUE;
}
int
VDKGrid::OnChangedCell(GtkWidget* wid, int row, int col, gpointer gp)
{
  if(row < 0 || col < 0)
    return TRUE;
  g_return_val_if_fail(wid != NULL,FALSE);
  g_return_val_if_fail(gp != NULL,FALSE);
  VDKGrid* obj = reinterpret_cast<VDKGrid*>(gp);
  VDKGridCell *cell = obj->ChangedCell; 
  if (cell)
    delete cell;
  cell = new VDKGridCell(GTK_SHEET(wid),row,col);
  cell->grid = obj;
  cell->Text(gtk_sheet_cell_get_text(GTK_SHEET(wid),row,col));
  obj->ChangedCell(cell);
  obj->SignalEmit(grid_changed_cell);
  obj->SignalEmit("grid_changed_cell"); 
  return TRUE;
}
///////////////////////////////////////////////////////////////
VDKGrid::VDKGrid(VDKForm* owner, 
		 int rows, int cols,
		 bool editable,
		 char* title):
  VDKObject(owner),
  ActiveCell("ActiveCell",this,NULL),
  PreviousActiveCell("PreviousActiveCell",this,NULL),
  ChangedCell("ChangedCell",this,NULL),
  SelectedRow("SelectedRow",this,-1),
  SelectedColumn("SelectedColumn",this,-1),
  RowTitleVisible("RowTitleVisible",this,true,
		  &VDKGrid::SetRowTitleVisible),
  ColumnTitleVisible("ColumnTitleVisible",this,true,
		  &VDKGrid::SetColumnTitleVisible),
  MaxRows("MaxRows",this,0,&VDKGrid::GetMaxRows),
  MaxColumns("MaxColumns",this,0,&VDKGrid::GetMaxColumns)
{
  rows = rows <= 0 ? 1 : rows;
  cols = cols <= 0 ? 1 : cols;
  if(editable)
    widget = gtk_sheet_new(rows,cols,title);
  else
    widget = gtk_sheet_new_browser(rows,cols,title);
  aCell = NULL;
  aColumn = NULL; 
  aRow = NULL;
  if(editable)
    gtk_signal_connect(GTK_OBJECT(widget),"changed",
		     GTK_SIGNAL_FUNC(VDKGrid::OnChangedCell),
		       (gpointer) this);
  gtk_signal_connect(GTK_OBJECT(widget),"activate",
		     GTK_SIGNAL_FUNC(VDKGrid::ActivateCell),
		       (gpointer) this);
  gtk_signal_connect(GTK_OBJECT(widget),"select_row",
		     GTK_SIGNAL_FUNC(VDKGrid::SelectRow),
		       (gpointer) this);
  gtk_signal_connect(GTK_OBJECT(widget),"select_column", 
		     GTK_SIGNAL_FUNC(VDKGrid::SelectColumn),
		       (gpointer) this);
  gtk_signal_connect(GTK_OBJECT(widget),"deactivate", 
		     GTK_SIGNAL_FUNC(VDKGrid::DeactivateCell),
		       (gpointer) this);
  ConnectDefaultSignals();
}
/*
 */
void
VDKGrid::Setup()
{
  /*
  GtkAdjustment *adj = gtk_sheet_get_hadjustment(GTK_SHEET(widget));
  if (adj)
    gtk_signal_connect(
		       GTK_OBJECT(adj),
		       "value_changed",
		       GTK_SIGNAL_FUNC(VDKGrid::HAdjChanged),
		       (gpointer) this );
  adj = gtk_sheet_get_vadjustment(GTK_SHEET(widget));
  if (adj)
    gtk_signal_connect(
		       GTK_OBJECT(adj),
		       "value_changed",
		       GTK_SIGNAL_FUNC(VDKGrid::VAdjChanged),
		       (gpointer) this );
  */
}
/*
 */
void    
VDKGrid::SetForeground(VDKRgb c, 
		       GtkStateType state)
{
  VDKObject::SetForeground(c,state);
  VDKColor *color = new VDKColor(this, c.red,c.green,c.blue);
  GtkSheetRange range;
  range.row0 = range.col0 = 0;
  range.rowi = GTK_SHEET(widget)->maxrow;
  range.coli = GTK_SHEET(widget)->maxcol;
  gtk_sheet_range_set_foreground(GTK_SHEET(widget),
				 range,
				 color->Color());
}
/*
 */
void    
VDKGrid::SetBackground(VDKRgb c, 
		       GtkStateType state)
{
  VDKObject::SetBackground(c,state);
  VDKColor *color = new VDKColor(this, c.red,c.green,c.blue);
  GtkSheetRange range;
  range.row0 = range.col0 = 0;
  range.rowi = GTK_SHEET(widget)->maxrow;
  range.coli = GTK_SHEET(widget)->maxcol;
  gtk_sheet_range_set_background(GTK_SHEET(widget),
				 range,
				 color->Color());
}
/*
 */
VDKGridCell* 
VDKGrid::Cell(int row, int col)
{
  if(aCell)
    delete aCell;
  aCell = new VDKGridCell(GTK_SHEET(widget),row,col);
  aCell->grid = this;
  char* p = gtk_sheet_cell_get_text(GTK_SHEET(widget),row,col);
  if(p)
    aCell->Text(p);
  return aCell;
}
/*
 */
VDKGridColumn* 
VDKGrid::Column(int col)
{
  if(aColumn)
    delete aColumn;
  aColumn = new VDKGridColumn(GTK_SHEET(widget),col);
  aColumn->col = col;
  return aColumn;
}
/*
 */
VDKGridRow* 
VDKGrid::Row(int row)
{
  if(aRow)
    delete aRow;
  aRow = new VDKGridRow(GTK_SHEET(widget),row);
  aRow->row = row;
  return aRow;
} 
/*
 */
void VDKGrid::AddRow(StringArray& array)
{
  g_return_if_fail(array.size() <= MaxColumns);
  gtk_sheet_add_row(GTK_SHEET(widget),1);
  int row = MaxRows-1;
  int i;
  for(i=0; i < MaxColumns; i++)
    Cell(row,i)->Text = array[i];
  gtk_sheet_moveto(GTK_SHEET(widget),row,0,1.0,0.0);
}
/*
 */
void VDKGrid::AddBlankRows(int n)
{ 
  gtk_sheet_add_row(GTK_SHEET(widget),n);
  gtk_sheet_moveto(GTK_SHEET(widget),MaxRows-1,0,1.0,0.0);
}
///////////////////// VDKGRIDCELL ////////////////////////////
void
VDKGridCell::SetBackground(VDKRgb& rgb)
{
  GtkSheetRange range;
  range.row0=row;
  range.rowi=row;
  range.col0=col;
  range.coli=col;
  GdkColor *color = (GdkColor*) malloc (sizeof (GdkColor));
  color->red    = rgb.red << 8;
  color->green  = rgb.green << 8;
  color->blue   = rgb.blue << 8;
  GdkColormap *colormap = gtk_widget_get_colormap(GTK_WIDGET(sheet));
  if (!gdk_color_alloc (colormap, color))
    gdk_color_black (colormap, color);
  gtk_sheet_range_set_background(sheet,range,color);
  free(color);
}
void
VDKGridCell::SetForeground(VDKRgb& rgb)
{
  GtkSheetRange range;
  range.row0=row;
  range.rowi=row;
  range.col0=col;
  range.coli=col;
  GdkColor *color = (GdkColor*) malloc (sizeof (GdkColor));
  color->red    = rgb.red << 8;
  color->green  = rgb.green << 8;
  color->blue   = rgb.blue << 8;
  GdkColormap *colormap = gtk_widget_get_colormap(GTK_WIDGET(sheet));
  if (!gdk_color_alloc (colormap, color))
    gdk_color_black (colormap, color);
  gtk_sheet_range_set_foreground(sheet,range,color);
  free(color);
}
void 
VDKGridCell::SetBorder(int mask, int width, int line_style)
{
  GtkSheetRange range;
  range.row0=row;
  range.rowi=row;
  range.col0=col;
  range.coli=col;  
  gtk_sheet_range_set_border(sheet, range,  mask, width, line_style);
}
void 
VDKGridCell::Attach(VDKObject* object,float x_align, float y_align)
{
AttachedWidget(object);
grid->AddItem(object);
object->Parent(grid);
if(! object->Visible)
  object->Visible = true;
gtk_sheet_attach(sheet,object->Widget(),row,col,x_align,y_align);
}
///////////////////// VDKGRISLICE ////////////////////////////
void
VDKGridSlice::SetRangeForeground(VDKRgb& rgb,GtkSheetRange& range)
{
  GdkColor *color = (GdkColor*) malloc (sizeof (GdkColor));
  color->red    = rgb.red << 8;
  color->green  = rgb.green << 8;
  color->blue   = rgb.blue << 8;
  GdkColormap *colormap = gtk_widget_get_colormap(GTK_WIDGET(sheet));
  if (!gdk_color_alloc (colormap, color))
    gdk_color_black (colormap, color);
  gtk_sheet_range_set_foreground(sheet,range,color);
  free(color);
}
/*
 */
void
VDKGridSlice::SetRangeBackground(VDKRgb& rgb,GtkSheetRange& range)
{
  GdkColor *color = (GdkColor*) malloc (sizeof (GdkColor));
  color->red    = rgb.red << 8;
  color->green  = rgb.green << 8;
  color->blue   = rgb.blue << 8;
  GdkColormap *colormap = gtk_widget_get_colormap(GTK_WIDGET(sheet));
  if (!gdk_color_alloc (colormap, color))
    gdk_color_black (colormap, color);
  gtk_sheet_range_set_background(sheet,range,color);
  free(color);
}
///////////////////// VDKGRID COLUMN /////////////////////////
void VDKGridColumn::SetForeground(VDKRgb rgb)
{
  GtkSheetRange range;
  range.row0=0;
  range.rowi=sheet->maxrow;
  range.col0 = range.coli = col;
  SetRangeForeground(rgb,range);
}

void VDKGridColumn::SetBackground(VDKRgb rgb)
{
  GtkSheetRange range;
  range.row0=0;
  range.rowi=sheet->maxrow;
  range.col0 = range.coli = col;
  SetRangeBackground(rgb,range);
}

void VDKGridColumn::SetWidth(int w)
{ 
  int max = 0;
  if(w != FIT_COLUMN_WIDTH)
    gtk_sheet_set_column_width(sheet,col,w);
  else
    {
      int i = 0;
      for( ; i < sheet->maxrow; i++)
	{
	  char* p = gtk_sheet_cell_get_text(sheet,i,col);
	  if(p)
	    {
	      char *q = "XX";
	      GtkSheetCellAttr attr;
	      gtk_sheet_get_attributes(sheet,i,col,&attr);
	      int l = gdk_string_width (attr.font,p)+
		gdk_string_width (attr.font,q);
	      max = l > max ? l : max;
	    }
	}
      gtk_sheet_set_column_width(sheet,col,max);
      Width(max); 
    }
} 
///////////////////// VDKGRID ROW  /////////////////////////
void VDKGridRow::SetHeight(int w)
{
  int max = 0;
  if(w != FIT_ROW_HEIGHT)
    gtk_sheet_set_row_height(sheet,row,w);
  else
    {
      int i = 0;
      for( ; i < sheet->maxcol; i++)
	{
	  char* p = gtk_sheet_cell_get_text(sheet,row,i);
	  if(p)
	    {
	      GtkSheetCellAttr attr;
	      gtk_sheet_get_attributes(sheet,row,i,&attr);
	      int l = ((attr.font->ascent+attr.font->descent+1)*3)/2;
	      max = l > max ? l : max;
	    }
	}
      if(! max)
	{
	  GtkStyle* style = GTK_WIDGET(sheet)->style;
	  GdkFont *font = style ? style->font : NULL;
	  max = font ? ((font->ascent + font->descent + 1)*3)/2 : 20;
	}
     gtk_sheet_set_row_height(sheet,row,max); 
     Height(max);
    }
}

 






