/*								-*- C++ -*-
 * $Id: WIN_textwindow.h,v 1.2 1999/09/23 21:58:11 wg Exp $
 *
 * Purpose: text window panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef TextWindow_h
#define TextWindow_h

#ifdef __GNUG__
#pragma interface
#endif

class wxPanel;

class wxTextWindow : public wxMultiText, public streambuf {
DECLARE_DYNAMIC_CLASS(wxTextWindow)
public:
    wxTextWindow(void);
    wxTextWindow(wxWindow *panel,
		 int x=-1, int y=-1, int width=-1, int height=-1,
		 long style=0, Constdata char *name=wxTextWindowNameStr);
    
    Bool Create(wxWindow *panel,
		int x=-1, int y=-1, int width=-1, int height=-1,
		long style=0, Constdata char *name=wxTextWindowNameStr);

    void  Clear(void);
    void  DiscardEdits(void) { modified = FALSE; }
    char  *GetContents(void);
    long  GetInsertionPoint(void);
    long  GetLastPosition(void);
    int   GetLineLength(long lineNo);
    int   GetLineText(long lineNo, char *buf);
    int   GetNumberOfLines(void);
    Bool  LoadFile(char *file);
    Bool  Modified(void) { return modified; }
    void  PositionToXY(long pos, long *x, long *y);
    void  Remove(long from, long to);
    void  Replace(long from, long to, char *value);
    Bool  SaveFile(char *file);
    void  SetEditable(Bool editable);
    void  SetInsertionPoint(long pos);
    void  SetInsertionPointEnd(void);
    void  SetSelection(long from, long to);
    void  ShowPosition(long pos);
    void  WriteText(char *text); // text must be 0-terminated
    void  WriteText(char *text, long len); // text need not be 0-terminated
    long  XYToPosition(long x, long y);

    // overload streambuf methods
    int overflow(int i);
    int sync(void);
    int underflow(void);

    wxTextWindow& operator<<(char *s);
    wxTextWindow& operator<<(int i);
    wxTextWindow& operator<<(long i);
    wxTextWindow& operator<<(float f);
    wxTextWindow& operator<<(double d);
    wxTextWindow& operator<<(char c);
private:
    #ifdef Have_Xt_Types
    static void EventCallback(Widget, XtPointer, XtPointer);
    #endif
    Bool modified;
};

#endif // TextWin_h
