/*								-*- C++ -*-
 * $Id: wx.h,v 1.2 1997-01-30 09:55:31+01 mho Exp $
 *
 * Purpose: wxWindows Xt-port main include file
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

//=============================================================================
// basic includes for wxWindows
//=============================================================================

#ifndef wx_h
#define wx_h

#if   defined (Uses_XtIntrinsicP)
	#include <X11/IntrinsicP.h>
	#define  Have_X_Types
	#define  Have_Xt_Types
#elif defined (Uses_XtIntrinsic)
	#include <X11/Intrinsic.h>
	#define  Have_X_Types
	#define  Have_Xt_Types
#elif defined (Uses_XLib)
	#include <X11/Xlib.h>
	#include <X11/Xutil.h>
	#include <X11/Xresource.h>
	#define  Have_X_Types
#endif

// standard include files needed in addition to wx include files
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fstream.h>

// standard wx include files
#include "wx_setup.h"
#include "wx_version.h"

#include "wx_defines.h"

#include "APP_global.h"
#include "DLG_dialogs.h"
#include "MSC_language.h"
#include "UTL_utilities.h"

#include "DAT_object.h"

#endif // wx_h

//=============================================================================
// Check if the application uses Uses_...
//=============================================================================

#define _NO_USES_DEFINES_FLAG

#ifdef Uses_wxApp
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxButton
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxCanvas
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxCanvasDC
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxCheckBox
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxChoice
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxColorDialog
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxDC
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxDialogBox
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxEvent
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxFontDialog
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxFrame
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxGDI
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxGauge
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxGroupBox
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxLayout
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxList
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxListBox
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxMemoryDC
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxMenu
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxMenuBar
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxMessage
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxMultiText
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxPanel
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxPanelDC
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxPathList
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxPrintSetup
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxPostscriptDC
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxRadioBox
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxResources
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxScreenDC
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxScrollBar
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxSlider
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxText
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxTextWindow
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxTypeTree
        #undef _NO_USES_DEFINES_FLAG
#endif
#ifdef Uses_wxWindow
        #undef _NO_USES_DEFINES_FLAG
#endif

#ifndef _NO_USES_DEFINES
#  ifdef _NO_USES_DEFINES_FLAG
#    define _NO_USES_DEFINES
#  endif
#endif          

//=============================================================================
// If the application doesn't use Uses_..., emulate the AIAI behaviour
//=============================================================================

#ifdef _NO_USES_DEFINES
	#define Uses_wxApp
	#define Uses_wxButton
	#define Uses_wxCanvas
	#define Uses_wxCanvasDC
	#define Uses_wxCheckBox
	#define Uses_wxChoice
	#define Uses_wxColourDialog
	#define Uses_wxDC
	#define Uses_wxDialogBox
	#define Uses_wxEvent
	#define Uses_wxFontDialog
	#define Uses_wxFrame
	#define Uses_wxGDI
	#define Uses_wxGauge
	#define Uses_wxGroupBox
	#define Uses_wxLayout
	#define Uses_wxList
	#define Uses_wxListBox
	#define Uses_wxMemoryDC
	#define Uses_wxMenu
	#define Uses_wxMenuBar
	#define Uses_wxMessage
	#define Uses_wxMultiText
	#define Uses_wxPanel
	#define Uses_wxPanelDC
	#define Uses_wxPathList
	#define Uses_wxPrintSetup
	#define Uses_wxPostScriptDC
	#define Uses_wxRadioBox
	#define Uses_wxResources
	#define Uses_wxScreenDC
	#define Uses_wxScrollBar
	#define Uses_wxSlider
	#define Uses_wxText
	#define Uses_wxTextWindow
	#define Uses_wxTypeTree
	#define Uses_wxWindow
#endif

//=============================================================================
// class dependencies
//=============================================================================

//--- PrologIO RPC ------------------------------------------------------------

#if defined(Uses_wxRPC)
	#define Uses_wxIPC
	#define Uses_wxClient
	#define Uses_wxServer
	#define Uses_wxPrologIO
#endif

#if defined(Uses_wxPrologIO)
	#define Uses_wxHashTable
	#define Uses_wxList
#endif

//--- misc --------------------------------------------------------------------

#if defined(Uses_wxClipboard)
	#define Uses_wxStringList
#endif

//--- data structures ---------------------------------------------------------

#if defined(Uses_wxTypeDef)
	#define Uses_wxTypeTree
#endif

#if defined(Uses_wxTypeTree)
	#define Uses_wxList
#endif

#if defined(Uses_wxNode) || defined(Uses_wxStringList) \
 || defined(Uses_wxPathList) || defined(Uses_wxHashTable) \
 || defined(Uses_wxPrintSetup)
	#define Uses_wxList
#endif

//--- high level classes ------------------------------------------------------

#if defined(Uses_wxDocView)
	#define Uses_wxList
	#define Uses_wxFrame
	#define Uses_wxEvtHandler
	#define Uses_wxWindow
	#define Uses_wxPrintPreview
#endif

#if defined(Uses_wxPrintPreview)
	#define Uses_wxCanvas
	#define Uses_wxDialogBox
	#define Uses_wxFrame
	#define Uses_wxPanel
	#define Uses_wxPrintSetup
#endif

//--- special dialog boxes ----------------------------------------------------

#if defined(Uses_wxColourDialog) || defined(Uses_wxFontDialog)
	#define Uses_wxDialogBox
#endif

//--- windows -----------------------------------------------------------------

//--- items ---
#if defined(Uses_wxTextWindow)
	#define Uses_wxMultiText
#endif
#if defined(Uses_wxMultiText)
	#define Uses_wxText
#endif
#if defined(Uses_GLCanvas)
	#define Uses_wxCanvas
#endif

#if defined(Uses_wxButton) \
 || defined(Uses_wxCanvas) \
 || defined(Uses_wxCheckBox) \
 || defined(Uses_wxChoice) \
 || defined(Uses_wxGauge) \
 || defined(Uses_wxGroupBox) \
 || defined(Uses_wxListBox) \
 || defined(Uses_wxMenu) \
 || defined(Uses_wxMenuBar) \
 || defined(Uses_wxMessage) \
 || defined(Uses_wxRadioBox) \
 || defined(Uses_wxScrollBar) \
 || defined(Uses_wxSlider) \
 || defined(Uses_wxText) \
 || defined(Uses_wxToolBar) \
 || defined(Uses_wxVirtListBox)
	#define Uses_wxItem
#endif

#if defined(Uses_wxMenuBar)
	#define Uses_wxMenu
#endif

#if defined(Uses_wxItem)
	#define Uses_wxPanel
	#define Uses_wxWindow
#endif

//--- panels ---
#if defined(Uses_wxDialogBase) || defined(Uses_wxEnhDialogBox)
	#define Uses_wxDialogBox
#endif

#if defined(Uses_wxDialogBox)
	#define Uses_wxFrame
#endif

#if defined(Uses_wxFrame)
	#define Uses_wxPanel
#endif

#if defined(Uses_wxPanel)
	#define Uses_wxWindow
#endif

//--- window ---
#if defined(Uses_wxLayout)
	#define Uses_wxEvent
	#define Uses_wxWindow
#endif

#if defined(Uses_wxWindow)
	#define Uses_wxWindowDC
	#define Uses_wxEvtHandler
	#define Uses_wxLayout
	#define Uses_wxGDI
#endif

#if defined(Uses_wxResources)
	#define Uses_wxHashTable
	#define Uses_wxList
	#define Uses_wxGDI
#endif

//--- drawing classes ---------------------------------------------------------

#if defined(Uses_wxGraphLayout)
	#define Uses_wxDC
#endif

#if defined(Uses_wxTreeLayout)
	#define Uses_wxDC
	#define Uses_wxList
#endif

//--- device contexts ---------------------------------------------------------

#if defined(Uses_wxCanvasDC) || defined(Uses_wxPanelDC) \
 || defined(Uses_wxMemoryDC) || defined(Uses_wxScreenDC)
	#define Uses_wxWindowDC
#endif

#if defined(Uses_wxWindowDC) || defined(Uses_wxPostScriptDC) || defined(Uses_MetafileDC)
	#define Uses_wxDC
#endif

#if defined(Uses_wxDC)
	#define Uses_wxGDI
#endif

//--- event handling ----------------------------------------------------------

#if defined(Uses_wxCommandEvent) || defined(Uses_wxKeyEvent) \
 || defined(Uses_wxMouseEvent)   || defined(Uses_wxEvent) \
 || defined(Uses_wxEvtHandler)
	#define Uses_wxEvent
#endif

//--- GDI classes -------------------------------------------------------------

#if defined(Uses_wxGDI)
	#define Uses_wxBitmap
	#define Uses_wxColour
	#define Uses_wxFont
	#define Uses_wxPenBrush
#endif

#if defined(Uses_wxBitmap) || defined(Uses_wxCursor) || defined(Uses_wxIcon) \
 || defined(Uses_wxGDIList)
	#define Uses_wxList
	#define Uses_wxBitmap
#endif

#if defined(Uses_wxBrush) || defined(Uses_wxPen) || defined(Uses_wxPenBrush) \
 || defined(Uses_wxPenList) || defined(Uses_BrushList)
	#define Uses_wxPenBrush
	#define Uses_wxColour
	#define Uses_wxList
#endif

#if defined(Uses_wxFont) || defined(Uses_wxFontList)
	#define Uses_wxList
#endif

#if defined(Uses_wxColour) || defined(Uses_wxColourMap) \
 || defined(Uses_wxColourDatabase)
	#define Uses_wxList
#endif

//--- IPC classes -------------------------------------------------------------

#if defined(Uses_wxHelp)
	#define Uses_wxClient
#endif

#if defined(Uses_wxClient) || defined(Uses_wxServer) || defined(Uses_wxIPC)
	#define Uses_wxIPC
	#define Uses_wxList
#endif

//=============================================================================
// include files depending on Uses defines
//=============================================================================

//--- data structures ---------------------------------------------------------

#if defined(Uses_wxList)
	#include "DAT_list.h"
#endif
#if defined(Uses_wxPathList)
	#include "DAT_pathlist.h"
#endif
#if defined(Uses_wxHashTable)
	#include "DAT_hashtable.h"
#endif
#if USE_TYPETREE && defined(Uses_wxTypeTree)
	#include "DAT_typetree.h"
#endif
#if defined(Uses_wxPrintSetup)
	#include "DAT_printsetup.h"
#endif
#if defined(Uses_wxString)
	#include "DAT_string.h"
#endif

//--- application -------------------------------------------------------------

#if defined(Uses_wxApp)
	#include "APP_app.h"
#endif

#if USE_THREADS && defined(Uses_wxThread)
	#include "APP_thread.h"
#endif

//--- event handling ----------------------------------------------------------

#if defined(Uses_wxEvent)
	#include "EVT_system.h"
	#include "EVT_standard.h"
#endif

#if defined(Uses_wxEvtHandler)
	#include "EVT_handler.h"
#endif

//--- GDI classes -------------------------------------------------------------

#if defined(Uses_wxBitmap)
	#include "GDI_bitmap.h"
#endif

#if defined(Uses_wxColour)
	#include "GDI_colour.h"
#endif

#if defined(Uses_wxFont)
	#include "GDI_font.h"
#endif

#if defined(Uses_wxPenBrush)
	#include "GDI_pen+brush.h"
#endif

//--- device contexts ---------------------------------------------------------

#if defined(Uses_wxDC)
	#include "DEV_dc.h"
#endif

#if defined(Uses_wxWindowDC)
	#include "DEV_windowdc.h"
#endif

#if defined(Uses_wxMemoryDC)
	#include "DEV_memorydc.h"
#endif

#if defined(Uses_wxScreenDC)
	#include "DEV_screendc.h"
#endif

#if USE_METAFILE && defined(Uses_wxMetaFileDC)
	#include "DEV_metafiledc.h"
#endif

#if USE_POSTSCRIPT && defined(Uses_wxPostScriptDC)
	#include "DEV_psdc.h"
#endif

//--- IPC classes -------------------------------------------------------------

#if USE_IPC && defined(Uses_wxIPC)
	#include "IPC_base.h"
#endif

#if USE_IPC && defined(Uses_wxClient)
	#include "IPC_client.h"
#endif

#if USE_IPC && defined(Uses_wxServer)
	#include "IPC_server.h"
#endif

#if USE_HELP && defined(Uses_wxHelp)
	#include "IPC_help.h"
#endif

//--- PrologIO RPC ------------------------------------------------------------

#if USE_PROLOGIO && defined(Uses_wxPrologIO)
	#include "PRO_read.h"
#endif

#if USE_RPC && defined(Uses_wxRPC)
	#include "PRO_rpc.h"
#endif

//--- miscellaneous classes ---------------------------------------------------

#if USE_CLIPBOARD && defined(Uses_wxClipboard)
	#include "MSC_clipboard.h"
#endif

#if defined(Uses_wxTimer)
	#include "MSC_timer.h"
#endif

#if USE_TIMEDATE && defined(Uses_wxDate)
	#include "MSC_date.h"
#endif

#if USE_FRACTION && defined(Uses_wxFraction)
	#include "MSC_fraction.h"
#endif

#if USE_TIMEDATE && defined(Uses_wxTime)
	#include "MSC_time.h"
#endif

//--- windows -----------------------------------------------------------------

#if defined(Uses_wxWindow)
	#include "WIN_window.h"
#endif

#if USE_CONSTRAINTS && defined(Uses_wxLayout)
	#include "WIN_layout.h"
#endif

//--- panels ---
#if defined(Uses_wxPanel)
	#include "WIN_panel.h"
#endif

#if defined(Uses_wxFrame)
	#include "WIN_frame.h"
#endif

#if defined(Uses_wxDialogBox)
	#include "WIN_dialogbox.h"
#endif

#if USE_ENHANCED_DIALOG && defined(wx_UsesEnhDialogBox)
	#include "WIN_enhdialogbox.h"
#endif

#if USE_WX_RESOURCES && defined(Uses_wxResources)
	#include "WIN_resources.h"
#endif

//--- items ---
#if defined(Uses_wxItem)
	#include "WIN_item.h"
#endif

#if defined(Uses_wxButton)
	#include "WIN_button.h"
#endif

#if defined(Uses_wxCanvas)
	#include "WIN_canvas.h"
#endif

#if defined(Uses_wxCheckBox)
	#include "WIN_checkbox.h"
#endif

#if defined(Uses_wxChoice)
	#include "WIN_choice.h"
#endif

#if defined(Uses_GLCanvas)
	#include "WIN_glcanvas.h"
#endif

#if USE_GAUGE && defined(Uses_wxGauge)
	#include "WIN_gauge.h"
#endif

#if defined(Uses_wxGroupBox)
	#include "WIN_groupbox.h"
#endif

#if defined(Uses_wxListBox)
	#include "WIN_listbox.h"
#endif

#if defined(Uses_wxMenu)
	#include "WIN_menu.h"
#endif

#if defined(Uses_wxMenuBar)
	#include "WIN_menubar.h"
#endif

#if defined(Uses_wxMessage)
	#include "WIN_message.h"
#endif

#if defined(Uses_wxRadioBox)
	#include "WIN_radiobox.h"
#endif

#if USE_SCROLLBAR && defined(Uses_wxScrollBar)
	#include "WIN_scrollbar.h"
#endif

#if defined(Uses_wxSlider)
	#include "WIN_slider.h"
#endif

#if USE_EXTENDED_STATICS && defined(Uses_wxStaticItems)
	#include "WIN_staticitems.h"
#endif

#if USE_TOOLBAR && defined(Uses_wxToolBar)
	#if USE_XT_TOOLBAR
		#include "WIN_toolbar.h"
	#else
		#include "WIN_toolbar2.h"
	#endif
#endif

#if USE_VLBOX && defined(Uses_wxVirtListBox)
	#include "WIN_virtlistbox.h"
#endif

//--- text items ---
#if defined(Uses_wxText)
	#include "WIN_text.h"
#endif

#if defined(Uses_wxMultiText)
	#include "WIN_multitext.h"
#endif

#if defined(Uses_wxTextWindow)
	#include "WIN_textwindow.h"
#endif

//--- dialogs ------- ---------------------------------------------------------

#if defined(Uses_wxDialogBase)
	#include "DLG_base.h"
#endif

//--- drawing classes ---------------------------------------------------------

#if USE_WXGRAPH && defined(Uses_wxGraphLayout)
	#include "DRW_graph.h"
#endif

#if USE_WXTREE && defined(Uses_wxTreeLayout)
	#include "DRW_tree.h"
#endif

//--- high level classes ------------------------------------------------------

#if USE_FORM && defined(Uses_wxForm)
	#include "HLV_form.h"
#endif

#if USE_PRINTING_ARCHITECTURE && defined(Uses_wxPrintPreview)
	#include "HLV_print.h"
#endif

#if USE_DOC_VIEW_ARCHITECTURE && defined(Uses_wxDocView)
	#include "HLV_doc.h"
#endif

//--- special dialog boxes ----------------------------------------------------

#if defined(Uses_wxColourDialog)
	#include "DLG_colour.h"
#endif

#if defined(Uses_wxFontDialog)
	#include "DLG_font.h"
#endif
