/*

	Functions:

        void YCSetIcon(GdkWindow *w, gchar **icon_data)

	GtkWidget *YCCreateLoadXPM(   
	        GtkWidget *ref_window,
	        gchar **xpmdata
	)
	int YCCreate(void)
	void YCDeleteAllAudioModes(yc_win_struct *ycw)
	void YCDeleteAllSoundPaths(yc_win_struct *ycw)
	void YCDestroy(void)

	---

 */

#include "yiffconfig.h"

#include "yiffbanner.xpm"
#include "yiffconfig.xpm"


void YCSetIcon(GdkWindow *w, gchar **icon_data)
{
        GdkWindowAttr attributes;
        gint attributes_mask;
        gint width, height;
        GdkGC *gc;
        GdkWindow *icon_window, *parent;  
        GdkPixmap *pixmap;
        GdkBitmap *mask;
        GtkStyle *style;   


        /* Create pixmap. */
        style = gtk_widget_get_default_style();
        gc = style->black_gc;
        pixmap = gdk_pixmap_create_from_xpm_d(
            w,
            &mask,
            &style->bg[GTK_STATE_NORMAL], 
            icon_data
        );
        gdk_window_get_size((GdkWindow *)pixmap, &width, &height);

        /* Create icon window. */
        parent = gdk_window_get_parent(w);
        if(parent == NULL)
        {
            fprintf(stderr,
                "YSetIcon(): Cannot get parent.\n"
            );
            return;
        }     
        attributes.width = width;
        attributes.height = height;
        attributes.wclass = GDK_INPUT_OUTPUT;
        attributes.window_type = GDK_WINDOW_TOPLEVEL;
        attributes.wmclass_name = "Eterm";
        attributes.wmclass_class = "Eterm";
        attributes.override_redirect = FALSE;
        attributes_mask = GDK_WA_WMCLASS | GDK_WA_NOREDIR;
        icon_window = gdk_window_new(
            parent,
            &attributes,   
            attributes_mask
        );    
        if(icon_window == NULL)
        {
            fprintf(stderr,  
                "YSetIcon(): Cannot create icon window.\n"
            );
            return;
        }

        /* Set icon. */
        gdk_window_set_icon(
            w,
            icon_window,
            pixmap,
            mask
        );

        return;
}



GtkWidget *YCCreateLoadXPM(
	GtkWidget *ref_window,
	gchar **xpmdata
)
{
        GtkStyle *style;
	GdkPixmap *gdk_pixmap;
        GdkBitmap *mask;


	if(ref_window == NULL)
	    return(NULL);

	gtk_widget_realize(ref_window);
        style = gtk_widget_get_default_style();
        gdk_pixmap = gdk_pixmap_create_from_xpm_d(
            ref_window->window,
            &mask,
            &style->bg[GTK_STATE_NORMAL],
            xpmdata
        );
	if(gdk_pixmap == NULL)
	    return(NULL);

        return(gtk_pixmap_new(gdk_pixmap, mask));
}

int YCCreate(void)
{
	int i;
        GtkWidget *w, *parent, *parent2, *parent3, *parent4;
        GList *glist = NULL;
        GSList *gslist = NULL;
        GtkAdjustment *gadj = NULL;
        yc_win_struct *ycw;
        gchar *hdg_text[10];
        gchar text[256];


        ycw = &yc_win;

	ycw->cur_page = 0;

	ycw->total_audio_modes = 0;
	ycw->audio_mode = NULL;
	ycw->cur_sel_audio_mode = -1;

	ycw->total_sound_paths = 0;
	ycw->cur_sel_sound_path = -1;

	ycw->midi_driver_command = NULL;

	ycw->con = NULL;



        w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        ycw->toplevel = w;
        gtk_widget_realize(w);
        YCSetIcon(w->window, yiffconfig_xpm);
        gtk_widget_set_usize(GTK_WIDGET(w), 500, 500);            
        gtk_window_set_title(GTK_WINDOW(w), "YIFF Configuration");
        gtk_signal_connect(
            GTK_OBJECT(w),
            "delete_event",
            GTK_SIGNAL_FUNC(YCExitCB),
            (gpointer)ycw
        );
        gtk_signal_connect(
            GTK_OBJECT(w),
            "destroy",
            GTK_SIGNAL_FUNC(YCExitCB),
            (gpointer)ycw   
        );


	/* Main table. */
	parent = ycw->toplevel;
        w = gtk_table_new(3, 1, FALSE);
        gtk_container_add(GTK_CONTAINER(parent), w);
        gtk_widget_show(w);


	/* Create the vertical boxes for each page toplevel. */
	parent = w;
	for(i = 0; i < YC_TOTAL_PAGES; i++)
	{
	    w = gtk_vbox_new(FALSE, 0);
	    ycw->page_toplevel[i] = w;

	    gtk_table_attach(GTK_TABLE(parent), 
		w,
		0, 1,
		0, 1,
		GTK_FILL | GTK_SHRINK | GTK_EXPAND,
		GTK_FILL | GTK_SHRINK | GTK_EXPAND,
		20, 20
	    );
	}
	gtk_widget_show(ycw->page_toplevel[0]);


	/* Seperator. */
	w = gtk_hseparator_new();
        gtk_table_attach(GTK_TABLE(parent),
            w,
            0, 1,
            1, 2,
            GTK_FILL | GTK_SHRINK | GTK_EXPAND,
            GTK_SHRINK,
            0, 0
        );
        gtk_widget_show(w);

	/* Create Back and Next buttons. */
	w = gtk_hbox_new(TRUE, 0);
	gtk_table_attach(GTK_TABLE(parent),
            w,
            0, 1,
            2, 3,
            GTK_FILL | GTK_SHRINK | GTK_EXPAND,
            GTK_SHRINK,
            10, 10
        );
	gtk_widget_show(w);

	parent = w;

	w = gtk_button_new();
	ycw->back_btn = w;
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, FALSE, 0);
	gtk_widget_set_usize(GTK_WIDGET(w), 60, 25);
	gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(YCBackBtnCB),
            ycw
        );
        gtk_widget_show(w);

	w = gtk_label_new("Exit");
	ycw->back_btn_label = w;
        gtk_container_add(GTK_CONTAINER(ycw->back_btn), w);
        gtk_widget_show(w);


        w = gtk_button_new();
        ycw->next_btn = w;
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, FALSE, 0);
        gtk_widget_set_usize(GTK_WIDGET(w), 60, 25);
        gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(YCNextBtnCB),
            ycw
        );
        gtk_widget_show(w);

        w = gtk_label_new("Next");
        ycw->next_btn_label = w;
        gtk_container_add(GTK_CONTAINER(ycw->next_btn), w);
	GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_widget_grab_default(w);
        gtk_widget_show(w);


	/* ***************************************************** */
	/* Widgets on page 0. */
	parent = ycw->page_toplevel[0];

	w = gtk_table_new(2, 1, FALSE);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	parent2 = w;

	w = YCCreateLoadXPM(ycw->toplevel, yiffbanner);
        gtk_table_attach(GTK_TABLE(parent2),
            w,
            0, 1,
            0, 1,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_widget_show(w);

	w = gtk_label_new(
"Welcome to the YIFF Configuration Wizard, this program\n\
will take you step by step through the process of configuring\n\
the YIFF sound server. Please make sure that you are running\n\
this program on the same physical computer that the YIFF\n\
sound server is installed on.\n\
\n\
Full configuration documentation is available at:\n\
        http://fox.mit.edu/xsw/yiff\n\
\n\
Enter the connect argument (address and port number to the\n\
recorder) and the start command (command used to start the\n\
YIFF sound server) below."
	);
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
        gtk_table_attach(GTK_TABLE(parent2),
            w,
            1, 2,
            0, 1,
            GTK_FILL | GTK_SHRINK | GTK_EXPAND,
            GTK_SHRINK,
            2, 2
        );
	gtk_widget_show(w);


        w = gtk_table_new(2, 2, FALSE);
        gtk_container_add(GTK_CONTAINER(parent), w);
        gtk_widget_show(w);

	parent = w;

        w = gtk_label_new("Recorder Address:");
        gtk_table_attach(GTK_TABLE(parent),
            w,
            0, 1,
            0, 1,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
        gtk_widget_show(w);

        w = gtk_entry_new_with_max_length(256);
        ycw->svr_addr_text = w;
/*
        gtk_signal_connect(
            GTK_OBJECT(w),
            "activate",
            GTK_SIGNAL_FUNC(YActivateCB),
            ycw
        );
 */
        gtk_entry_set_text(GTK_ENTRY(w), DEF_YSERVER_ADDRESS);
        gtk_table_attach(GTK_TABLE(parent),
            w,
            1, 2,
            0, 1,
            GTK_FILL | GTK_SHRINK | GTK_EXPAND,
            GTK_SHRINK,
            2, 2
        );
	gtk_entry_set_editable(GTK_ENTRY(w), TRUE);
        gtk_widget_show(w);


        w = gtk_label_new("Start Command:");
        gtk_table_attach(GTK_TABLE(parent),
            w,
            0, 1,
            1, 2,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
        gtk_widget_show(w);

        w = gtk_entry_new_with_max_length(256);
        ycw->svr_start_cmd_text = w;
/*      
        gtk_signal_connect(
            GTK_OBJECT(w),
            "activate",
            GTK_SIGNAL_FUNC(YActivateCB),
            yc
        );
 */     
        gtk_entry_set_text(GTK_ENTRY(w), DEF_YSERVER_START_CMD);
        gtk_table_attach(GTK_TABLE(parent),
            w,
            1, 2,
            1, 2,
            GTK_FILL | GTK_SHRINK | GTK_EXPAND,
            GTK_SHRINK,
            2, 2
        );
        gtk_entry_set_editable(GTK_ENTRY(w), TRUE); 
        gtk_widget_show(w);


        parent = ycw->page_toplevel[0];

        w = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent2 = w;

	w = gtk_label_new(
"If for any reason you do not want to start or connect to the\n\
YIFF Sound Server during this configuration, then check the\n\
box below."
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
        gtk_widget_show(w);


	w = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_check_button_new_with_label(
	    "Do not start or connect to the YIFF Sound Server"
	);
	ycw->no_start_svr_btn = w;
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(YCDoNotStartServerBtnCB),
            ycw
        );
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), FALSE);
        gtk_widget_show(w);




        /* ***************************************************** */
        /* Widgets on page 1. */

        parent = ycw->page_toplevel[1];

	w = gtk_hbox_new(FALSE, 10);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent2 = w;	/* The new hbox. */


	/* Scrolled window and colum list. */
        w = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(
            GTK_SCROLLED_WINDOW(w),
            GTK_POLICY_AUTOMATIC,
            GTK_POLICY_AUTOMATIC
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
        gtk_widget_show(w);

        parent = w;     /* The scrolled window. */
        hdg_text[0] = "Audio Modes";
        w = gtk_clist_new_with_titles(1, hdg_text);
        ycw->audio_modes_list = w;

	gtk_clist_set_column_justification(
	    GTK_CLIST(w),
	    0,
	    GTK_JUSTIFY_LEFT
	);
        gtk_signal_connect(GTK_OBJECT(w), "select_row",
            GTK_SIGNAL_FUNC(YCAudioModesListCB),
            ycw
        );
	/* Pretty it up. */
        gtk_clist_set_shadow_type(GTK_CLIST(w), GTK_SHADOW_OUT);
	/* Must set colum width! */
        gtk_clist_set_column_width(GTK_CLIST(w), 0, 150);
        gtk_container_add(GTK_CONTAINER(parent), w);
        gtk_widget_show(w);


	/* Add, remove, shift up, and shift down buttons. */
        w = gtk_vbox_new(TRUE, 0);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

	parent3 = w;	/* The new vbox. */

	w = gtk_vbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, FALSE, 0);
        gtk_widget_show(w);

	parent = w;	/* Vbox for add and delete buttons. */

        w = gtk_button_new_with_label("Add...");
        ycw->add_mode_btn = w;
        gtk_widget_set_usize(GTK_WIDGET(w), 60, 25);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 5);
        gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(YCAddModeBtnCB),
            ycw
        );
        gtk_widget_show(w);

        w = gtk_button_new_with_label("Delete");
        ycw->remove_mode_btn = w;
	gtk_widget_set_usize(GTK_WIDGET(w), 60, 25);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 5);
        gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(YCRemoveModeBtnCB),
            ycw
        );  
        gtk_widget_show(w);


	/* Shift up and down arrows (using same vbox, parent3). */
        w = gtk_vbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, FALSE, 0);
        gtk_widget_show(w);

        parent = w;	/* Vbox for up and down arrows. */

        w = gtk_button_new();
	parent4 = w;
        gtk_widget_set_usize(GTK_WIDGET(w), 20, 20);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 5);
        gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(YCModeShiftUpBtnCB),
            ycw
        );
        gtk_widget_show(w);
	w = gtk_arrow_new(GTK_ARROW_UP, GTK_SHADOW_OUT);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_widget_show(w);

        w = gtk_button_new();
        parent4 = w;
	gtk_widget_set_usize(GTK_WIDGET(w), 20, 20);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 5);
        gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(YCModeShiftDownBtnCB),
            ycw
        );
        gtk_widget_show(w);
        w = gtk_arrow_new(GTK_ARROW_DOWN, GTK_SHADOW_OUT); 
        gtk_container_add(GTK_CONTAINER(parent4), w);
        gtk_widget_show(w);



	/* Restore parent referance because we changed it above. */
	parent = ycw->page_toplevel[1];

	/* Table for sample rate, channels, sample size, etc. */
	w = gtk_table_new(5, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent = w;

	/* Sample rate. */
        w = gtk_label_new("Sample Rate (Hz):");
        gtk_table_attach(GTK_TABLE(parent),
            w,
            0, 1,
            0, 1,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
        gtk_widget_show(w);

        ycw->sample_rate_combo = gtk_combo_new();
        w = ycw->sample_rate_combo;
        gtk_table_attach(GTK_TABLE(parent),
            w,
            1, 2,
            0, 1,
            GTK_FILL | GTK_SHRINK | GTK_EXPAND,
            GTK_SHRINK,
            2, 2 
        );
        gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(w)->entry), "8000");
        glist = NULL;
        glist = g_list_append(glist, "8000");
        glist = g_list_append(glist, "11025");
        glist = g_list_append(glist, "22050");
        glist = g_list_append(glist, "44100");
        gtk_combo_set_popdown_strings(GTK_COMBO(w), glist);
        g_list_free(glist);
        gtk_combo_set_use_arrows(GTK_COMBO(w), TRUE);
        gtk_combo_set_case_sensitive(GTK_COMBO(w), FALSE);
        gtk_widget_show(w);

        /* Channels. */
        w = gtk_label_new("Channels:");
        gtk_table_attach(GTK_TABLE(parent),
            w,
            2, 3,
            0, 1,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
        gtk_widget_show(w);

	gslist = NULL;
        w = gtk_radio_button_new_with_label(gslist, "1");
        ycw->channels_tb1 = w;
        gtk_table_attach(GTK_TABLE(parent),
            w,
            3, 4,
            0, 1,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);
        gtk_widget_show(w);
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        w = gtk_radio_button_new_with_label(gslist, "2");
        ycw->channels_tb2 = w;
        gtk_table_attach(GTK_TABLE(parent),
            w,
            4, 5,
            0, 1,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_widget_show(w);


        /* Fragment size. */
        w = gtk_label_new("Fragment Size (Bytes):");
        gtk_table_attach(GTK_TABLE(parent),
            w,
            0, 1,
            1, 2,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
        gtk_widget_show(w);

        w = gtk_combo_new();
        ycw->fragment_size_combo = w;
        gtk_table_attach(GTK_TABLE(parent),
            w,
            1, 2,
            1, 2,
            GTK_FILL | GTK_SHRINK | GTK_EXPAND,
            GTK_SHRINK,
            2, 2
        );
        gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(w)->entry), "1024");
        glist = NULL;
        glist = g_list_append(glist, "256");
        glist = g_list_append(glist, "512");
        glist = g_list_append(glist, "1024");
        glist = g_list_append(glist, "2048");
        glist = g_list_append(glist, "4096");
        glist = g_list_append(glist, "8192");
        glist = g_list_append(glist, "16384");
        gtk_combo_set_popdown_strings(GTK_COMBO(w), glist);
        g_list_free(glist);
        gtk_combo_set_use_arrows(GTK_COMBO(w), TRUE);
        gtk_combo_set_case_sensitive(GTK_COMBO(w), FALSE);
        gtk_widget_show(w);


        /* Bits. */
        w = gtk_label_new("    Bits:");
        gtk_table_attach(GTK_TABLE(parent),
            w,
            2, 3,
            1, 2,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
        gtk_widget_show(w);

	gslist = NULL;
        w = gtk_radio_button_new_with_label(gslist, "8");
        ycw->sample_size_tb8 = w;
        gtk_table_attach(GTK_TABLE(parent),
            w,
            3, 4,
            1, 2,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);
        gtk_widget_show(w);
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        w = gtk_radio_button_new_with_label(gslist, "16");
        ycw->sample_size_tb16 = w;
        gtk_table_attach(GTK_TABLE(parent),
            w,
            4, 5,
            1, 2,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_widget_show(w);


        parent = ycw->page_toplevel[1];

        w = gtk_table_new(2, 1, FALSE);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;    /* The new hbox. */

        /* Cycle scale bar. */
        gadj = (GtkAdjustment *)gtk_adjustment_new(
            30000,      /* Value. */
            100,        /* Min. */
            500000,     /* Max. */
            100,        /* Step increment. */
            100,        /* Page increment. */
            100         /* Page size. */
        );
        w = gtk_hscale_new(gadj);
        ycw->cycle_scale = w;
        gtk_table_attach(GTK_TABLE(parent2),
            w,
            0, 1,
            0, 1,
            GTK_FILL | GTK_SHRINK | GTK_EXPAND,
            GTK_SHRINK,
            2, 2
        );
        gtk_signal_connect(
            GTK_OBJECT(gadj), "value_changed",
            GTK_SIGNAL_FUNC(YCCycleScaleCB), w
        );
        gtk_scale_set_draw_value(GTK_SCALE(w), TRUE);
        gtk_scale_set_digits(GTK_SCALE(w), 0);  /* Num of digits. */
        gtk_scale_set_value_pos(GTK_SCALE(w), GTK_POS_LEFT);
        gtk_widget_show(w);

        w = gtk_button_new_with_label("Calculate");
        ycw->cycle_calc_btn = w;
        gtk_table_attach(GTK_TABLE(parent2),
            w,
            1, 2,
            0, 1,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(YCCalculateBtnCB),
            ycw
        );
        gtk_widget_show(w);


	/* Apply changes button. */
        parent = ycw->page_toplevel[1];

	w = gtk_button_new_with_label(
	    "Apply values to the YIFF Server"
	);
	ycw->apply_changes_btn = w;
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 10);
	gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(YCApplyChangesBtnCB),
            ycw
        );
        gtk_widget_show(w);



        /* ***************************************************** */
        /* Widgets on page 2. */

        parent = ycw->page_toplevel[2];

	/* Listening port number. */
        w = gtk_vbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, FALSE, 0);
        gtk_widget_show(w);

        parent2 = w;

        w = gtk_label_new(
"Port number that the YIFF Sound Server is to poll new client program\n\
connections on, the default value is 9433."
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

        w = gtk_entry_new_with_max_length(80);
	ycw->port_num_text = w;
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


        /* Digital sample (DSP) device. */
        w = gtk_vbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, FALSE, 0);
        gtk_widget_show(w);

        parent2 = w;

        w = gtk_label_new(
"Device that the YIFF Sound Server is to use as the Digital Sample\n\
(DSP) device, the default value is /dev/dsp."
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

        w = gtk_entry_new_with_max_length(PATH_MAX + NAME_MAX);
        ycw->device_name_text = w;
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


        /* Mixer device. */
        w = gtk_vbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, FALSE, 0);
        gtk_widget_show(w);

        parent2 = w;

        w = gtk_label_new(
"Device that the YIFF Sound Server is to use as the mixer device, the\n\
default value is /dev/mixer."
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

        w = gtk_entry_new_with_max_length(PATH_MAX + NAME_MAX);
        ycw->mixer_name_text = w;
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


        /* MIDI play command. */
        w = gtk_vbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_label_new(
"Command that the YIFF Sound Server is to execute to play MIDI sound\n\
objects. Any occurance of %f will be replaced with the full path to the\n\
MIDI sound object on disk. If you do not want to play MIDI for whatever\n\
reason, leave this value blank."
	);
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

        w = gtk_entry_new_with_max_length(PATH_MAX + NAME_MAX);
        ycw->midi_play_cmd_text = w;
        gtk_entry_set_text(GTK_ENTRY(w), option.midi_play_cmd);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


        /* Refresh interval. */
        w = gtk_vbox_new(FALSE, 5);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

        parent2 = w;

        w = gtk_label_new(
"The refresh interval in microseconds in which the YIFF Sound Server\n\
is to refresh and resync its resources (such as the DSP stream),\n\
the default value is 30000000."
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

        w = gtk_entry_new_with_max_length(80);
        ycw->refresh_interval_text = w;
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);


        /* ***************************************************** */
        /* Widgets on page 3. */

        parent = ycw->page_toplevel[3];

	w = gtk_hbox_new(FALSE, 10);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent2 = w;

        /* Scrolled window and colum list. */  
        w = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(
            GTK_SCROLLED_WINDOW(w),
            GTK_POLICY_AUTOMATIC,
            GTK_POLICY_AUTOMATIC
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
        gtk_widget_show(w);

        parent = w;     /* The scrolled window. */
        hdg_text[0] = "Sound Paths";
        w = gtk_clist_new_with_titles(1, hdg_text);
        ycw->sound_paths_list = w;
        gtk_clist_set_column_justification(
            GTK_CLIST(w),
            0,
            GTK_JUSTIFY_LEFT
        );
        gtk_signal_connect(GTK_OBJECT(w),
	    "select_row",
            GTK_SIGNAL_FUNC(YCSoundPathListCB),
            ycw
        );
        /* Pretty it up. */
        gtk_clist_set_shadow_type(GTK_CLIST(w), GTK_SHADOW_OUT);
        /* Must set colum width! */
        gtk_clist_set_column_width(GTK_CLIST(w), 0, 150);
        gtk_container_add(GTK_CONTAINER(parent), w);
        gtk_widget_show(w);


        /* Remove, shift up, and shift down buttons. */
        w = gtk_vbox_new(TRUE, 0);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

        parent3 = w;    /* The new vbox. */

        w = gtk_vbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, FALSE, 0);
        gtk_widget_show(w);

        parent = w;     /* Vbox for delete buttons. */

        w = gtk_button_new_with_label("Delete");
        gtk_widget_set_usize(GTK_WIDGET(w), 60, 25);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 5);
        gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(YCRemoveSoundPathBtnCB),
            ycw
        );
        gtk_widget_show(w);


        /* Shift up and down arrows (using same vbox, parent3). */
        w = gtk_vbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, FALSE, 0);
        gtk_widget_show(w);

        parent = w;     /* Vbox for up and down arrows. */

        w = gtk_button_new();
        parent4 = w;
        gtk_widget_set_usize(GTK_WIDGET(w), 20, 20);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 5);
        gtk_signal_connect(
            GTK_OBJECT(w), 
            "clicked",
            GTK_SIGNAL_FUNC(YCSoundPathShiftUpBtnCB),
            ycw
        );
        gtk_widget_show(w);
        w = gtk_arrow_new(GTK_ARROW_UP, GTK_SHADOW_OUT);
        gtk_container_add(GTK_CONTAINER(parent4), w);
        gtk_widget_show(w);

        w = gtk_button_new();
        parent4 = w;
        gtk_widget_set_usize(GTK_WIDGET(w), 20, 20);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 5);
        gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(YCSoundPathShiftDownBtnCB),
            ycw
        );
        gtk_widget_show(w);
        w = gtk_arrow_new(GTK_ARROW_DOWN, GTK_SHADOW_OUT);
        gtk_container_add(GTK_CONTAINER(parent4), w);
        gtk_widget_show(w);


	parent = ycw->page_toplevel[3];

	/* Add sound path text and button. */
	w = gtk_table_new(2, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_label_new(
"Enter a sound search path below and then click on the `add' button."
	);
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
        gtk_table_attach(GTK_TABLE(parent2),
            w,
            0, 2,
            0, 1,
            GTK_FILL | GTK_SHRINK | GTK_EXPAND,
            GTK_SHRINK,
            2, 2
        );
        gtk_widget_show(w);

        w = gtk_entry_new_with_max_length(PATH_MAX + NAME_MAX);
        ycw->sound_path_add_text = w;
        gtk_signal_connect(
            GTK_OBJECT(w),
            "activate",
            GTK_SIGNAL_FUNC(YCAddSoundPathBtnCB),	/* Same as add. */
            ycw
        );
        gtk_table_attach(GTK_TABLE(parent2),
            w,
            0, 1,
            1, 2,
            GTK_FILL | GTK_SHRINK | GTK_EXPAND,
            GTK_SHRINK,
            2, 2
        );
        gtk_widget_show(w);

        w = gtk_button_new_with_label("Add");
        gtk_widget_set_usize(GTK_WIDGET(w), 60, 25);
	gtk_signal_connect(
            GTK_OBJECT(w),
            "clicked",
            GTK_SIGNAL_FUNC(YCAddSoundPathBtnCB),
            ycw
        );
        gtk_table_attach(GTK_TABLE(parent2),
            w,
            1, 2,
            1, 2,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_widget_show(w);



        /* ***************************************************** */
        /* Widgets on page 4. */

        parent = ycw->page_toplevel[4];

        w = gtk_vbox_new(FALSE, 10);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
	parent = w;


        w = gtk_vbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;

	w = gtk_label_new(
"Configuration of the YIFF Sound Server is now complete, the configuration\n\
will be saved to the file specified below."
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
        gtk_widget_show(w);

	w = gtk_table_new(2, 1, FALSE);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_label_new("Configuration File:");
	gtk_table_attach(GTK_TABLE(parent3),
            w,   
            0, 1,
            0, 1,
            GTK_SHRINK,
            GTK_SHRINK,
            2, 2
        );
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
        gtk_widget_show(w);

        w = gtk_entry_new_with_max_length(PATH_MAX + NAME_MAX);
        ycw->rcfile_name_text = w;
        gtk_entry_set_text(GTK_ENTRY(w), fname.rcfile);
        gtk_table_attach(GTK_TABLE(parent3),
            w,
            1, 2,
            0, 1,
            GTK_FILL | GTK_SHRINK | GTK_EXPAND,
            GTK_SHRINK,
            2, 2
        );
        gtk_entry_set_editable(GTK_ENTRY(w), TRUE);
        gtk_widget_show(w);


        w = gtk_label_new(
"You may go back and modify any changes you made before the configuration\n\
file is saved by clicking on the `Back' button. When you are satisfied with\n\
the changes you have made, click on the `Finish' button. You should also send\n\
a SIGHUP signal to the YIFF Sound Server process afterwards to ensure\n\
that it uses the values in the new configuration file. Make sure that the\n\
configuration file YIFF is currently using is the same one specified above\n\
or else you will have to restart YIFF and instruct it to use the new\n\
configuration file (read command instructions below)."
	);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
        gtk_widget_show(w);


        w = gtk_label_new(
"To start the YIFF Sound Server, first make sure that your sound driver(s)\n\
are loaded and then type `yiff <configuration_file>' at a command prompt.\n\
Replace <configuration_file> with the configuration file you want used."
        );
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
        gtk_widget_show(w);


        w = gtk_label_new(
"To verify that the YIFF Sound Server is running, type `yrecinfo' or type\n\
`ps|grep yiff' to check for it in the process listing."
        );
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
        gtk_widget_show(w);

        w = gtk_label_new(
"To shut down the YIFF Sound Server, type `yshutdown' or type `killall yiff'\n\
to kill it by sending it a terminate (SIGTERM) signal."
        );
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);  
        gtk_widget_show(w);




	/* Map the main toplevel. */
        gtk_widget_show(ycw->toplevel);


	return(0);
}

void YCDeleteAllAudioModes(yc_win_struct *ycw)
{
	gint i;


	if(ycw == NULL)
	    return;

        for(i = 0; i < ycw->total_audio_modes; i++)
            free(ycw->audio_mode[i]);  

        free(ycw->audio_mode);
        ycw->audio_mode = NULL;
        ycw->total_audio_modes = 0;

        ycw->cur_sel_audio_mode = -1;


	gtk_clist_clear(GTK_CLIST(ycw->audio_modes_list));


	return;
}

void YCDeleteAllSoundPaths(yc_win_struct *ycw)
{
        gint i;


        if(ycw == NULL)
            return;
/*
        for(i = 0; i < ycw->total_sound_paths; i++)
            free(ycw->sound_path[i]);

        free(ycw->sound_path);
        ycw->sound_path = NULL;
        ycw->total_sound_paths = 0;
 */
	return;
}

void YCDestroy(void)
{
	gint i;
	gchar *strptr;
	yc_win_struct *ycw;


	ycw = &yc_win;

	ycw->toplevel = NULL;
	for(i = 0; i < YC_TOTAL_PAGES; i++)
	    ycw->page_toplevel[i] = NULL;


	/* Free all audio modes. */
	YCDeleteAllAudioModes(ycw);


	/* Free all sound paths. */
	YCDeleteAllSoundPaths(ycw);


	/* Free midi driver command. */
	free(ycw->midi_driver_command);
	ycw->midi_driver_command = NULL;


	/* Close connection to YIFF Sound Server. */
        YCloseConnection(ycw->con, False);
        ycw->con = NULL;


	return;
}
