/*
** Copyright 1998 - 1999 Double Precision, Inc.  See COPYING for
** distribution information.
*/

#include	"auth.h"
#include	"authmod.h"
#include	"authstaticlist.h"
#include	"authsasl.h"
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

static const char rcsid[]="$Id: authtest.c,v 1.3 2000/02/21 23:54:04 mrsam Exp $";

static void usage()
{
	fprintf(stderr, "Usage: authtest [-s service] [ -m module ] userid password\n");
	exit(1);
}

static int callback_pre(struct authinfo *a, void *dummy)
{
        authsuccess(a->homedir, a->sysuserid ? 0:a->sysusername,
		a->sysuserid, &a->sysgroupid,
                a->address, a->fullname);

	if (a->maildir)
	{
	char	*p=malloc(sizeof("MAILDIR=")+strlen(a->maildir));

		strcat(strcpy(p, "MAILDIR="), a->maildir);
		putenv(p);
	}
	else	putenv("MAILDIR=");
	return (0);
}

int main(int argc, char **argv)
{
int	argn;
const char *service="login";
const char *module="";
int	i;
char	*p;

	if (getuid())
	{
		printf("I must be run as root!\n");
		exit(0);
	}

	for (argn=1; argn<argc; argn++)
	{
	const char *argp;

		if (argv[argn][0] != '-')	break;
		if (argv[argn][1] == 0)
		{
			++argn;
			break;
		}

		argp=argv[argn]+2;

		switch (argv[argn][1])	{
		case 's':
			if (!*argp && argn+1 < argc)
				argp=argv[++argn];
			service=argp;
			break;
		case 'm':
			if (!*argp && argn+1 < argc)
				argp=argv[++argn];
			module=argp;
			break;
		default:
			usage();
		}
	}
	if (argc - argn <= 0)
		usage();

	for (i=0; authstaticlist[i].auth_name; i++)
	{
	char	*authdata;
	char	buf[1024];

		if (*module && strcmp(module, authstaticlist[i].auth_name))
			continue;

		if (argc - argn > 1)
		{
			authdata=malloc(strlen(argv[argn])+strlen(argv[argn+1])+3);
			if (!authdata)
			{
				perror("malloc");
				exit(1);
			}
			sprintf(authdata, "%s\n%s\n",
				argv[argn], argv[argn+1]);

			p= (*authstaticlist[i].auth_func)(service,
				AUTHTYPE_LOGIN, authdata, 0);
			free(authdata);
			if (p == 0)	continue;
		}
		else
		{
		int	rc;

			if ((rc=(*authstaticlist[i].auth_prefunc)(argv[argn],
				service ? service:"",
				&callback_pre, 0)) != 0)
			{
				(*authstaticlist[i].auth_cleanupfunc)();
				if (rc < 0)
					continue;
				printf("Temporary authentication failure from"
					"module %s\n",
					authstaticlist[i].auth_name);
				break;
			}
			(*authstaticlist[i].auth_cleanupfunc)();
		}

		printf("Authenticated: module %s\n", authstaticlist[i].auth_name);
		if ( getcwd(buf, sizeof(buf)))
			printf("Home directory: %s\n", buf);
		else
			printf("Unable to determine home directory!!\n");

		printf("UID/GID: %lu/%lu\n",
			(unsigned long)getuid(), (unsigned long)getgid());

		p=getenv("MAILDIR");
		if (p && *p)
			printf("Maildir: %s\n", p);

		p=getenv("AUTHADDR");
		printf("AUTHADDR=%s\n", p && *p ? p:"<none>");
		p=getenv("AUTHFULLNAME");
		printf("AUTHFULLNAME=%s\n", p && *p ? p:"<none>");
		exit(0);
	}
	printf("Authentication FAILED!\n");
	return (0);
}
